/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.controlprogram;

import java.util.ArrayList;
import org.tugraz.sysds.api.DMLScript;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.hops.recompile.Recompiler;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.Program;
import org.tugraz.sysds.runtime.controlprogram.ProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.instructions.Instruction;
import org.tugraz.sysds.runtime.lineage.LineageCache;
import org.tugraz.sysds.runtime.lineage.LineageCacheConfig;
import org.tugraz.sysds.runtime.lineage.LineageCacheStatistics;
import org.tugraz.sysds.runtime.lineage.LineageItem;
import org.tugraz.sysds.runtime.lineage.LineageItemUtils;
import org.tugraz.sysds.utils.Statistics;

public class BasicProgramBlock
extends ProgramBlock {
    protected ArrayList<Instruction> _inst = new ArrayList();

    public BasicProgramBlock(Program prog) {
        super(prog);
    }

    public ArrayList<Instruction> getInstructions() {
        return this._inst;
    }

    public Instruction getInstruction(int i) {
        return this._inst.get(i);
    }

    public void setInstructions(ArrayList<Instruction> inst) {
        this._inst = inst;
    }

    public void addInstruction(Instruction inst) {
        this._inst.add(inst);
    }

    public void addInstructions(ArrayList<Instruction> inst) {
        this._inst.addAll(inst);
    }

    public int getNumInstructions() {
        return this._inst.size();
    }

    @Override
    public ArrayList<ProgramBlock> getChildBlocks() {
        return null;
    }

    @Override
    public boolean isNested() {
        return false;
    }

    @Override
    public void execute(ExecutionContext ec) {
        String name;
        ArrayList<Instruction> tmp = this._inst;
        try {
            long t0;
            long l = t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
            if (ConfigurationManager.isDynamicRecompilation() && this._sb != null && this._sb.requiresRecompilation()) {
                tmp = Recompiler.recompileHopsDag(this._sb, this._sb.getHops(), ec, null, false, true, this._tid);
            }
            if (DMLScript.STATISTICS) {
                long t1 = System.nanoTime();
                Statistics.incrementHOPRecompileTime(t1 - t0);
                if (tmp != this._inst) {
                    Statistics.incrementHOPRecompileSB();
                }
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("Unable to recompile program block.", ex);
        }
        LineageItem[] liInputs = null;
        if (this._sb != null && !LineageCacheConfig.ReuseCacheType.isNone()) {
            name = "SB" + this._sb.getSBID();
            liInputs = LineageItemUtils.getLineageItemInputstoSB(this._sb.getInputstoSB(), ec);
            if (LineageCache.reuse(this._sb.getOutputsofSB(), this._sb.getOutputsofSB().size(), liInputs, name, ec)) {
                if (DMLScript.STATISTICS) {
                    LineageCacheStatistics.incrementSBHits();
                }
                return;
            }
        }
        this.executeInstructions(tmp, ec);
        if (this._sb != null && liInputs != null) {
            name = "SB" + this._sb.getSBID();
            LineageCache.putValue(this._sb.getOutputsofSB(), this._sb.getOutputsofSB().size(), liInputs, name, ec);
        }
    }
}

