/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.compress.utils;

import java.util.ArrayList;
import org.tugraz.sysds.runtime.compress.utils.DblArray;
import org.tugraz.sysds.runtime.compress.utils.IntArrayList;

public class DblArrayIntListHashMap {
    private static final int INIT_CAPACITY = 8;
    private static final int RESIZE_FACTOR = 2;
    private static final float LOAD_FACTOR = 0.75f;
    private DArrayIListEntry[] _data = new DArrayIListEntry[8];
    private int _size = 0;

    public int size() {
        return this._size;
    }

    public IntArrayList get(DblArray key) {
        if (this._size == 0) {
            return null;
        }
        int hash = DblArrayIntListHashMap.hash(key);
        int ix = DblArrayIntListHashMap.indexFor(hash, this._data.length);
        DArrayIListEntry e = this._data[ix];
        while (e != null) {
            if (e.key.equals(key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public void appendValue(DblArray key, IntArrayList value) {
        int hash = DblArrayIntListHashMap.hash(key);
        int ix = DblArrayIntListHashMap.indexFor(hash, this._data.length);
        DArrayIListEntry enew = new DArrayIListEntry(key, value);
        enew.next = this._data[ix];
        this._data[ix] = enew;
        ++this._size;
        if ((float)this._size >= 0.75f * (float)this._data.length) {
            this.resize();
        }
    }

    public ArrayList<DArrayIListEntry> extractValues() {
        ArrayList<DArrayIListEntry> ret = new ArrayList<DArrayIListEntry>();
        for (DArrayIListEntry e : this._data) {
            if (e == null) continue;
            while (e.next != null) {
                ret.add(e);
                e = e.next;
            }
            ret.add(e);
        }
        return ret;
    }

    private void resize() {
        if (this._data.length > 0x3FFFFFFF) {
            return;
        }
        DArrayIListEntry[] olddata = this._data;
        this._data = new DArrayIListEntry[this._data.length * 2];
        this._size = 0;
        for (DArrayIListEntry e : olddata) {
            if (e == null) continue;
            while (e.next != null) {
                this.appendValue(e.key, e.value);
                e = e.next;
            }
            this.appendValue(e.key, e.value);
        }
    }

    private static int hash(DblArray key) {
        int h = key.hashCode();
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public class DArrayIListEntry {
        public DblArray key;
        public IntArrayList value;
        public DArrayIListEntry next;

        public DArrayIListEntry(DblArray ekey, IntArrayList evalue) {
            this.key = ekey;
            this.value = evalue;
            this.next = null;
        }
    }
}

