/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.compress.utils;

import java.util.Arrays;
import org.tugraz.sysds.runtime.compress.ColGroup;
import org.tugraz.sysds.runtime.compress.ColGroupDDC1;
import org.tugraz.sysds.runtime.compress.ColGroupOLE;
import org.tugraz.sysds.runtime.compress.ColGroupRLE;
import org.tugraz.sysds.runtime.compress.ColGroupUncompressed;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.util.DataConverter;

public class ConverterUtils {
    public static ColGroup copyColGroup(ColGroup group) {
        ColGroup ret = null;
        int[] colIndices = Arrays.copyOf(group.getColIndices(), group.getNumCols());
        if (group instanceof ColGroupUncompressed) {
            ColGroupUncompressed in = (ColGroupUncompressed)group;
            ret = new ColGroupUncompressed(colIndices, in.getNumRows(), in.getData());
        } else if (group instanceof ColGroupRLE) {
            ColGroupRLE in = (ColGroupRLE)group;
            ret = new ColGroupRLE(colIndices, in.getNumRows(), in.hasZeros(), in.getValues(), in.getBitmaps(), in.getBitmapOffsets());
        } else if (group instanceof ColGroupOLE) {
            ColGroupOLE in = (ColGroupOLE)group;
            ret = new ColGroupOLE(colIndices, in.getNumRows(), in.hasZeros(), in.getValues(), in.getBitmaps(), in.getBitmapOffsets());
        } else if (group instanceof ColGroupDDC1) {
            ColGroupDDC1 in = (ColGroupDDC1)group;
            ret = new ColGroupDDC1(colIndices, in.getNumRows(), in.getValues(), in.getData());
        } else {
            throw new RuntimeException("Using '" + group.getClass() + "' instance of ColGroup not fully supported");
        }
        return ret;
    }

    public static double[] getDenseVector(MatrixBlock vector) {
        return DataConverter.convertToDoubleVector(vector, false);
    }

    public static MatrixBlock getUncompressedColBlock(ColGroup group) {
        return group instanceof ColGroupUncompressed ? ((ColGroupUncompressed)group).getData() : new ColGroupUncompressed(Arrays.asList(group)).getData();
    }
}

