/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.compress.estim;

import org.tugraz.sysds.runtime.compress.UncompressedBitmap;
import org.tugraz.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;

public abstract class CompressedSizeEstimator {
    protected MatrixBlock _data;
    protected final int _numRows;

    public CompressedSizeEstimator(MatrixBlock data) {
        this._data = data;
        this._numRows = this._data.getNumColumns();
    }

    public int getNumRows() {
        return this._numRows;
    }

    public abstract CompressedSizeInfo estimateCompressedColGroupSize(int[] var1);

    public abstract CompressedSizeInfo estimateCompressedColGroupSize(UncompressedBitmap var1);

    protected SizeEstimationFactors computeSizeEstimationFactors(UncompressedBitmap ubm, boolean inclRLE) {
        int numVals = ubm.getNumValues();
        int numRuns = 0;
        int numOffs = 0;
        int numSegs = 0;
        int numSingle = 0;
        for (int i = 0; i < numVals; ++i) {
            int[] list = ubm.getOffsetsList(i).extractValues();
            int listSize = ubm.getNumOffsets(i);
            numOffs += listSize;
            numSegs += list[listSize - 1] / 65536 + 1;
            numSingle += listSize == 1 ? 1 : 0;
            if (!inclRLE) continue;
            int lastOff = -2;
            for (int j = 0; j < listSize; ++j) {
                if (list[j] != lastOff + 1) {
                    ++numRuns;
                    numRuns += (list[j] - lastOff) / 65536;
                }
                lastOff = list[j];
            }
        }
        return new SizeEstimationFactors(numVals, numSegs, numOffs, numRuns, numSingle);
    }

    protected static long getRLESize(int numVals, int numRuns, int numCols) {
        int ret = 0;
        ret += 8 * numVals * numCols;
        ret += 8 * numVals;
        return ret += 4 * numRuns;
    }

    protected static long getOLESize(int numVals, float numOffs, int numSeqs, int numCols) {
        int ret = 0;
        ret += 8 * numVals * numCols;
        ret += 8 * numVals;
        ret = (int)((float)ret + 2.0f * numOffs);
        return ret += 2 * numSeqs;
    }

    protected static long getDDCSize(int numVals, int numRows, int numCols) {
        if (numVals > 65534) {
            return Long.MAX_VALUE;
        }
        int ret = 0;
        ret += 8 * numVals * numCols;
        return ret += (numVals > 255 ? 2 : 1) * numRows;
    }

    protected static class SizeEstimationFactors {
        protected int numVals;
        protected int numSegs;
        protected int numOffs;
        protected int numRuns;
        protected int numSingle;

        protected SizeEstimationFactors(int numvals, int numsegs, int numoffs, int numruns, int numsingle) {
            this.numVals = numvals;
            this.numSegs = numsegs;
            this.numOffs = numoffs;
            this.numRuns = numruns;
            this.numSingle = numsingle;
        }
    }
}

