/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.compress.cocode;

import java.util.Arrays;
import org.tugraz.sysds.runtime.compress.cocode.PlanningCoCoder;
import org.tugraz.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.tugraz.sysds.runtime.compress.estim.CompressedSizeInfo;

public class PlanningCoCodingGroup {
    private int[] _colIndexes;
    private PlanningCoCodingGroup _leftGrp;
    private PlanningCoCodingGroup _rightGrp;
    private long _estSize;
    private double _cardRatio;

    public PlanningCoCodingGroup(int col, PlanningCoCoder.GroupableColInfo info) {
        this._colIndexes = new int[]{col};
        this._estSize = info.size;
        this._cardRatio = info.cardRatio;
    }

    public PlanningCoCodingGroup(PlanningCoCodingGroup grp1, PlanningCoCodingGroup grp2, CompressedSizeEstimator estim, int numRows) {
        this._colIndexes = PlanningCoCodingGroup.getMergedIndexes(grp1._colIndexes, grp2._colIndexes);
        CompressedSizeInfo groupSizeInfo = estim.estimateCompressedColGroupSize(this._colIndexes);
        this._estSize = groupSizeInfo.getMinSize();
        this._cardRatio = groupSizeInfo.getEstCard() / numRows;
        this._leftGrp = grp1;
        this._rightGrp = grp2;
    }

    public int[] getColIndices() {
        return this._colIndexes;
    }

    public long getEstSize() {
        return this._estSize;
    }

    public double getChangeInSize() {
        if (this._leftGrp == null || this._rightGrp == null) {
            return 0.0;
        }
        return this.getEstSize() - this._leftGrp.getEstSize() - this._rightGrp.getEstSize();
    }

    public double getCardinalityRatio() {
        return this._cardRatio;
    }

    public PlanningCoCodingGroup getLeftGroup() {
        return this._leftGrp;
    }

    public PlanningCoCodingGroup getRightGroup() {
        return this._rightGrp;
    }

    public int hashCode() {
        return Arrays.hashCode(this._colIndexes);
    }

    public boolean equals(Object that) {
        if (!(that instanceof PlanningCoCodingGroup)) {
            return false;
        }
        PlanningCoCodingGroup thatgrp = (PlanningCoCodingGroup)that;
        return Arrays.equals(this._colIndexes, thatgrp._colIndexes);
    }

    public String toString() {
        return Arrays.toString(this._colIndexes);
    }

    public static int[] getMergedIndexes(int[] indexes1, int[] indexes2) {
        int[] ret = new int[indexes1.length + indexes2.length];
        int grp1Ptr = 0;
        int grp2Ptr = 0;
        for (int mergedIx = 0; mergedIx < ret.length; ++mergedIx) {
            if (indexes1[grp1Ptr] < indexes2[grp2Ptr]) {
                ret[mergedIx] = indexes1[grp1Ptr++];
                if (grp1Ptr != indexes1.length) continue;
                System.arraycopy(indexes2, grp2Ptr, ret, mergedIx + 1, indexes2.length - grp2Ptr);
                break;
            }
            ret[mergedIx] = indexes2[grp2Ptr++];
            if (grp2Ptr != indexes2.length) continue;
            System.arraycopy(indexes1, grp1Ptr, ret, mergedIx + 1, indexes1.length - grp1Ptr);
            break;
        }
        return ret;
    }

    public static class ColIndexes {
        final int[] _colIndexes;

        public ColIndexes(int[] colIndexes) {
            this._colIndexes = colIndexes;
        }

        public int hashCode() {
            return Arrays.hashCode(this._colIndexes);
        }

        public boolean equals(Object that) {
            if (!(that instanceof ColIndexes)) {
                return false;
            }
            ColIndexes thatgrp = (ColIndexes)that;
            return Arrays.equals(this._colIndexes, thatgrp._colIndexes);
        }
    }
}

