/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.compress;

import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.tugraz.sysds.runtime.compress.utils.DblArrayIntListHashMap;
import org.tugraz.sysds.runtime.compress.utils.DoubleIntListHashMap;
import org.tugraz.sysds.runtime.compress.utils.IntArrayList;
import org.tugraz.sysds.runtime.util.SortUtils;

public final class UncompressedBitmap {
    private final int _numCols;
    private double[] _values;
    private IntArrayList[] _offsetsLists;

    public UncompressedBitmap(DblArrayIntListHashMap distinctVals, int numColumns) {
        int numVals = distinctVals.size();
        this._values = new double[numVals * numColumns];
        this._offsetsLists = new IntArrayList[numVals];
        int bitmapIx = 0;
        for (DblArrayIntListHashMap.DArrayIListEntry val : distinctVals.extractValues()) {
            System.arraycopy(val.key.getData(), 0, this._values, bitmapIx * numColumns, numColumns);
            this._offsetsLists[bitmapIx++] = val.value;
        }
        this._numCols = numColumns;
    }

    public UncompressedBitmap(DoubleIntListHashMap distinctVals) {
        int numVals = distinctVals.size();
        this._values = new double[numVals];
        this._offsetsLists = new IntArrayList[numVals];
        int bitmapIx = 0;
        for (DoubleIntListHashMap.DIListEntry val : distinctVals.extractValues()) {
            this._values[bitmapIx] = val.key;
            this._offsetsLists[bitmapIx++] = val.value;
        }
        this._numCols = 1;
    }

    public int getNumColumns() {
        return this._numCols;
    }

    public double[] getValues() {
        return this._values;
    }

    public double[] getValues(int ix) {
        return Arrays.copyOfRange(this._values, ix * this._numCols, (ix + 1) * this._numCols);
    }

    public int getNumValues() {
        return this._values.length / this._numCols;
    }

    public IntArrayList getOffsetsList(int ix) {
        return this._offsetsLists[ix];
    }

    public long getNumOffsets() {
        long ret = 0L;
        for (IntArrayList offlist : this._offsetsLists) {
            ret += (long)offlist.size();
        }
        return ret;
    }

    public int getNumOffsets(int ix) {
        return this._offsetsLists[ix].size();
    }

    public void sortValuesByFrequency() {
        int numVals = this.getNumValues();
        int numCols = this.getNumColumns();
        double[] freq = new double[numVals];
        int[] pos = new int[numVals];
        for (int i = 0; i < numVals; ++i) {
            freq[i] = this.getNumOffsets(i);
            pos[i] = i;
        }
        SortUtils.sortByValue(0, numVals, freq, pos);
        ArrayUtils.reverse((int[])pos);
        double[] lvalues = new double[numVals * numCols];
        IntArrayList[] loffsets = new IntArrayList[numVals];
        for (int i = 0; i < numVals; ++i) {
            System.arraycopy(this._values, pos[i] * numCols, lvalues, i * numCols, numCols);
            loffsets[i] = this._offsetsLists[pos[i]];
        }
        this._values = lvalues;
        this._offsetsLists = loffsets;
    }
}

