/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.compress;

import java.util.ArrayList;
import org.tugraz.sysds.runtime.compress.ColGroup;
import org.tugraz.sysds.runtime.compress.RowIterator;
import org.tugraz.sysds.runtime.data.SparseRow;
import org.tugraz.sysds.runtime.data.SparseRowVector;

class SparseRowIterator
extends RowIterator<SparseRow> {
    private final SparseRowVector _ret;
    private final double[] _tmp;

    public SparseRowIterator(int rl, int ru, ArrayList<ColGroup> colGroups, int clen) {
        super(rl, ru, colGroups);
        this._ret = new SparseRowVector(clen);
        this._tmp = new double[clen];
    }

    @Override
    public SparseRow next() {
        int blksz = 65536;
        int ix = this._rpos % 65536;
        boolean last = this._rpos + 1 == this._ru;
        for (int j = 0; j < this._iters.length; ++j) {
            this._iters[j].next(this._tmp, this._rpos, ix, last);
        }
        this._ret.setSize(0);
        for (int i = 0; i < this._tmp.length; ++i) {
            this._ret.append(i, this._tmp[i]);
        }
        ++this._rpos;
        return this._ret;
    }
}

