/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.compress;

import java.util.Arrays;
import org.tugraz.sysds.runtime.compress.ReaderColumnSelection;
import org.tugraz.sysds.runtime.compress.utils.DblArray;
import org.tugraz.sysds.runtime.data.SparseRow;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;

public class ReaderColumnSelectionSparse
extends ReaderColumnSelection {
    private final DblArray ZERO_DBL_ARRAY;
    private DblArray nonZeroReturn;
    private DblArray reusableReturn;
    private double[] reusableArr;
    private SparseRow[] sparseCols = null;
    private int[] sparsePos = null;

    public ReaderColumnSelectionSparse(MatrixBlock data, int[] colIndexes, boolean skipZeros) {
        super(colIndexes, data.getNumColumns(), skipZeros);
        this.ZERO_DBL_ARRAY = new DblArray(new double[colIndexes.length], true);
        this.reusableArr = new double[colIndexes.length];
        this.reusableReturn = new DblArray(this.reusableArr);
        this.sparseCols = new SparseRow[colIndexes.length];
        this.sparsePos = new int[colIndexes.length];
        if (data.getSparseBlock() != null) {
            for (int i = 0; i < colIndexes.length; ++i) {
                this.sparseCols[i] = data.getSparseBlock().get(colIndexes[i]);
            }
        }
    }

    @Override
    public DblArray nextRow() {
        if (this._skipZeros) {
            while ((this.nonZeroReturn = this.getNextRow()) != null && this.nonZeroReturn == this.ZERO_DBL_ARRAY) {
            }
            return this.nonZeroReturn;
        }
        return this.getNextRow();
    }

    private DblArray getNextRow() {
        if (this._lastRow == this._numRows - 1) {
            return null;
        }
        ++this._lastRow;
        for (int i = 0; i < this._colIndexes.length; ++i) {
            if (this.sparseCols[i] == null || this.sparseCols[i].indexes().length > this.sparsePos[i] && this.sparseCols[i].indexes()[this.sparsePos[i]] >= this._lastRow) continue;
            int n = i;
            this.sparsePos[n] = this.sparsePos[n] + 1;
        }
        Arrays.fill(this.reusableArr, 0.0);
        boolean zeroResult = true;
        for (int i = 0; i < this._colIndexes.length; ++i) {
            if (this.sparseCols[i] == null || this.sparseCols[i].indexes().length <= this.sparsePos[i] || this.sparseCols[i].indexes()[this.sparsePos[i]] != this._lastRow) continue;
            this.reusableArr[i] = this.sparseCols[i].values()[this.sparsePos[i]];
            zeroResult = false;
        }
        return zeroResult ? this.ZERO_DBL_ARRAY : this.reusableReturn;
    }
}

