/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.compress;

import org.tugraz.sysds.runtime.compress.ReaderColumnSelection;
import org.tugraz.sysds.runtime.compress.utils.DblArray;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;

public class ReaderColumnSelectionDenseSample
extends ReaderColumnSelection {
    protected MatrixBlock _data;
    private int[] _sampleIndexes;
    private int lastIndex = -1;
    private DblArray nonZeroReturn;
    private DblArray reusableReturn;
    private double[] reusableArr;

    public ReaderColumnSelectionDenseSample(MatrixBlock data, int[] colIndexes, int[] sampleIndexes, boolean skipZeros) {
        super(colIndexes, -1, skipZeros);
        this._data = data;
        this._sampleIndexes = sampleIndexes;
        this.reusableArr = new double[colIndexes.length];
        this.reusableReturn = new DblArray(this.reusableArr);
    }

    @Override
    public DblArray nextRow() {
        if (this._skipZeros) {
            while ((this.nonZeroReturn = this.getNextRow()) != null && DblArray.isZero(this.nonZeroReturn)) {
            }
            return this.nonZeroReturn;
        }
        return this.getNextRow();
    }

    private DblArray getNextRow() {
        if (this.lastIndex == this._sampleIndexes.length - 1) {
            return null;
        }
        ++this.lastIndex;
        for (int i = 0; i < this._colIndexes.length; ++i) {
            this.reusableArr[i] = this._data.quickGetValue(this._colIndexes[i], this._sampleIndexes[this.lastIndex]);
        }
        return this.reusableReturn;
    }

    @Override
    public int getCurrentRowIndex() {
        return this._sampleIndexes[this.lastIndex];
    }

    @Override
    public void reset() {
        this.lastIndex = -1;
    }
}

