/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.compress;

import org.tugraz.sysds.runtime.compress.ReaderColumnSelection;
import org.tugraz.sysds.runtime.compress.utils.DblArray;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;

public class ReaderColumnSelectionDense
extends ReaderColumnSelection {
    protected MatrixBlock _data;
    private DblArray nonZeroReturn;
    private DblArray reusableReturn;
    private double[] reusableArr;

    public ReaderColumnSelectionDense(MatrixBlock data, int[] colIndices, boolean skipZeros) {
        super(colIndices, data.getNumColumns(), skipZeros);
        this._data = data;
        this.reusableArr = new double[colIndices.length];
        this.reusableReturn = new DblArray(this.reusableArr);
    }

    @Override
    public DblArray nextRow() {
        if (this._skipZeros) {
            while ((this.nonZeroReturn = this.getNextRow()) != null && DblArray.isZero(this.nonZeroReturn)) {
            }
            return this.nonZeroReturn;
        }
        return this.getNextRow();
    }

    private DblArray getNextRow() {
        if (this._lastRow == this._numRows - 1) {
            return null;
        }
        ++this._lastRow;
        for (int i = 0; i < this._colIndexes.length; ++i) {
            this.reusableArr[i] = this._data.quickGetValue(this._colIndexes[i], this._lastRow);
        }
        return this.reusableReturn;
    }
}

