/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.compress;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.random.Well1024a;
import org.apache.log4j.Level;
import org.tugraz.sysds.hops.OptimizerUtils;
import org.tugraz.sysds.lops.MMTSJ;
import org.tugraz.sysds.lops.MapMultChain;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.compress.BitmapEncoder;
import org.tugraz.sysds.runtime.compress.ColGroup;
import org.tugraz.sysds.runtime.compress.ColGroupDDC;
import org.tugraz.sysds.runtime.compress.ColGroupDDC1;
import org.tugraz.sysds.runtime.compress.ColGroupDDC2;
import org.tugraz.sysds.runtime.compress.ColGroupOLE;
import org.tugraz.sysds.runtime.compress.ColGroupOffset;
import org.tugraz.sysds.runtime.compress.ColGroupRLE;
import org.tugraz.sysds.runtime.compress.ColGroupUncompressed;
import org.tugraz.sysds.runtime.compress.ColGroupValue;
import org.tugraz.sysds.runtime.compress.CompressionStatistics;
import org.tugraz.sysds.runtime.compress.DenseRowIterator;
import org.tugraz.sysds.runtime.compress.SparseRowIterator;
import org.tugraz.sysds.runtime.compress.UncompressedBitmap;
import org.tugraz.sysds.runtime.compress.cocode.PlanningCoCoder;
import org.tugraz.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.tugraz.sysds.runtime.compress.estim.CompressedSizeEstimatorFactory;
import org.tugraz.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.tugraz.sysds.runtime.compress.utils.ColumnGroupIterator;
import org.tugraz.sysds.runtime.compress.utils.ConverterUtils;
import org.tugraz.sysds.runtime.compress.utils.LinearAlgebraUtils;
import org.tugraz.sysds.runtime.controlprogram.caching.CacheBlock;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.parfor.stat.Timing;
import org.tugraz.sysds.runtime.data.SparseBlock;
import org.tugraz.sysds.runtime.data.SparseRow;
import org.tugraz.sysds.runtime.functionobjects.Builtin;
import org.tugraz.sysds.runtime.functionobjects.KahanFunction;
import org.tugraz.sysds.runtime.functionobjects.KahanPlus;
import org.tugraz.sysds.runtime.functionobjects.KahanPlusSq;
import org.tugraz.sysds.runtime.functionobjects.Multiply;
import org.tugraz.sysds.runtime.functionobjects.ReduceAll;
import org.tugraz.sysds.runtime.functionobjects.ReduceCol;
import org.tugraz.sysds.runtime.instructions.cp.CM_COV_Object;
import org.tugraz.sysds.runtime.instructions.cp.KahanObject;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObject;
import org.tugraz.sysds.runtime.instructions.spark.data.IndexedMatrixValue;
import org.tugraz.sysds.runtime.matrix.data.CTableMap;
import org.tugraz.sysds.runtime.matrix.data.IJV;
import org.tugraz.sysds.runtime.matrix.data.LibMatrixBincell;
import org.tugraz.sysds.runtime.matrix.data.LibMatrixReorg;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.data.MatrixIndexes;
import org.tugraz.sysds.runtime.matrix.data.MatrixValue;
import org.tugraz.sysds.runtime.matrix.data.RandomMatrixGenerator;
import org.tugraz.sysds.runtime.matrix.operators.AggregateBinaryOperator;
import org.tugraz.sysds.runtime.matrix.operators.AggregateOperator;
import org.tugraz.sysds.runtime.matrix.operators.AggregateTernaryOperator;
import org.tugraz.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.tugraz.sysds.runtime.matrix.operators.BinaryOperator;
import org.tugraz.sysds.runtime.matrix.operators.CMOperator;
import org.tugraz.sysds.runtime.matrix.operators.COVOperator;
import org.tugraz.sysds.runtime.matrix.operators.Operator;
import org.tugraz.sysds.runtime.matrix.operators.QuaternaryOperator;
import org.tugraz.sysds.runtime.matrix.operators.ReorgOperator;
import org.tugraz.sysds.runtime.matrix.operators.ScalarOperator;
import org.tugraz.sysds.runtime.matrix.operators.TernaryOperator;
import org.tugraz.sysds.runtime.matrix.operators.UnaryOperator;
import org.tugraz.sysds.runtime.util.CommonThreadPool;
import org.tugraz.sysds.runtime.util.IndexRange;
import org.tugraz.sysds.runtime.util.SortUtils;

public class CompressedMatrixBlock
extends MatrixBlock {
    private static final boolean LOCAL_DEBUG = false;
    private static final Level LOCAL_DEBUG_LEVEL = Level.DEBUG;
    private static final Log LOG = LogFactory.getLog((String)CompressedMatrixBlock.class.getName());
    private static final long serialVersionUID = 7319372019143154058L;
    public static final boolean TRANSPOSE_INPUT = true;
    public static final boolean MATERIALIZE_ZEROS = false;
    public static final long MIN_PAR_AGG_THRESHOLD = 0x1000000L;
    public static final boolean INVESTIGATE_ESTIMATES = false;
    public static boolean ALLOW_DDC_ENCODING = true;
    public static final boolean ALLOW_SHARED_DDC1_DICTIONARY = true;
    protected ArrayList<ColGroup> _colGroups = null;
    protected CompressionStatistics _stats = null;
    protected boolean _sharedDDC1Dict = false;
    protected long seed = -1L;
    protected double sampling_ratio = 0.05;

    public CompressedMatrixBlock() {
    }

    public CompressedMatrixBlock(int rl, int cl, boolean sparse) {
        super(rl, cl, sparse);
    }

    public CompressedMatrixBlock(MatrixBlock that) {
        super(that.getNumRows(), that.getNumColumns(), that.isInSparseFormat());
        if (this.isInSparseFormat()) {
            this.sparseBlock = that.getSparseBlock();
        } else {
            this.denseBlock = that.getDenseBlock();
        }
        this.nonZeros = that.getNonZeros();
    }

    public ArrayList<ColGroup> getColGroups() {
        return this._colGroups;
    }

    public int getNumColGroups() {
        return this._colGroups.size();
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setSamplingRatio(double sampling_ratio) {
        this.sampling_ratio = sampling_ratio;
    }

    public boolean isCompressed() {
        return this._colGroups != null;
    }

    public boolean isSingleUncompressedGroup() {
        return this._colGroups != null && this._colGroups.size() == 1 && this._colGroups.get(0) instanceof ColGroupUncompressed;
    }

    private void allocateColGroupList() {
        this._colGroups = new ArrayList();
    }

    @Override
    public boolean isEmptyBlock(boolean safe) {
        if (!this.isCompressed()) {
            return super.isEmptyBlock(safe);
        }
        return this._colGroups == null || this.getNonZeros() == 0L;
    }

    public MatrixBlock compress() {
        return this.compress(1);
    }

    public MatrixBlock compress(int k) {
        double[] dict;
        if (this.isCompressed()) {
            throw new DMLRuntimeException("Redundant compression, block already compressed.");
        }
        Timing time = new Timing(true);
        this._stats = new CompressionStatistics();
        int numRows = this.getNumRows();
        int numCols = this.getNumColumns();
        boolean sparse = this.isInSparseFormat();
        MatrixBlock rawblock = LibMatrixReorg.transpose(this, new MatrixBlock(numCols, numRows, sparse), k);
        CompressedSizeEstimator bitmapSizeEstimator = CompressedSizeEstimatorFactory.getSizeEstimator(rawblock, numRows, this.seed, this.sampling_ratio);
        ArrayList<Integer> colsC = new ArrayList<Integer>();
        ArrayList<Integer> colsUC = new ArrayList<Integer>();
        HashMap<Integer, Double> compRatios = new HashMap<Integer, Double>();
        CompressedSizeInfo[] sizeInfos = k > 1 ? CompressedMatrixBlock.computeCompressedSizeInfos(bitmapSizeEstimator, numCols, k) : CompressedMatrixBlock.computeCompressedSizeInfos(bitmapSizeEstimator, numCols);
        long nnzUC = 0L;
        for (int col = 0; col < numCols; ++col) {
            double uncompSize = CompressedMatrixBlock.getUncompressedSize(numRows, 1, OptimizerUtils.getSparsity(numRows, 1L, sizeInfos[col].getEstNnz()));
            double compRatio = uncompSize / (double)sizeInfos[col].getMinSize();
            if (compRatio > 1.0) {
                colsC.add(col);
                compRatios.put(col, compRatio);
                continue;
            }
            colsUC.add(col);
            nnzUC += (long)sizeInfos[col].getEstNnz();
        }
        boolean sparseUC = MatrixBlock.evalSparseFormatInMemory(numRows, colsUC.size(), nnzUC);
        if (!sparseUC && !colsUC.isEmpty()) {
            for (int i = 0; i < colsUC.size(); ++i) {
                int col = (Integer)colsUC.get(i);
                double uncompSize = CompressedMatrixBlock.getUncompressedSize(numRows, 1, 1.0);
                double compRatio = uncompSize / (double)sizeInfos[col].getMinSize();
                if (!(compRatio > 1.0)) continue;
                colsC.add(col);
                colsUC.remove(i);
                --i;
                compRatios.put(col, compRatio);
                nnzUC -= (long)sizeInfos[col].getEstNnz();
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("C: " + Arrays.toString((Object[])colsC.toArray(new Integer[0]))));
            LOG.trace((Object)("-- compression ratios: " + Arrays.toString(colsC.stream().map(c -> (Double)compRatios.get(c)).toArray())));
            LOG.trace((Object)("UC: " + Arrays.toString((Object[])colsUC.toArray(new Integer[0]))));
            LOG.trace((Object)("-- compression ratios: " + Arrays.toString(colsUC.stream().map(c -> (Double)compRatios.get(c)).toArray())));
        }
        if (LOG.isDebugEnabled()) {
            this._stats.timePhase1 = time.stop();
            LOG.debug((Object)"Compression statistics:");
            LOG.debug((Object)("--compression phase 1: " + this._stats.timePhase1));
        }
        if (colsC.isEmpty()) {
            LOG.warn((Object)"Abort block compression because all columns are incompressible.");
            return new MatrixBlock().copyShallow(this);
        }
        List<int[]> bitmapColGrps = PlanningCoCoder.findCocodesByPartitioning(bitmapSizeEstimator, colsC, sizeInfos, numRows, k);
        if (LOG.isDebugEnabled()) {
            this._stats.timePhase2 = time.stop();
            LOG.debug((Object)("--compression phase 2: " + this._stats.timePhase2));
        }
        ColGroup[] colGroups = k > 1 ? CompressedMatrixBlock.compressColGroups(rawblock, bitmapSizeEstimator, compRatios, numRows, bitmapColGrps, colsUC.isEmpty(), k) : CompressedMatrixBlock.compressColGroups(rawblock, bitmapSizeEstimator, compRatios, numRows, bitmapColGrps, colsUC.isEmpty());
        this.allocateColGroupList();
        HashSet<Integer> remainingCols = CompressedMatrixBlock.seq(0, numCols - 1, 1);
        for (int j = 0; j < colGroups.length; ++j) {
            if (colGroups[j] == null) continue;
            for (int col : colGroups[j].getColIndices()) {
                remainingCols.remove(col);
            }
            this._colGroups.add(colGroups[j]);
        }
        if (LOG.isDebugEnabled()) {
            this._stats.timePhase3 = time.stop();
            LOG.debug((Object)("--compression phase 3: " + this._stats.timePhase3));
        }
        if ((dict = CompressedMatrixBlock.createSharedDDC1Dictionary(this._colGroups)) != null) {
            CompressedMatrixBlock.applySharedDDC1Dictionary(this._colGroups, dict);
            this._sharedDDC1Dict = true;
        }
        if (LOG.isDebugEnabled()) {
            this._stats.timePhase4 = time.stop();
            LOG.debug((Object)("--compression phase 4: " + this._stats.timePhase4));
        }
        if (!remainingCols.isEmpty()) {
            ArrayList<Integer> list = new ArrayList<Integer>(remainingCols);
            ColGroupUncompressed ucgroup = new ColGroupUncompressed(list, rawblock);
            this._colGroups.add(ucgroup);
        }
        this._stats.size = this.estimateCompressedSizeInMemory();
        this._stats.ratio = (double)this.estimateSizeInMemory() / this._stats.size;
        if (this._stats.ratio < 1.0) {
            LOG.warn((Object)"Abort block compression because compression ratio is less than 1.");
            return new MatrixBlock().copyShallow(this);
        }
        rawblock.cleanupBlock(true, true);
        this.cleanupBlock(true, true);
        this._stats.timePhase5 = time.stop();
        int[] counts = CompressedMatrixBlock.getColGroupCounts(this._colGroups);
        LOG.info((Object)("--num col groups: " + this._colGroups.size() + ", -- num input cols: " + numCols));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("--compression phase 5: " + this._stats.timePhase5));
            LOG.debug((Object)("--col groups types (OLE,RLE,DDC1,DDC2,UC): " + counts[2] + "," + counts[1] + "," + counts[3] + "," + counts[4] + "," + counts[0]));
            LOG.debug((Object)("--col groups sizes (OLE,RLE,DDC1,DDC2,UC): " + counts[7] + "," + counts[6] + "," + counts[8] + "," + counts[9] + "," + counts[5]));
            LOG.debug((Object)("--compressed size: " + this._stats.size));
            LOG.debug((Object)("--compression ratio: " + this._stats.ratio));
        }
        return this;
    }

    public CompressionStatistics getCompressionStatistics() {
        return this._stats;
    }

    private static int[] getColGroupCounts(ArrayList<ColGroup> colgroups) {
        int[] ret = new int[10];
        for (ColGroup c : colgroups) {
            int n = c.getCompType().ordinal();
            ret[n] = ret[n] + 1;
            int n2 = 5 + c.getCompType().ordinal();
            ret[n2] = ret[n2] + c.getNumCols();
        }
        return ret;
    }

    private static CompressedSizeInfo[] computeCompressedSizeInfos(CompressedSizeEstimator estim, int clen) {
        CompressedSizeInfo[] ret = new CompressedSizeInfo[clen];
        for (int col = 0; col < clen; ++col) {
            ret[col] = estim.estimateCompressedColGroupSize(new int[]{col});
        }
        return ret;
    }

    private static CompressedSizeInfo[] computeCompressedSizeInfos(CompressedSizeEstimator estim, int clen, int k) {
        try {
            ExecutorService pool = CommonThreadPool.get(k);
            ArrayList<SizeEstimTask> tasks = new ArrayList<SizeEstimTask>();
            for (int col = 0; col < clen; ++col) {
                tasks.add(new SizeEstimTask(estim, col));
            }
            List rtask = pool.invokeAll(tasks);
            ArrayList ret = new ArrayList();
            for (Future lrtask : rtask) {
                ret.add(lrtask.get());
            }
            pool.shutdown();
            return ret.toArray(new CompressedSizeInfo[0]);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    private static ColGroup[] compressColGroups(MatrixBlock in, CompressedSizeEstimator estim, HashMap<Integer, Double> compRatios, int rlen, List<int[]> groups, boolean denseEst) {
        ColGroup[] ret = new ColGroup[groups.size()];
        for (int i = 0; i < groups.size(); ++i) {
            ret[i] = CompressedMatrixBlock.compressColGroup(in, estim, compRatios, rlen, groups.get(i), denseEst);
        }
        return ret;
    }

    private static ColGroup[] compressColGroups(MatrixBlock in, CompressedSizeEstimator estim, HashMap<Integer, Double> compRatios, int rlen, List<int[]> groups, boolean denseEst, int k) {
        try {
            ExecutorService pool = CommonThreadPool.get(k);
            ArrayList<CompressTask> tasks = new ArrayList<CompressTask>();
            for (int[] colIndexes : groups) {
                tasks.add(new CompressTask(in, estim, compRatios, rlen, colIndexes, denseEst));
            }
            List rtask = pool.invokeAll(tasks);
            ArrayList ret = new ArrayList();
            for (Future lrtask : rtask) {
                ret.add(lrtask.get());
            }
            pool.shutdown();
            return ret.toArray(new ColGroup[0]);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    private static ColGroup compressColGroup(MatrixBlock in, CompressedSizeEstimator estim, HashMap<Integer, Double> compRatios, int rlen, int[] colIndexes, boolean denseEst) {
        CompressedSizeInfo sizeInfo;
        int[] allGroupIndices = null;
        int allColsCount = colIndexes.length;
        UncompressedBitmap ubm = null;
        PriorityQueue<CompressedColumn> compRatioPQ = null;
        boolean skipGroup = false;
        block0: while (true) {
            ubm = BitmapEncoder.extractBitmap(colIndexes, in);
            sizeInfo = estim.estimateCompressedColGroupSize(ubm);
            double sp2 = denseEst ? 1.0 : OptimizerUtils.getSparsity(rlen, 1L, ubm.getNumOffsets());
            double compRatio = CompressedMatrixBlock.getUncompressedSize(rlen, colIndexes.length, sp2) / (double)sizeInfo.getMinSize();
            if (compRatio > 1.0) break;
            if (compRatioPQ == null) {
                allGroupIndices = (int[])colIndexes.clone();
                compRatioPQ = new PriorityQueue<CompressedColumn>();
                for (int i = 0; i < colIndexes.length; ++i) {
                    compRatioPQ.add(new CompressedColumn(i, compRatios.get(colIndexes[i])));
                }
            }
            int removeIx = ((CompressedColumn)compRatioPQ.poll()).colIx;
            allGroupIndices[removeIx] = -1;
            if (--allColsCount == 0) {
                skipGroup = true;
                break;
            }
            colIndexes = new int[allColsCount];
            int ix = 0;
            int[] nArray = allGroupIndices;
            int n = nArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block0;
                int col = nArray[n2];
                if (col != -1) {
                    colIndexes[ix++] = col;
                }
                ++n2;
            }
            break;
        }
        if (skipGroup) {
            return null;
        }
        long rleSize = sizeInfo.getRLESize();
        long oleSize = sizeInfo.getOLESize();
        long ddcSize = sizeInfo.getDDCSize();
        if (ALLOW_DDC_ENCODING && ddcSize < rleSize && ddcSize < oleSize) {
            if (ubm.getNumValues() <= 255) {
                return new ColGroupDDC1(colIndexes, rlen, ubm);
            }
            return new ColGroupDDC2(colIndexes, rlen, ubm);
        }
        if (rleSize < oleSize) {
            return new ColGroupRLE(colIndexes, rlen, ubm);
        }
        return new ColGroupOLE(colIndexes, rlen, ubm);
    }

    private static double getUncompressedSize(int rlen, int clen, double sparsity) {
        return Math.min(8.0 * (double)rlen * (double)clen, 4.0 * (double)rlen + 12.0 * (double)rlen * (double)clen * sparsity);
    }

    private static double[] createSharedDDC1Dictionary(ArrayList<ColGroup> colGroups) {
        int maxSize;
        if (!ALLOW_DDC_ENCODING) {
            return null;
        }
        HashSet<Double> tmp = new HashSet<Double>();
        int numQual = 0;
        for (ColGroup grp : colGroups) {
            if (grp.getNumCols() != 1 || !(grp instanceof ColGroupDDC1)) continue;
            ColGroupDDC1 grpDDC1 = (ColGroupDDC1)grp;
            for (double val : grpDDC1.getValues()) {
                tmp.add(val);
            }
            ++numQual;
        }
        int n = maxSize = tmp.contains(0.0) ? 256 : 255;
        if (tmp.isEmpty() || tmp.size() > maxSize || numQual < 2) {
            return null;
        }
        LOG.debug((Object)("Created shared directionary for " + numQual + " DDC1 single column groups."));
        return tmp.stream().mapToDouble(Double::doubleValue).toArray();
    }

    private static void applySharedDDC1Dictionary(ArrayList<ColGroup> colGroups, double[] dict) {
        HashMap<Double, Integer> map = new HashMap<Double, Integer>();
        for (int i = 0; i < dict.length; ++i) {
            map.put(dict[i], i);
        }
        for (ColGroup grp : colGroups) {
            if (grp.getNumCols() != 1 || !(grp instanceof ColGroupDDC1)) continue;
            ColGroupDDC1 grpDDC1 = (ColGroupDDC1)grp;
            grpDDC1.recodeData(map);
            grpDDC1.setValues(dict);
        }
    }

    public MatrixBlock decompress() {
        if (!this.isCompressed()) {
            return new MatrixBlock(this);
        }
        Timing time = new Timing(true);
        MatrixBlock ret = new MatrixBlock(this.getNumRows(), this.getNumColumns(), this.isInSparseFormat(), this.getNonZeros());
        if (ret.isInSparseFormat()) {
            int[] rnnz = new int[this.rlen];
            for (ColGroup grp : this._colGroups) {
                grp.countNonZerosPerRow(rnnz, 0, this.rlen);
            }
            ret.allocateSparseRowsBlock();
            SparseBlock rows = ret.getSparseBlock();
            for (int i = 0; i < this.rlen; ++i) {
                rows.allocate(i, rnnz[i]);
            }
        }
        for (ColGroup grp : this._colGroups) {
            grp.decompressToBlock(ret, 0, this.rlen);
        }
        ret.setNonZeros(this.nonZeros);
        if (ret.isInSparseFormat()) {
            ret.sortSparseRows();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("decompressed block in " + time.stop() + "ms."));
        }
        return ret;
    }

    public MatrixBlock decompress(int k) {
        if (!this.isCompressed()) {
            return new MatrixBlock(this);
        }
        if (k <= 1) {
            return this.decompress();
        }
        Timing time = LOG.isDebugEnabled() ? new Timing(true) : null;
        MatrixBlock ret = new MatrixBlock(this.rlen, this.clen, this.sparse, this.nonZeros).allocateBlock();
        try {
            ExecutorService pool = CommonThreadPool.get(k);
            int rlen = this.getNumRows();
            int blklen = BitmapEncoder.getAlignedBlocksize((int)Math.ceil((double)rlen / (double)k));
            ArrayList<DecompressTask> tasks = new ArrayList<DecompressTask>();
            int i = 0;
            while (i < k & i * blklen < this.getNumRows()) {
                tasks.add(new DecompressTask(this._colGroups, ret, i * blklen, Math.min((i + 1) * blklen, rlen)));
                ++i;
            }
            List rtasks = pool.invokeAll(tasks);
            pool.shutdown();
            for (Future rt : rtasks) {
                rt.get();
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        ret.setNonZeros(this.nonZeros);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("decompressed block w/ k=" + k + " in " + time.stop() + "ms."));
        }
        return ret;
    }

    public long estimateCompressedSizeInMemory() {
        if (!this.isCompressed()) {
            return 0L;
        }
        long total = MatrixBlock.estimateSizeInMemory(0L, 0L, 0.0);
        total += (long)(80 + 8 * this._colGroups.size());
        for (ColGroup grp : this._colGroups) {
            total += grp.estimateInMemorySize();
        }
        if (this._sharedDDC1Dict) {
            boolean seenDDC1 = false;
            for (ColGroup grp : this._colGroups) {
                if (grp.getNumCols() != 1 || !(grp instanceof ColGroupDDC1)) continue;
                if (seenDDC1) {
                    total -= ((ColGroupDDC1)grp).getValuesSize();
                }
                seenDDC1 = true;
            }
        }
        return total;
    }

    @Override
    public double quickGetValue(int r, int c) {
        if (!this.isCompressed()) {
            return super.quickGetValue(r, c);
        }
        ColGroup grp = null;
        for (ColGroup group : this._colGroups) {
            if (Arrays.binarySearch(group.getColIndices(), c) < 0) continue;
            grp = group;
            break;
        }
        return grp.get(r, c);
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = 22L;
        for (ColGroup grp : this._colGroups) {
            ++ret;
            ret += grp.getExactSizeOnDisk();
        }
        return ret;
    }

    @Override
    public boolean isShallowSerialize() {
        return false;
    }

    @Override
    public boolean isShallowSerialize(boolean inclConvert) {
        return false;
    }

    @Override
    public void toShallowSerializeBlock() {
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        boolean compressed = in.readBoolean();
        if (!compressed) {
            super.readFields(in);
            return;
        }
        this.rlen = in.readInt();
        this.clen = in.readInt();
        this.nonZeros = in.readLong();
        this._sharedDDC1Dict = in.readBoolean();
        int ncolGroups = in.readInt();
        this._colGroups = new ArrayList(ncolGroups);
        double[] sharedDict = null;
        for (int i = 0; i < ncolGroups; ++i) {
            ColGroup.CompressionType ctype = ColGroup.CompressionType.values()[in.readByte()];
            ColGroup grp = null;
            switch (ctype) {
                case UNCOMPRESSED: {
                    grp = new ColGroupUncompressed();
                    break;
                }
                case OLE_BITMAP: {
                    grp = new ColGroupOLE();
                    break;
                }
                case RLE_BITMAP: {
                    grp = new ColGroupRLE();
                    break;
                }
                case DDC1: {
                    grp = new ColGroupDDC1();
                    break;
                }
                case DDC2: {
                    grp = new ColGroupDDC2();
                }
            }
            grp.readFields(in, sharedDict != null);
            if (this._sharedDDC1Dict && grp.getNumCols() == 1 && grp instanceof ColGroupDDC1) {
                if (sharedDict == null) {
                    sharedDict = ((ColGroupValue)grp).getValues();
                } else {
                    ((ColGroupValue)grp).setValues(sharedDict);
                }
            }
            this._colGroups.add(grp);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.isCompressed());
        if (!this.isCompressed()) {
            super.write(out);
            return;
        }
        out.writeInt(this.rlen);
        out.writeInt(this.clen);
        out.writeLong(this.nonZeros);
        out.writeBoolean(this._sharedDDC1Dict);
        out.writeInt(this._colGroups.size());
        boolean skipDict = false;
        for (ColGroup grp : this._colGroups) {
            boolean shared = grp instanceof ColGroupDDC1 && this._sharedDDC1Dict && grp.getNumCols() == 1;
            out.writeByte(grp.getCompType().ordinal());
            grp.write(out, skipDict & shared);
            skipDict |= shared;
        }
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException {
        this.readFields(is);
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        this.write(os);
    }

    public Iterator<IJV> getIterator(int rl, int ru, boolean inclZeros) {
        return this.getIterator(rl, ru, 0, this.getNumColGroups(), inclZeros);
    }

    public Iterator<IJV> getIterator(int rl, int ru, int cgl, int cgu, boolean inclZeros) {
        return new ColumnGroupIterator(rl, ru, cgl, cgu, inclZeros, this._colGroups);
    }

    public Iterator<double[]> getDenseRowIterator(int rl, int ru) {
        return new DenseRowIterator(rl, ru, this._colGroups, this.clen);
    }

    public Iterator<SparseRow> getSparseRowIterator(int rl, int ru) {
        return new SparseRowIterator(rl, ru, this._colGroups, this.clen);
    }

    public int[] countNonZerosPerRow(int rl, int ru) {
        int[] rnnz = new int[ru - rl];
        for (ColGroup grp : this._colGroups) {
            grp.countNonZerosPerRow(rnnz, rl, ru);
        }
        return rnnz;
    }

    @Override
    public MatrixBlock scalarOperations(ScalarOperator sop, MatrixValue result) {
        if (!this.isCompressed()) {
            return super.scalarOperations(sop, result);
        }
        CompressedMatrixBlock ret = null;
        if (result == null || !(result instanceof CompressedMatrixBlock)) {
            ret = new CompressedMatrixBlock(this.getNumRows(), this.getNumColumns(), this.sparse);
        } else {
            ret = (CompressedMatrixBlock)result;
            ret.reset(this.rlen, this.clen);
        }
        ArrayList<ColGroup> newColGroups = new ArrayList<ColGroup>();
        for (ColGroup grp : this._colGroups) {
            newColGroups.add(grp.scalarOperation(sop));
        }
        ret._colGroups = newColGroups;
        ret.setNonZeros(this.rlen * this.clen);
        return ret;
    }

    @Override
    public MatrixBlock append(MatrixBlock that, MatrixBlock ret) {
        if (!this.isCompressed()) {
            if (that instanceof CompressedMatrixBlock) {
                that = ((CompressedMatrixBlock)that).decompress();
            }
            return super.append(that, ret, true);
        }
        int m = this.rlen;
        int n = this.clen + that.getNumColumns();
        long nnz = this.nonZeros + that.getNonZeros();
        CompressedMatrixBlock ret2 = null;
        if (ret == null || !(ret instanceof CompressedMatrixBlock)) {
            ret2 = new CompressedMatrixBlock(m, n, this.isInSparseFormat());
        } else {
            ret2 = (CompressedMatrixBlock)ret;
            ret2.reset(m, n);
        }
        ret2.allocateColGroupList();
        ret2._colGroups.addAll(this._colGroups);
        if (!(that instanceof CompressedMatrixBlock)) {
            that = new CompressedMatrixBlock(that);
            ((CompressedMatrixBlock)that).compress();
        }
        ArrayList<ColGroup> inColGroups = ((CompressedMatrixBlock)that)._colGroups;
        for (ColGroup group : inColGroups) {
            ColGroup tmp = ConverterUtils.copyColGroup(group);
            tmp.shiftColIndices(this.clen);
            ret2._colGroups.add(tmp);
        }
        ret2.setNonZeros(nnz);
        return ret2;
    }

    @Override
    public MatrixBlock chainMatrixMultOperations(MatrixBlock v, MatrixBlock w, MatrixBlock out, MapMultChain.ChainType ctype) {
        if (!this.isCompressed()) {
            return super.chainMatrixMultOperations(v, w, out, ctype);
        }
        if (this.getNumColumns() != v.getNumRows()) {
            throw new DMLRuntimeException("Dimensions mismatch on mmchain operation (" + this.getNumColumns() + " != " + v.getNumRows() + ")");
        }
        if (v.getNumColumns() != 1) {
            throw new DMLRuntimeException("Invalid input vector (column vector expected, but ncol=" + v.getNumColumns() + ")");
        }
        if (w != null && w.getNumColumns() != 1) {
            throw new DMLRuntimeException("Invalid weight vector (column vector expected, but ncol=" + w.getNumColumns() + ")");
        }
        if (this.isSingleUncompressedGroup()) {
            return ((ColGroupUncompressed)this._colGroups.get(0)).getData().chainMatrixMultOperations(v, w, out, ctype);
        }
        if (out != null) {
            out.reset(this.clen, 1, false);
        } else {
            out = new MatrixBlock(this.clen, 1, false);
        }
        if (this.isEmptyBlock(false)) {
            return out;
        }
        MatrixBlock tmp = new MatrixBlock(this.rlen, 1, false);
        this.rightMultByVector(v, tmp);
        if (ctype == MapMultChain.ChainType.XtwXv) {
            BinaryOperator bop = new BinaryOperator(Multiply.getMultiplyFnObject());
            LibMatrixBincell.bincellOpInPlace(tmp, w, bop);
        }
        CompressedMatrixBlock.leftMultByVectorTranspose(this._colGroups, tmp, out, true, true);
        return out;
    }

    @Override
    public MatrixBlock chainMatrixMultOperations(MatrixBlock v, MatrixBlock w, MatrixBlock out, MapMultChain.ChainType ctype, int k) {
        if (!this.isCompressed()) {
            return super.chainMatrixMultOperations(v, w, out, ctype, k);
        }
        if (this.getNumColumns() != v.getNumRows()) {
            throw new DMLRuntimeException("Dimensions mismatch on mmchain operation (" + this.getNumColumns() + " != " + v.getNumRows() + ")");
        }
        if (v.getNumColumns() != 1) {
            throw new DMLRuntimeException("Invalid input vector (column vector expected, but ncol=" + v.getNumColumns() + ")");
        }
        if (w != null && w.getNumColumns() != 1) {
            throw new DMLRuntimeException("Invalid weight vector (column vector expected, but ncol=" + w.getNumColumns() + ")");
        }
        if (this.isSingleUncompressedGroup()) {
            return ((ColGroupUncompressed)this._colGroups.get(0)).getData().chainMatrixMultOperations(v, w, out, ctype, k);
        }
        if (out != null) {
            out.reset(this.clen, 1, false);
        } else {
            out = new MatrixBlock(this.clen, 1, false);
        }
        if (this.isEmptyBlock(false)) {
            return out;
        }
        MatrixBlock tmp = new MatrixBlock(this.rlen, 1, false);
        this.rightMultByVector(v, tmp, k);
        if (ctype == MapMultChain.ChainType.XtwXv) {
            BinaryOperator bop = new BinaryOperator(Multiply.getMultiplyFnObject());
            LibMatrixBincell.bincellOpInPlace(tmp, w, bop);
        }
        this.leftMultByVectorTranspose(this._colGroups, tmp, out, true, k);
        return out;
    }

    @Override
    public MatrixBlock aggregateBinaryOperations(MatrixBlock m1, MatrixBlock m2, MatrixBlock ret, AggregateBinaryOperator op) {
        if (!this.isCompressed()) {
            return super.aggregateBinaryOperations(m1, m2, ret, op);
        }
        if (this.isSingleUncompressedGroup()) {
            MatrixBlock tmp = ((ColGroupUncompressed)this._colGroups.get(0)).getData();
            return tmp.aggregateBinaryOperations(this == m1 ? tmp : m1, this == m2 ? tmp : m2, ret, op);
        }
        Timing time = LOG.isDebugEnabled() ? new Timing(true) : null;
        int rl = m1.getNumRows();
        int cl = m2.getNumColumns();
        if (ret == null) {
            ret = new MatrixBlock(rl, cl, false, rl * cl);
        } else {
            ret.reset(rl, cl, false, rl * cl);
        }
        if (m1.getNumRows() > 1 && m2.getNumColumns() == 1) {
            CompressedMatrixBlock cmb = (CompressedMatrixBlock)m1;
            if (op.getNumThreads() > 1) {
                cmb.rightMultByVector(m2, ret, op.getNumThreads());
            } else {
                cmb.rightMultByVector(m2, ret);
            }
        } else if (m1.getNumRows() == 1 && m2.getNumColumns() > 1) {
            if (op.getNumThreads() > 1) {
                this.leftMultByVectorTranspose(this._colGroups, m1, ret, false, op.getNumThreads());
            } else {
                CompressedMatrixBlock.leftMultByVectorTranspose(this._colGroups, m1, ret, false, true);
            }
        } else {
            MatrixBlock that;
            boolean right = m1 == this;
            MatrixBlock matrixBlock = that = right ? m2 : m1;
            if (that instanceof CompressedMatrixBlock) {
                MatrixBlock matrixBlock2 = that = ((CompressedMatrixBlock)that).isCompressed() ? ((CompressedMatrixBlock)that).decompress() : that;
            }
            if (right) {
                that = LibMatrixReorg.transpose(that, new MatrixBlock(that.getNumColumns(), that.getNumRows(), that.isInSparseFormat()), op.getNumThreads());
            }
            MatrixBlock tmpIn = new MatrixBlock(1, that.getNumColumns(), false).allocateBlock();
            MatrixBlock tmpOut = new MatrixBlock(right ? rl : 1, right ? 1 : cl, false).allocateBlock();
            if (right) {
                for (int i = 0; i < that.getNumRows(); ++i) {
                    tmpIn = that.slice(i, i, 0, that.getNumColumns() - 1, tmpIn);
                    MatrixBlock tmpIn2 = LibMatrixReorg.transpose(tmpIn, new MatrixBlock(tmpIn.getNumColumns(), tmpIn.getNumRows(), false));
                    tmpOut.reset(tmpOut.getNumRows(), tmpOut.getNumColumns());
                    if (op.getNumThreads() > 1) {
                        this.rightMultByVector(tmpIn2, tmpOut, op.getNumThreads());
                    } else {
                        this.rightMultByVector(tmpIn2, tmpOut);
                    }
                    ret.leftIndexingOperations(tmpOut, 0, ret.getNumRows() - 1, i, i, ret, MatrixObject.UpdateType.INPLACE);
                }
            } else {
                for (int i = 0; i < that.getNumRows(); ++i) {
                    tmpIn = that.slice(i, i, 0, that.getNumColumns() - 1, tmpIn);
                    if (op.getNumThreads() > 1) {
                        this.leftMultByVectorTranspose(this._colGroups, tmpIn, tmpOut, false, op.getNumThreads());
                    } else {
                        CompressedMatrixBlock.leftMultByVectorTranspose(this._colGroups, tmpIn, tmpOut, false, true);
                    }
                    ret.leftIndexingOperations(tmpOut, i, i, 0, ret.getNumColumns() - 1, ret, MatrixObject.UpdateType.INPLACE);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Compressed MM in " + time.stop()));
        }
        return ret;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public MatrixBlock aggregateUnaryOperations(AggregateUnaryOperator op, MatrixValue result, int blen, MatrixIndexes indexesIn, boolean inCP) {
        if (!this.isCompressed()) {
            return super.aggregateUnaryOperations(op, result, blen, indexesIn, inCP);
        }
        if (!(op.aggOp.increOp.fn instanceof KahanPlus || op.aggOp.increOp.fn instanceof KahanPlusSq || op.aggOp.increOp.fn instanceof Builtin && (((Builtin)op.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MIN || ((Builtin)op.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MAX))) {
            throw new DMLRuntimeException("Unary aggregates other than sum/sumsq/min/max not supported yet.");
        }
        time = CompressedMatrixBlock.LOG.isDebugEnabled() != false ? new Timing(true) : null;
        tempCellIndex = new MatrixValue.CellIndex(-1, -1);
        op.indexFn.computeDimension(this.rlen, this.clen, tempCellIndex);
        if (op.aggOp.existsCorrection()) {
            switch (1.$SwitchMap$org$tugraz$sysds$common$Types$CorrectionLocationType[op.aggOp.correction.ordinal()]) {
                case 1: {
                    ++tempCellIndex.row;
                    break;
                }
                case 2: {
                    ++tempCellIndex.column;
                    break;
                }
                case 3: {
                    tempCellIndex.row += 2;
                    break;
                }
                case 4: {
                    tempCellIndex.column += 2;
                    break;
                }
                default: {
                    throw new DMLRuntimeException("unrecognized correctionLocation: " + (Object)op.aggOp.correction);
                }
            }
        }
        if (result == null) {
            result = new MatrixBlock(tempCellIndex.row, tempCellIndex.column, false);
        } else {
            result.reset(tempCellIndex.row, tempCellIndex.column, false);
        }
        ret = (MatrixBlock)result;
        ret.allocateDenseBlock();
        if (op.indexFn instanceof ReduceCol && op.aggOp.increOp.fn instanceof Builtin) {
            val = ((Builtin)op.aggOp.increOp.fn).getBuiltinCode() == Builtin.BuiltinCode.MAX ? -Infinity : Infinity;
            ret.getDenseBlock().set(val);
        }
        if (op.getNumThreads() > 1 && this.getExactSizeOnDisk() > 0x1000000L) {
            grpParts = this.createStaticTaskPartitioning(op.indexFn instanceof ReduceCol != false ? 1 : op.getNumThreads(), false);
            uc = this.getUncompressedColGroup();
            try {
                if (uc != null) {
                    uc.unaryAggregateOperations(op, ret);
                }
                pool = CommonThreadPool.get(op.getNumThreads());
                tasks = new ArrayList<UnaryAggregateTask>();
                if (op.indexFn instanceof ReduceCol && grpParts.length > 0) {
                    blklen = BitmapEncoder.getAlignedBlocksize((int)Math.ceil((double)this.rlen / (double)op.getNumThreads()));
                    i = 0;
                    while (i < op.getNumThreads() & i * blklen < this.rlen) {
                        tasks.add(new UnaryAggregateTask(grpParts[0], ret, i * blklen, Math.min((i + 1) * blklen, this.rlen), op));
                        ++i;
                    }
                } else {
                    for (ArrayList<ColGroup> grp : grpParts) {
                        tasks.add(new UnaryAggregateTask(grp, ret, 0, this.rlen, op));
                    }
                }
                rtasks = pool.invokeAll(tasks);
                pool.shutdown();
                if (!(op.indexFn instanceof ReduceAll)) ** GOTO lbl82
                if (op.aggOp.increOp.fn instanceof KahanFunction) {
                    kbuff = new KahanObject(ret.quickGetValue(0, 0), 0.0);
                    for (Future<T> rtask : rtasks) {
                        tmp = ((MatrixBlock)rtask.get()).quickGetValue(0, 0);
                        ((KahanFunction)op.aggOp.increOp.fn).execute2(kbuff, tmp);
                    }
                    ret.quickSetValue(0, 0, kbuff._sum);
                }
                val = ret.quickGetValue(0, 0);
                for (Future<T> rtask : rtasks) {
                    tmp = ((MatrixBlock)rtask.get()).quickGetValue(0, 0);
                    val = op.aggOp.increOp.fn.execute(val, tmp);
                }
                ret.quickSetValue(0, 0, val);
            }
            catch (Exception ex) {
                throw new DMLRuntimeException(ex);
            }
        } else {
            for (Object grp : this._colGroups) {
                if (!(grp instanceof ColGroupUncompressed)) continue;
                grp.unaryAggregateOperations(op, ret);
            }
            CompressedMatrixBlock.aggregateUnaryOperations(op, this._colGroups, ret, 0, this.rlen);
        }
lbl82:
        // 4 sources

        if (op.indexFn instanceof ReduceCol && op.aggOp.increOp.fn instanceof Builtin) {
            rnnz = new int[this.rlen];
            for (ColGroup grp : this._colGroups) {
                grp.countNonZerosPerRow(rnnz, 0, this.rlen);
            }
            builtin = (Builtin)op.aggOp.increOp.fn;
            for (i = 0; i < this.rlen; ++i) {
                if (rnnz[i] >= this.clen) continue;
                ret.quickSetValue(i, 0, builtin.execute(ret.quickGetValue(i, 0), 0.0));
            }
        }
        if (op.aggOp.existsCorrection() && inCP) {
            ret.dropLastRowsOrColumns(op.aggOp.correction);
        }
        ret.recomputeNonZeros();
        if (CompressedMatrixBlock.LOG.isDebugEnabled()) {
            CompressedMatrixBlock.LOG.debug((Object)("Compressed uagg k=" + op.getNumThreads() + " in " + time.stop()));
        }
        return ret;
    }

    @Override
    public MatrixBlock aggregateUnaryOperations(AggregateUnaryOperator op, MatrixValue result, int blen, MatrixIndexes indexesIn) {
        return this.aggregateUnaryOperations(op, result, blen, indexesIn, false);
    }

    private static void aggregateUnaryOperations(AggregateUnaryOperator op, ArrayList<ColGroup> groups, MatrixBlock ret, int rl, int ru) {
        boolean cacheDDC1;
        boolean bl = cacheDDC1 = ColGroupValue.LOW_LEVEL_OPT && op.indexFn instanceof ReduceCol && op.aggOp.increOp.fn instanceof KahanPlus && ColGroupOffset.ALLOW_CACHE_CONSCIOUS_ROWSUMS && ru - rl > 65536;
        if (cacheDDC1) {
            ArrayList<ColGroupDDC1> tmp = new ArrayList<ColGroupDDC1>();
            for (ColGroup grp : groups) {
                if (!(grp instanceof ColGroupDDC1)) continue;
                tmp.add((ColGroupDDC1)grp);
            }
            if (!tmp.isEmpty()) {
                ColGroupDDC1.computeRowSums(tmp.toArray(new ColGroupDDC1[0]), ret, KahanPlus.getKahanPlusFnObject(), rl, ru);
            }
        }
        for (ColGroup grp : groups) {
            if (grp instanceof ColGroupUncompressed || cacheDDC1 && grp instanceof ColGroupDDC1) continue;
            ((ColGroupValue)grp).unaryAggregateOperations(op, ret, rl, ru);
        }
    }

    @Override
    public MatrixBlock transposeSelfMatrixMultOperations(MatrixBlock out, MMTSJ.MMTSJType tstype) {
        Timing time;
        if (!this.isCompressed()) {
            return super.transposeSelfMatrixMultOperations(out, tstype);
        }
        if (this.isSingleUncompressedGroup()) {
            return ((ColGroupUncompressed)this._colGroups.get(0)).getData().transposeSelfMatrixMultOperations(out, tstype);
        }
        Timing timing = time = LOG.isDebugEnabled() ? new Timing(true) : null;
        if (tstype != MMTSJ.MMTSJType.LEFT) {
            throw new DMLRuntimeException("Invalid MMTSJ type '" + tstype.toString() + "'.");
        }
        if (out == null) {
            out = new MatrixBlock(this.clen, this.clen, false);
        } else {
            out.reset(this.clen, this.clen, false);
        }
        out.allocateDenseBlock();
        if (!this.isEmptyBlock(false)) {
            CompressedMatrixBlock.leftMultByTransposeSelf(this._colGroups, out, 0, this._colGroups.size());
            out.setNonZeros(LinearAlgebraUtils.copyUpperToLowerTriangle(out));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Compressed TSMM in " + time.stop()));
        }
        return out;
    }

    @Override
    public MatrixBlock transposeSelfMatrixMultOperations(MatrixBlock out, MMTSJ.MMTSJType tstype, int k) {
        Timing time;
        if (!this.isCompressed()) {
            return super.transposeSelfMatrixMultOperations(out, tstype, k);
        }
        if (this.isSingleUncompressedGroup()) {
            return ((ColGroupUncompressed)this._colGroups.get(0)).getData().transposeSelfMatrixMultOperations(out, tstype, k);
        }
        Timing timing = time = LOG.isDebugEnabled() ? new Timing(true) : null;
        if (tstype != MMTSJ.MMTSJType.LEFT) {
            throw new DMLRuntimeException("Invalid MMTSJ type '" + tstype.toString() + "'.");
        }
        if (out == null) {
            out = new MatrixBlock(this.clen, this.clen, false);
        } else {
            out.reset(this.clen, this.clen, false);
        }
        out.allocateDenseBlock();
        if (!this.isEmptyBlock(false)) {
            try {
                ExecutorService pool = CommonThreadPool.get(k);
                ArrayList<MatrixMultTransposeTask> tasks = new ArrayList<MatrixMultTransposeTask>();
                int numgrp = this._colGroups.size();
                int blklen = (int)Math.ceil((double)numgrp / (double)(2 * k));
                int i = 0;
                while (i < 2 * k & i * blklen < this.clen) {
                    tasks.add(new MatrixMultTransposeTask(this._colGroups, out, i * blklen, Math.min((i + 1) * blklen, numgrp)));
                    ++i;
                }
                List ret = pool.invokeAll(tasks);
                for (Future tret : ret) {
                    tret.get();
                }
                pool.shutdown();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error((Object)e.getMessage());
                throw new DMLRuntimeException(e);
            }
            out.setNonZeros(LinearAlgebraUtils.copyUpperToLowerTriangle(out));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Compressed TSMM k=" + k + " in " + time.stop()));
        }
        return out;
    }

    private void rightMultByVector(MatrixBlock vector, MatrixBlock result) {
        result.allocateDenseBlock();
        CompressedMatrixBlock.rightMultByVector(this._colGroups, vector, result, true, 0, result.getNumRows());
        result.recomputeNonZeros();
    }

    private void rightMultByVector(MatrixBlock vector, MatrixBlock result, int k) {
        result.allocateDenseBlock();
        try {
            ColGroupUncompressed uc = this.getUncompressedColGroup();
            if (uc != null) {
                uc.rightMultByVector(vector, result, k);
            }
            ExecutorService pool = CommonThreadPool.get(k);
            int rlen = this.getNumRows();
            int blklen = BitmapEncoder.getAlignedBlocksize((int)Math.ceil((double)rlen / (double)k));
            ArrayList<RightMatrixMultTask> tasks = new ArrayList<RightMatrixMultTask>();
            int i = 0;
            while (i < k & i * blklen < this.getNumRows()) {
                tasks.add(new RightMatrixMultTask(this._colGroups, vector, result, i * blklen, Math.min((i + 1) * blklen, rlen)));
                ++i;
            }
            List ret = pool.invokeAll(tasks);
            pool.shutdown();
            long lnnz = 0L;
            for (Future tmp : ret) {
                lnnz += ((Long)tmp.get()).longValue();
            }
            result.setNonZeros(lnnz);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    private static void rightMultByVector(ArrayList<ColGroup> groups, MatrixBlock vect, MatrixBlock ret, boolean inclUC, int rl, int ru) {
        boolean cacheDDC1;
        ColGroupValue.setupThreadLocalMemory(CompressedMatrixBlock.getMaxNumValues(groups));
        boolean bl = cacheDDC1 = ColGroupValue.LOW_LEVEL_OPT && ru - rl > 131072;
        if (inclUC) {
            for (ColGroup colGroup : groups) {
                if (!(colGroup instanceof ColGroupUncompressed)) continue;
                colGroup.rightMultByVector(vect, ret, rl, ru);
            }
        }
        if (cacheDDC1) {
            ArrayList<ColGroupDDC1> tmp = new ArrayList<ColGroupDDC1>();
            for (ColGroup grp : groups) {
                if (!(grp instanceof ColGroupDDC1)) continue;
                tmp.add((ColGroupDDC1)grp);
            }
            if (!tmp.isEmpty()) {
                ColGroupDDC1.rightMultByVector(tmp.toArray(new ColGroupDDC1[0]), vect, ret, rl, ru);
            }
        }
        for (ColGroup colGroup : groups) {
            if (colGroup instanceof ColGroupUncompressed || cacheDDC1 && colGroup instanceof ColGroupDDC1) continue;
            colGroup.rightMultByVector(vect, ret, rl, ru);
        }
        ColGroupValue.cleanupThreadLocalMemory();
    }

    private static void leftMultByVectorTranspose(List<ColGroup> colGroups, MatrixBlock vector, MatrixBlock result, boolean doTranspose, boolean allocTmp) {
        MatrixBlock rowVector = vector;
        if (doTranspose) {
            rowVector = new MatrixBlock(1, vector.getNumRows(), false);
            LibMatrixReorg.transpose(vector, rowVector);
        }
        result.reset();
        result.allocateDenseBlock();
        if (allocTmp) {
            ColGroupValue.setupThreadLocalMemory(CompressedMatrixBlock.getMaxNumValues(colGroups));
        }
        for (ColGroup grp : colGroups) {
            grp.leftMultByRowVector(rowVector, result);
        }
        if (allocTmp) {
            ColGroupValue.cleanupThreadLocalMemory();
        }
        result.recomputeNonZeros();
    }

    private static void leftMultByVectorTranspose(List<ColGroup> colGroups, ColGroupDDC vector, MatrixBlock result) {
        result.reset();
        for (ColGroup grp : colGroups) {
            ((ColGroupValue)grp).leftMultByRowVector(vector, result);
        }
        result.recomputeNonZeros();
    }

    private void leftMultByVectorTranspose(List<ColGroup> colGroups, MatrixBlock vector, MatrixBlock result, boolean doTranspose, int k) {
        MatrixBlock rowVector = vector;
        if (doTranspose) {
            rowVector = new MatrixBlock(1, vector.getNumRows(), false);
            LibMatrixReorg.transpose(vector, rowVector);
        }
        result.reset();
        result.allocateDenseBlock();
        try {
            ColGroupUncompressed uc = this.getUncompressedColGroup();
            if (uc != null) {
                uc.leftMultByRowVector(rowVector, result, k);
            }
            ExecutorService pool = CommonThreadPool.get(Math.min(colGroups.size() - (uc != null ? 1 : 0), k));
            ArrayList<ColGroup>[] grpParts = this.createStaticTaskPartitioning(4 * k, false);
            ArrayList<LeftMatrixMultTask> tasks = new ArrayList<LeftMatrixMultTask>();
            for (ArrayList<ColGroup> groups : grpParts) {
                tasks.add(new LeftMatrixMultTask(groups, rowVector, result));
            }
            List ret = pool.invokeAll(tasks);
            pool.shutdown();
            for (Future tmp : ret) {
                tmp.get();
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        result.recomputeNonZeros();
    }

    private static void leftMultByTransposeSelf(ArrayList<ColGroup> groups, MatrixBlock result, int gl, int gu) {
        int numRows = groups.get(0).getNumRows();
        int numGroups = groups.size();
        boolean containsUC = CompressedMatrixBlock.containsUncompressedColGroup(groups);
        MatrixBlock lhs = new MatrixBlock(1, numRows, false);
        MatrixBlock tmpret = new MatrixBlock(1, result.getNumColumns(), false);
        lhs.allocateDenseBlock();
        tmpret.allocateDenseBlock();
        ColGroupValue.setupThreadLocalMemory(CompressedMatrixBlock.getMaxNumValues(groups));
        for (int i = gl; i < gu; ++i) {
            ColGroup group = groups.get(i);
            int[] ixgroup = group.getColIndices();
            List<ColGroup> tmpList = groups.subList(i, numGroups);
            if (group instanceof ColGroupDDC && ixgroup.length == 1 && !containsUC && numRows < 65536) {
                CompressedMatrixBlock.leftMultByVectorTranspose(tmpList, (ColGroupDDC)group, tmpret);
                LinearAlgebraUtils.copyNonZerosToUpperTriangle(result, tmpret, ixgroup[0]);
                continue;
            }
            for (int j = 0; j < ixgroup.length; ++j) {
                group.decompressToBlock(lhs, j);
                if (lhs.isEmptyBlock(false)) continue;
                CompressedMatrixBlock.leftMultByVectorTranspose(tmpList, lhs, tmpret, false, false);
                LinearAlgebraUtils.copyNonZerosToUpperTriangle(result, tmpret, ixgroup[j]);
            }
        }
        ColGroupValue.cleanupThreadLocalMemory();
    }

    private ArrayList<ColGroup>[] createStaticTaskPartitioning(int k, boolean inclUncompressed) {
        if (this._colGroups.size() == 1 && this._colGroups.get(0) instanceof ColGroupUncompressed) {
            return new ArrayList[0];
        }
        int numTasks = Math.min(k, this._colGroups.size());
        ArrayList[] grpParts = new ArrayList[numTasks];
        int pos = 0;
        for (ColGroup grp : this._colGroups) {
            if (grpParts[pos] == null) {
                grpParts[pos] = new ArrayList();
            }
            if (!inclUncompressed && grp instanceof ColGroupUncompressed) continue;
            grpParts[pos].add(grp);
            pos = pos == numTasks - 1 ? 0 : pos + 1;
        }
        return grpParts;
    }

    private static int getMaxNumValues(List<ColGroup> groups) {
        int numVals = 1;
        for (ColGroup grp : groups) {
            if (!(grp instanceof ColGroupValue)) continue;
            numVals = Math.max(numVals, ((ColGroupValue)grp).getNumValues());
        }
        return numVals;
    }

    public boolean hasUncompressedColGroup() {
        return this.getUncompressedColGroup() != null;
    }

    private ColGroupUncompressed getUncompressedColGroup() {
        for (ColGroup grp : this._colGroups) {
            if (!(grp instanceof ColGroupUncompressed)) continue;
            return (ColGroupUncompressed)grp;
        }
        return null;
    }

    private static boolean containsUncompressedColGroup(ArrayList<ColGroup> groups) {
        for (ColGroup grp : groups) {
            if (!(grp instanceof ColGroupUncompressed)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MatrixBlock unaryOperations(UnaryOperator op, MatrixValue result) {
        this.printDecompressWarning("unaryOperations");
        MatrixBlock tmp = this.isCompressed() ? this.decompress() : this;
        return tmp.unaryOperations(op, result);
    }

    @Override
    public MatrixBlock binaryOperations(BinaryOperator op, MatrixValue thatValue, MatrixValue result) {
        this.printDecompressWarning("binaryOperations", (MatrixBlock)thatValue);
        MatrixBlock left = this.isCompressed() ? this.decompress() : this;
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(thatValue);
        return left.binaryOperations(op, right, result);
    }

    @Override
    public void binaryOperationsInPlace(BinaryOperator op, MatrixValue thatValue) {
        this.printDecompressWarning("binaryOperationsInPlace", (MatrixBlock)thatValue);
        MatrixBlock left = this.isCompressed() ? this.decompress() : this;
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(thatValue);
        left.binaryOperationsInPlace(op, right);
    }

    @Override
    public void incrementalAggregate(AggregateOperator aggOp, MatrixValue correction, MatrixValue newWithCorrection, boolean deep) {
        throw new DMLRuntimeException("CompressedMatrixBlock: incrementalAggregate not supported.");
    }

    @Override
    public void incrementalAggregate(AggregateOperator aggOp, MatrixValue newWithCorrection) {
        throw new DMLRuntimeException("CompressedMatrixBlock: incrementalAggregate not supported.");
    }

    @Override
    public MatrixBlock reorgOperations(ReorgOperator op, MatrixValue ret, int startRow, int startColumn, int length) {
        this.printDecompressWarning("reorgOperations");
        MatrixBlock tmp = this.isCompressed() ? this.decompress() : this;
        return tmp.reorgOperations(op, ret, startRow, startColumn, length);
    }

    @Override
    public MatrixBlock append(MatrixBlock that, MatrixBlock ret, boolean cbind) {
        if (cbind) {
            return this.append(that, ret);
        }
        this.printDecompressWarning("append-rbind", that);
        MatrixBlock left = this.isCompressed() ? this.decompress() : this;
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(that);
        return left.append(right, ret, cbind);
    }

    @Override
    public void append(MatrixValue v2, ArrayList<IndexedMatrixValue> outlist, int blen, boolean cbind, boolean m2IsLast, int nextNCol) {
        this.printDecompressWarning("append", (MatrixBlock)v2);
        MatrixBlock left = this.isCompressed() ? this.decompress() : this;
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(v2);
        left.append(right, outlist, blen, cbind, m2IsLast, nextNCol);
    }

    @Override
    public void permutationMatrixMultOperations(MatrixValue m2Val, MatrixValue out1Val, MatrixValue out2Val) {
        this.permutationMatrixMultOperations(m2Val, out1Val, out2Val, 1);
    }

    @Override
    public void permutationMatrixMultOperations(MatrixValue m2Val, MatrixValue out1Val, MatrixValue out2Val, int k) {
        this.printDecompressWarning("permutationMatrixMultOperations", (MatrixBlock)m2Val);
        MatrixBlock left = this.isCompressed() ? this.decompress() : this;
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(m2Val);
        left.permutationMatrixMultOperations(right, out1Val, out2Val, k);
    }

    @Override
    public MatrixBlock leftIndexingOperations(MatrixBlock rhsMatrix, int rl, int ru, int cl, int cu, MatrixBlock ret, MatrixObject.UpdateType update) {
        this.printDecompressWarning("leftIndexingOperations");
        MatrixBlock left = this.isCompressed() ? this.decompress() : this;
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(rhsMatrix);
        return left.leftIndexingOperations(right, rl, ru, cl, cu, ret, update);
    }

    @Override
    public MatrixBlock leftIndexingOperations(ScalarObject scalar, int rl, int cl, MatrixBlock ret, MatrixObject.UpdateType update) {
        this.printDecompressWarning("leftIndexingOperations");
        MatrixBlock tmp = this.isCompressed() ? this.decompress() : this;
        return tmp.leftIndexingOperations(scalar, rl, cl, ret, update);
    }

    @Override
    public MatrixBlock slice(int rl, int ru, int cl, int cu, CacheBlock ret) {
        this.printDecompressWarning("slice");
        MatrixBlock tmp = this.isCompressed() ? this.decompress() : this;
        return tmp.slice(rl, ru, cl, cu, ret);
    }

    @Override
    public void slice(ArrayList<IndexedMatrixValue> outlist, IndexRange range, int rowCut, int colCut, int blen, int boundaryRlen, int boundaryClen) {
        this.printDecompressWarning("slice");
        try {
            MatrixBlock tmp = this.isCompressed() ? this.decompress() : this;
            tmp.slice(outlist, range, rowCut, colCut, blen, boundaryRlen, boundaryClen);
        }
        catch (DMLRuntimeException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public MatrixBlock zeroOutOperations(MatrixValue result, IndexRange range, boolean complementary) {
        this.printDecompressWarning("zeroOutOperations");
        MatrixBlock tmp = this.isCompressed() ? this.decompress() : this;
        return tmp.zeroOutOperations(result, range, complementary);
    }

    @Override
    public CM_COV_Object cmOperations(CMOperator op) {
        this.printDecompressWarning("cmOperations");
        if (!this.isCompressed() || this.isEmptyBlock()) {
            return super.cmOperations(op);
        }
        ColGroup grp = this._colGroups.get(0);
        if (grp instanceof ColGroupUncompressed) {
            return ((ColGroupUncompressed)grp).getData().cmOperations(op);
        }
        ColGroupValue grpVal = (ColGroupValue)grp;
        MatrixBlock vals = grpVal.getValuesAsBlock();
        MatrixBlock counts = ColGroupValue.getCountsAsBlock(grpVal.getCounts(true));
        return vals.cmOperations(op, counts);
    }

    @Override
    public CM_COV_Object cmOperations(CMOperator op, MatrixBlock weights) {
        this.printDecompressWarning("cmOperations");
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(weights);
        if (!this.isCompressed() || this.isEmptyBlock()) {
            return super.cmOperations(op, right);
        }
        ColGroup grp = this._colGroups.get(0);
        if (grp instanceof ColGroupUncompressed) {
            return ((ColGroupUncompressed)grp).getData().cmOperations(op);
        }
        return this.decompress().cmOperations(op, right);
    }

    @Override
    public CM_COV_Object covOperations(COVOperator op, MatrixBlock that) {
        this.printDecompressWarning("covOperations");
        MatrixBlock left = this.isCompressed() ? this.decompress() : this;
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(that);
        return left.covOperations(op, right);
    }

    @Override
    public CM_COV_Object covOperations(COVOperator op, MatrixBlock that, MatrixBlock weights) {
        this.printDecompressWarning("covOperations");
        MatrixBlock left = this.isCompressed() ? this.decompress() : this;
        MatrixBlock right1 = CompressedMatrixBlock.getUncompressed(that);
        MatrixBlock right2 = CompressedMatrixBlock.getUncompressed(weights);
        return left.covOperations(op, right1, right2);
    }

    @Override
    public MatrixBlock sortOperations(MatrixValue weights, MatrixBlock result) {
        this.printDecompressWarning("sortOperations");
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(weights);
        if (!this.isCompressed()) {
            return super.sortOperations(right, result);
        }
        ColGroup grp = this._colGroups.get(0);
        if (grp instanceof ColGroupUncompressed) {
            return ((ColGroupUncompressed)grp).getData().sortOperations(right, result);
        }
        if (right == null) {
            ColGroupValue grpVal = (ColGroupValue)grp;
            MatrixBlock vals = grpVal.getValuesAsBlock();
            int[] counts = grpVal.getCounts(true);
            double[] data = vals.getDenseBlock() != null ? vals.getDenseBlockValues() : null;
            SortUtils.sortByValue(0, vals.getNumRows(), data, counts);
            MatrixBlock counts2 = ColGroupValue.getCountsAsBlock(counts);
            return vals.sortOperations(counts2, result);
        }
        return this.decompress().sortOperations(right, result);
    }

    @Override
    public MatrixBlock aggregateBinaryOperations(MatrixIndexes m1Index, MatrixBlock m1Value, MatrixIndexes m2Index, MatrixBlock m2Value, MatrixBlock result, AggregateBinaryOperator op) {
        this.printDecompressWarning("aggregateBinaryOperations");
        MatrixBlock left = this.isCompressed() ? this.decompress() : this;
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(m2Value);
        return left.aggregateBinaryOperations(m1Index, left, m2Index, right, result, op);
    }

    @Override
    public MatrixBlock aggregateTernaryOperations(MatrixBlock m1, MatrixBlock m2, MatrixBlock m3, MatrixBlock ret, AggregateTernaryOperator op, boolean inCP) {
        this.printDecompressWarning("aggregateTernaryOperations");
        MatrixBlock left = this.isCompressed() ? this.decompress() : this;
        MatrixBlock right1 = CompressedMatrixBlock.getUncompressed(m2);
        MatrixBlock right2 = CompressedMatrixBlock.getUncompressed(m3);
        return left.aggregateTernaryOperations(left, right1, right2, ret, op, inCP);
    }

    @Override
    public MatrixBlock uaggouterchainOperations(MatrixBlock mbLeft, MatrixBlock mbRight, MatrixBlock mbOut, BinaryOperator bOp, AggregateUnaryOperator uaggOp) {
        this.printDecompressWarning("uaggouterchainOperations");
        MatrixBlock left = this.isCompressed() ? this.decompress() : this;
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(mbRight);
        return left.uaggouterchainOperations(left, right, mbOut, bOp, uaggOp);
    }

    @Override
    public MatrixBlock groupedAggOperations(MatrixValue tgt, MatrixValue wghts, MatrixValue ret, int ngroups, Operator op) {
        return this.groupedAggOperations(tgt, wghts, ret, ngroups, op, 1);
    }

    @Override
    public MatrixBlock groupedAggOperations(MatrixValue tgt, MatrixValue wghts, MatrixValue ret, int ngroups, Operator op, int k) {
        this.printDecompressWarning("groupedAggOperations");
        MatrixBlock left = this.isCompressed() ? this.decompress() : this;
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(wghts);
        return left.groupedAggOperations(left, right, ret, ngroups, op, k);
    }

    @Override
    public MatrixBlock removeEmptyOperations(MatrixBlock ret, boolean rows, boolean emptyReturn, MatrixBlock select) {
        this.printDecompressWarning("removeEmptyOperations");
        MatrixBlock tmp = this.isCompressed() ? this.decompress() : this;
        return tmp.removeEmptyOperations(ret, rows, emptyReturn, select);
    }

    @Override
    public MatrixBlock removeEmptyOperations(MatrixBlock ret, boolean rows, boolean emptyReturn) {
        this.printDecompressWarning("removeEmptyOperations");
        MatrixBlock tmp = this.isCompressed() ? this.decompress() : this;
        return tmp.removeEmptyOperations(ret, rows, emptyReturn);
    }

    @Override
    public MatrixBlock rexpandOperations(MatrixBlock ret, double max, boolean rows, boolean cast, boolean ignore, int k) {
        this.printDecompressWarning("rexpandOperations");
        MatrixBlock tmp = this.isCompressed() ? this.decompress() : this;
        return tmp.rexpandOperations(ret, max, rows, cast, ignore, k);
    }

    @Override
    public MatrixBlock replaceOperations(MatrixValue result, double pattern, double replacement) {
        this.printDecompressWarning("replaceOperations");
        MatrixBlock tmp = this.isCompressed() ? this.decompress() : this;
        return tmp.replaceOperations(result, pattern, replacement);
    }

    @Override
    public void ctableOperations(Operator op, double scalar, MatrixValue that, CTableMap resultMap, MatrixBlock resultBlock) {
        this.printDecompressWarning("ctableOperations");
        MatrixBlock left = this.isCompressed() ? this.decompress() : this;
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(that);
        left.ctableOperations(op, scalar, (MatrixValue)right, resultMap, resultBlock);
    }

    @Override
    public void ctableOperations(Operator op, double scalar, double scalar2, CTableMap resultMap, MatrixBlock resultBlock) {
        this.printDecompressWarning("ctableOperations");
        MatrixBlock tmp = this.isCompressed() ? this.decompress() : this;
        tmp.ctableOperations(op, scalar, scalar2, resultMap, resultBlock);
    }

    @Override
    public void ctableOperations(Operator op, MatrixIndexes ix1, double scalar, boolean left, int brlen, CTableMap resultMap, MatrixBlock resultBlock) {
        this.printDecompressWarning("ctableOperations");
        MatrixBlock tmp = this.isCompressed() ? this.decompress() : this;
        tmp.ctableOperations(op, ix1, scalar, left, brlen, resultMap, resultBlock);
    }

    @Override
    public void ctableOperations(Operator op, MatrixValue that, double scalar, boolean ignoreZeros, CTableMap resultMap, MatrixBlock resultBlock) {
        this.printDecompressWarning("ctableOperations");
        MatrixBlock left = this.isCompressed() ? this.decompress() : this;
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(that);
        left.ctableOperations(op, right, scalar, ignoreZeros, resultMap, resultBlock);
    }

    @Override
    public MatrixBlock ctableSeqOperations(MatrixValue that, double scalar, MatrixBlock resultBlock) {
        this.printDecompressWarning("ctableOperations");
        MatrixBlock right = CompressedMatrixBlock.getUncompressed(that);
        return this.ctableSeqOperations(right, scalar, resultBlock);
    }

    @Override
    public void ctableOperations(Operator op, MatrixValue that, MatrixValue that2, CTableMap resultMap) {
        this.printDecompressWarning("ctableOperations");
        MatrixBlock left = this.isCompressed() ? this.decompress() : this;
        MatrixBlock right1 = CompressedMatrixBlock.getUncompressed(that);
        MatrixBlock right2 = CompressedMatrixBlock.getUncompressed(that2);
        left.ctableOperations(op, right1, right2, resultMap);
    }

    @Override
    public void ctableOperations(Operator op, MatrixValue that, MatrixValue that2, CTableMap resultMap, MatrixBlock resultBlock) {
        this.printDecompressWarning("ctableOperations");
        MatrixBlock left = this.isCompressed() ? this.decompress() : this;
        MatrixBlock right1 = CompressedMatrixBlock.getUncompressed(that);
        MatrixBlock right2 = CompressedMatrixBlock.getUncompressed(that2);
        left.ctableOperations(op, right1, (MatrixValue)right2, resultMap, resultBlock);
    }

    @Override
    public MatrixBlock ternaryOperations(TernaryOperator op, MatrixBlock m2, MatrixBlock m3, MatrixBlock ret) {
        this.printDecompressWarning("ternaryOperations");
        MatrixBlock left = this.isCompressed() ? this.decompress() : this;
        MatrixBlock right1 = CompressedMatrixBlock.getUncompressed(m2);
        MatrixBlock right2 = CompressedMatrixBlock.getUncompressed(m3);
        return left.ternaryOperations(op, right1, right2, ret);
    }

    @Override
    public MatrixBlock quaternaryOperations(QuaternaryOperator qop, MatrixBlock um, MatrixBlock vm, MatrixBlock wm, MatrixBlock out) {
        return this.quaternaryOperations(qop, um, vm, wm, out, 1);
    }

    @Override
    public MatrixBlock quaternaryOperations(QuaternaryOperator qop, MatrixBlock um, MatrixBlock vm, MatrixBlock wm, MatrixBlock out, int k) {
        this.printDecompressWarning("quaternaryOperations");
        MatrixBlock left = this.isCompressed() ? this.decompress() : this;
        MatrixBlock right1 = CompressedMatrixBlock.getUncompressed(um);
        MatrixBlock right2 = CompressedMatrixBlock.getUncompressed(vm);
        MatrixBlock right3 = CompressedMatrixBlock.getUncompressed(wm);
        return left.quaternaryOperations(qop, right1, right2, right3, out, k);
    }

    @Override
    public MatrixBlock randOperationsInPlace(RandomMatrixGenerator rgen, Well1024a bigrand, long bSeed) {
        throw new DMLRuntimeException("CompressedMatrixBlock: randOperationsInPlace not supported.");
    }

    @Override
    public MatrixBlock randOperationsInPlace(RandomMatrixGenerator rgen, Well1024a bigrand, long bSeed, int k) {
        throw new DMLRuntimeException("CompressedMatrixBlock: randOperationsInPlace not supported.");
    }

    @Override
    public MatrixBlock seqOperationsInPlace(double from, double to, double incr) {
        throw new DMLRuntimeException("CompressedMatrixBlock: seqOperationsInPlace not supported.");
    }

    private static boolean isCompressed(MatrixBlock mb) {
        return mb instanceof CompressedMatrixBlock && ((CompressedMatrixBlock)mb).isCompressed();
    }

    private static MatrixBlock getUncompressed(MatrixValue mVal) {
        return CompressedMatrixBlock.isCompressed((MatrixBlock)mVal) ? ((CompressedMatrixBlock)mVal).decompress() : (MatrixBlock)mVal;
    }

    private void printDecompressWarning(String operation) {
        if (this.isCompressed()) {
            LOG.warn((Object)("Operation '" + operation + "' not supported yet - decompressing for ULA operations."));
        }
    }

    private void printDecompressWarning(String operation, MatrixBlock m2) {
        if (this.isCompressed() || CompressedMatrixBlock.isCompressed(m2)) {
            LOG.warn((Object)("Operation '" + operation + "' not supported yet - decompressing for ULA operations."));
        }
    }

    private static HashSet<Integer> seq(int from, int to, int incr) {
        HashSet<Integer> ret = new HashSet<Integer>();
        for (int i = from; i <= to; i += incr) {
            ret.add(i);
        }
        return ret;
    }

    private static class DecompressTask
    implements Callable<Object> {
        private final List<ColGroup> _colGroups;
        private final MatrixBlock _ret;
        private final int _rl;
        private final int _ru;

        protected DecompressTask(List<ColGroup> colGroups, MatrixBlock ret, int rl, int ru) {
            this._colGroups = colGroups;
            this._ret = ret;
            this._rl = rl;
            this._ru = ru;
        }

        @Override
        public Object call() {
            if (this._ret.isInSparseFormat()) {
                int[] rnnz = new int[this._ru - this._rl];
                for (ColGroup grp : this._colGroups) {
                    grp.countNonZerosPerRow(rnnz, this._rl, this._ru);
                }
                SparseBlock rows = this._ret.getSparseBlock();
                for (int i = this._rl; i < this._ru; ++i) {
                    rows.allocate(i, rnnz[i - this._rl]);
                }
            }
            for (ColGroup grp : this._colGroups) {
                grp.decompressToBlock(this._ret, this._rl, this._ru);
            }
            if (this._ret.isInSparseFormat()) {
                this._ret.sortSparseRows(this._rl, this._ru);
            }
            return null;
        }
    }

    private static class CompressTask
    implements Callable<ColGroup> {
        private final MatrixBlock _in;
        private final CompressedSizeEstimator _estim;
        private final HashMap<Integer, Double> _compRatios;
        private final int _rlen;
        private final int[] _colIndexes;
        private final boolean _denseEst;

        protected CompressTask(MatrixBlock in, CompressedSizeEstimator estim, HashMap<Integer, Double> compRatios, int rlen, int[] colIndexes, boolean denseEst) {
            this._in = in;
            this._estim = estim;
            this._compRatios = compRatios;
            this._rlen = rlen;
            this._colIndexes = colIndexes;
            this._denseEst = denseEst;
        }

        @Override
        public ColGroup call() {
            return CompressedMatrixBlock.compressColGroup(this._in, this._estim, this._compRatios, this._rlen, this._colIndexes, this._denseEst);
        }
    }

    private static class SizeEstimTask
    implements Callable<CompressedSizeInfo> {
        private final CompressedSizeEstimator _estim;
        private final int _col;

        protected SizeEstimTask(CompressedSizeEstimator estim, int col) {
            this._estim = estim;
            this._col = col;
        }

        @Override
        public CompressedSizeInfo call() {
            return this._estim.estimateCompressedColGroupSize(new int[]{this._col});
        }
    }

    private static class UnaryAggregateTask
    implements Callable<MatrixBlock> {
        private final ArrayList<ColGroup> _groups;
        private final int _rl;
        private final int _ru;
        private final MatrixBlock _ret;
        private final AggregateUnaryOperator _op;

        protected UnaryAggregateTask(ArrayList<ColGroup> groups, MatrixBlock ret, int rl, int ru, AggregateUnaryOperator op) {
            this._groups = groups;
            this._op = op;
            this._rl = rl;
            this._ru = ru;
            if (this._op.indexFn instanceof ReduceAll) {
                this._ret = new MatrixBlock(ret.getNumRows(), ret.getNumColumns(), false);
                this._ret.allocateDenseBlock();
                if (this._op.aggOp.increOp.fn instanceof Builtin) {
                    System.arraycopy(ret.getDenseBlockValues(), 0, this._ret.getDenseBlockValues(), 0, ret.getNumRows() * ret.getNumColumns());
                }
            } else {
                this._ret = ret;
            }
        }

        @Override
        public MatrixBlock call() {
            CompressedMatrixBlock.aggregateUnaryOperations(this._op, this._groups, this._ret, this._rl, this._ru);
            return this._ret;
        }
    }

    private static class MatrixMultTransposeTask
    implements Callable<Object> {
        private final ArrayList<ColGroup> _groups;
        private final MatrixBlock _ret;
        private final int _gl;
        private final int _gu;

        protected MatrixMultTransposeTask(ArrayList<ColGroup> groups, MatrixBlock ret, int gl, int gu) {
            this._groups = groups;
            this._ret = ret;
            this._gl = gl;
            this._gu = gu;
        }

        @Override
        public Object call() {
            CompressedMatrixBlock.leftMultByTransposeSelf(this._groups, this._ret, this._gl, this._gu);
            return null;
        }
    }

    private static class RightMatrixMultTask
    implements Callable<Long> {
        private final ArrayList<ColGroup> _groups;
        private final MatrixBlock _vect;
        private final MatrixBlock _ret;
        private final int _rl;
        private final int _ru;

        protected RightMatrixMultTask(ArrayList<ColGroup> groups, MatrixBlock vect, MatrixBlock ret, int rl, int ru) {
            this._groups = groups;
            this._vect = vect;
            this._ret = ret;
            this._rl = rl;
            this._ru = ru;
        }

        @Override
        public Long call() {
            CompressedMatrixBlock.rightMultByVector(this._groups, this._vect, this._ret, false, this._rl, this._ru);
            return this._ret.recomputeNonZeros(this._rl, this._ru - 1, 0, 0);
        }
    }

    private static class LeftMatrixMultTask
    implements Callable<Object> {
        private final ArrayList<ColGroup> _groups;
        private final MatrixBlock _vect;
        private final MatrixBlock _ret;

        protected LeftMatrixMultTask(ArrayList<ColGroup> groups, MatrixBlock vect, MatrixBlock ret) {
            this._groups = groups;
            this._vect = vect;
            this._ret = ret;
        }

        @Override
        public Object call() {
            ColGroupValue.setupThreadLocalMemory(CompressedMatrixBlock.getMaxNumValues(this._groups));
            for (ColGroup grp : this._groups) {
                grp.leftMultByRowVector(this._vect, this._ret);
            }
            ColGroupValue.cleanupThreadLocalMemory();
            return null;
        }
    }

    private static class CompressedColumn
    implements Comparable<CompressedColumn> {
        final int colIx;
        final double compRatio;

        public CompressedColumn(int colIx, double compRatio) {
            this.colIx = colIx;
            this.compRatio = compRatio;
        }

        @Override
        public int compareTo(CompressedColumn o) {
            return (int)Math.signum(this.compRatio - o.compRatio);
        }
    }
}

