/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.runtime.compress;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tugraz.sysds.runtime.compress.BitmapEncoder;
import org.tugraz.sysds.runtime.compress.ColGroup;
import org.tugraz.sysds.runtime.compress.ColGroupDDC;
import org.tugraz.sysds.runtime.compress.ColGroupOffset;
import org.tugraz.sysds.runtime.compress.UncompressedBitmap;
import org.tugraz.sysds.runtime.compress.utils.ConverterUtils;
import org.tugraz.sysds.runtime.compress.utils.LinearAlgebraUtils;
import org.tugraz.sysds.runtime.data.DenseBlock;
import org.tugraz.sysds.runtime.functionobjects.Builtin;
import org.tugraz.sysds.runtime.functionobjects.KahanFunction;
import org.tugraz.sysds.runtime.functionobjects.KahanPlus;
import org.tugraz.sysds.runtime.instructions.cp.KahanObject;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.matrix.operators.ScalarOperator;

public class ColGroupOLE
extends ColGroupOffset {
    private static final long serialVersionUID = -9157676271360528008L;
    private static final Log LOG = LogFactory.getLog((String)ColGroupOLE.class.getName());

    public ColGroupOLE() {
    }

    public ColGroupOLE(int[] colIndices, int numRows, UncompressedBitmap ubm) {
        super(colIndices, numRows, ubm);
        int numVals = ubm.getNumValues();
        char[][] lbitmaps = new char[numVals][];
        int totalLen = 0;
        for (int i = 0; i < numVals; ++i) {
            lbitmaps[i] = BitmapEncoder.genOffsetBitmap(ubm.getOffsetsList(i).extractValues(), ubm.getNumOffsets(i));
            totalLen += lbitmaps[i].length;
        }
        this.createCompressedBitmaps(numVals, totalLen, lbitmaps);
        this._skiplist = new int[numVals];
        if (LOW_LEVEL_OPT && numRows > 131072) {
            int blksz = 65536;
            int rl = this.getNumRows() / 2 / blksz * blksz;
            for (int k = 0; k < numVals; ++k) {
                int boff = this._ptr[k];
                int blen = this.len(k);
                int bix = 0;
                for (int i = 0; i < rl && bix < blen; bix += this._data[boff + bix] + '\u0001', i += blksz) {
                }
                this._skiplist[k] = bix;
            }
        }
        double ucSize = MatrixBlock.estimateSizeDenseInMemory(numRows, colIndices.length);
        if ((double)this.estimateInMemorySize() > ucSize) {
            LOG.warn((Object)("OLE group larger than UC dense: " + this.estimateInMemorySize() + " " + ucSize));
        }
    }

    public ColGroupOLE(int[] colIndices, int numRows, boolean zeros, double[] values, char[] bitmaps, int[] bitmapOffs) {
        super(colIndices, numRows, zeros, values);
        this._data = bitmaps;
        this._ptr = bitmapOffs;
    }

    @Override
    public ColGroup.CompressionType getCompType() {
        return ColGroup.CompressionType.OLE_BITMAP;
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int rl, int ru) {
        if (LOW_LEVEL_OPT && this.getNumValues() > 1) {
            int blksz = 65536;
            int numCols = this.getNumCols();
            int numVals = this.getNumValues();
            int[] apos = this.skipScan(numVals, rl);
            for (int bi = rl; bi < ru; bi += 65536) {
                int k = 0;
                int off = 0;
                while (k < numVals) {
                    int boff = this._ptr[k];
                    int bix = apos[k];
                    int blen = this.len(k);
                    if (bix < blen) {
                        int pos;
                        char len = this._data[boff + bix];
                        for (int i = pos = boff + bix + 1; i < pos + len; ++i) {
                            int rix = bi + this._data[i];
                            for (int j = 0; j < numCols; ++j) {
                                if (this._values[off + j] == 0.0) continue;
                                target.appendValue(rix, this._colIndexes[j], this._values[off + j]);
                            }
                        }
                        int n = k;
                        apos[n] = apos[n] + (len + '\u0001');
                    }
                    ++k;
                    off += numCols;
                }
            }
        } else {
            super.decompressToBlock(target, rl, ru);
        }
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int[] colixTargets) {
        if (LOW_LEVEL_OPT && this.getNumValues() > 1) {
            int blksz = 65536;
            int numCols = this.getNumCols();
            int numVals = this.getNumValues();
            int n = this.getNumRows();
            int[] apos = new int[numVals];
            int[] cix = new int[numCols];
            for (int j = 0; j < numCols; ++j) {
                cix[j] = colixTargets[this._colIndexes[j]];
            }
            for (int bi = 0; bi < n; bi += 65536) {
                int k = 0;
                int off = 0;
                while (k < numVals) {
                    int boff = this._ptr[k];
                    int bix = apos[k];
                    int blen = this.len(k);
                    if (bix < blen) {
                        int pos;
                        char len = this._data[boff + bix];
                        for (int i = pos = boff + bix + 1; i < pos + len; ++i) {
                            int rix = bi + this._data[i];
                            for (int j = 0; j < numCols; ++j) {
                                if (this._values[off + j] == 0.0) continue;
                                target.appendValue(rix, cix[j], this._values[off + j]);
                            }
                        }
                        int n2 = k;
                        apos[n2] = apos[n2] + (len + '\u0001');
                    }
                    ++k;
                    off += numCols;
                }
            }
        } else {
            super.decompressToBlock(target, colixTargets);
        }
    }

    @Override
    public void decompressToBlock(MatrixBlock target, int colpos) {
        int blksz = 65536;
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        int n = this.getNumRows();
        double[] c = target.getDenseBlockValues();
        int[] apos = ColGroupOLE.allocIVector(numVals, true);
        int nnz = 0;
        for (int bi = 0; bi < n; bi += 65536) {
            Arrays.fill(c, bi, Math.min(bi + 65536, n), 0.0);
            int k = 0;
            int off = 0;
            while (k < numVals) {
                int boff = this._ptr[k];
                int bix = apos[k];
                int blen = this.len(k);
                if (bix < blen) {
                    int pos;
                    char len = this._data[boff + bix];
                    for (int i = pos = boff + bix + 1; i < pos + len; ++i) {
                        c[bi + this._data[i]] = this._values[off + colpos];
                        ++nnz;
                    }
                    int n2 = k;
                    apos[n2] = apos[n2] + (len + '\u0001');
                }
                ++k;
                off += numCols;
            }
        }
        target.setNonZeros(nnz);
    }

    @Override
    public int[] getCounts(int[] counts) {
        int numVals = this.getNumValues();
        Arrays.fill(counts, 0, numVals, 0);
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int count = 0;
            for (int bix = 0; bix < blen; bix += this._data[boff + bix] + '\u0001') {
                count += this._data[boff + bix];
            }
            counts[k] = count;
        }
        return counts;
    }

    @Override
    public int[] getCounts(int rl, int ru, int[] counts) {
        int blksz = 65536;
        int numVals = this.getNumValues();
        Arrays.fill(counts, 0, numVals, 0);
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int bix = this.skipScanVal(k, rl);
            int count = 0;
            for (int off = rl; bix < blen && off < ru; bix += this._data[boff + bix] + '\u0001', off += 65536) {
                count += this._data[boff + bix];
            }
            counts[k] = count;
        }
        return counts;
    }

    @Override
    public ColGroup scalarOperation(ScalarOperator op) {
        double val0 = op.executeScalar(0.0);
        if (op.sparseSafe || val0 == 0.0) {
            return new ColGroupOLE(this._colIndexes, this._numRows, this._zeros, this.applyScalarOp(op), this._data, this._ptr);
        }
        boolean[] lind = this.computeZeroIndicatorVector();
        int[] loff = this.computeOffsets(lind);
        if (loff.length == 0) {
            return new ColGroupOLE(this._colIndexes, this._numRows, true, this.applyScalarOp(op), this._data, this._ptr);
        }
        double[] rvalues = this.applyScalarOp(op, val0, this.getNumCols());
        char[] lbitmap = BitmapEncoder.genOffsetBitmap(loff, loff.length);
        char[] rbitmaps = Arrays.copyOf(this._data, this._data.length + lbitmap.length);
        System.arraycopy(lbitmap, 0, rbitmaps, this._data.length, lbitmap.length);
        int[] rbitmapOffs = Arrays.copyOf(this._ptr, this._ptr.length + 1);
        rbitmapOffs[rbitmapOffs.length - 1] = rbitmaps.length;
        return new ColGroupOLE(this._colIndexes, this._numRows, loff.length < this._numRows, rvalues, rbitmaps, rbitmapOffs);
    }

    @Override
    public void rightMultByVector(MatrixBlock vector, MatrixBlock result, int rl, int ru) {
        double[] b = ConverterUtils.getDenseVector(vector);
        double[] c = result.getDenseBlockValues();
        int blksz = 65536;
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        double[] sb = new double[numCols];
        for (int j = 0; j < numCols; ++j) {
            sb[j] = b[this._colIndexes[j]];
        }
        if (LOW_LEVEL_OPT && numVals > 1 && this._numRows > 65536) {
            int blksz2 = 131072;
            int[] apos = this.skipScan(numVals, rl);
            double[] aval = this.preaggValues(numVals, sb);
            for (int bi = rl; bi < ru; bi += 131072) {
                int bimax = Math.min(bi + 131072, ru);
                for (int k = 0; k < numVals; ++k) {
                    char len;
                    int boff = this._ptr[k];
                    int blen = this.len(k);
                    double val = aval[k];
                    int bix = apos[k];
                    for (int ii = bi; ii < bimax && bix < blen; bix += len + '\u0001', ii += 65536) {
                        len = this._data[boff + bix];
                        int pos = boff + bix + 1;
                        LinearAlgebraUtils.vectAdd(val, c, this._data, pos, ii, len);
                    }
                    apos[k] = bix;
                }
            }
        } else {
            for (int k = 0; k < numVals; ++k) {
                int boff = this._ptr[k];
                int blen = this.len(k);
                double val = this.sumValues(k, sb);
                if (val == 0.0) continue;
                int bix = 0;
                int off = 0;
                int slen = -1;
                if (rl > 0) {
                    while (bix < blen & off < rl) {
                        slen = this._data[boff + bix];
                        bix += slen + 1;
                        off += 65536;
                    }
                }
                while (bix < blen & off < ru) {
                    slen = this._data[boff + bix];
                    for (int blckIx = 1; blckIx <= slen; ++blckIx) {
                        int n = off + this._data[boff + bix + blckIx];
                        c[n] = c[n] + val;
                    }
                    bix += slen + 1;
                    off += 65536;
                }
            }
        }
    }

    @Override
    public void leftMultByRowVector(MatrixBlock vector, MatrixBlock result) {
        double[] a = ConverterUtils.getDenseVector(vector);
        double[] c = result.getDenseBlockValues();
        int blksz = 65536;
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        int n = this.getNumRows();
        if (LOW_LEVEL_OPT && numVals > 1 && this._numRows > 65536) {
            int blksz2 = 131072;
            int[] apos = ColGroupOLE.allocIVector(numVals, true);
            double[] cvals = ColGroupOLE.allocDVector(numVals, true);
            for (int ai = 0; ai < n; ai += 131072) {
                int aimax = Math.min(ai + 131072, n);
                int k = 0;
                while (k < numVals) {
                    char len;
                    int boff = this._ptr[k];
                    int blen = this.len(k);
                    int bix = apos[k];
                    double vsum = 0.0;
                    for (int ii = ai; ii < aimax && bix < blen; bix += len + '\u0001', ii += 65536) {
                        len = this._data[boff + bix];
                        int pos = boff + bix + 1;
                        vsum += LinearAlgebraUtils.vectSum(a, this._data, ii, pos, len);
                    }
                    apos[k] = bix;
                    int n2 = k++;
                    cvals[n2] = cvals[n2] + vsum;
                }
            }
            int k = 0;
            int valOff = 0;
            while (k < numVals) {
                for (int j = 0; j < numCols; ++j) {
                    int n3 = this._colIndexes[j];
                    c[n3] = c[n3] + cvals[k] * this._values[valOff + j];
                }
                ++k;
                valOff += numCols;
            }
        } else {
            int k = 0;
            int valOff = 0;
            while (k < numVals) {
                int boff = this._ptr[k];
                int blen = this.len(k);
                double vsum = 0.0;
                int bix = 0;
                int off = 0;
                while (bix < blen) {
                    vsum += LinearAlgebraUtils.vectSum(a, this._data, off, boff + bix + 1, this._data[boff + bix]);
                    bix += this._data[boff + bix] + '\u0001';
                    off += 65536;
                }
                for (int j = 0; j < numCols; ++j) {
                    int n4 = this._colIndexes[j];
                    c[n4] = c[n4] + vsum * this._values[valOff + j];
                }
                ++k;
                valOff += numCols;
            }
        }
    }

    @Override
    public void leftMultByRowVector(ColGroupDDC a, MatrixBlock result) {
        double[] c = result.getDenseBlockValues();
        int numCols = this.getNumCols();
        int numVals = this.getNumValues();
        int k = 0;
        int valOff = 0;
        while (k < numVals) {
            int j;
            int boff = this._ptr[k];
            double vsum = 0.0;
            for (j = boff + 1; j < boff + 1 + this._data[boff]; ++j) {
                vsum += a.getData(this._data[j]);
            }
            for (j = 0; j < numCols; ++j) {
                int n = this._colIndexes[j];
                c[n] = c[n] + vsum * this._values[valOff + j];
            }
            ++k;
            valOff += numCols;
        }
    }

    @Override
    protected final void computeSum(MatrixBlock result, KahanFunction kplus) {
        KahanObject kbuff = new KahanObject(result.quickGetValue(0, 0), result.quickGetValue(0, 1));
        int numVals = this.getNumValues();
        int numCols = this.getNumCols();
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int valOff = k * numCols;
            int count = 0;
            for (int bix = 0; bix < blen; bix += this._data[boff + bix] + '\u0001') {
                count += this._data[boff + bix];
            }
            for (int j = 0; j < numCols; ++j) {
                kplus.execute3(kbuff, this._values[valOff + j], count);
            }
        }
        result.quickSetValue(0, 0, kbuff._sum);
        result.quickSetValue(0, 1, kbuff._correction);
    }

    @Override
    protected final void computeRowSums(MatrixBlock result, KahanFunction kplus, int rl, int ru) {
        DenseBlock c = result.getDenseBlock();
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        KahanPlus kplus2 = KahanPlus.getKahanPlusFnObject();
        int blksz = 65536;
        int numVals = this.getNumValues();
        if (ALLOW_CACHE_CONSCIOUS_ROWSUMS && LOW_LEVEL_OPT && numVals > 1 && this._numRows > 65536) {
            int blksz2 = 65536;
            int[] apos = this.skipScan(numVals, rl);
            double[] aval = this.sumAllValues(kplus, kbuff, false);
            for (int bi = rl; bi < ru; bi += 65536) {
                int bimax = Math.min(bi + 65536, ru);
                for (int k = 0; k < numVals; ++k) {
                    int len;
                    int boff = this._ptr[k];
                    int blen = this.len(k);
                    double val = aval[k];
                    int bix = apos[k];
                    for (int ii = bi; ii < bimax && bix < blen; bix += len + '\u0001', ii += 65536) {
                        len = this._data[boff + bix];
                        int pos = boff + bix + 1;
                        for (int i = 0; i < len; ++i) {
                            int rix = ii + this._data[pos + i];
                            double[] cvals = c.values(rix);
                            int cix = c.pos(rix);
                            kbuff.set(cvals[cix], cvals[cix + 1]);
                            kplus2.execute2(kbuff, val);
                            cvals[cix] = kbuff._sum;
                            cvals[cix + 1] = kbuff._correction;
                        }
                    }
                    apos[k] = bix;
                }
            }
        } else {
            for (int k = 0; k < numVals; ++k) {
                int slen;
                int boff = this._ptr[k];
                int blen = this.len(k);
                double val = this.sumValues(k, kplus, kbuff);
                if (val == 0.0) continue;
                int bix = this.skipScanVal(k, rl);
                for (int off = (rl + 1) / 65536 * 65536; bix < blen && off < ru; bix += slen + '\u0001', off += 65536) {
                    slen = this._data[boff + bix];
                    for (int i = 1; i <= slen; ++i) {
                        int rix = off + this._data[boff + bix + i];
                        double[] cvals = c.values(rix);
                        int cix = c.pos(rix);
                        kbuff.set(cvals[cix], cvals[cix + 1]);
                        kplus2.execute2(kbuff, val);
                        cvals[cix] = kbuff._sum;
                        cvals[cix + 1] = kbuff._correction;
                    }
                }
            }
        }
    }

    @Override
    protected final void computeColSums(MatrixBlock result, KahanFunction kplus) {
        KahanObject kbuff = new KahanObject(0.0, 0.0);
        int numVals = this.getNumValues();
        int numCols = this.getNumCols();
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int valOff = k * numCols;
            int count = 0;
            for (int bix = 0; bix < blen; bix += this._data[boff + bix] + '\u0001') {
                count += this._data[boff + bix];
            }
            for (int j = 0; j < numCols; ++j) {
                kbuff.set(result.quickGetValue(0, this._colIndexes[j]), result.quickGetValue(1, this._colIndexes[j]));
                kplus.execute3(kbuff, this._values[valOff + j], count);
                result.quickSetValue(0, this._colIndexes[j], kbuff._sum);
                result.quickSetValue(1, this._colIndexes[j], kbuff._correction);
            }
        }
    }

    @Override
    protected final void computeRowMxx(MatrixBlock result, Builtin builtin, int rl, int ru) {
        int blksz = 65536;
        int numVals = this.getNumValues();
        double[] c = result.getDenseBlockValues();
        for (int k = 0; k < numVals; ++k) {
            int slen;
            int boff = this._ptr[k];
            int blen = this.len(k);
            double val = this.mxxValues(k, builtin);
            int bix = this.skipScanVal(k, rl);
            for (int off = bix * 65536; bix < blen && off < ru; bix += slen + '\u0001', off += 65536) {
                slen = this._data[boff + bix];
                for (int i = 1; i <= slen; ++i) {
                    int rix = off + this._data[boff + bix + i];
                    c[rix] = builtin.execute(c[rix], val);
                }
            }
        }
    }

    @Override
    protected boolean[] computeZeroIndicatorVector() {
        boolean[] ret = new boolean[this._numRows];
        int blksz = 65536;
        int numVals = this.getNumValues();
        Arrays.fill(ret, true);
        for (int k = 0; k < numVals; ++k) {
            int boff = this._ptr[k];
            int blen = this.len(k);
            int off = 0;
            int bix = 0;
            while (bix < blen) {
                int slen = this._data[boff + bix];
                for (int i = 1; i <= slen; ++i) {
                    int n = off + this._data[boff + bix + i];
                    ret[n] = ret[n] & false;
                }
                bix += slen + '\u0001';
                off += 65536;
            }
        }
        return ret;
    }

    @Override
    protected void countNonZerosPerRow(int[] rnnz, int rl, int ru) {
        int blksz = 65536;
        int blksz2 = 131072;
        int numVals = this.getNumValues();
        int numCols = this.getNumCols();
        int[] apos = this.skipScan(numVals, rl);
        for (int bi = rl; bi < ru; bi += 131072) {
            int bimax = Math.min(bi + 131072, ru);
            for (int k = 0; k < numVals; ++k) {
                int boff = this._ptr[k];
                int blen = this.len(k);
                int bix = apos[k];
                int slen = 0;
                for (int off = bi; bix < blen && off < bimax; bix += slen + '\u0001', off += 65536) {
                    slen = this._data[boff + bix];
                    for (int blckIx = 1; blckIx <= slen; ++blckIx) {
                        int n = off + this._data[boff + bix + blckIx] - rl;
                        rnnz[n] = rnnz[n] + numCols;
                    }
                }
                apos[k] = bix;
            }
        }
    }

    private int[] skipScan(int numVals, int rl) {
        int[] ret = ColGroupOLE.allocIVector(numVals, rl == 0);
        int blksz = 65536;
        if (rl > 0) {
            int rskip = this.getNumRows() / 2 / 65536 * 65536;
            for (int k = 0; k < numVals; ++k) {
                int boff = this._ptr[k];
                int blen = this.len(k);
                int start = rl >= rskip ? rskip : 0;
                int bix = rl >= rskip ? this._skiplist[k] : 0;
                for (int i = start; i < rl && bix < blen; bix += this._data[boff + bix] + '\u0001', i += 65536) {
                }
                ret[k] = bix;
            }
        }
        return ret;
    }

    private int skipScanVal(int k, int rl) {
        int blksz = 65536;
        if (rl > 0) {
            int rskip = this.getNumRows() / 2 / 65536 * 65536;
            int boff = this._ptr[k];
            int blen = this.len(k);
            int start = rl >= rskip ? rskip : 0;
            int bix = rl >= rskip ? this._skiplist[k] : 0;
            for (int i = start; i < rl && bix < blen; bix += this._data[boff + bix] + '\u0001', i += 65536) {
            }
            return bix;
        }
        return 0;
    }

    @Override
    public Iterator<Integer> getIterator(int k) {
        return new OLEValueIterator(k, 0, this.getNumRows());
    }

    @Override
    public Iterator<Integer> getIterator(int k, int rl, int ru) {
        return new OLEValueIterator(k, rl, ru);
    }

    @Override
    public ColGroup.ColGroupRowIterator getRowIterator(int rl, int ru) {
        return new OLERowIterator(rl, ru);
    }

    private class OLERowIterator
    extends ColGroup.ColGroupRowIterator {
        private final int[] _apos;
        private final int[] _vcodes;

        public OLERowIterator(int rl, int ru) {
            super(ColGroupOLE.this);
            this._apos = ColGroupOLE.this.skipScan(ColGroupOLE.this.getNumValues(), rl);
            this._vcodes = new int[Math.min(65536, ru - rl)];
            Arrays.fill(this._vcodes, -1);
            this.getNextSegment();
        }

        @Override
        public void next(double[] buff, int rowIx, int segIx, boolean last) {
            int clen = ColGroupOLE.this._colIndexes.length;
            int vcode = this._vcodes[segIx];
            if (vcode >= 0) {
                int off = vcode * clen;
                for (int j = 0; j < clen; ++j) {
                    buff[ColGroupOLE.this._colIndexes[j]] = ColGroupOLE.this._values[off + j];
                }
                this._vcodes[segIx] = -1;
            }
            if (segIx + 1 == 65536 && !last) {
                this.getNextSegment();
            }
        }

        private void getNextSegment() {
            int numVals = ColGroupOLE.this.getNumValues();
            for (int k = 0; k < numVals; ++k) {
                int boff = ColGroupOLE.this._ptr[k];
                int bix = this._apos[k];
                int blen = ColGroupOLE.this.len(k);
                if (bix >= blen) continue;
                int slen = ColGroupOLE.this._data[boff + bix];
                int off = boff + bix + 1;
                for (int i = 0; i < slen; ++i) {
                    this._vcodes[ColGroupOLE.this._data[off + i]] = k;
                }
                int n = k;
                this._apos[n] = this._apos[n] + (slen + '\u0001');
            }
        }
    }

    private class OLEValueIterator
    implements Iterator<Integer> {
        private final int _ru;
        private final int _boff;
        private final int _blen;
        private int _bix;
        private int _start;
        private int _slen;
        private int _spos;
        private int _rpos;

        public OLEValueIterator(int k, int rl, int ru) {
            this._ru = ru;
            this._boff = ColGroupOLE.this._ptr[k];
            this._blen = ColGroupOLE.this.len(k);
            int lrl = rl - rl % 65536;
            this._bix = ColGroupOLE.this.skipScanVal(k, lrl);
            this._start = lrl;
            if (this._bix < this._blen) {
                this._slen = ColGroupOLE.this._data[this._boff + this._bix];
                this._spos = 0;
                this._rpos = ColGroupOLE.this._data[this._boff + this._bix + 1];
                while (this._rpos < rl) {
                    this.nextRowOffset();
                }
            } else {
                this._rpos = this._ru;
            }
        }

        @Override
        public boolean hasNext() {
            return this._rpos < this._ru;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new RuntimeException("No more OLE entries.");
            }
            int ret = this._rpos;
            this.nextRowOffset();
            return ret;
        }

        private void nextRowOffset() {
            if (this._spos + 1 < this._slen) {
                ++this._spos;
                this._rpos = this._start + ColGroupOLE.this._data[this._boff + this._bix + this._spos + 1];
            } else {
                this._start += 65536;
                this._bix += this._slen + 1;
                if (this._bix < this._blen) {
                    this._slen = ColGroupOLE.this._data[this._boff + this._bix];
                    this._spos = 0;
                    this._rpos = this._start + ColGroupOLE.this._data[this._boff + this._bix + 1];
                } else {
                    this._rpos = this._ru;
                }
            }
        }
    }
}

