/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.parser;

import java.util.ArrayList;
import java.util.HashMap;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.hops.Hop;
import org.tugraz.sysds.hops.recompile.Recompiler;
import org.tugraz.sysds.lops.Lop;
import org.tugraz.sysds.parser.BooleanIdentifier;
import org.tugraz.sysds.parser.ConstIdentifier;
import org.tugraz.sysds.parser.DMLProgram;
import org.tugraz.sysds.parser.DataIdentifier;
import org.tugraz.sysds.parser.DoubleIdentifier;
import org.tugraz.sysds.parser.Expression;
import org.tugraz.sysds.parser.ForStatement;
import org.tugraz.sysds.parser.IndexedIdentifier;
import org.tugraz.sysds.parser.IntIdentifier;
import org.tugraz.sysds.parser.IterablePredicate;
import org.tugraz.sysds.parser.LanguageException;
import org.tugraz.sysds.parser.ParseInfo;
import org.tugraz.sysds.parser.Statement;
import org.tugraz.sysds.parser.StatementBlock;
import org.tugraz.sysds.parser.VariableSet;
import org.tugraz.sysds.parser.WhileStatementBlock;
import org.tugraz.sysds.runtime.instructions.cp.BooleanObject;
import org.tugraz.sysds.runtime.instructions.cp.DoubleObject;

public class ForStatementBlock
extends StatementBlock {
    protected Hop _fromHops = null;
    protected Hop _toHops = null;
    protected Hop _incrementHops = null;
    protected Lop _fromLops = null;
    protected Lop _toLops = null;
    protected Lop _incrementLops = null;
    protected boolean _requiresFromRecompile = false;
    protected boolean _requiresToRecompile = false;
    protected boolean _requiresIncrementRecompile = false;

    public IterablePredicate getIterPredicate() {
        return ((ForStatement)this._statements.get(0)).getIterablePredicate();
    }

    @Override
    public VariableSet validate(DMLProgram dmlProg, VariableSet ids, HashMap<String, ConstIdentifier> constVars, boolean conditional) {
        boolean bl;
        if (this._statements.size() > 1) {
            this.raiseValidateError("ForStatementBlock should have only 1 statement (for statement)", conditional);
        }
        ForStatement fs = (ForStatement)this._statements.get(0);
        IterablePredicate predicate = fs.getIterablePredicate();
        VariableSet origVarsBeforeBody = new VariableSet();
        for (String string : ids.getVariableNames()) {
            DataIdentifier origId = ids.getVariable(string);
            DataIdentifier copyId = new DataIdentifier(origId);
            origVarsBeforeBody.addVariable(string, copyId);
        }
        for (String string : this._updated.getVariableNames()) {
            if (!constVars.containsKey(string)) continue;
            constVars.remove(string);
        }
        predicate.validateExpression(ids.getVariables(), constVars, conditional);
        ArrayList<StatementBlock> body = fs.getBody();
        if (!conditional) {
            this.performConstantPropagation(constVars);
        }
        this._dmlProg = dmlProg;
        for (StatementBlock sb : body) {
            ids = sb.validate(dmlProg, ids, constVars, true);
            constVars = sb.getConstOut();
        }
        if (!body.isEmpty()) {
            this._constVarsIn.putAll(body.get(0).getConstIn());
            this._constVarsOut.putAll(body.get(body.size() - 1).getConstOut());
        }
        boolean bl2 = false;
        for (String key : this._updated.getVariableNames()) {
            DataIdentifier startVersion = origVarsBeforeBody.getVariable(key);
            DataIdentifier endVersion = ids.getVariable(key);
            if (startVersion == null || endVersion == null) continue;
            if (!startVersion.getOutput().getDataType().equals((Object)endVersion.getOutput().getDataType())) {
                this.raiseValidateError("ForStatementBlock has unsupported conditional data type change of variable '" + key + "' in loop body.", conditional);
            }
            long startVersionDim1 = startVersion instanceof IndexedIdentifier ? ((IndexedIdentifier)startVersion).getOrigDim1() : startVersion.getDim1();
            long endVersionDim1 = endVersion instanceof IndexedIdentifier ? ((IndexedIdentifier)endVersion).getOrigDim1() : endVersion.getDim1();
            long startVersionDim2 = startVersion instanceof IndexedIdentifier ? ((IndexedIdentifier)startVersion).getOrigDim2() : startVersion.getDim2();
            long endVersionDim2 = endVersion instanceof IndexedIdentifier ? ((IndexedIdentifier)endVersion).getOrigDim2() : endVersion.getDim2();
            boolean sizeUnchanged = startVersionDim1 == endVersionDim1 && startVersionDim2 == endVersionDim2;
            boolean nnzUnchanged = false;
            if (sizeUnchanged && nnzUnchanged) continue;
            bl = true;
            DataIdentifier recVersion = new DataIdentifier(endVersion);
            if (!sizeUnchanged) {
                recVersion.setDimensions(-1L, -1L);
            }
            if (!nnzUnchanged) {
                recVersion.setNnz(-1L);
            }
            origVarsBeforeBody.addVariable(key, recVersion);
        }
        if (bl) {
            ids = origVarsBeforeBody;
            for (String var : this._updated.getVariableNames()) {
                if (!constVars.containsKey(var)) continue;
                constVars.remove(var);
            }
            if (!conditional) {
                this.performConstantPropagation(constVars);
            }
            predicate.validateExpression(ids.getVariables(), constVars, conditional);
            body = fs.getBody();
            this._dmlProg = dmlProg;
            for (StatementBlock sb : body) {
                ids = sb.validate(dmlProg, ids, constVars, true);
                constVars = sb.getConstOut();
            }
            if (!body.isEmpty()) {
                this._constVarsIn.putAll(body.get(0).getConstIn());
                this._constVarsOut.putAll(body.get(body.size() - 1).getConstOut());
            }
        }
        return ids;
    }

    @Override
    public VariableSet initializeforwardLV(VariableSet activeInPassed) {
        ForStatement fstmt = (ForStatement)this._statements.get(0);
        if (this._statements.size() > 1) {
            throw new LanguageException(((Statement)this._statements.get(0)).printErrorLocation() + "ForStatementBlock should have only 1 statement (for statement)");
        }
        this._read = new VariableSet();
        this._read.addVariables(fstmt.getIterablePredicate().variablesRead());
        this._updated.addVariables(fstmt.getIterablePredicate().variablesUpdated());
        this._gen = new VariableSet();
        this._gen.addVariables(fstmt.getIterablePredicate().variablesRead());
        this._kill.addVariables(fstmt.getIterablePredicate().variablesUpdated());
        VariableSet current = new VariableSet();
        current.addVariables(activeInPassed);
        current.addVariables(this._updated);
        for (StatementBlock sb : fstmt.getBody()) {
            current = sb.initializeforwardLV(current);
            for (String varName : sb._gen.getVariableNames()) {
                if (this._kill.getVariableNames().contains(varName)) continue;
                this._gen.addVariable(varName, sb._gen.getVariable(varName));
            }
            this._read.addVariables(sb._read);
            this._updated.addVariables(sb._updated);
            if (sb instanceof WhileStatementBlock || sb instanceof ForStatementBlock) continue;
            this._kill.addVariables(sb._kill);
        }
        for (String varName : this._updated.getVariableNames()) {
            if (activeInPassed.containsVariable(varName)) continue;
            this._warnSet.addVariable(varName, this._updated.getVariable(varName));
        }
        this._liveOut = new VariableSet();
        this._liveOut.addVariables(current);
        this._liveOut.addVariables(this._updated);
        return this._liveOut;
    }

    @Override
    public VariableSet initializebackwardLV(VariableSet loPassed) {
        ForStatement fstmt = (ForStatement)this._statements.get(0);
        VariableSet lo = new VariableSet();
        lo.addVariables(loPassed);
        int numBlocks = fstmt.getBody().size();
        for (int i = numBlocks - 1; i >= 0; --i) {
            lo = fstmt.getBody().get(i).analyze(lo);
        }
        VariableSet loReturn = new VariableSet();
        loReturn.addVariables(lo);
        return loReturn;
    }

    public void setFromHops(Hop hops) {
        this._fromHops = hops;
    }

    public void setToHops(Hop hops) {
        this._toHops = hops;
    }

    public void setIncrementHops(Hop hops) {
        this._incrementHops = hops;
    }

    public Hop getFromHops() {
        return this._fromHops;
    }

    public Hop getToHops() {
        return this._toHops;
    }

    public Hop getIncrementHops() {
        return this._incrementHops;
    }

    public void setFromLops(Lop lops) {
        this._fromLops = lops;
    }

    public void setToLops(Lop lops) {
        this._toLops = lops;
    }

    public void setIncrementLops(Lop lops) {
        this._incrementLops = lops;
    }

    public Lop getFromLops() {
        return this._fromLops;
    }

    public Lop getToLops() {
        return this._toLops;
    }

    public Lop getIncrementLops() {
        return this._incrementLops;
    }

    @Override
    public VariableSet analyze(VariableSet loPassed) {
        VariableSet predVars = new VariableSet();
        IterablePredicate ip = ((ForStatement)this._statements.get(0)).getIterablePredicate();
        predVars.addVariables(ip.variablesRead());
        predVars.addVariables(ip.variablesUpdated());
        VariableSet candidateLO = new VariableSet();
        candidateLO.addVariables(loPassed);
        candidateLO.addVariables(this._gen);
        candidateLO.addVariables(predVars);
        VariableSet origLiveOut = new VariableSet();
        origLiveOut.addVariables(this._liveOut);
        origLiveOut.addVariables(predVars);
        origLiveOut.addVariables(this._gen);
        this._liveOut = new VariableSet();
        for (String string : candidateLO.getVariableNames()) {
            if (!origLiveOut.containsVariable(string)) continue;
            this._liveOut.addVariable(string, candidateLO.getVariable(string));
        }
        this.initializebackwardLV(this._liveOut);
        VariableSet finalWarnSet = new VariableSet();
        for (String varName : this._warnSet.getVariableNames()) {
            if (!this._liveOut.containsVariable(varName)) continue;
            finalWarnSet.addVariable(varName, this._warnSet.getVariable(varName));
        }
        this._warnSet = finalWarnSet;
        for (String varName : this._warnSet.getVariableNames()) {
            if (ip.getIterVar().getName().equals(varName)) continue;
            LOG.warn((Object)(this._warnSet.getVariable(varName).printWarningLocation() + "Initialization of " + varName + " depends on for execution"));
        }
        this._liveIn = new VariableSet();
        this._liveIn.addVariables(this._liveOut);
        this._liveIn.addVariables(this._gen);
        VariableSet variableSet = new VariableSet();
        variableSet.addVariables(this._liveIn);
        return variableSet;
    }

    public void performConstantPropagation(HashMap<String, ConstIdentifier> currConstVars) {
        IterablePredicate ip = this.getIterPredicate();
        Expression replacementExpr = ForStatementBlock.replaceConstantVar(ip.getFromExpr(), currConstVars);
        if (replacementExpr != null) {
            ip.setFromExpr(replacementExpr);
        }
        if ((replacementExpr = ForStatementBlock.replaceConstantVar(ip.getToExpr(), currConstVars)) != null) {
            ip.setToExpr(replacementExpr);
        }
        if ((replacementExpr = ForStatementBlock.replaceConstantVar(ip.getIncrementExpr(), currConstVars)) != null) {
            ip.setIncrementExpr(replacementExpr);
        }
    }

    private static Expression replaceConstantVar(Expression expr, HashMap<String, ConstIdentifier> currConstVars) {
        Expression ret = null;
        if (expr instanceof DataIdentifier && !(expr instanceof IndexedIdentifier)) {
            String identifierName = ((DataIdentifier)expr).getName();
            if (currConstVars.containsKey(identifierName)) {
                ConstIdentifier constValue = currConstVars.get(identifierName);
                switch (constValue.getValueType()) {
                    case FP64: {
                        ret = new IntIdentifier(new DoubleObject(((DoubleIdentifier)constValue).getValue()).getLongValue(), (ParseInfo)expr);
                        break;
                    }
                    case INT64: {
                        ret = new IntIdentifier((IntIdentifier)constValue, (ParseInfo)expr);
                        break;
                    }
                    case BOOLEAN: {
                        ret = new IntIdentifier(new BooleanObject(((BooleanIdentifier)constValue).getValue()).getLongValue(), (ParseInfo)expr);
                        break;
                    }
                }
            }
        } else {
            ret = expr;
        }
        return ret;
    }

    public boolean updatePredicateRecompilationFlags() {
        if (ConfigurationManager.isDynamicRecompilation()) {
            this._requiresFromRecompile = Recompiler.requiresRecompilation(this.getFromHops());
            this._requiresToRecompile = Recompiler.requiresRecompilation(this.getToHops());
            this._requiresIncrementRecompile = Recompiler.requiresRecompilation(this.getIncrementHops());
        }
        return this._requiresFromRecompile || this._requiresToRecompile || this._requiresIncrementRecompile;
    }

    public boolean requiresFromRecompilation() {
        return this._requiresFromRecompile;
    }

    public boolean requiresToRecompilation() {
        return this._requiresToRecompile;
    }

    public boolean requiresIncrementRecompilation() {
        return this._requiresIncrementRecompile;
    }
}

