/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.parser;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONObject;
import org.tugraz.sysds.api.DMLScript;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.conf.CompilerConfig;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.parser.BinaryExpression;
import org.tugraz.sysds.parser.BooleanIdentifier;
import org.tugraz.sysds.parser.ConstIdentifier;
import org.tugraz.sysds.parser.DataIdentifier;
import org.tugraz.sysds.parser.DoubleIdentifier;
import org.tugraz.sysds.parser.Expression;
import org.tugraz.sysds.parser.FunctionCallIdentifier;
import org.tugraz.sysds.parser.Identifier;
import org.tugraz.sysds.parser.IndexedIdentifier;
import org.tugraz.sysds.parser.IntIdentifier;
import org.tugraz.sysds.parser.LanguageException;
import org.tugraz.sysds.parser.ParameterExpression;
import org.tugraz.sysds.parser.ParseInfo;
import org.tugraz.sysds.parser.StringIdentifier;
import org.tugraz.sysds.parser.VariableSet;
import org.tugraz.sysds.parser.dml.CustomErrorListener;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.tugraz.sysds.runtime.io.FileFormatPropertiesMM;
import org.tugraz.sysds.runtime.io.IOUtilFunctions;
import org.tugraz.sysds.runtime.util.HDFSTool;
import org.tugraz.sysds.runtime.util.UtilFunctions;
import org.tugraz.sysds.utils.JSONHelper;

public class DataExpression
extends DataIdentifier {
    public static final String RAND_DIMS = "dims";
    public static final String RAND_ROWS = "rows";
    public static final String RAND_COLS = "cols";
    public static final String RAND_MIN = "min";
    public static final String RAND_MAX = "max";
    public static final String RAND_SPARSITY = "sparsity";
    public static final String RAND_SEED = "seed";
    public static final String RAND_PDF = "pdf";
    public static final String RAND_LAMBDA = "lambda";
    public static final String RAND_PDF_UNIFORM = "uniform";
    public static final String RAND_BY_ROW = "byrow";
    public static final String RAND_DIMNAMES = "dimnames";
    public static final String RAND_DATA = "data";
    public static final String IO_FILENAME = "iofilename";
    public static final String READROWPARAM = "rows";
    public static final String READCOLPARAM = "cols";
    public static final String READNNZPARAM = "nnz";
    public static final String SQL_CONN = "conn";
    public static final String SQL_USER = "user";
    public static final String SQL_PASS = "password";
    public static final String SQL_QUERY = "query";
    public static final String FED_ADDRESSES = "addresses";
    public static final String FED_RANGES = "ranges";
    public static final String FORMAT_TYPE = "format";
    public static final String FORMAT_TYPE_VALUE_TEXT = "text";
    public static final String FORMAT_TYPE_VALUE_BINARY = "binary";
    public static final String FORMAT_TYPE_VALUE_CSV = "csv";
    public static final String FORMAT_TYPE_VALUE_MATRIXMARKET = "mm";
    public static final String FORMAT_TYPE_VALUE_LIBSVM = "libsvm";
    public static final String ROWBLOCKCOUNTPARAM = "rows_in_block";
    public static final String COLUMNBLOCKCOUNTPARAM = "cols_in_block";
    public static final String DATATYPEPARAM = "data_type";
    public static final String VALUETYPEPARAM = "value_type";
    public static final String DESCRIPTIONPARAM = "description";
    public static final String AUTHORPARAM = "author";
    public static final String SCHEMAPARAM = "schema";
    public static final String CREATEDPARAM = "created";
    public static final String DELIM_DELIMITER = "sep";
    public static final String DELIM_HAS_HEADER_ROW = "header";
    public static final String DELIM_FILL = "fill";
    public static final String DELIM_FILL_VALUE = "default";
    public static final String DELIM_NA_STRINGS = "na.strings";
    public static final String DELIM_NA_STRING_SEP = "\u00b7";
    public static final String DELIM_SPARSE = "sparse";
    public static final String[] RAND_VALID_PARAM_NAMES = new String[]{"rows", "cols", "dims", "min", "max", "sparsity", "seed", "pdf", "lambda"};
    public static final String[] RESHAPE_VALID_PARAM_NAMES = new String[]{"byrow", "dimnames", "data", "rows", "cols", "dims"};
    public static final String[] SQL_VALID_PARAM_NAMES = new String[]{"conn", "user", "password", "query"};
    public static final String[] FEDERATED_VALID_PARAM_NAMES = new String[]{"addresses", "ranges"};
    public static final String[] READ_VALID_MTD_PARAM_NAMES = new String[]{"iofilename", "rows", "cols", "nnz", "format", "rows_in_block", "cols_in_block", "data_type", "value_type", "schema", "description", "author", "created", "default", "sep", "fill", "header", "na.strings"};
    public static final String[] READ_VALID_PARAM_NAMES = new String[]{"iofilename", "rows", "cols", "format", "data_type", "value_type", "schema", "rows_in_block", "cols_in_block", "nnz", "default", "sep", "fill", "header", "na.strings"};
    public static final String DEFAULT_DELIM_DELIMITER = ",";
    public static final boolean DEFAULT_DELIM_HAS_HEADER_ROW = false;
    public static final boolean DEFAULT_DELIM_FILL = true;
    public static final double DEFAULT_DELIM_FILL_VALUE = 0.0;
    public static final boolean DEFAULT_DELIM_SPARSE = false;
    private Expression.DataOp _opcode;
    private HashMap<String, Expression> _varParams;
    private boolean _strInit = false;
    private boolean _checkMetadata = true;

    public DataExpression() {
    }

    public void setCheckMetadata(boolean checkMetadata) {
        this._checkMetadata = checkMetadata;
    }

    public static DataExpression getDataExpression(ParserRuleContext ctx, String functionName, ArrayList<ParameterExpression> passedParamExprs, String filename, CustomErrorListener errorListener) {
        ParseInfo pi = ParseInfo.ctxAndFilenameToParseInfo(ctx, filename);
        return DataExpression.getDataExpression(functionName, passedParamExprs, pi, errorListener);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static DataExpression getDataExpression(String functionName, ArrayList<ParameterExpression> passedParamExprs, ParseInfo parseInfo, CustomErrorListener errorListener) {
        DataExpression dataExpr;
        block66: {
            Object firstParam2;
            int unnamedParamCount;
            int namedParamCount;
            block67: {
                Iterator<ParameterExpression> firstParam2;
                int unnamedParamCount2;
                int namedParamCount2;
                block65: {
                    Object firstParam32;
                    int unnamedParamCount3;
                    int namedParamCount3;
                    block63: {
                        Iterator<ParameterExpression> pname2;
                        int unnamedParamCount4;
                        int namedParamCount4;
                        block61: {
                            Iterator<ParameterExpression> pexpr2;
                            block59: {
                                block57: {
                                    block64: {
                                        block62: {
                                            block60: {
                                                block58: {
                                                    block56: {
                                                        ParameterExpression pexpr2;
                                                        if (functionName == null || passedParamExprs == null) {
                                                            return null;
                                                        }
                                                        dataExpr = null;
                                                        if (!functionName.equals("read") && !functionName.equals("readMM") && !functionName.equals("read.csv")) break block56;
                                                        Expression.DataOp dop = Expression.DataOp.READ;
                                                        dataExpr = new DataExpression(dop, new HashMap<String, Expression>(), parseInfo);
                                                        if (functionName.equals("readMM")) {
                                                            dataExpr.addVarParam(FORMAT_TYPE, new StringIdentifier(FORMAT_TYPE_VALUE_MATRIXMARKET, parseInfo));
                                                        }
                                                        if (functionName.equals("read.csv")) {
                                                            dataExpr.addVarParam(FORMAT_TYPE, new StringIdentifier(FORMAT_TYPE_VALUE_CSV, parseInfo));
                                                        }
                                                        if (functionName.equals("read.libsvm")) {
                                                            dataExpr.addVarParam(FORMAT_TYPE, new StringIdentifier(FORMAT_TYPE_VALUE_LIBSVM, parseInfo));
                                                        }
                                                        if (passedParamExprs.size() < 1) {
                                                            errorListener.validationError(parseInfo, "read method must have at least filename parameter");
                                                            return null;
                                                        }
                                                        ParameterExpression parameterExpression = pexpr2 = passedParamExprs.size() == 0 ? null : passedParamExprs.get(0);
                                                        if (pexpr2 != null && (pexpr2.getName() != null || pexpr2.getName() != null && pexpr2.getName().equalsIgnoreCase(IO_FILENAME))) {
                                                            errorListener.validationError(parseInfo, "first parameter to read statement must be filename");
                                                            return null;
                                                        }
                                                        if (pexpr2 != null) {
                                                            dataExpr.addVarParam(IO_FILENAME, pexpr2.getExpr());
                                                        }
                                                        break block57;
                                                    }
                                                    if (!functionName.equalsIgnoreCase("rand")) break block58;
                                                    Expression.DataOp dop = Expression.DataOp.RAND;
                                                    dataExpr = new DataExpression(dop, new HashMap<String, Expression>(), parseInfo);
                                                    pexpr2 = passedParamExprs.iterator();
                                                    break block59;
                                                }
                                                if (!functionName.equals("matrix")) break block60;
                                                Expression.DataOp dop = Expression.DataOp.MATRIX;
                                                dataExpr = new DataExpression(dop, new HashMap<String, Expression>(), parseInfo);
                                                namedParamCount4 = 0;
                                                unnamedParamCount4 = 0;
                                                pname2 = passedParamExprs.iterator();
                                                break block61;
                                            }
                                            if (!functionName.equals("tensor")) break block62;
                                            Expression.DataOp dop = Expression.DataOp.TENSOR;
                                            dataExpr = new DataExpression(dop, new HashMap<String, Expression>(), parseInfo);
                                            namedParamCount3 = 0;
                                            unnamedParamCount3 = 0;
                                            firstParam32 = passedParamExprs.iterator();
                                            break block63;
                                        }
                                        if (!functionName.equals("sql")) break block64;
                                        Expression.DataOp dop = Expression.DataOp.SQL;
                                        dataExpr = new DataExpression(dop, new HashMap<String, Expression>(), parseInfo);
                                        namedParamCount2 = 0;
                                        unnamedParamCount2 = 0;
                                        firstParam2 = passedParamExprs.iterator();
                                        break block65;
                                    }
                                    if (!functionName.equals("federated")) break block66;
                                    Expression.DataOp dop = Expression.DataOp.FEDERATED;
                                    dataExpr = new DataExpression(dop, new HashMap<String, Expression>(), parseInfo);
                                    namedParamCount = 0;
                                    unnamedParamCount = 0;
                                    firstParam2 = passedParamExprs.iterator();
                                    break block67;
                                }
                                for (int i = 1; i < passedParamExprs.size(); ++i) {
                                    String currName = passedParamExprs.get(i).getName();
                                    Expression currExpr = passedParamExprs.get(i).getExpr();
                                    if (dataExpr.getVarParam(currName) != null) {
                                        errorListener.validationError(parseInfo, "attempted to add IOStatement parameter " + currName + " more than once");
                                        return null;
                                    }
                                    boolean isValidName = false;
                                    for (String paramName : READ_VALID_PARAM_NAMES) {
                                        if (!paramName.equals(currName)) continue;
                                        isValidName = true;
                                    }
                                    if (!isValidName) {
                                        errorListener.validationError(parseInfo, "attempted to add invalid read statement parameter " + currName);
                                        return null;
                                    }
                                    dataExpr.addVarParam(currName, currExpr);
                                }
                                break block66;
                            }
                            while (pexpr2.hasNext()) {
                                ParameterExpression currExpr = pexpr2.next();
                                String pname2 = currExpr.getName();
                                Expression pexpr3 = currExpr.getExpr();
                                if (pname2 == null) {
                                    errorListener.validationError(parseInfo, "for rand statement, all arguments must be named parameters");
                                    return null;
                                }
                                dataExpr.addRandExprParam(pname2, pexpr3);
                            }
                            dataExpr.setRandDefault();
                            break block66;
                        }
                        while (pname2.hasNext()) {
                            ParameterExpression currExpr = pname2.next();
                            if (currExpr.getName() == null) {
                                ++unnamedParamCount4;
                                continue;
                            }
                            ++namedParamCount4;
                        }
                        if (passedParamExprs.size() < 3) {
                            errorListener.validationError(parseInfo, "for matrix statement, must specify at least 3 arguments: data, rows, cols");
                            return null;
                        }
                        if (unnamedParamCount4 > 1) {
                            if (namedParamCount4 > 0) {
                                errorListener.validationError(parseInfo, "for matrix statement, cannot mix named and unnamed parameters");
                                return null;
                            }
                            if (unnamedParamCount4 < 3) {
                                errorListener.validationError(parseInfo, "for matrix statement, must specify at least 3 arguments: data, rows, cols");
                                return null;
                            }
                            dataExpr.addMatrixExprParam(RAND_DATA, passedParamExprs.get(0).getExpr());
                            dataExpr.addMatrixExprParam("rows", passedParamExprs.get(1).getExpr());
                            dataExpr.addMatrixExprParam("cols", passedParamExprs.get(2).getExpr());
                            if (unnamedParamCount4 >= 4) {
                                dataExpr.addMatrixExprParam(RAND_BY_ROW, passedParamExprs.get(3).getExpr());
                            }
                            if (unnamedParamCount4 == 5) {
                                dataExpr.addMatrixExprParam(RAND_DIMNAMES, passedParamExprs.get(4).getExpr());
                            }
                            if (unnamedParamCount4 > 5) {
                                errorListener.validationError(parseInfo, "for matrix statement, at most 5 arguments supported: data, rows, cols, byrow, dimname");
                                return null;
                            }
                        } else {
                            ParameterExpression firstParam32 = passedParamExprs.get(0);
                            if (firstParam32.getName() != null && !firstParam32.getName().equals(RAND_DATA)) {
                                errorListener.validationError(parseInfo, "matrix method must have data parameter as first parameter or unnamed parameter");
                                return null;
                            }
                            dataExpr.addMatrixExprParam(RAND_DATA, passedParamExprs.get(0).getExpr());
                            for (int i = 1; i < passedParamExprs.size(); ++i) {
                                if (passedParamExprs.get(i).getName() == null) {
                                    errorListener.validationError(parseInfo, "for matrix statement, cannot mix named and unnamed parameters, only data parameter can be unnammed");
                                    return null;
                                }
                                dataExpr.addMatrixExprParam(passedParamExprs.get(i).getName(), passedParamExprs.get(i).getExpr());
                            }
                        }
                        dataExpr.setMatrixDefault();
                        break block66;
                    }
                    while (firstParam32.hasNext()) {
                        ParameterExpression currExpr = firstParam32.next();
                        if (currExpr.getName() == null) {
                            ++unnamedParamCount3;
                            continue;
                        }
                        ++namedParamCount3;
                    }
                    if (passedParamExprs.size() < 2) {
                        errorListener.validationError(parseInfo, "for tensor statement, must specify at least 2 arguments: data, dims[]");
                        return null;
                    }
                    if (unnamedParamCount3 > 1) {
                        if (namedParamCount3 > 0) {
                            errorListener.validationError(parseInfo, "for tensor statement, cannot mix named and unnamed parameters");
                            return null;
                        }
                        dataExpr.addTensorExprParam(RAND_DATA, passedParamExprs.get(0).getExpr());
                        dataExpr.addTensorExprParam(RAND_DIMS, passedParamExprs.get(1).getExpr());
                        if (unnamedParamCount3 >= 3) {
                            dataExpr.addTensorExprParam(RAND_BY_ROW, passedParamExprs.get(2).getExpr());
                        }
                        if (unnamedParamCount3 == 4) {
                            dataExpr.addTensorExprParam(RAND_DIMNAMES, passedParamExprs.get(3).getExpr());
                        }
                        if (unnamedParamCount3 > 4) {
                            errorListener.validationError(parseInfo, "for tensor statement, at most 4 arguments supported: data, dims, byrow, dimname");
                            return null;
                        }
                    } else {
                        firstParam32 = passedParamExprs.get(0);
                        if (((ParameterExpression)firstParam32).getName() != null && !((ParameterExpression)firstParam32).getName().equals(RAND_DATA)) {
                            errorListener.validationError(parseInfo, "tensor method must have data parameter as first parameter or unnamed parameter");
                            return null;
                        }
                        dataExpr.addTensorExprParam(RAND_DATA, passedParamExprs.get(0).getExpr());
                        for (int i = 1; i < passedParamExprs.size(); ++i) {
                            if (passedParamExprs.get(i).getName() == null) {
                                errorListener.validationError(parseInfo, "for tensor statement, cannot mix named and unnamed parameters, only data parameter can be unnammed");
                                return null;
                            }
                            dataExpr.addTensorExprParam(passedParamExprs.get(i).getName(), passedParamExprs.get(i).getExpr());
                        }
                    }
                    dataExpr.setTensorDefault();
                    break block66;
                }
                while (firstParam2.hasNext()) {
                    ParameterExpression currExpr = firstParam2.next();
                    if (currExpr.getName() == null) {
                        ++unnamedParamCount2;
                        continue;
                    }
                    ++namedParamCount2;
                }
                if (passedParamExprs.size() < 2) {
                    errorListener.validationError(parseInfo, "for sql statement, must specify at least 2 arguments: conn, query");
                    return null;
                }
                if (unnamedParamCount2 > 0) {
                    if (namedParamCount2 > 0) {
                        errorListener.validationError(parseInfo, "for sql statement, cannot mix named and unnamed parameters");
                        return null;
                    }
                    if (unnamedParamCount2 != 2 && unnamedParamCount2 != 4) {
                        errorListener.validationError(parseInfo, "for sql statement, at most 4 arguments supported: conn, user, password, query");
                        return null;
                    }
                    dataExpr.addSqlExprParam(SQL_CONN, passedParamExprs.get(0).getExpr());
                    dataExpr.addSqlExprParam(SQL_QUERY, passedParamExprs.get(1).getExpr());
                    if (unnamedParamCount2 == 4) {
                        dataExpr.addSqlExprParam(SQL_PASS, passedParamExprs.get(2).getExpr());
                        dataExpr.addSqlExprParam(SQL_QUERY, passedParamExprs.get(3).getExpr());
                    }
                } else {
                    for (ParameterExpression passedParamExpr : passedParamExprs) {
                        dataExpr.addSqlExprParam(passedParamExpr.getName(), passedParamExpr.getExpr());
                    }
                }
                dataExpr.setSqlDefault();
                break block66;
            }
            while (firstParam2.hasNext()) {
                ParameterExpression currExpr = firstParam2.next();
                if (currExpr.getName() == null) {
                    ++unnamedParamCount;
                    continue;
                }
                ++namedParamCount;
            }
            if (passedParamExprs.size() != 2) {
                errorListener.validationError(parseInfo, "for federated statement, must specify exactly 2 argument: addresses, ranges");
                return null;
            }
            if (unnamedParamCount > 0) {
                if (namedParamCount > 0) {
                    errorListener.validationError(parseInfo, "for federated statement, cannot mix named and unnamed parameters");
                    return null;
                }
                ParameterExpression param = passedParamExprs.get(0);
                dataExpr.addFederatedExprParam(FED_ADDRESSES, param.getExpr());
                param = passedParamExprs.get(1);
                dataExpr.addFederatedExprParam(FED_RANGES, param.getExpr());
            } else {
                firstParam2 = passedParamExprs.get(0);
                if (((ParameterExpression)firstParam2).getName() != null && !((ParameterExpression)firstParam2).getName().equals(FED_ADDRESSES)) {
                    errorListener.validationError(parseInfo, "federated method must have addresses parameter as first parameter or unnamed parameter");
                    return null;
                }
                for (ParameterExpression passedParamExpr : passedParamExprs) {
                    dataExpr.addFederatedExprParam(passedParamExpr.getName(), passedParamExpr.getExpr());
                }
            }
        }
        if (dataExpr != null) {
            dataExpr.setParseInfo(parseInfo);
        }
        return dataExpr;
    }

    public void addRandExprParam(String paramName, Expression paramValue) {
        if (DMLScript.VALIDATOR_IGNORE_ISSUES && paramValue == null) {
            return;
        }
        boolean found = false;
        if (paramName != null) {
            for (String name : RAND_VALID_PARAM_NAMES) {
                if (!name.equals(paramName)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            this.raiseValidateError("unexpected parameter \"" + paramName + "\". Legal parameters for Rand statement are (capitalization-sensitive): " + "rows" + ", " + "cols" + ", " + RAND_MIN + ", " + RAND_MAX + ", " + RAND_SPARSITY + ", " + RAND_SEED + ", " + RAND_PDF + ", " + RAND_LAMBDA);
        }
        if (this.getVarParam(paramName) != null) {
            this.raiseValidateError("attempted to add Rand statement parameter " + paramValue + " more than once");
        }
        if (paramName.equals("rows") && paramValue instanceof DoubleIdentifier) {
            paramValue = new IntIdentifier((long)((DoubleIdentifier)paramValue).getValue(), (ParseInfo)this);
        } else if (paramName.equals("cols") && paramValue instanceof DoubleIdentifier) {
            paramValue = new IntIdentifier((long)((DoubleIdentifier)paramValue).getValue(), (ParseInfo)this);
        }
        paramValue.setParseInfo(this);
        this.addVarParam(paramName, paramValue);
    }

    public void addMatrixExprParam(String paramName, Expression paramValue) {
        boolean found = false;
        if (paramName != null) {
            found = Arrays.stream(RESHAPE_VALID_PARAM_NAMES).anyMatch(name -> name.equals(paramName));
        }
        if (!found) {
            this.raiseValidateError("unexpected parameter \"" + paramName + "\". Legal parameters for  matrix statement are (capitalization-sensitive): " + RAND_DATA + ", " + "rows" + ", " + "cols" + ", " + RAND_BY_ROW);
        }
        if (this.getVarParam(paramName) != null) {
            this.raiseValidateError("attempted to add matrix statement parameter " + paramValue + " more than once");
        }
        if (paramName.equals("rows") && paramValue instanceof DoubleIdentifier) {
            paramValue = new IntIdentifier((long)((DoubleIdentifier)paramValue).getValue(), (ParseInfo)this);
        } else if (paramName.equals("cols") && paramValue instanceof DoubleIdentifier) {
            paramValue = new IntIdentifier((long)((DoubleIdentifier)paramValue).getValue(), (ParseInfo)this);
        }
        paramValue.setParseInfo(this);
        this.addVarParam(paramName, paramValue);
    }

    public void addTensorExprParam(String paramName, Expression paramValue) {
        boolean found = false;
        if (paramName != null) {
            found = Arrays.asList(RESHAPE_VALID_PARAM_NAMES).contains(paramName);
        }
        if (!found) {
            this.raiseValidateError("unexpected parameter \"" + paramName + "\". Legal parameters for tensor statement are (capitalization-sensitive): " + RAND_DATA + ", " + RAND_DIMS + ", " + RAND_BY_ROW + ", " + RAND_DIMNAMES);
        }
        if (this.getVarParam(paramName) != null) {
            this.raiseValidateError("attempted to add tensor statement parameter " + paramValue + " more than once");
        }
        paramValue.setParseInfo(this);
        this.addVarParam(paramName, paramValue);
    }

    public void addSqlExprParam(String paramName, Expression paramValue) {
        boolean found = false;
        if (paramName != null) {
            found = Arrays.asList(SQL_VALID_PARAM_NAMES).contains(paramName);
        }
        if (!found) {
            this.raiseValidateError("unexpected parameter \"" + paramName + "\". Legal parameters for sql statement are (capitalization-sensitive): " + SQL_CONN + ", " + SQL_USER + ", " + SQL_PASS + ", " + SQL_QUERY);
        }
        if (this.getVarParam(paramName) != null) {
            this.raiseValidateError("attempted to add sql statement parameter " + paramValue + " more than once");
        }
        paramValue.setParseInfo(this);
        this.addVarParam(paramName, paramValue);
    }

    public void addFederatedExprParam(String paramName, Expression paramValue) {
        boolean found;
        boolean bl = found = paramName != null && Arrays.asList(FEDERATED_VALID_PARAM_NAMES).contains(paramName);
        if (!found) {
            this.raiseValidateError("unexpected parameter \"" + paramName + "\". Legal parameters for federated statement are (capitalization-sensitive): " + FED_ADDRESSES + ", " + FED_RANGES);
        }
        if (this.getVarParam(paramName) != null) {
            this.raiseValidateError("attempted to add federated statement parameter " + paramValue + " more than once");
        }
        paramValue.setParseInfo(this);
        this.addVarParam(paramName, paramValue);
    }

    public DataExpression(Expression.DataOp op, HashMap<String, Expression> varParams, ParseInfo parseInfo) {
        this._opcode = op;
        this._varParams = varParams;
        this.setParseInfo(parseInfo);
    }

    public DataExpression(ParserRuleContext ctx, Expression.DataOp op, HashMap<String, Expression> varParams, String filename) {
        this._opcode = op;
        this._varParams = varParams;
        this.setCtxValuesAndFilename(ctx, filename);
    }

    @Override
    public Expression rewriteExpression(String prefix) {
        HashMap<String, Expression> newVarParams = new HashMap<String, Expression>();
        for (Map.Entry<String, Expression> e : this._varParams.entrySet()) {
            String key = e.getKey();
            Expression newExpr = e.getValue().rewriteExpression(prefix);
            newVarParams.put(key, newExpr);
        }
        DataExpression retVal = new DataExpression(this._opcode, newVarParams, this);
        retVal._strInit = this._strInit;
        return retVal;
    }

    public void setMatrixDefault() {
        if (this.getVarParam(RAND_BY_ROW) == null) {
            this.addVarParam(RAND_BY_ROW, new BooleanIdentifier(true, this));
        }
    }

    public void setTensorDefault() {
        if (this.getVarParam(RAND_BY_ROW) == null) {
            this.addVarParam(RAND_BY_ROW, new BooleanIdentifier(true, this));
        }
    }

    private void setSqlDefault() {
        if (this.getVarParam(SQL_USER) == null) {
            this.addVarParam(SQL_USER, new StringIdentifier("", this));
        }
        if (this.getVarParam(SQL_PASS) == null) {
            this.addVarParam(SQL_PASS, new StringIdentifier("", this));
        }
    }

    public void setRandDefault() {
        ConstIdentifier id;
        if (this.getVarParam(RAND_DIMS) == null) {
            if (this.getVarParam("rows") == null) {
                id = new IntIdentifier(1L, (ParseInfo)this);
                this.addVarParam("rows", id);
            }
            if (this.getVarParam("cols") == null) {
                id = new IntIdentifier(1L, (ParseInfo)this);
                this.addVarParam("cols", id);
            }
        }
        if (this.getVarParam(RAND_MIN) == null) {
            id = new DoubleIdentifier(0.0, (ParseInfo)this);
            this.addVarParam(RAND_MIN, id);
        }
        if (this.getVarParam(RAND_MAX) == null) {
            id = new DoubleIdentifier(1.0, (ParseInfo)this);
            this.addVarParam(RAND_MAX, id);
        }
        if (this.getVarParam(RAND_SPARSITY) == null) {
            id = new DoubleIdentifier(1.0, (ParseInfo)this);
            this.addVarParam(RAND_SPARSITY, id);
        }
        if (this.getVarParam(RAND_SEED) == null) {
            id = new IntIdentifier(-1L, (ParseInfo)this);
            this.addVarParam(RAND_SEED, id);
        }
        if (this.getVarParam(RAND_PDF) == null) {
            id = new StringIdentifier(RAND_PDF_UNIFORM, this);
            this.addVarParam(RAND_PDF, id);
        }
        if (this.getVarParam(RAND_LAMBDA) == null) {
            id = new DoubleIdentifier(1.0, (ParseInfo)this);
            this.addVarParam(RAND_LAMBDA, id);
        }
    }

    public void setOpCode(Expression.DataOp op) {
        this._opcode = op;
    }

    public Expression.DataOp getOpCode() {
        return this._opcode;
    }

    public HashMap<String, Expression> getVarParams() {
        return this._varParams;
    }

    public void setVarParams(HashMap<String, Expression> varParams) {
        this._varParams = varParams;
    }

    public Expression getVarParam(String name) {
        return this._varParams.get(name);
    }

    public void addVarParam(String name, Expression value) {
        if (DMLScript.VALIDATOR_IGNORE_ISSUES && value == null) {
            return;
        }
        this._varParams.put(name, value);
        this.setFilename(value.getFilename());
        if (this.getBeginLine() == 0) {
            this.setBeginLine(value.getBeginLine());
        }
        if (this.getBeginColumn() == 0) {
            this.setBeginColumn(value.getBeginColumn());
        }
        if (this.getEndLine() == 0) {
            this.setEndLine(value.getEndLine());
        }
        if (this.getEndColumn() == 0) {
            this.setEndColumn(value.getEndColumn());
        }
        if (this.getText() == null) {
            this.setText(value.getText());
        }
    }

    public void removeVarParam(String name) {
        this._varParams.remove(name);
    }

    public void removeVarParam(String ... names) {
        for (String name : names) {
            this.removeVarParam(name);
        }
    }

    private String getInputFileName(HashMap<String, ConstIdentifier> currConstVars, boolean conditional) {
        String filename = null;
        Expression fileNameExpr = this.getVarParam(IO_FILENAME);
        if (fileNameExpr instanceof ConstIdentifier) {
            return fileNameExpr.toString();
        }
        if (fileNameExpr instanceof BinaryExpression) {
            BinaryExpression expr = (BinaryExpression)fileNameExpr;
            Expression.BinaryOp op = expr.getOpCode();
            switch (op) {
                case PLUS: {
                    filename = "";
                    filename = this.fileNameCat(expr, currConstVars, filename, conditional);
                    StringIdentifier fileString = new StringIdentifier(filename, this);
                    this.removeVarParam(IO_FILENAME);
                    this.addVarParam(IO_FILENAME, fileString);
                    break;
                }
                default: {
                    this.raiseValidateError("for read method, parameter iofilename can only be const string concatenations. ", conditional);
                    break;
                }
            }
        } else {
            this.raiseValidateError("for read method, parameter iofilename can only be a const string or const string concatenations. ", conditional);
        }
        return filename;
    }

    public static String getMTDFileName(String inputFileName) {
        return inputFileName + ".mtd";
    }

    @Override
    public void validateExpression(HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> currConstVars, boolean conditional) {
        for (Map.Entry<String, Expression> e : this.getVarParams().entrySet()) {
            String s = e.getKey();
            Expression inputParamExpr = e.getValue();
            if (inputParamExpr instanceof FunctionCallIdentifier) {
                this.raiseValidateError("UDF function call not supported as parameter to built-in function call", false, "Invalid Parameters");
            }
            inputParamExpr.validateExpression(ids, currConstVars, conditional);
            if (this.getVarParam(s).getOutput().getDataType() == Types.DataType.SCALAR || s.equals(RAND_DATA) || s.equals(RAND_DIMS) || s.equals(FED_ADDRESSES) || s.equals(FED_RANGES)) continue;
            this.raiseValidateError("Non-scalar data types are not supported for data expression.", conditional, "Invalid Parameters");
        }
        this.performConstantPropagationRand(currConstVars);
        this.performConstantPropagationReadWrite(currConstVars);
        Expression dataParam1 = this.getVarParam(RAND_DATA);
        if (dataParam1 == null && (this.getOpCode().equals((Object)Expression.DataOp.MATRIX) || this.getOpCode().equals((Object)Expression.DataOp.TENSOR))) {
            this.raiseValidateError("for matrix or tensor, must defined data parameter", conditional, "Invalid Parameters");
        }
        if (dataParam1 != null && dataParam1.getOutput().getDataType() == Types.DataType.SCALAR && (this._opcode == Expression.DataOp.MATRIX || this._opcode == Expression.DataOp.TENSOR)) {
            this.setOpCode(Expression.DataOp.RAND);
        }
        switch (this.getOpCode()) {
            case READ: {
                String string;
                String formatTypeString;
                boolean shouldReadMTD;
                String dataTypeString;
                if (this.getVarParam(DATATYPEPARAM) != null && !(this.getVarParam(DATATYPEPARAM) instanceof StringIdentifier)) {
                    this.raiseValidateError("for read statement, parameter data_type can only be a string. Valid values are: matrix, scalar", conditional);
                }
                String string2 = dataTypeString = this.getVarParam(DATATYPEPARAM) == null ? null : this.getVarParam(DATATYPEPARAM).toString();
                if (dataTypeString != null && dataTypeString.equalsIgnoreCase("scalar") && (this.getVarParam("rows") != null || this.getVarParam("cols") != null || this.getVarParam(ROWBLOCKCOUNTPARAM) != null || this.getVarParam(COLUMNBLOCKCOUNTPARAM) != null || this.getVarParam(FORMAT_TYPE) != null || this.getVarParam(DELIM_DELIMITER) != null || this.getVarParam(DELIM_HAS_HEADER_ROW) != null || this.getVarParam(DELIM_FILL) != null || this.getVarParam(DELIM_FILL_VALUE) != null || this.getVarParam(DELIM_NA_STRINGS) != null)) {
                    this.raiseValidateError("Invalid parameters in read statement of a scalar: " + this.toString() + ". Only " + VALUETYPEPARAM + " is allowed.", conditional, "Invalid Parameters");
                }
                JSONObject configObject = null;
                String inputFileName = this.getInputFileName(currConstVars, conditional);
                String mtdFileName = DataExpression.getMTDFileName(inputFileName);
                boolean bl = shouldReadMTD = this._checkMetadata && (!ConfigurationManager.getCompilerConfigFlag(CompilerConfig.ConfigType.IGNORE_READ_WRITE_METADATA) || HDFSTool.existsFileOnHDFS(mtdFileName));
                if (shouldReadMTD && !HDFSTool.existsFileOnHDFS(inputFileName)) {
                    String fsext = InfrastructureAnalyzer.isLocalMode() ? "FS (local mode)" : "HDFS";
                    this.raiseValidateError("Read input file does not exist on " + fsext + ": " + inputFileName, conditional);
                }
                boolean inferredFormatType = false;
                String string3 = formatTypeString = this.getVarParam(FORMAT_TYPE) == null ? null : this.getVarParam(FORMAT_TYPE).toString();
                if (formatTypeString == null && shouldReadMTD && this.checkHasMatrixMarketFormat(inputFileName, mtdFileName, conditional)) {
                    formatTypeString = FORMAT_TYPE_VALUE_MATRIXMARKET;
                    this.addVarParam(FORMAT_TYPE, new StringIdentifier(FORMAT_TYPE_VALUE_MATRIXMARKET, this));
                    inferredFormatType = true;
                    shouldReadMTD = false;
                }
                if (formatTypeString == null && shouldReadMTD && (formatTypeString = this.checkHasDelimitedFormat(inputFileName, conditional)) != null) {
                    this.addVarParam(FORMAT_TYPE, new StringIdentifier(formatTypeString, this));
                    inferredFormatType = true;
                }
                if (formatTypeString != null && formatTypeString.equalsIgnoreCase(FORMAT_TYPE_VALUE_MATRIXMARKET)) {
                    shouldReadMTD = false;
                    String[] headerLines = null;
                    try {
                        headerLines = IOUtilFunctions.readMatrixMarketHeader(inputFileName);
                    }
                    catch (DMLRuntimeException ex) {
                        this.raiseValidateError(ex.getMessage(), conditional);
                    }
                    if (headerLines != null && headerLines.length >= 2) {
                        long nnzCount2;
                        long colsCount2;
                        long rowsCount2;
                        long rowsCount;
                        String firstLine = headerLines[0].trim();
                        FileFormatPropertiesMM fileFormatPropertiesMM = FileFormatPropertiesMM.parse(firstLine);
                        String secondLine = headerLines[1];
                        String[] sizeInfo = secondLine.trim().split("\\s+");
                        if (sizeInfo.length != 3) {
                            this.raiseValidateError("Unsupported size line in MatrixMarket file: " + headerLines[1] + ". Only supported format in MatrixMarket file has size line: <NUM ROWS> <NUM COLS> <NUM NON-ZEROS>, where each value is an integer.", conditional);
                        }
                        if ((rowsCount = Long.parseLong(sizeInfo[0])) < 0L) {
                            this.raiseValidateError("MM file: invalid number of rows: " + rowsCount);
                        } else if (this.getVarParam("rows") != null && (rowsCount2 = Long.parseLong(this.getVarParam("rows").toString())) != rowsCount) {
                            this.raiseValidateError("MM file: invalid specified number of rows: " + rowsCount2 + " vs " + rowsCount);
                        }
                        this.addVarParam("rows", new IntIdentifier(rowsCount, (ParseInfo)this));
                        long colsCount = Long.parseLong(sizeInfo[1]);
                        if (colsCount < 0L) {
                            this.raiseValidateError("MM file: invalid number of columns: " + colsCount);
                        } else if (this.getVarParam("cols") != null && (colsCount2 = Long.parseLong(this.getVarParam("cols").toString())) != colsCount) {
                            this.raiseValidateError("MM file: invalid specified number of columns: " + colsCount2 + " vs " + colsCount);
                        }
                        this.addVarParam("cols", new IntIdentifier(colsCount, (ParseInfo)this));
                        long nnzCount = Long.parseLong(sizeInfo[2]) * (long)(fileFormatPropertiesMM.isSymmetric() ? 2 : 1);
                        if (nnzCount < 0L) {
                            this.raiseValidateError("MM file: invalid number of non-zeros: " + nnzCount);
                        } else if (this.getVarParam(READNNZPARAM) != null && (nnzCount2 = Long.parseLong(this.getVarParam(READNNZPARAM).toString())) != nnzCount) {
                            this.raiseValidateError("MM file: invalid specified number of non-zeros: " + nnzCount2 + " vs " + nnzCount);
                        }
                        this.addVarParam(READNNZPARAM, new IntIdentifier(nnzCount, (ParseInfo)this));
                    }
                }
                if (shouldReadMTD) {
                    configObject = this.readMetadataFile(mtdFileName, conditional);
                    if (configObject != null) {
                        this.parseMetaDataFileParameters(mtdFileName, configObject, conditional);
                        inferredFormatType = true;
                    } else {
                        LOG.warn((Object)("Metadata file: " + new Path(mtdFileName) + " not provided"));
                    }
                }
                boolean isCSV = false;
                boolean bl2 = isCSV = formatTypeString != null && formatTypeString.equalsIgnoreCase(FORMAT_TYPE_VALUE_CSV);
                if (isCSV) {
                    shouldReadMTD = true;
                    if (!inferredFormatType) {
                        for (String string4 : this._varParams.keySet()) {
                            if (string4.equals(IO_FILENAME) || string4.equals(FORMAT_TYPE) || string4.equals(DELIM_HAS_HEADER_ROW) || string4.equals(DELIM_DELIMITER) || string4.equals(DELIM_FILL) || string4.equals(DELIM_FILL_VALUE) || string4.equals("rows") || string4.equals("cols") || string4.equals(READNNZPARAM) || string4.equals(DATATYPEPARAM) || string4.equals(VALUETYPEPARAM) || string4.equals(SCHEMAPARAM)) continue;
                            String msg = "Only parameters allowed are: iofilename,schema,header,sep,fill,default,rows,cols";
                            this.raiseValidateError("Invalid parameter " + string4 + " in read statement: " + this.toString() + ". " + msg, conditional, "Invalid Parameters");
                        }
                    }
                    if (this.getVarParam(DELIM_DELIMITER) == null) {
                        this.addVarParam(DELIM_DELIMITER, new StringIdentifier(DEFAULT_DELIM_DELIMITER, this));
                    } else if (this.getVarParam(DELIM_DELIMITER) instanceof ConstIdentifier && !(this.getVarParam(DELIM_DELIMITER) instanceof StringIdentifier)) {
                        this.raiseValidateError("For delimited file '" + this.getVarParam(DELIM_DELIMITER) + "' must be a string value ", conditional);
                    }
                    if (this.getVarParam(DELIM_FILL_VALUE) == null) {
                        this.addVarParam(DELIM_FILL_VALUE, new DoubleIdentifier(0.0, (ParseInfo)this));
                    } else if (this.getVarParam(DELIM_FILL_VALUE) instanceof ConstIdentifier && !(this.getVarParam(DELIM_FILL_VALUE) instanceof IntIdentifier) && !(this.getVarParam(DELIM_FILL_VALUE) instanceof DoubleIdentifier)) {
                        this.raiseValidateError("For delimited file '" + this.getVarParam(DELIM_FILL_VALUE) + "' must be a numeric value ", conditional);
                    }
                    if (this.getVarParam(DELIM_HAS_HEADER_ROW) == null) {
                        this.addVarParam(DELIM_HAS_HEADER_ROW, new BooleanIdentifier(false, this));
                    } else if (this.getVarParam(DELIM_HAS_HEADER_ROW) instanceof ConstIdentifier && !(this.getVarParam(DELIM_HAS_HEADER_ROW) instanceof BooleanIdentifier)) {
                        this.raiseValidateError("For delimited file '" + this.getVarParam(DELIM_HAS_HEADER_ROW) + "' must be a boolean value ", conditional);
                    }
                    if (this.getVarParam(DELIM_FILL) == null) {
                        this.addVarParam(DELIM_FILL, new BooleanIdentifier(true, this));
                    } else if (this.getVarParam(DELIM_FILL) instanceof ConstIdentifier && !(this.getVarParam(DELIM_FILL) instanceof BooleanIdentifier)) {
                        this.raiseValidateError("For delimited file '" + this.getVarParam(DELIM_FILL) + "' must be a boolean value ", conditional);
                    }
                }
                boolean islibsvm = false;
                boolean bl3 = islibsvm = formatTypeString != null && formatTypeString.equalsIgnoreCase(FORMAT_TYPE_VALUE_LIBSVM);
                if (islibsvm) {
                    shouldReadMTD = true;
                    if (!inferredFormatType) {
                        for (String key : this._varParams.keySet()) {
                            if (key.equals(IO_FILENAME) || key.equals(FORMAT_TYPE) || key.equals("rows") || key.equals("cols") || key.equals(READNNZPARAM) || key.equals(DATATYPEPARAM) || key.equals(VALUETYPEPARAM)) continue;
                            String msg = "Only parameters allowed are: iofilename,rows,cols";
                            this.raiseValidateError("Invalid parameter " + key + " in read statement: " + this.toString() + ". " + msg, conditional, "Invalid Parameters");
                        }
                    }
                }
                String string5 = dataTypeString = this.getVarParam(DATATYPEPARAM) == null ? null : this.getVarParam(DATATYPEPARAM).toString();
                if (dataTypeString == null || dataTypeString.equalsIgnoreCase("matrix") || dataTypeString.equalsIgnoreCase("frame")) {
                    String fmt;
                    boolean bl4;
                    boolean bl5 = false;
                    if (dataTypeString == null || dataTypeString.equalsIgnoreCase("matrix")) {
                        bl4 = true;
                    }
                    this.getOutput().setDataType(bl4 ? Types.DataType.MATRIX : Types.DataType.FRAME);
                    Expression ennz = this.getVarParam(READNNZPARAM);
                    long nnz = -1L;
                    if (ennz != null) {
                        nnz = Long.valueOf(ennz.toString());
                        this.getOutput().setNnz(nnz);
                    }
                    this.getOutput().setDimensions(-1L, -1L);
                    if (!isCSV && ConfigurationManager.getCompilerConfig().getBool(CompilerConfig.ConfigType.REJECT_READ_WRITE_UNKNOWNS) && (this.getVarParam("rows") == null || this.getVarParam("cols") == null)) {
                        this.raiseValidateError("Missing or incomplete dimension information in read statement: " + mtdFileName, conditional, "Invalid Parameters");
                    }
                    if (this.getVarParam("rows") instanceof ConstIdentifier && this.getVarParam("cols") instanceof ConstIdentifier) {
                        Long dim2;
                        Long dim1 = this.getVarParam("rows") == null ? null : Long.valueOf(this.getVarParam("rows").toString());
                        Long l = dim2 = this.getVarParam("cols") == null ? null : Long.valueOf(this.getVarParam("cols").toString());
                        if (!isCSV && (dim1 < 0L || dim2 < 0L) && ConfigurationManager.getCompilerConfig().getBool(CompilerConfig.ConfigType.REJECT_READ_WRITE_UNKNOWNS)) {
                            this.raiseValidateError("Invalid dimension information in read statement", conditional, "Invalid Parameters");
                        }
                        if (dim1 != null && dim2 != null) {
                            this.getOutput().setDimensions(dim1, dim2);
                        } else if (!(isCSV || dim1 == null && dim2 == null)) {
                            this.raiseValidateError("Partial dimension information in read statement", conditional, "Invalid Parameters");
                        }
                    }
                    this.getOutput().setBlocksize(-1);
                    int format = 1;
                    String string6 = fmt = this.getVarParam(FORMAT_TYPE) == null ? null : this.getVarParam(FORMAT_TYPE).toString();
                    if (fmt == null || fmt.equalsIgnoreCase(FORMAT_TYPE_VALUE_TEXT)) {
                        this.getOutput().setFormatType(Expression.FormatType.TEXT);
                        format = 1;
                    } else if (fmt.equalsIgnoreCase(FORMAT_TYPE_VALUE_BINARY)) {
                        this.getOutput().setFormatType(Expression.FormatType.BINARY);
                        format = 2;
                    } else if (fmt.equalsIgnoreCase(FORMAT_TYPE_VALUE_CSV)) {
                        this.getOutput().setFormatType(Expression.FormatType.CSV);
                        format = 1;
                    } else if (fmt.equalsIgnoreCase(FORMAT_TYPE_VALUE_MATRIXMARKET)) {
                        this.getOutput().setFormatType(Expression.FormatType.MM);
                        format = 1;
                    } else if (fmt.equalsIgnoreCase(FORMAT_TYPE_VALUE_LIBSVM)) {
                        this.getOutput().setFormatType(Expression.FormatType.LIBSVM);
                        format = 1;
                    } else {
                        this.raiseValidateError("Invalid format '" + fmt + "' in statement: " + this.toString(), conditional);
                    }
                    if (this.getVarParam(ROWBLOCKCOUNTPARAM) instanceof ConstIdentifier && this.getVarParam(COLUMNBLOCKCOUNTPARAM) instanceof ConstIdentifier) {
                        Integer rowBlockCount = this.getVarParam(ROWBLOCKCOUNTPARAM) == null ? null : Integer.valueOf(this.getVarParam(ROWBLOCKCOUNTPARAM).toString());
                        this.getOutput().setBlocksize(rowBlockCount != null ? rowBlockCount : -1);
                    }
                    if (!(format != 1 && bl4 || this.getOutput().getBlocksize() == -1)) {
                        this.raiseValidateError("Invalid block dimensions (" + this.getOutput().getBlocksize() + ") when format=" + this.getVarParam(FORMAT_TYPE) + " in \"" + this.toString() + "\".", conditional);
                    }
                } else if (dataTypeString.equalsIgnoreCase("scalar")) {
                    this.getOutput().setDataType(Types.DataType.SCALAR);
                    this.getOutput().setNnz(-1L);
                } else {
                    this.raiseValidateError("Unknown Data Type " + dataTypeString + ". Valid  values: " + "scalar" + ", " + "matrix", conditional, "Invalid Parameters");
                }
                if (this.getVarParam(VALUETYPEPARAM) != null && !(this.getVarParam(VALUETYPEPARAM) instanceof StringIdentifier)) {
                    this.raiseValidateError("for read method, parameter value_type can only be a string. Valid values are: double, int, boolean, string", conditional);
                }
                String string7 = string = this.getVarParam(VALUETYPEPARAM) == null ? null : this.getVarParam(VALUETYPEPARAM).toString();
                if (string != null) {
                    if (string.equalsIgnoreCase("double")) {
                        this.getOutput().setValueType(Types.ValueType.FP64);
                        break;
                    }
                    if (string.equalsIgnoreCase("string")) {
                        this.getOutput().setValueType(Types.ValueType.STRING);
                        break;
                    }
                    if (string.equalsIgnoreCase("int")) {
                        this.getOutput().setValueType(Types.ValueType.INT64);
                        break;
                    }
                    if (string.equalsIgnoreCase("boolean")) {
                        this.getOutput().setValueType(Types.ValueType.BOOLEAN);
                        break;
                    }
                    this.raiseValidateError("Unknown Value Type " + string + ". Valid values are: " + "double" + ", " + "int" + ", " + "boolean" + ", " + "string", conditional);
                    break;
                }
                this.getOutput().setValueType(Types.ValueType.FP64);
                break;
            }
            case WRITE: {
                if (this.getVarParam(FORMAT_TYPE) == null || this.getVarParam(FORMAT_TYPE).toString().equalsIgnoreCase(FORMAT_TYPE_VALUE_CSV)) {
                    if (this.getVarParam(DELIM_DELIMITER) == null) {
                        this.addVarParam(DELIM_DELIMITER, new StringIdentifier(DEFAULT_DELIM_DELIMITER, this));
                    }
                    if (this.getVarParam(DELIM_HAS_HEADER_ROW) == null) {
                        this.addVarParam(DELIM_HAS_HEADER_ROW, new BooleanIdentifier(false, this));
                    }
                    if (this.getVarParam(DELIM_SPARSE) == null) {
                        this.addVarParam(DELIM_SPARSE, new BooleanIdentifier(false, this));
                    }
                }
                if ((this.getVarParam(FORMAT_TYPE) == null || this.getVarParam(FORMAT_TYPE).toString().equalsIgnoreCase(FORMAT_TYPE_VALUE_LIBSVM)) && this.getVarParam(DELIM_SPARSE) == null) {
                    this.addVarParam(DELIM_SPARSE, new BooleanIdentifier(false, this));
                }
                if (this.getVarParam(FORMAT_TYPE) == null || this.getVarParam(FORMAT_TYPE).toString().equalsIgnoreCase(FORMAT_TYPE_VALUE_TEXT)) {
                    this.getOutput().setBlocksize(-1);
                    break;
                }
                if (this.getVarParam(FORMAT_TYPE).toString().equalsIgnoreCase(FORMAT_TYPE_VALUE_BINARY)) {
                    this.getOutput().setBlocksize(ConfigurationManager.getBlocksize());
                    break;
                }
                if (this.getVarParam(FORMAT_TYPE).toString().equalsIgnoreCase(FORMAT_TYPE_VALUE_MATRIXMARKET) || this.getVarParam(FORMAT_TYPE).toString().equalsIgnoreCase(FORMAT_TYPE_VALUE_CSV) || this.getVarParam(FORMAT_TYPE).toString().equalsIgnoreCase(FORMAT_TYPE_VALUE_LIBSVM)) {
                    this.getOutput().setBlocksize(-1);
                    break;
                }
                this.raiseValidateError("Invalid format " + this.getVarParam(FORMAT_TYPE) + " in statement: " + this.toString(), conditional);
                break;
            }
            case RAND: {
                Expression minExpr;
                Expression lambda;
                boolean isTensorOperation;
                Expression dataParam = this.getVarParam(RAND_DATA);
                if (dataParam != null) {
                    if (dataParam instanceof DataIdentifier) {
                        this.addVarParam(RAND_MIN, dataParam);
                        this.addVarParam(RAND_MAX, dataParam);
                    } else if (dataParam instanceof IntIdentifier) {
                        this.addVarParam(RAND_MIN, dataParam);
                        this.addVarParam(RAND_MAX, dataParam);
                    } else if (dataParam instanceof DoubleIdentifier) {
                        double roundedValue = ((DoubleIdentifier)dataParam).getValue();
                        DoubleIdentifier minExpr2 = new DoubleIdentifier(roundedValue, (ParseInfo)this);
                        this.addVarParam(RAND_MIN, minExpr2);
                        this.addVarParam(RAND_MAX, minExpr2);
                    } else if (dataParam instanceof StringIdentifier) {
                        String data = ((StringIdentifier)dataParam).getValue();
                        StringIdentifier minExpr3 = new StringIdentifier(data, this);
                        this.addVarParam(RAND_MIN, minExpr3);
                        this.addVarParam(RAND_MAX, minExpr3);
                        this._strInit = true;
                    } else {
                        dataParam.validateExpression(ids, currConstVars, conditional);
                        this.addVarParam(RAND_MIN, dataParam);
                        this.addVarParam(RAND_MAX, dataParam);
                    }
                    this.removeVarParam(RAND_DATA);
                    this.removeVarParam(RAND_BY_ROW);
                    this.setRandDefault();
                }
                this.validateParams(conditional, RAND_VALID_PARAM_NAMES, "Legal parameters for Rand statement are (capitalization-sensitive): rows, cols, dims, min, max, sparsity, seed, pdf, lambda");
                if (this.getVarParam("rows") instanceof StringIdentifier || this.getVarParam("rows") instanceof BooleanIdentifier) {
                    this.raiseValidateError("for Rand statement rows has incorrect value type", conditional);
                }
                if (this.getVarParam("cols") instanceof StringIdentifier || this.getVarParam("cols") instanceof BooleanIdentifier) {
                    this.raiseValidateError("for Rand statement cols has incorrect value type", conditional);
                }
                if (this.getVarParam(RAND_DIMS) instanceof IntIdentifier || this.getVarParam(RAND_DIMS) instanceof DoubleIdentifier || this.getVarParam(RAND_DIMS) instanceof BooleanIdentifier) {
                    this.raiseValidateError("for Rand statement dims has incorrect value type", conditional);
                }
                if (this.getVarParam(RAND_SEED) instanceof StringIdentifier || this.getVarParam(RAND_SEED) instanceof BooleanIdentifier) {
                    this.raiseValidateError("for Rand statement seed has incorrect value type", conditional);
                }
                boolean bl = isTensorOperation = this.getVarParam(RAND_DIMS) != null;
                if (this.getVarParam(RAND_MAX) instanceof StringIdentifier && !this._strInit || this.getVarParam(RAND_MAX) instanceof BooleanIdentifier && !isTensorOperation) {
                    this.raiseValidateError("for Rand statement max has incorrect value type", conditional);
                }
                if (this.getVarParam(RAND_MIN) instanceof StringIdentifier && !this._strInit || this.getVarParam(RAND_MIN) instanceof BooleanIdentifier && !isTensorOperation) {
                    this.raiseValidateError("for Rand statement min has incorrect value type", conditional);
                }
                if (!(this.getVarParam(RAND_PDF) instanceof StringIdentifier)) {
                    this.raiseValidateError("for Rand statement pdf has incorrect value type", conditional);
                }
                if (!((lambda = this.getVarParam(RAND_LAMBDA)) instanceof DataIdentifier) && !(lambda instanceof ConstIdentifier) || lambda.getOutput().getValueType() != Types.ValueType.FP64 && lambda.getOutput().getValueType() != Types.ValueType.INT64) {
                    this.raiseValidateError("for Rand statement lambda has incorrect data type", conditional);
                }
                long rowsLong = -1L;
                long colsLong = -1L;
                Expression rowsExpr = this.getVarParam("rows");
                Expression colsExpr = this.getVarParam("cols");
                if (!isTensorOperation) {
                    long roundedValue;
                    ConstIdentifier constValue;
                    String identifierName;
                    if (rowsExpr instanceof IntIdentifier) {
                        if (((IntIdentifier)rowsExpr).getValue() < 0L) {
                            this.raiseValidateError("In rand statement, can only assign rows a long (integer) value >= 0 -- attempted to assign value: " + ((IntIdentifier)rowsExpr).getValue(), conditional);
                        }
                        rowsLong = ((IntIdentifier)rowsExpr).getValue();
                    } else if (rowsExpr instanceof DoubleIdentifier) {
                        if (((DoubleIdentifier)rowsExpr).getValue() < 0.0) {
                            this.raiseValidateError("In rand statement, can only assign rows a long (integer) value >= 0 -- attempted to assign value: " + rowsExpr.toString(), conditional);
                        }
                        rowsLong = UtilFunctions.toLong(Math.floor(((DoubleIdentifier)rowsExpr).getValue()));
                    } else if (rowsExpr instanceof DataIdentifier && !(rowsExpr instanceof IndexedIdentifier)) {
                        identifierName = ((DataIdentifier)rowsExpr).getName();
                        if (currConstVars.containsKey(identifierName)) {
                            constValue = currConstVars.get(identifierName);
                            if (constValue instanceof IntIdentifier) {
                                if (((IntIdentifier)constValue).getValue() < 0L) {
                                    this.raiseValidateError("In rand statement, can only assign rows a long (integer) value >= 0 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                roundedValue = ((IntIdentifier)constValue).getValue();
                                rowsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("rows", rowsExpr);
                                rowsLong = roundedValue;
                            } else if (constValue instanceof DoubleIdentifier) {
                                if (((DoubleIdentifier)constValue).getValue() < 0.0) {
                                    this.raiseValidateError("In rand statement, can only assign rows a long (double) value >= 0 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                roundedValue = Double.valueOf(Math.floor(((DoubleIdentifier)constValue).getValue())).longValue();
                                rowsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("rows", rowsExpr);
                                rowsLong = roundedValue;
                            } else {
                                this.raiseValidateError("In rand statement, can only assign rows a long (integer) value >= 0 -- attempted to assign value: " + constValue.toString(), conditional);
                            }
                        } else {
                            rowsExpr.validateExpression(ids, currConstVars, conditional);
                        }
                    } else {
                        rowsExpr.validateExpression(ids, currConstVars, conditional);
                    }
                    if (colsExpr instanceof IntIdentifier) {
                        if (((IntIdentifier)colsExpr).getValue() < 0L) {
                            this.raiseValidateError("In rand statement, can only assign cols a long (integer) value >= 0 -- attempted to assign value: " + colsExpr.toString(), conditional);
                        }
                        colsLong = ((IntIdentifier)colsExpr).getValue();
                    } else if (colsExpr instanceof DoubleIdentifier) {
                        if (((DoubleIdentifier)colsExpr).getValue() < 0.0) {
                            this.raiseValidateError("In rand statement, can only assign cols a long (integer) value >= 0 -- attempted to assign value: " + colsExpr.toString(), conditional);
                        }
                        colsLong = Double.valueOf(Math.floor(((DoubleIdentifier)colsExpr).getValue())).longValue();
                    } else if (colsExpr instanceof DataIdentifier && !(colsExpr instanceof IndexedIdentifier)) {
                        identifierName = ((DataIdentifier)colsExpr).getName();
                        if (currConstVars.containsKey(identifierName)) {
                            constValue = currConstVars.get(identifierName);
                            if (constValue instanceof IntIdentifier) {
                                if (((IntIdentifier)constValue).getValue() < 0L) {
                                    this.raiseValidateError("In rand statement, can only assign cols a long (integer) value >= 0 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                roundedValue = ((IntIdentifier)constValue).getValue();
                                colsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("cols", colsExpr);
                                colsLong = roundedValue;
                            } else if (constValue instanceof DoubleIdentifier) {
                                if (((DoubleIdentifier)constValue).getValue() < 0.0) {
                                    this.raiseValidateError("In rand statement, can only assign cols a long (double) value >= 0 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                roundedValue = Double.valueOf(Math.floor(((DoubleIdentifier)constValue).getValue())).longValue();
                                colsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("cols", colsExpr);
                                colsLong = roundedValue;
                            } else {
                                this.raiseValidateError("In rand statement, can only assign cols a long (integer) value >= 0 -- attempted to assign value: " + constValue.toString(), conditional);
                            }
                        } else {
                            colsExpr.validateExpression(ids, currConstVars, conditional);
                        }
                    } else {
                        colsExpr.validateExpression(ids, currConstVars, conditional);
                    }
                }
                if ((minExpr = this.getVarParam(RAND_MIN)) instanceof DataIdentifier && !(minExpr instanceof IndexedIdentifier)) {
                    String identifierName = ((DataIdentifier)minExpr).getName();
                    if (currConstVars.containsKey(identifierName)) {
                        ConstIdentifier constValue = currConstVars.get(identifierName);
                        if (constValue instanceof IntIdentifier) {
                            long roundedValue = ((IntIdentifier)constValue).getValue();
                            minExpr = new DoubleIdentifier(roundedValue, (ParseInfo)this);
                            this.addVarParam(RAND_MIN, minExpr);
                        } else if (constValue instanceof DoubleIdentifier) {
                            double roundedValue = ((DoubleIdentifier)constValue).getValue();
                            minExpr = new DoubleIdentifier(roundedValue, (ParseInfo)this);
                            this.addVarParam(RAND_MIN, minExpr);
                        } else {
                            this.raiseValidateError("In rand statement, can only assign min a numerical value -- attempted to assign: " + constValue.toString(), conditional);
                        }
                    } else {
                        minExpr.validateExpression(ids, currConstVars, conditional);
                    }
                } else {
                    minExpr.validateExpression(ids, currConstVars, conditional);
                }
                Expression maxExpr = this.getVarParam(RAND_MAX);
                if (maxExpr instanceof DataIdentifier && !(maxExpr instanceof IndexedIdentifier)) {
                    String identifierName = ((DataIdentifier)maxExpr).getName();
                    if (currConstVars.containsKey(identifierName)) {
                        ConstIdentifier constValue = currConstVars.get(identifierName);
                        if (constValue instanceof IntIdentifier) {
                            long roundedValue = ((IntIdentifier)constValue).getValue();
                            maxExpr = new DoubleIdentifier(roundedValue, (ParseInfo)this);
                            this.addVarParam(RAND_MAX, maxExpr);
                        } else if (constValue instanceof DoubleIdentifier) {
                            double roundedValue = ((DoubleIdentifier)constValue).getValue();
                            maxExpr = new DoubleIdentifier(roundedValue, (ParseInfo)this);
                            this.addVarParam(RAND_MAX, maxExpr);
                        } else {
                            this.raiseValidateError("In rand statement, can only assign max a numerical value -- attempted to assign: " + constValue.toString(), conditional);
                        }
                    } else {
                        maxExpr.validateExpression(ids, currConstVars, conditional);
                    }
                } else {
                    maxExpr.validateExpression(ids, currConstVars, conditional);
                }
                this.getOutput().setFormatType(Expression.FormatType.BINARY);
                if (isTensorOperation) {
                    this.getOutput().setDataType(Types.DataType.TENSOR);
                    this.getOutput().setValueType(this.getVarParam(RAND_MIN).getOutput().getValueType());
                    this.getOutput().setDimensions(-1L, -1L);
                } else {
                    this.getOutput().setDataType(Types.DataType.MATRIX);
                    this.getOutput().setValueType(Types.ValueType.FP64);
                    this.getOutput().setDimensions(rowsLong, colsLong);
                }
                if (this.getOutput() instanceof IndexedIdentifier) {
                    DataIdentifier targetAsSeen = ids.get(((DataIdentifier)this.getOutput()).getName());
                    if (targetAsSeen == null) {
                        this.raiseValidateError("cannot assign value to indexed identifier " + ((DataIdentifier)this.getOutput()).getName() + " without first initializing " + ((DataIdentifier)this.getOutput()).getName(), conditional);
                    }
                    ((IndexedIdentifier)this.getOutput()).setOriginalDimensions(targetAsSeen.getDim1(), targetAsSeen.getDim2());
                }
                if (!(this.getOutput() instanceof IndexedIdentifier)) break;
                LOG.warn((Object)(this.printWarningLocation() + "Output for Rand Statement may have incorrect size information"));
                break;
            }
            case MATRIX: {
                Expression colsExpr;
                long roundedValue;
                ConstIdentifier constValue;
                String identifierName;
                this.setMatrixDefault();
                this.validateParams(conditional, RESHAPE_VALID_PARAM_NAMES, "Legal parameters for matrix statement are (case-sensitive): data, rows, cols, byrow");
                if (this.getVarParam(RAND_DATA) != null && this.getVarParam(RAND_DATA) instanceof BooleanIdentifier) {
                    this.raiseValidateError("for matrix statement data has incorrect value type", conditional);
                }
                if (this.getVarParam("rows") != null && (this.getVarParam("rows") instanceof StringIdentifier || this.getVarParam("rows") instanceof BooleanIdentifier)) {
                    this.raiseValidateError("for matrix statement rows has incorrect value type", conditional);
                }
                if (this.getVarParam("cols") != null && (this.getVarParam("cols") instanceof StringIdentifier || this.getVarParam("cols") instanceof BooleanIdentifier)) {
                    this.raiseValidateError("for matrix statement cols has incorrect value type", conditional);
                }
                if (!(this.getVarParam(RAND_BY_ROW) instanceof BooleanIdentifier)) {
                    this.raiseValidateError("for matrix statement byrow has incorrect value type", conditional);
                }
                this.getVarParam(RAND_DATA).validateExpression(ids, currConstVars, conditional);
                long rowsLong = -1L;
                long colsLong = -1L;
                Expression rowsExpr = this.getVarParam("rows");
                if (rowsExpr != null) {
                    if (rowsExpr instanceof IntIdentifier) {
                        if (((IntIdentifier)rowsExpr).getValue() >= 1L) {
                            rowsLong = ((IntIdentifier)rowsExpr).getValue();
                        } else {
                            this.raiseValidateError("In matrix statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + ((IntIdentifier)rowsExpr).getValue(), conditional);
                        }
                    } else if (rowsExpr instanceof DoubleIdentifier) {
                        if (((DoubleIdentifier)rowsExpr).getValue() >= 1.0) {
                            rowsLong = Double.valueOf(Math.floor(((DoubleIdentifier)rowsExpr).getValue())).longValue();
                        } else {
                            this.raiseValidateError("In matrix statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + rowsExpr.toString(), conditional);
                        }
                    } else if (rowsExpr instanceof DataIdentifier && !(rowsExpr instanceof IndexedIdentifier)) {
                        identifierName = ((DataIdentifier)rowsExpr).getName();
                        if (currConstVars.containsKey(identifierName)) {
                            constValue = currConstVars.get(identifierName);
                            if (constValue instanceof IntIdentifier) {
                                if (((IntIdentifier)constValue).getValue() < 1L) {
                                    this.raiseValidateError("In matrix statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                roundedValue = ((IntIdentifier)constValue).getValue();
                                rowsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("rows", rowsExpr);
                                rowsLong = roundedValue;
                            } else if (constValue instanceof DoubleIdentifier) {
                                if (((DoubleIdentifier)constValue).getValue() < 1.0) {
                                    this.raiseValidateError("In matrix statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                roundedValue = Double.valueOf(Math.floor(((DoubleIdentifier)constValue).getValue())).longValue();
                                rowsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("rows", rowsExpr);
                                rowsLong = roundedValue;
                            } else {
                                this.raiseValidateError("In matrix statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                            }
                        } else {
                            rowsExpr.validateExpression(ids, currConstVars, conditional);
                        }
                    } else {
                        rowsExpr.validateExpression(ids, currConstVars, conditional);
                    }
                }
                if ((colsExpr = this.getVarParam("cols")) != null) {
                    if (colsExpr instanceof IntIdentifier) {
                        if (((IntIdentifier)colsExpr).getValue() >= 1L) {
                            colsLong = ((IntIdentifier)colsExpr).getValue();
                        } else {
                            this.raiseValidateError("In matrix statement, can only assign cols a long (integer) value >= 1 -- attempted to assign value: " + colsExpr.toString(), conditional);
                        }
                    } else if (colsExpr instanceof DoubleIdentifier) {
                        if (((DoubleIdentifier)colsExpr).getValue() >= 1.0) {
                            colsLong = Double.valueOf(Math.floor(((DoubleIdentifier)colsExpr).getValue())).longValue();
                        } else {
                            this.raiseValidateError("In matrix statement, can only assign rows a long (integer) value >= 1 -- attempted to assign value: " + colsExpr.toString(), conditional);
                        }
                    } else if (colsExpr instanceof DataIdentifier && !(colsExpr instanceof IndexedIdentifier)) {
                        identifierName = ((DataIdentifier)colsExpr).getName();
                        if (currConstVars.containsKey(identifierName)) {
                            constValue = currConstVars.get(identifierName);
                            if (constValue instanceof IntIdentifier) {
                                if (((IntIdentifier)constValue).getValue() < 1L) {
                                    this.raiseValidateError("In matrix statement, can only assign cols a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                roundedValue = ((IntIdentifier)constValue).getValue();
                                colsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("cols", colsExpr);
                                colsLong = roundedValue;
                            } else if (constValue instanceof DoubleIdentifier) {
                                if (((DoubleIdentifier)constValue).getValue() < 1.0) {
                                    this.raiseValidateError("In matrix statement, can only assign cols a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                                }
                                roundedValue = Double.valueOf(Math.floor(((DoubleIdentifier)constValue).getValue())).longValue();
                                colsExpr = new IntIdentifier(roundedValue, (ParseInfo)this);
                                this.addVarParam("cols", colsExpr);
                                colsLong = roundedValue;
                            } else {
                                this.raiseValidateError("In matrix statement, can only assign cols a long (integer) value >= 1 -- attempted to assign value: " + constValue.toString(), conditional);
                            }
                        } else {
                            colsExpr.validateExpression(ids, currConstVars, conditional);
                        }
                    } else {
                        colsExpr.validateExpression(ids, currConstVars, conditional);
                    }
                }
                this.getOutput().setFormatType(Expression.FormatType.BINARY);
                this.getOutput().setDataType(Types.DataType.MATRIX);
                this.getOutput().setValueType(Types.ValueType.FP64);
                this.getOutput().setDimensions(rowsLong, colsLong);
                if (this.getOutput() instanceof IndexedIdentifier) {
                    ((IndexedIdentifier)this.getOutput()).setOriginalDimensions(this.getOutput().getDim1(), this.getOutput().getDim2());
                }
                if (!(this.getOutput() instanceof IndexedIdentifier)) break;
                LOG.warn((Object)(this.printWarningLocation() + "Output for matrix Statement may have incorrect size information"));
                break;
            }
            case TENSOR: {
                this.setTensorDefault();
                this.validateParams(conditional, RESHAPE_VALID_PARAM_NAMES, "Legal parameters for tensor statement are (case-sensitive): data, dims, byrow");
                if (this.getVarParam(RAND_DIMS) != null && this.getVarParam(RAND_DIMS) instanceof BooleanIdentifier) {
                    this.raiseValidateError("for tensor statement dims has incorrect value type", conditional);
                }
                if (!(this.getVarParam(RAND_BY_ROW) instanceof BooleanIdentifier)) {
                    this.raiseValidateError("for tensor statement byrow has incorrect value type", conditional);
                }
                this.getVarParam(RAND_DATA).validateExpression(ids, currConstVars, conditional);
                this.getVarParam(RAND_DIMS).validateExpression(ids, currConstVars, conditional);
                this.getOutput().setFormatType(Expression.FormatType.BINARY);
                this.getOutput().setDataType(Types.DataType.TENSOR);
                this.getOutput().setValueType(this.getVarParam(RAND_DATA).getOutput().getValueType());
                this.getOutput().setDimensions(-1L, -1L);
                if (this.getOutput() instanceof IndexedIdentifier) {
                    ((IndexedIdentifier)this.getOutput()).setOriginalDimensions(this.getOutput().getDim1(), this.getOutput().getDim2());
                }
                if (!(this.getOutput() instanceof IndexedIdentifier)) break;
                LOG.warn((Object)(this.printWarningLocation() + "Output for tensor Statement may have incorrect size information"));
                break;
            }
            case SQL: {
                this.setSqlDefault();
                this.validateParams(conditional, SQL_VALID_PARAM_NAMES, "Legal parameters for tensor statement are (case-sensitive): conn, user, password, query");
                Expression exp = this.getVarParam(SQL_CONN);
                if (!(exp instanceof StringIdentifier) && exp instanceof Identifier) {
                    this.raiseValidateError("for tensor statement conn has incorrect value type", conditional);
                }
                if (!((exp = this.getVarParam(SQL_USER)) instanceof StringIdentifier) && exp instanceof Identifier) {
                    this.raiseValidateError("for tensor statement user has incorrect value type", conditional);
                }
                if (!((exp = this.getVarParam(SQL_PASS)) instanceof StringIdentifier) && exp instanceof Identifier) {
                    this.raiseValidateError("for tensor statement password has incorrect value type", conditional);
                }
                if (!((exp = this.getVarParam(SQL_QUERY)) instanceof StringIdentifier) && exp instanceof Identifier) {
                    this.raiseValidateError("for tensor statement query has incorrect value type", conditional);
                }
                this.getVarParam(SQL_CONN).validateExpression(ids, currConstVars, conditional);
                this.getVarParam(SQL_USER).validateExpression(ids, currConstVars, conditional);
                this.getVarParam(SQL_PASS).validateExpression(ids, currConstVars, conditional);
                this.getVarParam(SQL_QUERY).validateExpression(ids, currConstVars, conditional);
                this.getOutput().setFormatType(Expression.FormatType.BINARY);
                this.getOutput().setDataType(Types.DataType.TENSOR);
                this.getOutput().setValueType(Types.ValueType.UNKNOWN);
                this.getOutput().setDimensions(-1L, -1L);
                if (!(this.getOutput() instanceof IndexedIdentifier)) break;
                LOG.warn((Object)(this.printWarningLocation() + "Output for sql statement may have incorrect size information"));
                break;
            }
            case FEDERATED: {
                this.validateParams(conditional, FEDERATED_VALID_PARAM_NAMES, "Legal parameters for federated statement are (case-sensitive): addresses, ranges");
                Expression exp = this.getVarParam(FED_ADDRESSES);
                if (!(exp instanceof DataIdentifier)) {
                    this.raiseValidateError("for federated statement addresses has incorrect value type", conditional);
                }
                this.getVarParam(FED_ADDRESSES).validateExpression(ids, currConstVars, conditional);
                exp = this.getVarParam(FED_RANGES);
                if (!(exp instanceof DataIdentifier)) {
                    this.raiseValidateError("for federated statement ranges has incorrect value type", conditional);
                }
                this.getVarParam(FED_RANGES).validateExpression(ids, currConstVars, conditional);
                this.getOutput().setFormatType(Expression.FormatType.BINARY);
                this.getOutput().setDataType(Types.DataType.MATRIX);
                this.getOutput().setValueType(Types.ValueType.FP64);
                this.getOutput().setDimensions(-1L, -1L);
                break;
            }
            default: {
                this.raiseValidateError("Unsupported Data expression " + (Object)((Object)this.getOpCode()), false, "Invalid Parameters");
            }
        }
    }

    private void validateParams(boolean conditional, String[] validParamNames, String legalMessage) {
        for (String key : this._varParams.keySet()) {
            boolean found = false;
            for (String name : validParamNames) {
                found |= name.equals(key);
            }
            if (found) continue;
            this.raiseValidateError("unexpected parameter \"" + key + "\". " + legalMessage, conditional);
        }
    }

    private void performConstantPropagationRand(HashMap<String, ConstIdentifier> currConstVars) {
        String[] paramNamesForEval = new String[]{RAND_DATA, RAND_SPARSITY, RAND_MIN, RAND_MAX};
        this.performConstantPropagation(currConstVars, paramNamesForEval);
    }

    private void performConstantPropagationReadWrite(HashMap<String, ConstIdentifier> currConstVars) {
        String[] paramNamesForEval = new String[]{FORMAT_TYPE, IO_FILENAME, "rows", "cols", READNNZPARAM};
        this.performConstantPropagation(currConstVars, paramNamesForEval);
    }

    private void performConstantPropagation(HashMap<String, ConstIdentifier> currConstVars, String[] paramNames) {
        for (String paramName : paramNames) {
            Expression paramExp = this.getVarParam(paramName);
            if (paramExp == null || !(paramExp instanceof DataIdentifier) || paramExp instanceof IndexedIdentifier || !currConstVars.containsKey(((DataIdentifier)paramExp).getName())) continue;
            this.addVarParam(paramName, currConstVars.get(((DataIdentifier)paramExp).getName()));
        }
    }

    private String fileNameCat(BinaryExpression expr, HashMap<String, ConstIdentifier> currConstVars, String filename, boolean conditional) {
        String name;
        if (expr.getLeft() instanceof BinaryExpression && ((BinaryExpression)expr.getLeft()).getOpCode() == Expression.BinaryOp.PLUS) {
            filename = this.fileNameCat((BinaryExpression)expr.getLeft(), currConstVars, filename, conditional) + filename;
        } else if (expr.getLeft() instanceof ConstIdentifier) {
            filename = ((ConstIdentifier)expr.getLeft()).toString() + filename;
        } else if (expr.getLeft() instanceof DataIdentifier && ((DataIdentifier)expr.getLeft()).getDataType() == Types.DataType.SCALAR) {
            name = ((DataIdentifier)expr.getLeft()).getName();
            filename = ((StringIdentifier)currConstVars.get(name)).getValue() + filename;
        } else {
            this.raiseValidateError("Parameter iofilename only supports a const string or const string concatenations.", conditional);
        }
        if (expr.getRight() instanceof BinaryExpression && ((BinaryExpression)expr.getRight()).getOpCode() == Expression.BinaryOp.PLUS) {
            filename = filename + this.fileNameCat((BinaryExpression)expr.getRight(), currConstVars, filename, conditional);
        } else if (expr.getRight() instanceof ConstIdentifier) {
            filename = filename + ((ConstIdentifier)expr.getRight()).toString();
        } else if (expr.getRight() instanceof DataIdentifier && ((DataIdentifier)expr.getRight()).getDataType() == Types.DataType.SCALAR && ((DataIdentifier)expr.getRight()).getValueType() == Types.ValueType.STRING) {
            name = ((DataIdentifier)expr.getRight()).getName();
            filename = filename + ((StringIdentifier)currConstVars.get(name)).getValue();
        } else {
            this.raiseValidateError("Parameter iofilename only supports a const string or const string concatenations.", conditional);
        }
        return filename;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._opcode.toString());
        sb.append("(");
        boolean first = true;
        for (Map.Entry<String, Expression> e : this._varParams.entrySet()) {
            String key = e.getKey();
            Expression expr = e.getValue();
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(key);
            sb.append("=");
            if (expr instanceof StringIdentifier) {
                sb.append("\"");
                sb.append(expr);
                sb.append("\"");
                continue;
            }
            sb.append(expr);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet result = new VariableSet();
        for (Expression expr : this._varParams.values()) {
            result.addVariables(expr.variablesRead());
        }
        return result;
    }

    @Override
    public VariableSet variablesUpdated() {
        VariableSet result = new VariableSet();
        for (Expression expr : this._varParams.values()) {
            result.addVariables(expr.variablesUpdated());
        }
        result.addVariable(((DataIdentifier)this.getOutput()).getName(), (DataIdentifier)this.getOutput());
        return result;
    }

    private void parseMetaDataFileParameters(String mtdFileName, JSONObject configObject, boolean conditional) {
        Iterator iterator = configObject.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry obj;
            Map.Entry e = obj = iterator.next();
            Object key = e.getKey();
            Object val = e.getValue();
            boolean isValidName = false;
            for (String paramName : READ_VALID_MTD_PARAM_NAMES) {
                if (!paramName.equals(key)) continue;
                isValidName = true;
            }
            if (!isValidName) {
                this.raiseValidateError("MTD file " + mtdFileName + " contains invalid parameter name: " + key, false);
            }
            if (this.getVarParam(key.toString()) != null && this.getVarParam(key.toString()) instanceof ConstIdentifier && !this.getVarParam(key.toString()).toString().equalsIgnoreCase(val.toString())) {
                this.raiseValidateError("Parameter '" + key.toString() + "' has conflicting values in metadata and read statement. MTD file value: '" + val.toString() + "'. Read statement value: '" + this.getVarParam(key.toString()) + "'.", conditional);
                continue;
            }
            if (this.getVarParam(key.toString()) != null || key.toString().equalsIgnoreCase(DESCRIPTIONPARAM) || key.toString().equalsIgnoreCase(AUTHORPARAM) || key.toString().equalsIgnoreCase(CREATEDPARAM)) continue;
            StringIdentifier strId = new StringIdentifier(val.toString(), this);
            if (key.toString().equalsIgnoreCase(DELIM_HAS_HEADER_ROW) || key.toString().equalsIgnoreCase(DELIM_FILL) || key.toString().equalsIgnoreCase(DELIM_SPARSE)) {
                BooleanIdentifier boolId = null;
                if (strId.toString().equalsIgnoreCase("true")) {
                    boolId = new BooleanIdentifier(true, this);
                } else if (strId.toString().equalsIgnoreCase("false")) {
                    boolId = new BooleanIdentifier(false, this);
                } else {
                    this.raiseValidateError("Invalid value provided for 'header' in metadata file '" + mtdFileName + "'. Must be either TRUE or FALSE.", conditional);
                }
                this.removeVarParam(key.toString());
                this.addVarParam(key.toString(), boolId);
                continue;
            }
            if (key.toString().equalsIgnoreCase(DELIM_FILL_VALUE)) {
                DoubleIdentifier doubleId = new DoubleIdentifier(Double.parseDouble(strId.toString()), (ParseInfo)this);
                this.removeVarParam(key.toString());
                this.addVarParam(key.toString(), doubleId);
                continue;
            }
            if (key.toString().equalsIgnoreCase(DELIM_NA_STRINGS)) {
                String naStrings = null;
                if (val instanceof String) {
                    naStrings = val.toString();
                } else {
                    StringBuilder sb = new StringBuilder();
                    JSONArray valarr = (JSONArray)val;
                    for (int naid = 0; naid < valarr.size(); ++naid) {
                        sb.append((String)valarr.get(naid));
                        if (naid >= valarr.size() - 1) continue;
                        sb.append(DELIM_NA_STRING_SEP);
                    }
                    naStrings = sb.toString();
                }
                StringIdentifier sid = new StringIdentifier(naStrings, this);
                this.removeVarParam(key.toString());
                this.addVarParam(key.toString(), sid);
                continue;
            }
            this.addVarParam(key.toString(), strId);
        }
    }

    public JSONObject readMetadataFile(String filename, boolean conditional) {
        JSONObject retVal = null;
        boolean exists = HDFSTool.existsFileOnHDFS(filename);
        boolean isDir = HDFSTool.isDirectory(filename);
        if (exists && isDir) {
            retVal = new JSONObject();
            for (FileStatus stat : HDFSTool.getDirectoryListing(filename)) {
                Path childPath = stat.getPath();
                if (!childPath.getName().startsWith("part")) continue;
                try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)IOUtilFunctions.getFileSystem(childPath).open(childPath)));){
                    JSONObject childObj = JSONHelper.parse(br);
                    Iterator iterator = childObj.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry obj;
                        Map.Entry e = obj = iterator.next();
                        Object key = e.getKey();
                        Object val = e.getValue();
                        retVal.put(key, val);
                    }
                }
                catch (Exception e) {
                    this.raiseValidateError("for MTD file in directory, error parting part of MTD file with path " + childPath.toString() + ": " + e.getMessage(), conditional);
                }
            }
        } else if (exists) {
            Path path = new Path(filename);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)IOUtilFunctions.getFileSystem(path).open(path)));){
                retVal = new JSONObject(br);
            }
            catch (Exception e) {
                this.raiseValidateError("error parsing MTD file with path " + filename + ": " + e.getMessage(), conditional);
            }
        }
        return retVal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkHasMatrixMarketFormat(String inputFileName, String mtdFileName, boolean conditional) {
        JSONObject mtdObject = this.readMetadataFile(mtdFileName, conditional);
        if (mtdObject != null) {
            return false;
        }
        if (!HDFSTool.existsFileOnHDFS(inputFileName)) return false;
        if (HDFSTool.isDirectory(inputFileName)) return false;
        Path path = new Path(inputFileName);
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)IOUtilFunctions.getFileSystem(path).open(path)));){
            String headerLine = new String("");
            if (in.ready()) {
                headerLine = in.readLine();
            }
            boolean bl = headerLine != null && headerLine.startsWith("%%");
            return bl;
        }
        catch (Exception ex) {
            throw new LanguageException("Failed to read matrix market header.", ex);
        }
    }

    public String checkHasDelimitedFormat(String filename, boolean conditional) {
        JSONObject mtdObject = this.readMetadataFile(filename + ".mtd", conditional);
        if (mtdObject != null) {
            String formatTypeString = (String)JSONHelper.get(mtdObject, FORMAT_TYPE);
            if (formatTypeString != null && (formatTypeString.equalsIgnoreCase(FORMAT_TYPE_VALUE_CSV) || formatTypeString.equalsIgnoreCase(FORMAT_TYPE_VALUE_LIBSVM))) {
                return formatTypeString;
            }
            return null;
        }
        return null;
    }

    public boolean isCSVReadWithUnknownSize() {
        Expression format = this.getVarParam(FORMAT_TYPE);
        if (this._opcode == Expression.DataOp.READ && format != null && format.toString().equalsIgnoreCase(FORMAT_TYPE_VALUE_CSV)) {
            Expression rows = this.getVarParam("rows");
            Expression cols = this.getVarParam("cols");
            return rows == null || Long.parseLong(rows.toString()) < 0L || cols == null || Long.parseLong(cols.toString()) < 0L;
        }
        return false;
    }

    public boolean isRead() {
        return this._opcode == Expression.DataOp.READ;
    }
}

