/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.parser;

import java.util.ArrayList;
import org.antlr.v4.runtime.ParserRuleContext;
import org.tugraz.sysds.common.Builtins;
import org.tugraz.sysds.parser.DataIdentifier;
import org.tugraz.sysds.parser.Expression;
import org.tugraz.sysds.parser.FunctionCallIdentifier;
import org.tugraz.sysds.parser.IndexedIdentifier;
import org.tugraz.sysds.parser.ParseInfo;
import org.tugraz.sysds.parser.Statement;
import org.tugraz.sysds.parser.StringIdentifier;
import org.tugraz.sysds.parser.VariableSet;

public class AssignmentStatement
extends Statement {
    private ArrayList<DataIdentifier> _targetList = new ArrayList();
    private Expression _source;
    private boolean _isAccum;

    @Override
    public Statement rewriteStatement(String prefix) {
        DataIdentifier newTarget = (DataIdentifier)this._targetList.get(0).rewriteExpression(prefix);
        Expression newSource = this._source.rewriteExpression(prefix);
        AssignmentStatement retVal = new AssignmentStatement(newTarget, newSource, this);
        return retVal;
    }

    public AssignmentStatement(DataIdentifier di, Expression exp) {
        this._targetList.add(di);
        this._source = exp;
    }

    public AssignmentStatement(DataIdentifier di, Expression exp, ParseInfo parseInfo) {
        this(di, exp);
        this.setParseInfo(parseInfo);
    }

    public AssignmentStatement(ParserRuleContext ctx, DataIdentifier di, Expression exp) {
        this(di, exp);
        this.setCtxValues(ctx);
    }

    public AssignmentStatement(ParserRuleContext ctx, DataIdentifier di, Expression exp, String filename) {
        this(ctx, di, exp);
        this.setFilename(filename);
    }

    public DataIdentifier getTarget() {
        return this._targetList.get(0);
    }

    public ArrayList<DataIdentifier> getTargetList() {
        return this._targetList;
    }

    public void setTarget(DataIdentifier di) {
        this._targetList.set(0, di);
    }

    public Expression getSource() {
        return this._source;
    }

    public void setSource(Expression s) {
        this._source = s;
    }

    public boolean isAccumulator() {
        return this._isAccum;
    }

    public void setAccumulator(boolean flag) {
        this._isAccum = flag;
    }

    @Override
    public boolean controlStatement() {
        if (this._source instanceof FunctionCallIdentifier) {
            return true;
        }
        return this._source.toString().contains(Builtins.TIME.toString());
    }

    @Override
    public void initializeforwardLV(VariableSet activeIn) {
    }

    @Override
    public VariableSet initializebackwardLV(VariableSet lo) {
        return lo;
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet result = new VariableSet();
        result.addVariables(this._source.variablesRead());
        for (DataIdentifier target : this._targetList) {
            if (!(target instanceof IndexedIdentifier) && !this._isAccum) continue;
            result.addVariables(target.variablesRead());
        }
        return result;
    }

    @Override
    public VariableSet variablesUpdated() {
        VariableSet result = new VariableSet();
        for (DataIdentifier target : this._targetList) {
            if (target == null) continue;
            result.addVariable(target.getName(), target);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this._targetList.size(); ++i) {
            sb.append(this._targetList.get(i));
        }
        sb.append(this._isAccum ? " += " : " = ");
        if (this._source instanceof StringIdentifier) {
            sb.append("\"");
            sb.append(this._source.toString());
            sb.append("\"");
        } else {
            sb.append(this._source.toString());
        }
        sb.append(";");
        return sb.toString();
    }
}

