/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.lops;

import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.lops.Lop;
import org.tugraz.sysds.lops.LopProperties;
import org.tugraz.sysds.lops.Unary;

public class WeightedUnaryMM
extends Lop {
    public static final String OPCODE = "mapwumm";
    public static final String OPCODE_CP = "wumm";
    private WUMMType _wummType = null;
    private Unary.OperationTypes _uop = null;
    private int _numThreads = 1;

    public WeightedUnaryMM(Lop input1, Lop input2, Lop input3, Types.DataType dt, Types.ValueType vt, WUMMType wt, Unary.OperationTypes op, LopProperties.ExecType et) {
        super(Lop.Type.WeightedUMM, dt, vt);
        this.addInput(input1);
        this.addInput(input2);
        this.addInput(input3);
        input1.addOutput(this);
        input2.addOutput(this);
        input3.addOutput(this);
        this._wummType = wt;
        this._uop = op;
        this.setupLopProperties(et);
    }

    @Override
    public String toString() {
        return "Operation = WeightedUMM";
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        if (this.getExecType() == LopProperties.ExecType.CP) {
            sb.append(OPCODE_CP);
        } else {
            sb.append(OPCODE);
        }
        sb.append("\u00b0");
        sb.append(Unary.getOpcode(this._uop));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(2).prepInputOperand(input3));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        sb.append((Object)this._wummType);
        if (this.getExecType() == LopProperties.ExecType.CP) {
            sb.append("\u00b0");
            sb.append(this._numThreads);
        }
        return sb.toString();
    }

    public void setNumThreads(int k) {
        this._numThreads = k;
    }

    public static enum WUMMType {
        MULT,
        DIV;

    }
}

