/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.lops;

import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.lops.Lop;
import org.tugraz.sysds.lops.LopProperties;
import org.tugraz.sysds.lops.LopsException;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;

public class UnaryCP
extends Lop {
    public static final String CAST_AS_SCALAR_OPCODE = "castdts";
    public static final String CAST_AS_MATRIX_OPCODE = "castdtm";
    public static final String CAST_AS_FRAME_OPCODE = "castdtf";
    public static final String CAST_AS_DOUBLE_OPCODE = "castvtd";
    public static final String CAST_AS_INT_OPCODE = "castvti";
    public static final String CAST_AS_BOOLEAN_OPCODE = "castvtb";
    OperationTypes operation;

    public UnaryCP(Lop input, OperationTypes op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.UnaryCP, dt, vt);
        this.operation = op;
        this.addInput(input);
        input.addOutput(this);
        this.lps.setProperties(this.inputs, et);
    }

    public UnaryCP(Lop input, OperationTypes op, Types.DataType dt, Types.ValueType vt) {
        this(input, op, dt, vt, LopProperties.ExecType.CP);
    }

    @Override
    public String toString() {
        return "Operation: " + (Object)((Object)this.operation);
    }

    private String getOpCode() {
        return UnaryCP.getOpCode(this.operation);
    }

    public static String getOpCode(OperationTypes op) {
        switch (op) {
            case NOT: {
                return "!";
            }
            case ABS: {
                return "abs";
            }
            case SIN: {
                return "sin";
            }
            case COS: {
                return "cos";
            }
            case TAN: {
                return "tan";
            }
            case ASIN: {
                return "asin";
            }
            case ACOS: {
                return "acos";
            }
            case ATAN: {
                return "atan";
            }
            case SINH: {
                return "sinh";
            }
            case COSH: {
                return "cosh";
            }
            case TANH: {
                return "tanh";
            }
            case SQRT: {
                return "sqrt";
            }
            case LOG: {
                return "log";
            }
            case ROUND: {
                return "round";
            }
            case EXP: {
                return "exp";
            }
            case PRINT: {
                return "print";
            }
            case ASSERT: {
                return "assert";
            }
            case CAST_AS_MATRIX: {
                return CAST_AS_MATRIX_OPCODE;
            }
            case CAST_AS_FRAME: {
                return CAST_AS_FRAME_OPCODE;
            }
            case STOP: {
                return "stop";
            }
            case CEIL: {
                return "ceil";
            }
            case FLOOR: {
                return "floor";
            }
            case CUMSUM: {
                return "ucumk+";
            }
            case CAST_AS_SCALAR: {
                return CAST_AS_SCALAR_OPCODE;
            }
            case CAST_AS_DOUBLE: {
                return CAST_AS_DOUBLE_OPCODE;
            }
            case CAST_AS_INT: {
                return CAST_AS_INT_OPCODE;
            }
            case CAST_AS_BOOLEAN: {
                return CAST_AS_BOOLEAN_OPCODE;
            }
            case NROW: {
                return "nrow";
            }
            case NCOL: {
                return "ncol";
            }
            case LENGTH: {
                return "length";
            }
            case EXISTS: {
                return "exists";
            }
            case LINEAGE: {
                return "lineage";
            }
            case SOFTMAX: {
                return "softmax";
            }
        }
        throw new LopsException("Unknown operation: " + (Object)((Object)op));
    }

    @Override
    public String getInstructions(String input, String output) {
        return InstructionUtils.concatOperands(this.getExecType().name(), this.getOpCode(), this.getInputs().get(0).prepScalarInputOperand(this.getExecType()), this.prepOutputOperand(output));
    }

    public static enum OperationTypes {
        NOT,
        ABS,
        SIN,
        COS,
        TAN,
        ASIN,
        ACOS,
        ATAN,
        SQRT,
        LOG,
        EXP,
        SINH,
        COSH,
        TANH,
        CAST_AS_SCALAR,
        CAST_AS_MATRIX,
        CAST_AS_FRAME,
        CAST_AS_DOUBLE,
        CAST_AS_INT,
        CAST_AS_BOOLEAN,
        PRINT,
        ASSERT,
        NROW,
        NCOL,
        LENGTH,
        EXISTS,
        LINEAGE,
        ROUND,
        STOP,
        CEIL,
        FLOOR,
        CUMSUM,
        SOFTMAX,
        TYPEOF,
        DETECTSCHEMA;

    }
}

