/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.lops;

import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.lops.Lop;
import org.tugraz.sysds.lops.LopProperties;

public class Transform
extends Lop {
    private Types.ReOrgOp _operation = null;
    private boolean _bSortIndInMem = false;
    private boolean _outputEmptyBlock = true;
    private int _numThreads = 1;

    public Transform(Lop input, Types.ReOrgOp op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        this(input, op, dt, vt, et, 1);
    }

    public Transform(Lop[] inputs, Types.ReOrgOp op, Types.DataType dt, Types.ValueType vt, boolean outputEmptyBlock, LopProperties.ExecType et) {
        this(inputs, op, dt, vt, et, 1);
        this._outputEmptyBlock = outputEmptyBlock;
    }

    public Transform(Lop input, Types.ReOrgOp op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et, int k) {
        super(Lop.Type.Transform, dt, vt);
        this.init(new Lop[]{input}, op, dt, vt, et);
        this._numThreads = k;
    }

    public Transform(Lop[] inputs, Types.ReOrgOp op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et, int k) {
        super(Lop.Type.Transform, dt, vt);
        this.init(inputs, op, dt, vt, et);
        this._numThreads = k;
    }

    public Transform(Lop input, Types.ReOrgOp op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et, boolean bSortIndInMem) {
        super(Lop.Type.Transform, dt, vt);
        this._bSortIndInMem = bSortIndInMem;
        this.init(new Lop[]{input}, op, dt, vt, et);
    }

    public Transform(Lop[] inputs, Types.ReOrgOp op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et, boolean bSortIndInMem) {
        super(Lop.Type.Transform, dt, vt);
        this._bSortIndInMem = bSortIndInMem;
        this.init(inputs, op, dt, vt, et);
    }

    public Transform(Lop[] inputs, Types.ReOrgOp op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et, boolean bSortIndInMem, int k) {
        super(Lop.Type.Transform, dt, vt);
        this._bSortIndInMem = bSortIndInMem;
        this._numThreads = k;
        this.init(inputs, op, dt, vt, et);
    }

    private void init(Lop[] input, Types.ReOrgOp op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        this._operation = op;
        for (Lop in : input) {
            this.addInput(in);
            in.addOutput(this);
        }
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return " Operation: " + (Object)((Object)this._operation);
    }

    public Types.ReOrgOp getOp() {
        return this._operation;
    }

    private String getOpcode() {
        switch (this._operation) {
            case TRANS: {
                return "r'";
            }
            case REV: {
                return "rev";
            }
            case DIAG: {
                return "rdiag";
            }
            case RESHAPE: {
                return "rshape";
            }
            case SORT: {
                return "rsort";
            }
        }
        throw new UnsupportedOperationException(this.printErrorLocation() + "Instruction is not defined for Transform operation " + (Object)((Object)this._operation));
    }

    @Override
    public String getInstructions(String input1, String output) {
        return this.getInstructions(input1, 1, output);
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String input4, String output) {
        return this.getInstructions(input1, 4, output);
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String input4, String input5, String output) {
        return this.getInstructions(input1, 5, output);
    }

    private String getInstructions(String input1, int numInputs, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        for (int i = 1; i < numInputs; ++i) {
            Lop ltmp = this.getInputs().get(i);
            sb.append("\u00b0");
            sb.append(ltmp.prepScalarInputOperand(this.getExecType()));
        }
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        if (this.getExecType() == LopProperties.ExecType.CP && (this._operation == Types.ReOrgOp.TRANS || this._operation == Types.ReOrgOp.SORT)) {
            sb.append("\u00b0");
            sb.append(this._numThreads);
        }
        if (this.getExecType() == LopProperties.ExecType.SPARK && this._operation == Types.ReOrgOp.RESHAPE) {
            sb.append("\u00b0");
            sb.append(this._outputEmptyBlock);
        }
        if (this.getExecType() == LopProperties.ExecType.SPARK && this._operation == Types.ReOrgOp.SORT) {
            sb.append("\u00b0");
            sb.append(this._bSortIndInMem);
        }
        return sb.toString();
    }
}

