/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.lops;

import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.lops.Lop;
import org.tugraz.sysds.lops.LopProperties;

public class Ternary
extends Lop {
    private final Types.OpOp3 _op;

    public Ternary(Types.OpOp3 op, Lop input1, Lop input2, Lop input3, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.Ternary, dt, vt);
        this._op = op;
        this.init(input1, input2, input3, et);
    }

    private void init(Lop input1, Lop input2, Lop input3, LopProperties.ExecType et) {
        this.addInput(input1);
        this.addInput(input2);
        this.addInput(input3);
        input1.addOutput(this);
        input2.addOutput(this);
        input3.addOutput(this);
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return "Operation = t(" + this._op.toString() + ")";
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this._op.toString());
        String[] inputs = new String[]{input1, input2, input3};
        for (int i = 0; i < 3; ++i) {
            sb.append("\u00b0");
            sb.append(this.getInputs().get(i).prepInputOperand(inputs[i]));
        }
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }
}

