/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.lops;

import java.util.HashSet;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.lops.Lop;
import org.tugraz.sysds.lops.LopProperties;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;

public class SortKeys
extends Lop {
    public static final String OPCODE = "qsort";
    private OperationTypes operation;

    public OperationTypes getOpType() {
        return this.operation;
    }

    public SortKeys(Lop input, OperationTypes op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.SortKeys, dt, vt);
        this.init(input, null, op, et);
    }

    public SortKeys(Lop input, boolean desc, OperationTypes op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.SortKeys, dt, vt);
        this.init(input, null, op, et);
    }

    public SortKeys(Lop input1, Lop input2, OperationTypes op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.SortKeys, dt, vt);
        this.init(input1, input2, op, et);
    }

    private void init(Lop input1, Lop input2, OperationTypes op, LopProperties.ExecType et) {
        this.addInput(input1);
        input1.addOutput(this);
        this.operation = op;
        if (input2 != null) {
            this.addInput(input2);
            input2.addOutput(this);
        }
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return "Operation: SortKeys (" + (Object)((Object)this.operation) + ")";
    }

    @Override
    public String getInstructions(String input, String output) {
        return InstructionUtils.concatOperands(this.getExecType().name(), OPCODE, this.getInputs().get(0).prepInputOperand(input), this.prepOutputOperand(output));
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        return InstructionUtils.concatOperands(this.getExecType().name(), OPCODE, this.getInputs().get(0).prepInputOperand(input1), this.getInputs().get(1).prepInputOperand(input2), this.prepOutputOperand(output));
    }

    public static SortKeys constructSortByValueLop(Lop input1, OperationTypes op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        for (Lop lop : input1.getOutputs()) {
            if (lop.type != Lop.Type.SortKeys) continue;
            return (SortKeys)lop;
        }
        SortKeys retVal = new SortKeys(input1, op, dt, vt, et);
        retVal.setAllPositions(input1.getFilename(), input1.getBeginLine(), input1.getBeginColumn(), input1.getEndLine(), input1.getEndColumn());
        return retVal;
    }

    public static SortKeys constructSortByValueLop(Lop input1, Lop input2, OperationTypes op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        HashSet<Lop> set1 = new HashSet<Lop>();
        set1.addAll(input1.getOutputs());
        set1.retainAll(input2.getOutputs());
        for (Lop lop : set1) {
            if (lop.type != Lop.Type.SortKeys) continue;
            return (SortKeys)lop;
        }
        SortKeys retVal = new SortKeys(input1, input2, op, dt, vt, et);
        retVal.setAllPositions(input1.getFilename(), input1.getBeginLine(), input1.getBeginColumn(), input1.getEndLine(), input1.getEndColumn());
        return retVal;
    }

    public static enum OperationTypes {
        WithWeights,
        WithoutWeights,
        Indexes;

    }
}

