/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.lops;

import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.lops.Lop;
import org.tugraz.sysds.lops.LopProperties;
import org.tugraz.sysds.lops.LopsException;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;

public class ReBlock
extends Lop {
    public static final String OPCODE = "rblk";
    private boolean _outputEmptyBlocks = true;
    private int _blocksize;

    public ReBlock(Lop input, int blen, Types.DataType dt, Types.ValueType vt, boolean outputEmptyBlocks, LopProperties.ExecType et) {
        super(Lop.Type.ReBlock, dt, vt);
        this.addInput(input);
        input.addOutput(this);
        this._blocksize = blen;
        this._outputEmptyBlocks = outputEmptyBlocks;
        if (et != LopProperties.ExecType.SPARK) {
            throw new LopsException("Incorrect execution type for Reblock:" + (Object)((Object)et));
        }
        this.lps.setProperties(this.inputs, LopProperties.ExecType.SPARK);
    }

    @Override
    public String toString() {
        return "Reblock - blocksize = " + this._blocksize;
    }

    @Override
    public String getInstructions(String input1, String output) {
        return InstructionUtils.concatOperands(this.getExecType().name(), OPCODE, this.getInputs().get(0).prepInputOperand(input1), this.prepOutputOperand(output), String.valueOf(this._blocksize), String.valueOf(this._outputEmptyBlocks));
    }

    private Types.FileFormat getChildFormat(Lop node) {
        if (node.getOutputParameters().getFile_name() != null || node.getOutputParameters().getLabel() != null) {
            return node.getOutputParameters().getFormat();
        }
        if (node.getInputs().size() > 1) {
            throw new LopsException(this.printErrorLocation() + "Should only have one child! \n");
        }
        return node.getInputs().get(0).getOutputParameters().getFormat();
    }
}

