/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.lops;

import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.hops.AggBinaryOp;
import org.tugraz.sysds.hops.HopsException;
import org.tugraz.sysds.lops.Lop;
import org.tugraz.sysds.lops.LopProperties;
import org.tugraz.sysds.lops.LopsException;

public class PartialAggregate
extends Lop {
    private Types.AggOp operation;
    private Types.Direction direction;
    private int _numThreads = -1;
    private AggBinaryOp.SparkAggType _aggtype = AggBinaryOp.SparkAggType.MULTI_BLOCK;

    public PartialAggregate(Lop input, Types.AggOp op, Types.Direction direct, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et, int k) {
        super(Lop.Type.PartialAggregate, dt, vt);
        this.init(input, op, direct, dt, vt, et);
        this._numThreads = k;
    }

    public PartialAggregate(Lop input, Types.AggOp op, Types.Direction direct, Types.DataType dt, Types.ValueType vt, AggBinaryOp.SparkAggType aggtype, LopProperties.ExecType et) {
        super(Lop.Type.PartialAggregate, dt, vt);
        this.init(input, op, direct, dt, vt, et);
        this._aggtype = aggtype;
    }

    private void init(Lop input, Types.AggOp op, Types.Direction direct, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        this.operation = op;
        this.direction = direct;
        this.addInput(input);
        input.addOutput(this);
        this.lps.setProperties(this.inputs, et);
    }

    public Types.CorrectionLocationType getCorrectionLocation() {
        return PartialAggregate.getCorrectionLocation(this.operation, this.direction);
    }

    public static Types.CorrectionLocationType getCorrectionLocation(Types.AggOp operation, Types.Direction direction) {
        Types.CorrectionLocationType loc;
        block0 : switch (operation) {
            case SUM: 
            case SUM_SQ: 
            case TRACE: {
                switch (direction) {
                    case Col: {
                        loc = Types.CorrectionLocationType.LASTROW;
                        break block0;
                    }
                    case Row: 
                    case RowCol: {
                        loc = Types.CorrectionLocationType.LASTCOLUMN;
                        break block0;
                    }
                }
                throw new LopsException("PartialAggregate.getCorrectionLocation() - Unknown aggregate direction: " + (Object)((Object)direction));
            }
            case MEAN: {
                switch (direction) {
                    case Col: {
                        loc = Types.CorrectionLocationType.LASTTWOROWS;
                        break block0;
                    }
                    case Row: 
                    case RowCol: {
                        loc = Types.CorrectionLocationType.LASTTWOCOLUMNS;
                        break block0;
                    }
                }
                throw new LopsException("PartialAggregate.getCorrectionLocation() - Unknown aggregate direction: " + (Object)((Object)direction));
            }
            case VAR: {
                switch (direction) {
                    case Col: {
                        loc = Types.CorrectionLocationType.LASTFOURROWS;
                        break block0;
                    }
                    case Row: 
                    case RowCol: {
                        loc = Types.CorrectionLocationType.LASTFOURCOLUMNS;
                        break block0;
                    }
                }
                throw new LopsException("PartialAggregate.getCorrectionLocation() - Unknown aggregate direction: " + (Object)((Object)direction));
            }
            case MAXINDEX: 
            case MININDEX: {
                loc = Types.CorrectionLocationType.LASTCOLUMN;
                break;
            }
            default: {
                loc = Types.CorrectionLocationType.NONE;
            }
        }
        return loc;
    }

    public void setDimensionsBasedOnDirection(long dim1, long dim2, long blen) {
        PartialAggregate.setDimensionsBasedOnDirection(this, dim1, dim2, blen, this.direction);
    }

    public static void setDimensionsBasedOnDirection(Lop lop, long dim1, long dim2, long blen, Types.Direction dir) {
        block5: {
            try {
                if (dir == Types.Direction.Row) {
                    lop.outParams.setDimensions(dim1, 1L, blen, -1L);
                    break block5;
                }
                if (dir == Types.Direction.Col) {
                    lop.outParams.setDimensions(1L, dim2, blen, -1L);
                    break block5;
                }
                if (dir == Types.Direction.RowCol) {
                    lop.outParams.setDimensions(1L, 1L, blen, -1L);
                    break block5;
                }
                throw new LopsException("In PartialAggregate Lop, Unknown aggregate direction " + (Object)((Object)dir));
            }
            catch (HopsException e) {
                throw new LopsException("In PartialAggregate Lop, error setting dimensions based on direction", e);
            }
        }
    }

    @Override
    public String toString() {
        return "Partial Aggregate " + (Object)((Object)this.operation);
    }

    private String getOpcode() {
        return PartialAggregate.getOpcode(this.operation, this.direction);
    }

    @Override
    public String getInstructions(String input1, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        if (this.getExecType() == LopProperties.ExecType.SPARK) {
            sb.append((Object)this._aggtype);
        } else if (this.getExecType() == LopProperties.ExecType.CP) {
            sb.append(this._numThreads);
        }
        return sb.toString();
    }

    public static String getOpcode(Types.AggOp op, Types.Direction dir) {
        switch (op) {
            case SUM: {
                if (dir == Types.Direction.RowCol) {
                    return "uak+";
                }
                if (dir == Types.Direction.Row) {
                    return "uark+";
                }
                if (dir != Types.Direction.Col) break;
                return "uack+";
            }
            case SUM_SQ: {
                if (dir == Types.Direction.RowCol) {
                    return "uasqk+";
                }
                if (dir == Types.Direction.Row) {
                    return "uarsqk+";
                }
                if (dir != Types.Direction.Col) break;
                return "uacsqk+";
            }
            case MEAN: {
                if (dir == Types.Direction.RowCol) {
                    return "uamean";
                }
                if (dir == Types.Direction.Row) {
                    return "uarmean";
                }
                if (dir != Types.Direction.Col) break;
                return "uacmean";
            }
            case VAR: {
                if (dir == Types.Direction.RowCol) {
                    return "uavar";
                }
                if (dir == Types.Direction.Row) {
                    return "uarvar";
                }
                if (dir != Types.Direction.Col) break;
                return "uacvar";
            }
            case PROD: {
                switch (dir) {
                    case RowCol: {
                        return "ua*";
                    }
                    case Row: {
                        return "uar*";
                    }
                    case Col: {
                        return "uac*";
                    }
                }
            }
            case SUM_PROD: {
                switch (dir) {
                    case RowCol: {
                        return "ua+*";
                    }
                    case Row: {
                        return "uar+*";
                    }
                    case Col: {
                        return "uac+*";
                    }
                }
            }
            case MAX: {
                if (dir == Types.Direction.RowCol) {
                    return "uamax";
                }
                if (dir == Types.Direction.Row) {
                    return "uarmax";
                }
                if (dir != Types.Direction.Col) break;
                return "uacmax";
            }
            case MIN: {
                if (dir == Types.Direction.RowCol) {
                    return "uamin";
                }
                if (dir == Types.Direction.Row) {
                    return "uarmin";
                }
                if (dir != Types.Direction.Col) break;
                return "uacmin";
            }
            case MAXINDEX: {
                if (dir != Types.Direction.Row) break;
                return "uarimax";
            }
            case MININDEX: {
                if (dir != Types.Direction.Row) break;
                return "uarimin";
            }
            case TRACE: {
                if (dir != Types.Direction.RowCol) break;
                return "uaktrace";
            }
        }
        throw new UnsupportedOperationException("Instruction is not defined for PartialAggregate operation " + (Object)((Object)op));
    }
}

