/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.lops;

import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.lops.Lop;
import org.tugraz.sysds.lops.LopProperties;
import org.tugraz.sysds.lops.LopsException;

public class Nary
extends Lop {
    private Types.OpOpN operationType;

    public Nary(Types.OpOpN operationType, Types.DataType dt, Types.ValueType vt, Lop[] inputLops, LopProperties.ExecType et) {
        super(Lop.Type.Nary, dt, vt);
        this.operationType = operationType;
        for (Lop inputLop : inputLops) {
            this.addInput(inputLop);
            inputLop.addOutput(this);
        }
        if (et != LopProperties.ExecType.CP && et != LopProperties.ExecType.SPARK) {
            throw new LopsException("Unsupported exec type for nary lop:" + et.name());
        }
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return "Operation Type: " + (Object)((Object)this.operationType);
    }

    public Types.OpOpN getOp() {
        return this.operationType;
    }

    @Override
    public String getInstructions(String[] inputs, String output) {
        String opString = this.getOpcode();
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(opString);
        sb.append("\u00b0");
        for (int i = 0; i < inputs.length; ++i) {
            sb.append(this.getInputs().get(i).prepInputOperand(inputs[i]));
            sb.append("\u00b0");
        }
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    private String getOpcode() {
        switch (this.operationType) {
            case PRINTF: 
            case CBIND: 
            case RBIND: 
            case EVAL: 
            case LIST: {
                return this.operationType.name().toLowerCase();
            }
            case MIN: 
            case MAX: {
                return "n" + this.operationType.name().toLowerCase();
            }
            case PLUS: {
                return "n+";
            }
        }
        throw new UnsupportedOperationException("Nary operation type (" + (Object)((Object)this.operationType) + ") is not defined.");
    }
}

