/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.lops;

import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.hops.AggBinaryOp;
import org.tugraz.sysds.lops.Lop;
import org.tugraz.sysds.lops.LopProperties;

public class MapMult
extends Lop {
    public static final String OPCODE = "mapmm";
    private CacheType _cacheType = null;
    private boolean _outputEmptyBlocks = true;
    private AggBinaryOp.SparkAggType _aggtype = AggBinaryOp.SparkAggType.MULTI_BLOCK;

    public MapMult(Lop input1, Lop input2, Types.DataType dt, Types.ValueType vt, boolean rightCache, boolean partitioned, boolean emptyBlocks, AggBinaryOp.SparkAggType aggtype) {
        super(Lop.Type.MapMult, dt, vt);
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        this._cacheType = rightCache ? (partitioned ? CacheType.RIGHT_PART : CacheType.RIGHT) : (partitioned ? CacheType.LEFT_PART : CacheType.LEFT);
        this._outputEmptyBlocks = emptyBlocks;
        this._aggtype = aggtype;
        this.lps.setProperties(this.inputs, LopProperties.ExecType.SPARK);
    }

    @Override
    public String toString() {
        return "Operation = MapMM";
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(OPCODE);
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        sb.append("\u00b0");
        sb.append((Object)this._cacheType);
        sb.append("\u00b0");
        sb.append(this._outputEmptyBlocks);
        if (this.getExecType() == LopProperties.ExecType.SPARK) {
            sb.append("\u00b0");
            sb.append(this._aggtype.toString());
        }
        return sb.toString();
    }

    public static enum CacheType {
        RIGHT,
        RIGHT_PART,
        LEFT,
        LEFT_PART;


        public boolean isRight() {
            return this == RIGHT || this == RIGHT_PART;
        }

        public CacheType getFlipped() {
            switch (this) {
                case RIGHT: {
                    return LEFT;
                }
                case RIGHT_PART: {
                    return LEFT_PART;
                }
                case LEFT: {
                    return RIGHT;
                }
                case LEFT_PART: {
                    return RIGHT_PART;
                }
            }
            return null;
        }
    }
}

