/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.lops;

import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.lops.Lop;
import org.tugraz.sysds.lops.LopProperties;

public class LeftIndex
extends Lop {
    public static final String OPCODE = "leftIndex";
    private LixCacheType _type;

    public LeftIndex(Lop lhsInput, Lop rhsInput, Lop rowL, Lop rowU, Lop colL, Lop colU, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.LeftIndex, dt, vt);
        this._type = LixCacheType.NONE;
        this.init(lhsInput, rhsInput, rowL, rowU, colL, colU, et);
    }

    public LeftIndex(Lop lhsInput, Lop rhsInput, Lop rowL, Lop rowU, Lop colL, Lop colU, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et, LixCacheType type) {
        super(Lop.Type.LeftIndex, dt, vt);
        this._type = type;
        this.init(lhsInput, rhsInput, rowL, rowU, colL, colU, et);
    }

    private void init(Lop lhsMatrix, Lop rhsMatrix, Lop rowL, Lop rowU, Lop colL, Lop colU, LopProperties.ExecType et) {
        this.addInput(lhsMatrix);
        this.addInput(rhsMatrix);
        this.addInput(rowL);
        this.addInput(rowU);
        this.addInput(colL);
        this.addInput(colU);
        lhsMatrix.addOutput(this);
        rhsMatrix.addOutput(this);
        rowL.addOutput(this);
        rowU.addOutput(this);
        colL.addOutput(this);
        colU.addOutput(this);
        this.lps.setProperties(this.inputs, et);
    }

    private String getOpcode() {
        if (this._type != LixCacheType.NONE) {
            return "mapLeftIndex";
        }
        return OPCODE;
    }

    @Override
    public String getInstructions(String lhsInput, String rhsInput, String rowl, String rowu, String coll, String colu, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(lhsInput));
        sb.append("\u00b0");
        if (this.getInputs().get(1).getDataType() == Types.DataType.SCALAR) {
            sb.append(this.getInputs().get(1).prepScalarInputOperand(this.getExecType()));
        } else {
            sb.append(this.getInputs().get(1).prepInputOperand(rhsInput));
        }
        sb.append("\u00b0");
        sb.append(this.getInputs().get(2).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(3).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(4).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(5).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        if (this.getExecType() == LopProperties.ExecType.SPARK) {
            sb.append("\u00b0");
            sb.append(this._type.toString());
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getOpcode();
    }

    public static enum LixCacheType {
        RIGHT,
        LEFT,
        NONE;

    }
}

