/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.lops;

import java.util.HashMap;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.lops.Lop;
import org.tugraz.sysds.lops.LopProperties;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;

public class GroupedAggregateM
extends Lop {
    public static final String OPCODE = "mapgroupedagg";
    private HashMap<String, Lop> _inputParams;
    private CacheType _cacheType = null;

    public GroupedAggregateM(HashMap<String, Lop> inputParameterLops, Types.DataType dt, Types.ValueType vt, boolean partitioned, LopProperties.ExecType et) {
        super(Lop.Type.GroupedAggM, dt, vt);
        this.init(inputParameterLops, dt, vt, et);
        this._inputParams = inputParameterLops;
        this._cacheType = partitioned ? CacheType.RIGHT_PART : CacheType.RIGHT;
    }

    private void init(HashMap<String, Lop> inputParameterLops, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        this.addInput(inputParameterLops.get("target"));
        inputParameterLops.get("target").addOutput(this);
        this.addInput(inputParameterLops.get("groups"));
        inputParameterLops.get("groups").addOutput(this);
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return "Operation = MapGroupedAggregate";
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        return InstructionUtils.concatOperands(this.getExecType().name(), OPCODE, this.getInputs().get(0).prepInputOperand(input1), this.getInputs().get(1).prepInputOperand(input2), this.prepOutputOperand(output), this._inputParams.get("ngroups").prepScalarInputOperand(this.getExecType()), this._cacheType.name());
    }

    public static enum CacheType {
        RIGHT,
        RIGHT_PART;

    }
}

