/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.lops;

import java.util.ArrayList;
import org.tugraz.sysds.common.Builtins;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.hops.Hop;
import org.tugraz.sysds.lops.Lop;
import org.tugraz.sysds.lops.LopProperties;
import org.tugraz.sysds.parser.DMLProgram;

public class FunctionCallCP
extends Lop {
    private String _fnamespace;
    private String _fname;
    private String[] _inputNames;
    private String[] _outputNames;
    private ArrayList<Lop> _outputLops = null;

    public FunctionCallCP(ArrayList<Lop> inputs, String fnamespace, String fname, String[] inputNames, String[] outputNames, ArrayList<Hop> outputHops, LopProperties.ExecType et) {
        this(inputs, fnamespace, fname, inputNames, outputNames, et);
        if (outputHops != null) {
            this._outputLops = new ArrayList();
            this.setLevel();
            for (Hop h : outputHops) {
                Lop outputLop = h.constructLops();
                this._outputLops.add(outputLop);
                this.addOutput(outputLop);
                if (outputLop.getLevel() > this.getLevel()) continue;
                outputLop.updateLevel(this.getLevel() + 1);
            }
        }
    }

    public FunctionCallCP(ArrayList<Lop> inputs, String fnamespace, String fname, String[] inputNames, String[] outputNames, LopProperties.ExecType et) {
        super(Lop.Type.FunctionCallCP, Types.DataType.UNKNOWN, Types.ValueType.UNKNOWN);
        this._fnamespace = fnamespace;
        this._fname = fname;
        this._inputNames = inputNames;
        this._outputNames = outputNames;
        for (Lop in : inputs) {
            this.addInput(in);
            in.addOutput(this);
        }
        this.lps.setProperties(inputs, et);
    }

    public ArrayList<Lop> getFunctionOutputs() {
        return this._outputLops;
    }

    public boolean requiresOutputCreateVar() {
        return !this._fname.equalsIgnoreCase(Builtins.REMOVE.getName());
    }

    @Override
    public String toString() {
        return "function call: " + DMLProgram.constructFunctionKey(this._fnamespace, this._fname);
    }

    private String getInstructionsMultipleReturnBuiltins(String[] inputs, String[] outputs) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this._fname.toLowerCase());
        for (i = 0; i < inputs.length; ++i) {
            sb.append("\u00b0");
            sb.append(this.getInputs().get(i).prepInputOperand(inputs[i]));
        }
        for (i = 0; i < this._outputNames.length; ++i) {
            sb.append("\u00b0");
            sb.append(this._outputNames[i]);
        }
        return sb.toString();
    }

    @Override
    public String getInstructions(String[] inputs, String[] outputs) {
        if (this._fnamespace.equalsIgnoreCase("_internal")) {
            return this.getInstructionsMultipleReturnBuiltins(inputs, outputs);
        }
        StringBuilder inst = new StringBuilder();
        inst.append((Object)this.getExecType());
        inst.append("\u00b0");
        inst.append("extfunct");
        inst.append("\u00b0");
        inst.append(this._fnamespace);
        inst.append("\u00b0");
        inst.append(this._fname);
        inst.append("\u00b0");
        inst.append(inputs.length);
        inst.append("\u00b0");
        inst.append(this._outputNames.length);
        for (int i = 0; i < inputs.length; ++i) {
            inst.append("\u00b0");
            inst.append(this._inputNames[i]);
            inst.append("=");
            inst.append(this.getInputs().get(i).prepInputOperand(inputs[i]));
        }
        for (String out : this._outputNames) {
            inst.append("\u00b0");
            inst.append(out);
        }
        return inst.toString();
    }
}

