/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.lops;

import java.util.HashMap;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.lops.Lop;
import org.tugraz.sysds.lops.LopProperties;
import org.tugraz.sysds.lops.LopsException;
import org.tugraz.sysds.parser.DataExpression;
import org.tugraz.sysds.parser.DataIdentifier;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;

public class DataGen
extends Lop {
    public static final String RAND_OPCODE = "rand";
    public static final String SEQ_OPCODE = "seq";
    public static final String SINIT_OPCODE = "sinit";
    public static final String SAMPLE_OPCODE = "sample";
    public static final String TIME_OPCODE = "time";
    private int _numThreads = 1;
    private String baseDir;
    private HashMap<String, Lop> _inputParams;
    private final Types.OpOpDG _op;

    public DataGen(Types.OpOpDG op, DataIdentifier id, HashMap<String, Lop> inputParametersLops, String baseDir, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.DataGen, dt, vt);
        this._op = op;
        for (Lop lop : inputParametersLops.values()) {
            this.addInput(lop);
            lop.addOutput(this);
        }
        this._inputParams = inputParametersLops;
        this.init(id, baseDir, et);
    }

    public Types.OpOpDG getDataGenMethod() {
        return this._op;
    }

    public void init(DataIdentifier id, String baseDir, LopProperties.ExecType et) {
        this.getOutputParameters().setFormat(Types.FileFormat.BINARY);
        this.getOutputParameters().setBlocked(true);
        this.getOutputParameters().setNumRows(id.getDim1());
        this.getOutputParameters().setNumCols(id.getDim2());
        this.getOutputParameters().setNnz(-1L);
        this.getOutputParameters().setBlocksize(id.getBlocksize());
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String getInstructions(String output) {
        switch (this._op) {
            case RAND: {
                return this.getRandInstructionCPSpark(output);
            }
            case SINIT: {
                return this.getSInitInstructionCPSpark(output);
            }
            case SEQ: {
                return this.getSeqInstructionCPSpark(output);
            }
            case SAMPLE: {
                return this.getSampleInstructionCPSpark(output);
            }
            case TIME: {
                return this.getTimeInstructionCP(output);
            }
        }
        throw new LopsException("Unknown data generation method: " + (Object)((Object)this._op));
    }

    private String getRandInstructionCPSpark(String output) {
        if (this._op != Types.OpOpDG.RAND) {
            throw new LopsException("Invalid instruction generation for data generation method " + (Object)((Object)this._op));
        }
        if (this.getInputs().size() != DataExpression.RAND_VALID_PARAM_NAMES.length - 2 && this.getInputs().size() != DataExpression.RAND_VALID_PARAM_NAMES.length - 1) {
            throw new LopsException(this.printErrorLocation() + "Invalid number of operands (" + this.getInputs().size() + ") for a Rand operation");
        }
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(RAND_OPCODE);
        sb.append("\u00b0");
        Lop iLop = this._inputParams.get("dims");
        if (iLop != null) {
            sb.append(iLop.prepScalarInputOperand(this.getExecType()));
            sb.append("\u00b0");
        } else {
            iLop = this._inputParams.get("rows");
            sb.append(iLop.prepScalarInputOperand(this.getExecType()));
            sb.append("\u00b0");
            iLop = this._inputParams.get("cols");
            sb.append(iLop.prepScalarInputOperand(this.getExecType()));
            sb.append("\u00b0");
        }
        sb.append(this.getOutputParameters().getBlocksize());
        sb.append("\u00b0");
        iLop = this._inputParams.get("min");
        sb.append(iLop.prepScalarLabel());
        sb.append("\u00b0");
        iLop = this._inputParams.get("max");
        sb.append(iLop.prepScalarLabel());
        sb.append("\u00b0");
        iLop = this._inputParams.get("sparsity");
        if (iLop.isVariable()) {
            sb.append(iLop.prepScalarLabel());
        } else {
            sb.append(iLop.getOutputParameters().getLabel());
        }
        sb.append("\u00b0");
        iLop = this._inputParams.get("seed");
        sb.append(iLop.prepScalarLabel());
        sb.append("\u00b0");
        if (this.getExecType() == LopProperties.ExecType.SPARK) {
            sb.append(this.baseDir);
            sb.append("\u00b0");
        }
        if ((iLop = this._inputParams.get("pdf")).isVariable()) {
            throw new LopsException(this.printErrorLocation() + "Parameter " + "pdf" + " must be a literal for a Rand operation.");
        }
        sb.append(iLop.getOutputParameters().getLabel());
        sb.append("\u00b0");
        iLop = this._inputParams.get("lambda");
        sb.append(iLop == null ? "" : iLop.prepScalarLabel());
        sb.append("\u00b0");
        if (this.getExecType() == LopProperties.ExecType.CP) {
            sb.append(this._numThreads);
            sb.append("\u00b0");
        }
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    private String getSInitInstructionCPSpark(String output) {
        if (this._op != Types.OpOpDG.SINIT) {
            throw new LopsException("Invalid instruction generation for data generation method " + (Object)((Object)this._op));
        }
        Lop iLop = this._inputParams.get("rows");
        String rowsString = iLop.prepScalarLabel();
        iLop = this._inputParams.get("cols");
        String colsString = iLop.prepScalarLabel();
        String blen = String.valueOf(this.getOutputParameters().getBlocksize());
        iLop = this._inputParams.get("min");
        String minString = iLop.getOutputParameters().getLabel();
        if (iLop.isVariable()) {
            throw new LopsException(this.printErrorLocation() + "Parameter " + "min" + " must be a literal for a Rand operation.");
        }
        StringBuilder sb = new StringBuilder();
        LopProperties.ExecType et = this.getExecType();
        sb.append((Object)et);
        sb.append("\u00b0");
        sb.append(SINIT_OPCODE);
        sb.append("\u00b0");
        sb.append(rowsString);
        sb.append("\u00b0");
        sb.append(colsString);
        sb.append("\u00b0");
        sb.append(blen);
        sb.append("\u00b0");
        sb.append(minString);
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    private String getSampleInstructionCPSpark(String output) {
        if (this._op != Types.OpOpDG.SAMPLE) {
            throw new LopsException("Invalid instruction generation for data generation method " + (Object)((Object)this._op));
        }
        Lop lsize = this._inputParams.get("rows".toString());
        Lop lrange = this._inputParams.get("max".toString());
        Lop lreplace = this._inputParams.get("pdf".toString());
        Lop lseed = this._inputParams.get("seed".toString());
        return InstructionUtils.concatOperands(this.getExecType().name(), SAMPLE_OPCODE, lrange.prepScalarLabel(), lsize.prepScalarInputOperand(this.getExecType()), lreplace.prepScalarLabel(), lseed.prepScalarLabel(), String.valueOf(this.getOutputParameters().getBlocksize()), this.prepOutputOperand(output));
    }

    private String getTimeInstructionCP(String output) {
        if (this._op != Types.OpOpDG.TIME) {
            throw new LopsException("Invalid instruction generation for data generation method " + (Object)((Object)this._op));
        }
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(TIME_OPCODE);
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    private String getSeqInstructionCPSpark(String output) {
        if (this._op != Types.OpOpDG.SEQ) {
            throw new LopsException("Invalid instruction generation for data generation method " + (Object)((Object)this._op));
        }
        StringBuilder sb = new StringBuilder();
        LopProperties.ExecType et = this.getExecType();
        sb.append((Object)et);
        sb.append("\u00b0");
        Lop iLop = null;
        iLop = this._inputParams.get("from".toString());
        String fromString = iLop.prepScalarInputOperand(et);
        iLop = this._inputParams.get("to".toString());
        String toString = iLop.prepScalarInputOperand(et);
        iLop = this._inputParams.get("incr".toString());
        String incrString = iLop.prepScalarInputOperand(et);
        String rowsString = String.valueOf(this.getOutputParameters().getNumRows());
        String colsString = String.valueOf(this.getOutputParameters().getNumCols());
        String blen = String.valueOf(this.getOutputParameters().getBlocksize());
        sb.append(SEQ_OPCODE);
        sb.append("\u00b0");
        sb.append(rowsString);
        sb.append("\u00b0");
        sb.append(colsString);
        sb.append("\u00b0");
        sb.append(blen);
        sb.append("\u00b0");
        sb.append(fromString);
        sb.append("\u00b0");
        sb.append(toString);
        sb.append("\u00b0");
        sb.append(incrString);
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._op.toString());
        sb.append(" ; num_rows=" + this.getOutputParameters().getNumRows());
        sb.append(" ; num_cols=" + this.getOutputParameters().getNumCols());
        sb.append(" ; nnz=" + this.getOutputParameters().getNnz());
        sb.append(" ; blocksize=" + this.getOutputParameters().getBlocksize());
        sb.append(" ; format=" + (Object)((Object)this.getOutputParameters().getFormat()));
        sb.append(" ; blocked=" + this.getOutputParameters().isBlocked());
        sb.append(" ; dir=" + this.baseDir);
        return sb.toString();
    }

    public void setNumThreads(int k) {
        this._numThreads = k;
    }
}

