/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.lops;

import org.apache.spark.storage.StorageLevel;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.lops.Lop;
import org.tugraz.sysds.lops.LopProperties;
import org.tugraz.sysds.lops.LopsException;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;

public class Checkpoint
extends Lop {
    public static final String OPCODE = "chkpoint";
    public static final StorageLevel DEFAULT_STORAGE_LEVEL = StorageLevel.MEMORY_AND_DISK();
    public static final StorageLevel SER_STORAGE_LEVEL = StorageLevel.MEMORY_AND_DISK_SER();
    public static final boolean CHECKPOINT_SPARSE_CSR = true;
    private StorageLevel _storageLevel;

    public Checkpoint(Lop input, Types.DataType dt, Types.ValueType vt, String level) {
        super(Lop.Type.Checkpoint, dt, vt);
        this.addInput(input);
        input.addOutput(this);
        this._storageLevel = StorageLevel.fromString((String)level);
        this.lps.setProperties(this.inputs, LopProperties.ExecType.SPARK);
    }

    public StorageLevel getStorageLevel() {
        return this._storageLevel;
    }

    public void setStorageLevel(StorageLevel level) {
        this._storageLevel = level;
    }

    @Override
    public String toString() {
        return "Checkpoint - storage.level = " + this._storageLevel.toString();
    }

    @Override
    public String getInstructions(String input1, String output) {
        if (this.getExecType() != LopProperties.ExecType.SPARK) {
            throw new LopsException("Wrong execution type for Checkpoint.getInstructions (expected: SPARK, found: " + (Object)((Object)this.getExecType()) + ").");
        }
        return InstructionUtils.concatOperands(this.getExecType().name(), OPCODE, this.getInputs().get(0).prepInputOperand(input1), this.prepOutputOperand(output), Checkpoint.getStorageLevelString(this._storageLevel));
    }

    public static String getStorageLevelString(StorageLevel level) {
        if (StorageLevel.NONE().equals((Object)level)) {
            return "NONE";
        }
        if (StorageLevel.MEMORY_ONLY().equals((Object)level)) {
            return "MEMORY_ONLY";
        }
        if (StorageLevel.MEMORY_ONLY_2().equals((Object)level)) {
            return "MEMORY_ONLY_2";
        }
        if (StorageLevel.MEMORY_ONLY_SER().equals((Object)level)) {
            return "MEMORY_ONLY_SER";
        }
        if (StorageLevel.MEMORY_ONLY_SER_2().equals((Object)level)) {
            return "MEMORY_ONLY_SER_2";
        }
        if (StorageLevel.MEMORY_AND_DISK().equals((Object)level)) {
            return "MEMORY_AND_DISK";
        }
        if (StorageLevel.MEMORY_AND_DISK_2().equals((Object)level)) {
            return "MEMORY_AND_DISK_2";
        }
        if (StorageLevel.MEMORY_AND_DISK_SER().equals((Object)level)) {
            return "MEMORY_AND_DISK_SER";
        }
        if (StorageLevel.MEMORY_AND_DISK_SER_2().equals((Object)level)) {
            return "MEMORY_AND_DISK_SER_2";
        }
        if (StorageLevel.DISK_ONLY().equals((Object)level)) {
            return "DISK_ONLY";
        }
        if (StorageLevel.DISK_ONLY_2().equals((Object)level)) {
            return "DISK_ONLY_2";
        }
        return "INVALID";
    }

    public static String getDefaultStorageLevelString() {
        return Checkpoint.getStorageLevelString(DEFAULT_STORAGE_LEVEL);
    }

    public static String getSerializeStorageLevelString() {
        return Checkpoint.getStorageLevelString(SER_STORAGE_LEVEL);
    }
}

