/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.lops;

import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.lops.Lop;
import org.tugraz.sysds.lops.LopProperties;

public class CentralMoment
extends Lop {
    private void init(Lop input1, Lop input2, Lop input3, LopProperties.ExecType et) {
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        if (input3 != null) {
            this.addInput(input3);
            input3.addOutput(this);
        }
        this.lps.setProperties(this.inputs, et);
    }

    public CentralMoment(Lop input1, Lop input2, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        this(input1, input2, null, dt, vt, et);
    }

    public CentralMoment(Lop input1, Lop input2, Lop input3, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.CentralMoment, dt, vt);
        this.init(input1, input2, input3, et);
    }

    @Override
    public String toString() {
        return "Operation = CentralMoment";
    }

    @Override
    public String getInstructions(String input1, String input2, String input3, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append("cm");
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        if (input3 != null) {
            sb.append(this.getInputs().get(1).prepInputOperand(input2));
            sb.append("\u00b0");
        }
        sb.append(this.getInputs().get(input3 != null ? 2 : 1).prepScalarInputOperand(this.getExecType()));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        return sb.toString();
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        return this.getInstructions(input1, input2, null, output);
    }
}

