/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.lops;

import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.lops.Data;
import org.tugraz.sysds.lops.Lop;
import org.tugraz.sysds.lops.LopProperties;
import org.tugraz.sysds.lops.LopsException;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;

public class CSVReBlock
extends Lop {
    public static final String OPCODE = "csvrblk";
    private int _blocksize;

    public CSVReBlock(Lop input, int blen, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        super(Lop.Type.CSVReBlock, dt, vt);
        this.addInput(input);
        input.addOutput(this);
        this._blocksize = blen;
        if (et != LopProperties.ExecType.SPARK) {
            throw new LopsException("Incorrect execution type for CSVReblock:" + (Object)((Object)et));
        }
        this.lps.setProperties(this.inputs, LopProperties.ExecType.SPARK);
    }

    @Override
    public String toString() {
        return "CSVReblock - blocksize = " + this._blocksize;
    }

    private String prepCSVProperties() {
        StringBuilder sb = new StringBuilder();
        Data dataInput = (Data)this.getInputs().get(0);
        Lop headerLop = dataInput.getNamedInputLop("header", String.valueOf(false));
        Lop delimLop = dataInput.getNamedInputLop("sep", ",");
        Lop fillLop = dataInput.getNamedInputLop("fill", String.valueOf(true));
        Lop fillValueLop = dataInput.getNamedInputLop("default", String.valueOf(0.0));
        if (headerLop.isVariable()) {
            throw new LopsException(this.printErrorLocation() + "Parameter " + "header" + " must be a literal.");
        }
        if (delimLop.isVariable()) {
            throw new LopsException(this.printErrorLocation() + "Parameter " + "sep" + " must be a literal.");
        }
        if (fillLop.isVariable()) {
            throw new LopsException(this.printErrorLocation() + "Parameter " + "fill" + " must be a literal.");
        }
        if (fillValueLop.isVariable()) {
            throw new LopsException(this.printErrorLocation() + "Parameter " + "default" + " must be a literal.");
        }
        sb.append(((Data)headerLop).getBooleanValue());
        sb.append("\u00b0");
        sb.append(((Data)delimLop).getStringValue());
        sb.append("\u00b0");
        sb.append(((Data)fillLop).getBooleanValue());
        sb.append("\u00b0");
        sb.append(((Data)fillValueLop).getDoubleValue());
        return sb.toString();
    }

    @Override
    public String getInstructions(String input1, String output) {
        return InstructionUtils.concatOperands(this.getExecType().name(), OPCODE, this.getInputs().get(0).prepInputOperand(input1), this.prepOutputOperand(output), String.valueOf(this._blocksize), this.prepCSVProperties());
    }
}

