/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.lops;

import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.lops.Binary;
import org.tugraz.sysds.lops.Lop;
import org.tugraz.sysds.lops.LopProperties;
import org.tugraz.sysds.lops.LopsException;
import org.tugraz.sysds.runtime.instructions.InstructionUtils;

public class BinaryM
extends Lop {
    private Binary.OperationTypes _operation;
    private VectorType _vectorType = null;

    public BinaryM(Lop input1, Lop input2, Binary.OperationTypes op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et, boolean colVector) {
        super(Lop.Type.Binary, dt, vt);
        this._operation = op;
        this._vectorType = colVector ? VectorType.COL_VECTOR : VectorType.ROW_VECTOR;
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        if (et != LopProperties.ExecType.SPARK) {
            throw new LopsException("Incorrect execution type for BinaryM lop:" + et.name());
        }
        this.lps.setProperties(this.inputs, LopProperties.ExecType.SPARK);
    }

    @Override
    public String toString() {
        return " Operation: " + (Object)((Object)this._operation);
    }

    public Binary.OperationTypes getOperationType() {
        return this._operation;
    }

    private String getOpcode() {
        return BinaryM.getOpcode(this._operation);
    }

    public static String getOpcode(Binary.OperationTypes op) {
        switch (op) {
            case ADD: {
                return "map+";
            }
            case SUBTRACT: {
                return "map-";
            }
            case MULTIPLY: {
                return "map*";
            }
            case DIVIDE: {
                return "map/";
            }
            case MODULUS: {
                return "map%%";
            }
            case INTDIV: {
                return "map%/%";
            }
            case MINUS1_MULTIPLY: {
                return "map1-*";
            }
            case LESS_THAN: {
                return "map<";
            }
            case LESS_THAN_OR_EQUALS: {
                return "map<=";
            }
            case GREATER_THAN: {
                return "map>";
            }
            case GREATER_THAN_OR_EQUALS: {
                return "map>=";
            }
            case EQUALS: {
                return "map==";
            }
            case NOT_EQUALS: {
                return "map!=";
            }
            case AND: {
                return "map&&";
            }
            case OR: {
                return "map||";
            }
            case MIN: {
                return "mapmin";
            }
            case MAX: {
                return "mapmax";
            }
            case POW: {
                return "map^";
            }
        }
        throw new UnsupportedOperationException("Instruction is not defined for Binary operation: " + (Object)((Object)op));
    }

    public static boolean isOpcode(String opcode) {
        return opcode.equals("map+") || opcode.equals("map-") || opcode.equals("map*") || opcode.equals("map/") || opcode.equals("map%%") || opcode.equals("map%/%") || opcode.equals("map<") || opcode.equals("map<=") || opcode.equals("map>") || opcode.equals("map>=") || opcode.equals("map==") || opcode.equals("map!=") || opcode.equals("map&&") || opcode.equals("map||") || opcode.equals("mapmin") || opcode.equals("mapmax") || opcode.equals("map^") || opcode.equals("map1-*");
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        return InstructionUtils.concatOperands(this.getExecType().name(), this.getOpcode(), this.getInputs().get(0).prepInputOperand(input1), this.getInputs().get(1).prepInputOperand(input2), this.prepOutputOperand(output), "RIGHT", this._vectorType.name());
    }

    public static enum VectorType {
        COL_VECTOR,
        ROW_VECTOR;

    }
}

