/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.lops;

import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.lops.Lop;
import org.tugraz.sysds.lops.LopProperties;

public class Binary
extends Lop {
    private OperationTypes operation;
    private int numThreads = -1;
    boolean isLeftTransposed;
    boolean isRightTransposed;

    public Binary(Lop input1, Lop input2, OperationTypes op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        this(input1, input2, op, dt, vt, et, 1);
    }

    public Binary(Lop input1, Lop input2, OperationTypes op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et, int k) {
        super(Lop.Type.Binary, dt, vt);
        this.init(input1, input2, op, dt, vt, et);
        this.numThreads = k;
    }

    public Binary(Lop input1, Lop input2, OperationTypes op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et, boolean isLeftTransposed, boolean isRightTransposed) {
        super(Lop.Type.Binary, dt, vt);
        this.init(input1, input2, op, dt, vt, et);
        this.isLeftTransposed = isLeftTransposed;
        this.isRightTransposed = isRightTransposed;
    }

    private void init(Lop input1, Lop input2, OperationTypes op, Types.DataType dt, Types.ValueType vt, LopProperties.ExecType et) {
        this.operation = op;
        this.addInput(input1);
        this.addInput(input2);
        input1.addOutput(this);
        input2.addOutput(this);
        this.lps.setProperties(this.inputs, et);
    }

    @Override
    public String toString() {
        return " Operation: " + (Object)((Object)this.operation);
    }

    public OperationTypes getOperationType() {
        return this.operation;
    }

    private String getOpcode() {
        return Binary.getOpcode(this.operation);
    }

    public static String getOpcode(OperationTypes op) {
        switch (op) {
            case ADD: {
                return "+";
            }
            case SUBTRACT: {
                return "-";
            }
            case MULTIPLY: {
                return "*";
            }
            case DIVIDE: {
                return "/";
            }
            case MODULUS: {
                return "%%";
            }
            case INTDIV: {
                return "%/%";
            }
            case MATMULT: {
                return "ba+*";
            }
            case MINUS1_MULTIPLY: {
                return "1-*";
            }
            case LESS_THAN: {
                return "<";
            }
            case LESS_THAN_OR_EQUALS: {
                return "<=";
            }
            case GREATER_THAN: {
                return ">";
            }
            case GREATER_THAN_OR_EQUALS: {
                return ">=";
            }
            case EQUALS: {
                return "==";
            }
            case NOT_EQUALS: {
                return "!=";
            }
            case AND: {
                return "&&";
            }
            case OR: {
                return "||";
            }
            case XOR: {
                return "xor";
            }
            case BW_AND: {
                return "bitwAnd";
            }
            case BW_OR: {
                return "bitwOr";
            }
            case BW_XOR: {
                return "bitwXor";
            }
            case BW_SHIFTL: {
                return "bitwShiftL";
            }
            case BW_SHIFTR: {
                return "bitwShiftR";
            }
            case MIN: {
                return "min";
            }
            case MAX: {
                return "max";
            }
            case POW: {
                return "^";
            }
            case SOLVE: {
                return "solve";
            }
        }
        throw new UnsupportedOperationException("Instruction is not defined for Binary operation: " + (Object)((Object)op));
    }

    @Override
    public String getInstructions(String input1, String input2, String output) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getExecType());
        sb.append("\u00b0");
        sb.append(this.getOpcode());
        sb.append("\u00b0");
        sb.append(this.getInputs().get(0).prepInputOperand(input1));
        sb.append("\u00b0");
        sb.append(this.getInputs().get(1).prepInputOperand(input2));
        sb.append("\u00b0");
        sb.append(this.prepOutputOperand(output));
        if (this.operation == OperationTypes.MATMULT && this.getExecType() == LopProperties.ExecType.CP) {
            sb.append("\u00b0");
            sb.append(this.numThreads);
        } else if (this.operation == OperationTypes.MATMULT && this.getExecType() == LopProperties.ExecType.GPU) {
            sb.append("\u00b0");
            sb.append(this.isLeftTransposed);
            sb.append("\u00b0");
            sb.append(this.isRightTransposed);
        }
        return sb.toString();
    }

    public static enum OperationTypes {
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        MINUS1_MULTIPLY,
        MODULUS,
        INTDIV,
        MATMULT,
        LESS_THAN,
        LESS_THAN_OR_EQUALS,
        GREATER_THAN,
        GREATER_THAN_OR_EQUALS,
        EQUALS,
        NOT_EQUALS,
        AND,
        OR,
        XOR,
        MAX,
        MIN,
        POW,
        SOLVE,
        NOTSUPPORTED,
        BW_AND,
        BW_OR,
        BW_XOR,
        BW_SHIFTL,
        BW_SHIFTR;

    }
}

