/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.hops.rewrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.hops.DataOp;
import org.tugraz.sysds.hops.Hop;
import org.tugraz.sysds.hops.rewrite.HopRewriteRule;
import org.tugraz.sysds.hops.rewrite.ProgramRewriteStatus;
import org.tugraz.sysds.runtime.controlprogram.LocalVariableMap;
import org.tugraz.sysds.runtime.controlprogram.caching.CacheableData;
import org.tugraz.sysds.runtime.instructions.cp.Data;
import org.tugraz.sysds.runtime.matrix.data.InputInfo;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;
import org.tugraz.sysds.runtime.meta.MetaData;
import org.tugraz.sysds.runtime.meta.MetaDataFormat;

public class RewriteRemovePersistentReadWrite
extends HopRewriteRule {
    private HashSet<String> _inputs = new HashSet();
    private HashSet<String> _outputs = null;
    private HashMap<String, MetaData> _inputsMeta = null;

    public RewriteRemovePersistentReadWrite(String[] in, String[] out) {
        this(in, out, null);
    }

    public RewriteRemovePersistentReadWrite(String[] in, String[] out, LocalVariableMap vars) {
        for (String var : in) {
            this._inputs.add(var);
        }
        this._outputs = new HashSet();
        for (String var : out) {
            this._outputs.add(var);
        }
        this._inputsMeta = new HashMap();
        if (vars != null) {
            for (String varname : in) {
                Data dat = vars.get(varname);
                if (dat == null || !(dat instanceof CacheableData)) continue;
                this._inputsMeta.put(varname, ((CacheableData)dat).getMetaData());
            }
        }
    }

    @Override
    public ArrayList<Hop> rewriteHopDAGs(ArrayList<Hop> roots, ProgramRewriteStatus state) {
        if (roots == null) {
            return null;
        }
        for (Hop h : roots) {
            this.rule_RemovePersistentDataOp(h);
        }
        return roots;
    }

    @Override
    public Hop rewriteHopDAG(Hop root, ProgramRewriteStatus state) {
        if (root == null) {
            return root;
        }
        this.rule_RemovePersistentDataOp(root);
        return root;
    }

    private void rule_RemovePersistentDataOp(Hop hop) {
        if (hop.isVisited()) {
            return;
        }
        ArrayList<Hop> inputs = hop.getInput();
        for (int i = 0; i < inputs.size(); ++i) {
            this.rule_RemovePersistentDataOp(inputs.get(i));
        }
        if (hop instanceof DataOp) {
            DataOp dop = (DataOp)hop;
            Types.OpOpData dotype = dop.getOp();
            switch (dotype) {
                case PERSISTENTREAD: {
                    if (this._inputs.contains(dop.getName())) {
                        boolean matchingBlksz;
                        dop.setDataOpType(Types.OpOpData.TRANSIENTREAD);
                        if (hop.getDataType() == Types.DataType.SCALAR) {
                            dop.removeInput("iofilename");
                        }
                        if (!dop.requiresReblock() || !this._inputsMeta.containsKey(dop.getName()) || !(this._inputsMeta.get(dop.getName()) instanceof MetaDataFormat)) break;
                        MetaDataFormat meta = (MetaDataFormat)this._inputsMeta.get(dop.getName());
                        DataCharacteristics dc = meta.getDataCharacteristics();
                        boolean bl = matchingBlksz = dc.getBlocksize() == dop.getBlocksize();
                        if (meta.getInputInfo() != InputInfo.BinaryBlockInputInfo || !matchingBlksz && dop.getDataType() != Types.DataType.FRAME) break;
                        dop.setRequiresReblock(false);
                        break;
                    }
                    LOG.warn((Object)("Non-registered persistent read of variable '" + dop.getName() + "' (line " + dop.getBeginLine() + ")."));
                    break;
                }
                case PERSISTENTWRITE: {
                    if (this._outputs.contains(dop.getName())) {
                        dop.setDataOpType(Types.OpOpData.TRANSIENTWRITE);
                        dop.setBlocksize(dop.getInput().get(0).getBlocksize());
                        if (hop.getDataType() != Types.DataType.SCALAR) break;
                        dop.removeInput("iofilename");
                        break;
                    }
                    LOG.warn((Object)("Non-registered persistent write of variable '" + dop.getName() + "' (line " + dop.getBeginLine() + ")."));
                    break;
                }
            }
        }
        hop.setVisited();
    }
}

