/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.hops.rewrite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.tugraz.sysds.api.DMLScript;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.hops.AggUnaryOp;
import org.tugraz.sysds.hops.BinaryOp;
import org.tugraz.sysds.hops.DataOp;
import org.tugraz.sysds.hops.DnnOp;
import org.tugraz.sysds.hops.FunctionOp;
import org.tugraz.sysds.hops.Hop;
import org.tugraz.sysds.hops.LiteralOp;
import org.tugraz.sysds.hops.OptimizerUtils;
import org.tugraz.sysds.hops.ReorgOp;
import org.tugraz.sysds.hops.UnaryOp;
import org.tugraz.sysds.hops.rewrite.HopRewriteRule;
import org.tugraz.sysds.hops.rewrite.HopRewriteUtils;
import org.tugraz.sysds.hops.rewrite.ProgramRewriteStatus;
import org.tugraz.sysds.runtime.instructions.gpu.context.GPUContextPool;

public class RewriteGPUSpecificOps
extends HopRewriteRule {
    private static int _seq = 1;

    @Override
    public ArrayList<Hop> rewriteHopDAGs(ArrayList<Hop> roots, ProgramRewriteStatus state) {
        int i;
        if (roots == null) {
            return roots;
        }
        for (i = 0; i < roots.size(); ++i) {
            this.rule_GPUKernels(roots, roots.get(i), false);
        }
        Hop.resetVisitStatus(roots, true);
        for (i = 0; i < roots.size(); ++i) {
            this.rule_GPUKernels(roots, roots.get(i), true);
        }
        Hop.resetVisitStatus(roots, true);
        return roots;
    }

    @Override
    public Hop rewriteHopDAG(Hop root, ProgramRewriteStatus state) {
        if (root == null) {
            return root;
        }
        this.rule_GPUKernels(null, root, false);
        root.resetVisitStatus();
        this.rule_GPUKernels(null, root, true);
        return root;
    }

    private void rule_GPUKernels(ArrayList<Hop> roots, Hop hop, boolean descendFirst) {
        if (hop.isVisited()) {
            return;
        }
        for (int i = 0; i < hop.getInput().size(); ++i) {
            Hop hi = hop.getInput().get(i);
            if (descendFirst) {
                this.rule_GPUKernels(roots, hi, descendFirst);
            }
            if (roots != null) {
                // empty if block
            }
            hi = RewriteGPUSpecificOps.batchNormTest(hop, hi, i);
            hi = RewriteGPUSpecificOps.channelSums(hop, hi, i);
            hi = RewriteGPUSpecificOps.updateNesterovX(hop, hi, i);
            if (descendFirst) continue;
            this.rule_GPUKernels(roots, hi, descendFirst);
        }
        hop.setVisited();
    }

    private static boolean isBiasAdd(Hop h) {
        return HopRewriteUtils.isDnn(h, Types.OpOpDnn.BIASADD);
    }

    private static boolean isBiasMultiply(Hop h) {
        return HopRewriteUtils.isDnn(h, Types.OpOpDnn.BIASMULT);
    }

    private static boolean fitsOnGPU(Hop h, double multiplier) {
        double memEst = multiplier * h.getMemEstimate();
        return DMLScript.USE_ACCELERATOR && h.dimsKnown() && OptimizerUtils.isMemoryBasedOptLevel() && memEst < OptimizerUtils.getLocalMemBudget() && memEst < (double)GPUContextPool.initialGPUMemBudget();
    }

    private static boolean fitsOnGPU(ArrayList<Hop> inputHops, boolean isFirstSameSizeAsOutput) {
        return RewriteGPUSpecificOps.fitsOnGPU(inputHops, isFirstSameSizeAsOutput, 0L);
    }

    private static boolean fitsOnGPU(ArrayList<Hop> inputHops, boolean isFirstSameSizeAsOutput, long additionalBytes) {
        double memEst = additionalBytes;
        boolean isFirst = true;
        for (Hop h : inputHops) {
            double est = h.getMemEstimate();
            if (est == -1.0) {
                return false;
            }
            if (isFirst && isFirstSameSizeAsOutput) {
                isFirst = false;
                memEst += 2.0 * est;
                continue;
            }
            memEst += est;
        }
        return DMLScript.USE_ACCELERATOR && OptimizerUtils.isMemoryBasedOptLevel() && memEst < OptimizerUtils.getLocalMemBudget() && memEst < (double)GPUContextPool.initialGPUMemBudget();
    }

    private static boolean hasFirstInput(Hop h) {
        return h != null && h.getInput() != null && h.getInput().size() >= 1;
    }

    private static Hop getFirstInput(Hop h) {
        if (h == null || h.getInput() == null || h.getInput().size() < 1) {
            throw new RuntimeException("No input available for " + h);
        }
        return h.getInput().get(0);
    }

    private static boolean hasSecondInput(Hop h) {
        return h != null && h.getInput() != null && h.getInput().size() >= 2;
    }

    private static Hop getSecondInput(Hop h) {
        if (h == null || h.getInput() == null || h.getInput().size() < 2) {
            throw new RuntimeException("Expected atleast two inputs for " + h);
        }
        return h.getInput().get(1);
    }

    private static Hop getThirdInput(Hop h) {
        if (h == null || h.getInput() == null || h.getInput().size() < 3) {
            throw new RuntimeException("Expected atleast three inputs for " + h);
        }
        return h.getInput().get(2);
    }

    private static boolean isUnaryMinus(Hop h) {
        return HopRewriteUtils.isBinary(h, Hop.OpOp2.MINUS) && HopRewriteUtils.isLiteralOfValue(h.getInput().get(0), 0.0);
    }

    private static boolean isOneDivideBySqrt(Hop h) {
        return HopRewriteUtils.isBinary(h, Hop.OpOp2.DIV) && HopRewriteUtils.isUnary(h.getInput().get(1), Hop.OpOp1.SQRT) && HopRewriteUtils.isLiteralOfValue(h.getInput().get(0), 1.0);
    }

    private static Hop channelSums(Hop parent, Hop hi, int pos) {
        Hop colSumsInput;
        AggUnaryOp hop;
        if (hi instanceof AggUnaryOp && (hop = (AggUnaryOp)hi).getOp() == Types.AggOp.SUM && hop.getDirection() == Types.Direction.Row && HopRewriteUtils.isReorg(hop.getInput().get(0), Types.ReOrgOp.RESHAPE) && (colSumsInput = hop.getInput().get(0).getInput().get(0)) instanceof AggUnaryOp && ((AggUnaryOp)colSumsInput).getOp() == Types.AggOp.SUM && ((AggUnaryOp)colSumsInput).getDirection() == Types.Direction.Col) {
            ArrayList<Hop> inHops = new ArrayList<Hop>();
            inHops.add(colSumsInput.getInput().get(0));
            long numChannels = Hop.computeSizeInformation(hop.getInput().get(0).getInput().get(1));
            long HW = Hop.computeSizeInformation(hop.getInput().get(0).getInput().get(2));
            if (numChannels > 0L && HW > 0L && RewriteGPUSpecificOps.fitsOnGPU(inHops, false, numChannels * 8L)) {
                inHops.add(new LiteralOp(numChannels));
                inHops.add(new LiteralOp(HW));
                LOG.debug((Object)"Applied channelSums rewrite.");
                DnnOp newHop = new DnnOp(hi.getName(), hi.getDataType(), hi.getValueType(), Types.OpOpDnn.CHANNEL_SUMS, inHops);
                return HopRewriteUtils.rewireAllParentChildReferences(hi, newHop);
            }
        }
        return hi;
    }

    private static boolean isRowMeans(Hop h) {
        return h instanceof AggUnaryOp && ((AggUnaryOp)h).getOp() == Types.AggOp.MEAN && ((AggUnaryOp)h).getDirection() == Types.Direction.Row;
    }

    private static boolean isRowVars(Hop h) {
        return h instanceof AggUnaryOp && ((AggUnaryOp)h).getOp() == Types.AggOp.VAR && ((AggUnaryOp)h).getDirection() == Types.Direction.Row;
    }

    private static boolean isRowVars(Hop h, Hop childHop) {
        return RewriteGPUSpecificOps.isRowVars(h) && RewriteGPUSpecificOps.getFirstInput(h) == childHop;
    }

    private static boolean isColMeans(Hop h) {
        return h instanceof AggUnaryOp && ((AggUnaryOp)h).getOp() == Types.AggOp.MEAN && ((AggUnaryOp)h).getDirection() == Types.Direction.Col;
    }

    private static boolean isColVars(Hop h) {
        return h instanceof AggUnaryOp && ((AggUnaryOp)h).getOp() == Types.AggOp.VAR && ((AggUnaryOp)h).getDirection() == Types.Direction.Col;
    }

    private static boolean isReshape(Hop h) {
        return h instanceof ReorgOp && ((ReorgOp)h).getOp() == Types.ReOrgOp.RESHAPE;
    }

    private static boolean isReshape(Hop h, long expectedRows, long expectedCols) {
        return h instanceof ReorgOp && ((ReorgOp)h).getOp() == Types.ReOrgOp.RESHAPE && Hop.computeSizeInformation(RewriteGPUSpecificOps.getSecondInput(h)) == expectedRows && Hop.computeSizeInformation(RewriteGPUSpecificOps.getThirdInput(h)) == expectedCols;
    }

    private static boolean isBinaryAdd(Hop h) {
        return h instanceof BinaryOp && ((BinaryOp)h).getOp() == Hop.OpOp2.PLUS;
    }

    private static boolean isBinaryMSAdd(Hop h, double expectedValue) {
        return h instanceof BinaryOp && ((BinaryOp)h).getOp() == Hop.OpOp2.PLUS && RewriteGPUSpecificOps.getFirstInput(h).getDataType() == Types.DataType.MATRIX && RewriteGPUSpecificOps.getSecondInput(h).getDataType() == Types.DataType.SCALAR && OptimizerUtils.rEvalSimpleDoubleExpression(RewriteGPUSpecificOps.getSecondInput(h), new HashMap<Long, Double>()) == expectedValue;
    }

    private static boolean isBinaryMMAdd(Hop h) {
        return h instanceof BinaryOp && ((BinaryOp)h).getOp() == Hop.OpOp2.PLUS && RewriteGPUSpecificOps.getFirstInput(h).getDataType() == Types.DataType.MATRIX && RewriteGPUSpecificOps.getSecondInput(h).getDataType() == Types.DataType.MATRIX;
    }

    private static boolean isBinaryMMMinus(Hop h) {
        return h instanceof BinaryOp && ((BinaryOp)h).getOp() == Hop.OpOp2.MINUS && RewriteGPUSpecificOps.getFirstInput(h).getDataType() == Types.DataType.MATRIX && RewriteGPUSpecificOps.getSecondInput(h).getDataType() == Types.DataType.MATRIX;
    }

    private static boolean isBinaryMSMult(Hop h, double expectedValue) {
        return h instanceof BinaryOp && ((BinaryOp)h).getOp() == Hop.OpOp2.MULT && RewriteGPUSpecificOps.getFirstInput(h).getDataType() == Types.DataType.MATRIX && RewriteGPUSpecificOps.getSecondInput(h).getDataType() == Types.DataType.SCALAR && OptimizerUtils.rEvalSimpleDoubleExpression(RewriteGPUSpecificOps.getSecondInput(h), new HashMap<Long, Double>()) == expectedValue;
    }

    private static boolean isBinarySSMinus(Hop h) {
        return h instanceof BinaryOp && ((BinaryOp)h).getOp() == Hop.OpOp2.MINUS && RewriteGPUSpecificOps.getFirstInput(h).getDataType() == Types.DataType.SCALAR && RewriteGPUSpecificOps.getSecondInput(h).getDataType() == Types.DataType.SCALAR;
    }

    private static boolean isBinarySSDiv(Hop h) {
        return h instanceof BinaryOp && ((BinaryOp)h).getOp() == Hop.OpOp2.DIV && RewriteGPUSpecificOps.getFirstInput(h).getDataType() == Types.DataType.SCALAR && RewriteGPUSpecificOps.getSecondInput(h).getDataType() == Types.DataType.SCALAR;
    }

    private static boolean isBinarySMDiv(Hop h, double expectedValue) {
        return h instanceof BinaryOp && ((BinaryOp)h).getOp() == Hop.OpOp2.DIV && RewriteGPUSpecificOps.getFirstInput(h).getDataType() == Types.DataType.SCALAR && RewriteGPUSpecificOps.getSecondInput(h).getDataType() == Types.DataType.MATRIX && OptimizerUtils.rEvalSimpleDoubleExpression(RewriteGPUSpecificOps.getFirstInput(h), new HashMap<Long, Double>()) == expectedValue;
    }

    private static boolean isAnyBinaryAdd(ArrayList<Hop> hops) {
        if (hops != null) {
            for (Hop h : hops) {
                if (!(h instanceof BinaryOp) || ((BinaryOp)h).getOp() != Hop.OpOp2.PLUS) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isBinaryMSMult(Hop h) {
        return h instanceof BinaryOp && ((BinaryOp)h).getOp() == Hop.OpOp2.MULT && RewriteGPUSpecificOps.getFirstInput(h).getDataType() == Types.DataType.MATRIX && RewriteGPUSpecificOps.getSecondInput(h).getDataType() == Types.DataType.SCALAR;
    }

    private static boolean isBinarySMMult(Hop h) {
        return h instanceof BinaryOp && ((BinaryOp)h).getOp() == Hop.OpOp2.MULT && RewriteGPUSpecificOps.getSecondInput(h).getDataType() == Types.DataType.MATRIX && RewriteGPUSpecificOps.getFirstInput(h).getDataType() == Types.DataType.SCALAR;
    }

    private static boolean isBinarySMMult(Hop h, double expectedVal) {
        return h instanceof BinaryOp && ((BinaryOp)h).getOp() == Hop.OpOp2.MULT && RewriteGPUSpecificOps.getSecondInput(h).getDataType() == Types.DataType.MATRIX && RewriteGPUSpecificOps.getFirstInput(h).getDataType() == Types.DataType.SCALAR && RewriteGPUSpecificOps.getValue(RewriteGPUSpecificOps.getFirstInput(h)) == expectedVal;
    }

    private static double getValue(Hop h) {
        return OptimizerUtils.rEvalSimpleDoubleExpression(h, new HashMap<Long, Double>());
    }

    private static boolean isBatchNormTrainMean(Hop mean, Hop X) {
        return RewriteGPUSpecificOps.isRowMeans(mean) && RewriteGPUSpecificOps.isReshape(RewriteGPUSpecificOps.getFirstInput(mean)) && RewriteGPUSpecificOps.isColMeans(RewriteGPUSpecificOps.getFirstInput(RewriteGPUSpecificOps.getFirstInput(mean))) && RewriteGPUSpecificOps.getFirstInput(RewriteGPUSpecificOps.getFirstInput(RewriteGPUSpecificOps.getFirstInput(mean))) == X;
    }

    private static boolean isNrowOfX(Hop expr, Hop X) {
        return expr instanceof UnaryOp && ((UnaryOp)expr).getOp() == Hop.OpOp1.NROW && RewriteGPUSpecificOps.getFirstInput(expr) == X;
    }

    private static boolean isCorrectedColVars(Hop expr, Hop X, boolean ignoreCorrectionTerm) {
        if (RewriteGPUSpecificOps.isColVars(expr) && RewriteGPUSpecificOps.getFirstInput(expr) == X) {
            return true;
        }
        if (X.rowsKnown()) {
            return RewriteGPUSpecificOps.isBinaryMSMult(expr, ((double)X.getDim1() - 1.0) / (double)X.getDim1()) && RewriteGPUSpecificOps.isColVars(RewriteGPUSpecificOps.getFirstInput(expr)) && RewriteGPUSpecificOps.getFirstInput(RewriteGPUSpecificOps.getFirstInput(expr)) == X;
        }
        if (RewriteGPUSpecificOps.isBinaryMSMult(expr) && RewriteGPUSpecificOps.isColVars(RewriteGPUSpecificOps.getFirstInput(expr)) && RewriteGPUSpecificOps.getFirstInput(RewriteGPUSpecificOps.getFirstInput(expr)) == X) {
            boolean ret;
            if (ignoreCorrectionTerm) {
                return true;
            }
            Hop tmp = RewriteGPUSpecificOps.getSecondInput(expr);
            boolean isNMinus1Pattern = RewriteGPUSpecificOps.isBinarySSDiv(tmp) && RewriteGPUSpecificOps.isBinarySSMinus(RewriteGPUSpecificOps.getFirstInput(tmp)) && RewriteGPUSpecificOps.getFirstInput(RewriteGPUSpecificOps.getFirstInput(tmp)) == RewriteGPUSpecificOps.getSecondInput(tmp) && OptimizerUtils.rEvalSimpleDoubleExpression(RewriteGPUSpecificOps.getSecondInput(RewriteGPUSpecificOps.getFirstInput(tmp)), new HashMap<Long, Double>()) == 1.0;
            boolean bl = ret = isNMinus1Pattern && RewriteGPUSpecificOps.isNrowOfX(RewriteGPUSpecificOps.getSecondInput(tmp), X);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Is the corrected column variance pattern for batch_norm_train rewrite when number of rows of X unknown matched:" + ret));
            }
            return ret;
        }
        return false;
    }

    private static boolean isBatchNormTrainVar(Hop mean, Hop var, Hop X, Hop subgrpMeans, boolean ignoreCorrectionTerm) {
        long numChannels = Hop.computeSizeInformation(RewriteGPUSpecificOps.getSecondInput(RewriteGPUSpecificOps.getFirstInput(mean)));
        long HW = Hop.computeSizeInformation(RewriteGPUSpecificOps.getThirdInput(RewriteGPUSpecificOps.getFirstInput(mean)));
        return numChannels > 0L && HW > 0L && RewriteGPUSpecificOps.isBinaryMMAdd(var) && RewriteGPUSpecificOps.isRowMeans(RewriteGPUSpecificOps.getFirstInput(var)) && RewriteGPUSpecificOps.isReshape(RewriteGPUSpecificOps.getFirstInput(RewriteGPUSpecificOps.getFirstInput(var)), numChannels, HW) && RewriteGPUSpecificOps.isCorrectedColVars(RewriteGPUSpecificOps.getFirstInput(RewriteGPUSpecificOps.getFirstInput(RewriteGPUSpecificOps.getFirstInput(var))), X, ignoreCorrectionTerm) && RewriteGPUSpecificOps.isBinaryMSMult(RewriteGPUSpecificOps.getSecondInput(var), ((double)HW - 1.0) / (double)HW) && RewriteGPUSpecificOps.isRowVars(RewriteGPUSpecificOps.getFirstInput(RewriteGPUSpecificOps.getSecondInput(var)), subgrpMeans);
    }

    private static Hop[] getUpdatedMovingAverageExpressions(Hop rhsTimesOp, double mu) {
        if (rhsTimesOp == null || rhsTimesOp.getParent() == null || rhsTimesOp.getParent().size() != 1 || !RewriteGPUSpecificOps.isBinarySMMult(rhsTimesOp) || !RewriteGPUSpecificOps.isBinaryAdd(rhsTimesOp.getParent().get(0))) {
            return null;
        }
        double expectedOneMinusMu = OptimizerUtils.rEvalSimpleDoubleExpression(RewriteGPUSpecificOps.getFirstInput(rhsTimesOp), new HashMap<Long, Double>());
        Hop plusOp = rhsTimesOp.getParent().get(0);
        Hop lhsTimesOp = null;
        lhsTimesOp = plusOp.getInput().get(0) == rhsTimesOp ? plusOp.getInput().get(1) : plusOp.getInput().get(0);
        if (expectedOneMinusMu == 1.0 - mu && plusOp.getParent() != null && plusOp.getParent().size() == 1 && RewriteGPUSpecificOps.isBinarySMMult(lhsTimesOp) && OptimizerUtils.rEvalSimpleDoubleExpression(RewriteGPUSpecificOps.getFirstInput(lhsTimesOp), new HashMap<Long, Double>()) == mu) {
            return new Hop[]{plusOp.getParent().get(0), RewriteGPUSpecificOps.getSecondInput(lhsTimesOp), RewriteGPUSpecificOps.getSecondInput(rhsTimesOp)};
        }
        return null;
    }

    private static Hop[] getUpdatedMovingAverageExpressions(ArrayList<Hop> rhsTimesOps, double mu) {
        if (rhsTimesOps == null || rhsTimesOps.size() == 0) {
            return null;
        }
        Hop[] ret = null;
        for (Hop h : rhsTimesOps) {
            boolean matched = RewriteGPUSpecificOps.isUpdatedMovingAverageExpression(h, mu);
            if (matched && ret != null) {
                return null;
            }
            if (!matched) continue;
            ret = RewriteGPUSpecificOps.getUpdatedMovingAverageExpressions(h, mu);
        }
        return ret;
    }

    private static Double getMuFromUpdatedMovingAverageExpressions(ArrayList<Hop> rhsTimesOps) {
        if (rhsTimesOps == null || rhsTimesOps.size() == 0) {
            return null;
        }
        Double ret = null;
        for (Hop h : rhsTimesOps) {
            boolean matched = RewriteGPUSpecificOps.isUpdatedMovingAverageExpression(h);
            if (matched && ret != null) {
                return null;
            }
            if (!matched) continue;
            ret = -(OptimizerUtils.rEvalSimpleDoubleExpression(RewriteGPUSpecificOps.getFirstInput(h), new HashMap<Long, Double>()) - 1.0);
        }
        return ret;
    }

    private static boolean isUpdatedMovingAverageExpression(Hop rhsTimesOp) {
        if (rhsTimesOp == null || rhsTimesOp.getParent() == null || rhsTimesOp.getParent().size() != 1 || !RewriteGPUSpecificOps.isBinarySMMult(rhsTimesOp) || !RewriteGPUSpecificOps.isBinaryAdd(rhsTimesOp.getParent().get(0))) {
            return false;
        }
        Hop plusOp = rhsTimesOp.getParent().get(0);
        Hop lhsTimesOp = null;
        lhsTimesOp = plusOp.getInput().get(0) == rhsTimesOp ? plusOp.getInput().get(1) : plusOp.getInput().get(0);
        return plusOp.getParent() != null && plusOp.getParent().size() == 1 && RewriteGPUSpecificOps.isBinarySMMult(lhsTimesOp);
    }

    private static boolean isUpdatedMovingAverageExpression(Hop rhsTimesOp, double mu) {
        if (rhsTimesOp == null || rhsTimesOp.getParent() == null || rhsTimesOp.getParent().size() != 1 || !RewriteGPUSpecificOps.isBinarySMMult(rhsTimesOp) || !RewriteGPUSpecificOps.isBinaryAdd(rhsTimesOp.getParent().get(0))) {
            return false;
        }
        double expectedOneMinusMu = OptimizerUtils.rEvalSimpleDoubleExpression(RewriteGPUSpecificOps.getFirstInput(rhsTimesOp), new HashMap<Long, Double>());
        Hop plusOp = rhsTimesOp.getParent().get(0);
        Hop lhsTimesOp = null;
        lhsTimesOp = plusOp.getInput().get(0) == rhsTimesOp ? plusOp.getInput().get(1) : plusOp.getInput().get(0);
        return expectedOneMinusMu == 1.0 - mu && plusOp.getParent() != null && plusOp.getParent().size() == 1 && RewriteGPUSpecificOps.isBinarySMMult(lhsTimesOp) && OptimizerUtils.rEvalSimpleDoubleExpression(RewriteGPUSpecificOps.getFirstInput(lhsTimesOp), new HashMap<Long, Double>()) == mu;
    }

    private static boolean isOneBySqrt(Hop denom) {
        return denom.getParent() != null && denom.getParent().get(0) instanceof UnaryOp && ((UnaryOp)denom.getParent().get(0)).getOp() == Hop.OpOp1.SQRT && denom.getParent().get(0).getParent() != null && denom.getParent().get(0).getParent().size() == 1 && RewriteGPUSpecificOps.isBinarySMDiv(denom.getParent().get(0).getParent().get(0), 1.0);
    }

    private static Hop batchNormTrain(ArrayList<Hop> roots, Hop parent, Hop hi, int pos) {
        Hop norm;
        if (RewriteGPUSpecificOps.hasFirstInput(hi) && RewriteGPUSpecificOps.isBiasAdd(hi) && RewriteGPUSpecificOps.isBiasMultiply(RewriteGPUSpecificOps.getFirstInput(hi)) && RewriteGPUSpecificOps.hasSecondInput(norm = RewriteGPUSpecificOps.getFirstInput(RewriteGPUSpecificOps.getFirstInput(hi))) && RewriteGPUSpecificOps.isBiasMultiply(norm) && RewriteGPUSpecificOps.isBiasAdd(RewriteGPUSpecificOps.getFirstInput(norm)) && RewriteGPUSpecificOps.hasSecondInput(RewriteGPUSpecificOps.getFirstInput(norm)) && RewriteGPUSpecificOps.isUnaryMinus(RewriteGPUSpecificOps.getSecondInput(RewriteGPUSpecificOps.getFirstInput(norm))) && RewriteGPUSpecificOps.isOneDivideBySqrt(RewriteGPUSpecificOps.getSecondInput(norm))) {
            double eps = 0.0;
            Hop var = RewriteGPUSpecificOps.getFirstInput(RewriteGPUSpecificOps.getSecondInput(RewriteGPUSpecificOps.getSecondInput(norm)));
            if (RewriteGPUSpecificOps.isBinaryAdd(var) && (RewriteGPUSpecificOps.getFirstInput(var) instanceof LiteralOp || RewriteGPUSpecificOps.getSecondInput(var) instanceof LiteralOp)) {
                if (RewriteGPUSpecificOps.getFirstInput(var) instanceof LiteralOp) {
                    eps = OptimizerUtils.rEvalSimpleDoubleExpression(RewriteGPUSpecificOps.getFirstInput(var), new HashMap<Long, Double>());
                    var = RewriteGPUSpecificOps.getSecondInput(var);
                } else {
                    eps = OptimizerUtils.rEvalSimpleDoubleExpression(RewriteGPUSpecificOps.getSecondInput(var), new HashMap<Long, Double>());
                    var = RewriteGPUSpecificOps.getFirstInput(var);
                }
            }
            Hop X = RewriteGPUSpecificOps.getFirstInput(RewriteGPUSpecificOps.getFirstInput(norm));
            Hop mean = RewriteGPUSpecificOps.getSecondInput(RewriteGPUSpecificOps.getSecondInput(RewriteGPUSpecificOps.getFirstInput(norm)));
            if (RewriteGPUSpecificOps.hasFirstInput(mean) && RewriteGPUSpecificOps.isBatchNormTrainMean(mean, X) && RewriteGPUSpecificOps.isBatchNormTrainVar(mean, var, X, RewriteGPUSpecificOps.getFirstInput(mean), false) && mean.getParent() != null && mean.getParent().size() >= 2 && var.getParent() != null && var.getParent().size() == 2) {
                Hop gamma = RewriteGPUSpecificOps.getSecondInput(RewriteGPUSpecificOps.getFirstInput(hi));
                Hop beta = RewriteGPUSpecificOps.getSecondInput(hi);
                Double potentialMu = RewriteGPUSpecificOps.getMuFromUpdatedMovingAverageExpressions(var.getParent());
                if (potentialMu == null) {
                    return hi;
                }
                double mu = potentialMu;
                Hop[] means = RewriteGPUSpecificOps.getUpdatedMovingAverageExpressions(mean.getParent(), mu);
                Hop[] vars = RewriteGPUSpecificOps.getUpdatedMovingAverageExpressions(var.getParent(), mu);
                if (means == null || vars == null) {
                    return hi;
                }
                Hop varPlusEps = null;
                boolean isFirstBinaryAddOp = RewriteGPUSpecificOps.isAnyBinaryAdd(var.getParent().get(0).getParent());
                boolean isSecondBinaryAddOp = RewriteGPUSpecificOps.isAnyBinaryAdd(var.getParent().get(1).getParent());
                if (isFirstBinaryAddOp && !isSecondBinaryAddOp) {
                    varPlusEps = var.getParent().get(1);
                } else if (!isFirstBinaryAddOp && isSecondBinaryAddOp) {
                    varPlusEps = var.getParent().get(0);
                }
                if (varPlusEps != null && RewriteGPUSpecificOps.isBinaryMSAdd(varPlusEps, eps) && RewriteGPUSpecificOps.isOneBySqrt(varPlusEps)) {
                    Hop cache_var = varPlusEps.getParent().get(0).getParent().get(0);
                    Hop ema_mean_upd = means[0];
                    Hop ema_var_upd = vars[0];
                    Hop ema_mean = means[1];
                    Hop ema_var = vars[1];
                    Hop cache_mean = means[2];
                    ArrayList<Hop> inHops = new ArrayList<Hop>();
                    inHops.add(X);
                    inHops.add(gamma);
                    inHops.add(beta);
                    inHops.add(ema_mean);
                    inHops.add(ema_var);
                    inHops.add(new LiteralOp(eps));
                    inHops.add(new LiteralOp(mu));
                    Hop[] oldHops = new Hop[]{hi, ema_mean_upd, ema_var_upd, cache_mean, cache_var};
                    if (!RewriteGPUSpecificOps.isAnyPersistentWrite(oldHops)) {
                        LOG.debug((Object)"Applied batchNormTrain rewrite.");
                        ArrayList<Hop> outputs = RewriteGPUSpecificOps.getMultiOutputHops(roots, oldHops);
                        FunctionOp ret = new FunctionOp(FunctionOp.FunctionType.MULTIRETURN_BUILTIN, "_internal", "batch_norm2d_train", null, inHops, (String[])outputs.stream().map(h -> h.getName()).toArray(String[]::new), outputs);
                        Collections.reverse(roots);
                        roots.add(ret);
                        Collections.reverse(roots);
                        return ret;
                    }
                }
            }
        }
        return hi;
    }

    private static boolean isAnyPersistentWrite(Hop[] outputHops) {
        for (Hop outHop : outputHops) {
            if (!HopRewriteUtils.isData(outHop, Types.OpOpData.PERSISTENTWRITE)) continue;
            return true;
        }
        return false;
    }

    private static ArrayList<Hop> getMultiOutputHops(ArrayList<Hop> roots, Hop[] oldHops) {
        ArrayList<Hop> ret = new ArrayList<Hop>();
        for (int i = 0; i < oldHops.length; ++i) {
            if (HopRewriteUtils.isData(oldHops[i], Types.OpOpData.PERSISTENTWRITE)) {
                throw new RuntimeException("Persistent write is not supported as output for the given rewrite." + oldHops[i]);
            }
            String name = HopRewriteUtils.isData(oldHops[i], Types.OpOpData.TRANSIENTWRITE) ? oldHops[i].getName() : "_genGPU" + _seq++;
            DataOp tRead = HopRewriteUtils.createTransientRead(name, oldHops[i]);
            HopRewriteUtils.rewireAllParentChildReferences(oldHops[i], tRead);
            ret.add(tRead);
            if (!roots.contains(oldHops[i])) continue;
            roots.remove(oldHops[i]);
        }
        return ret;
    }

    private static Hop updateNesterovX(Hop parent, Hop hi, int pos) {
        Hop tmp;
        Hop mu;
        Hop onePlusMu;
        if (RewriteGPUSpecificOps.fitsOnGPU(hi, 4.0) && RewriteGPUSpecificOps.isBinaryMMAdd(hi) && RewriteGPUSpecificOps.isBinaryMMMinus(RewriteGPUSpecificOps.getFirstInput(hi)) && RewriteGPUSpecificOps.isBinarySMMult(RewriteGPUSpecificOps.getSecondInput(RewriteGPUSpecificOps.getFirstInput(hi))) && RewriteGPUSpecificOps.isBinarySMMult(RewriteGPUSpecificOps.getSecondInput(hi)) && RewriteGPUSpecificOps.isOnePlusMu(onePlusMu = RewriteGPUSpecificOps.getFirstInput(RewriteGPUSpecificOps.getSecondInput(hi)), mu = RewriteGPUSpecificOps.getFirstInput(tmp = RewriteGPUSpecificOps.getSecondInput(RewriteGPUSpecificOps.getFirstInput(hi))))) {
            Hop v_prev = RewriteGPUSpecificOps.getSecondInput(tmp);
            Hop v = RewriteGPUSpecificOps.getSecondInput(RewriteGPUSpecificOps.getSecondInput(hi));
            Hop X = RewriteGPUSpecificOps.getFirstInput(RewriteGPUSpecificOps.getFirstInput(hi));
            if (RewriteGPUSpecificOps.hasSameDimensions(X, v) && RewriteGPUSpecificOps.hasSameDimensions(X, v_prev)) {
                ArrayList<Hop> inHops = new ArrayList<Hop>();
                inHops.add(X);
                inHops.add(v);
                inHops.add(v_prev);
                inHops.add(mu);
                LOG.debug((Object)"Applied updateNesterovX rewrite.");
                DnnOp newHop = new DnnOp(hi.getName(), hi.getDataType(), hi.getValueType(), Types.OpOpDnn.UPDATE_NESTEROV_X, inHops);
                return HopRewriteUtils.rewireAllParentChildReferences(hi, newHop);
            }
        }
        return hi;
    }

    private static boolean hasSameDimensions(Hop x, Hop y) {
        return x.dimsKnown() && y.dimsKnown() && x.getDim1() == y.getDim1() && x.getDim2() == y.getDim2();
    }

    private static boolean isOnePlusMu(Hop onePlusMu, Hop mu) {
        return RewriteGPUSpecificOps.isBinarySMMult(onePlusMu, 1.0) && RewriteGPUSpecificOps.getSecondInput(onePlusMu) == mu || RewriteGPUSpecificOps.getValue(onePlusMu) == RewriteGPUSpecificOps.getValue(mu) + 1.0;
    }

    private static Hop batchNormTest(Hop parent, Hop hi, int pos) {
        Hop norm;
        if (RewriteGPUSpecificOps.hasFirstInput(hi) && RewriteGPUSpecificOps.isBiasAdd(hi) && RewriteGPUSpecificOps.isBiasMultiply(RewriteGPUSpecificOps.getFirstInput(hi)) && RewriteGPUSpecificOps.fitsOnGPU(hi, 3.0) && RewriteGPUSpecificOps.hasSecondInput(norm = RewriteGPUSpecificOps.getFirstInput(RewriteGPUSpecificOps.getFirstInput(hi))) && RewriteGPUSpecificOps.isBiasMultiply(norm) && RewriteGPUSpecificOps.isBiasAdd(RewriteGPUSpecificOps.getFirstInput(norm)) && RewriteGPUSpecificOps.isUnaryMinus(RewriteGPUSpecificOps.getSecondInput(RewriteGPUSpecificOps.getFirstInput(norm))) && RewriteGPUSpecificOps.isOneDivideBySqrt(RewriteGPUSpecificOps.getSecondInput(norm))) {
            boolean potentialForBatchNormTrain;
            double eps = 0.0;
            Hop var = RewriteGPUSpecificOps.getFirstInput(RewriteGPUSpecificOps.getSecondInput(RewriteGPUSpecificOps.getSecondInput(norm)));
            if (HopRewriteUtils.isBinary(var, Hop.OpOp2.PLUS) && (RewriteGPUSpecificOps.getFirstInput(var) instanceof LiteralOp || RewriteGPUSpecificOps.getSecondInput(var) instanceof LiteralOp)) {
                if (RewriteGPUSpecificOps.getFirstInput(var) instanceof LiteralOp) {
                    eps = OptimizerUtils.rEvalSimpleDoubleExpression(RewriteGPUSpecificOps.getFirstInput(var), new HashMap<Long, Double>());
                    var = RewriteGPUSpecificOps.getSecondInput(var);
                } else {
                    eps = OptimizerUtils.rEvalSimpleDoubleExpression(RewriteGPUSpecificOps.getSecondInput(var), new HashMap<Long, Double>());
                    var = RewriteGPUSpecificOps.getFirstInput(var);
                }
            }
            Hop X = RewriteGPUSpecificOps.getFirstInput(RewriteGPUSpecificOps.getFirstInput(norm));
            Hop mean = RewriteGPUSpecificOps.getSecondInput(RewriteGPUSpecificOps.getSecondInput(RewriteGPUSpecificOps.getFirstInput(norm)));
            boolean bl = potentialForBatchNormTrain = !X.rowsKnown() && RewriteGPUSpecificOps.isBatchNormTrainMean(mean, X) && RewriteGPUSpecificOps.isBatchNormTrainVar(mean, var, X, RewriteGPUSpecificOps.getFirstInput(mean), true);
            if (!potentialForBatchNormTrain) {
                Hop gamma = RewriteGPUSpecificOps.getSecondInput(RewriteGPUSpecificOps.getFirstInput(hi));
                Hop beta = RewriteGPUSpecificOps.getSecondInput(hi);
                ArrayList<Hop> inHops = new ArrayList<Hop>();
                inHops.add(X);
                inHops.add(gamma);
                inHops.add(beta);
                inHops.add(mean);
                inHops.add(var);
                inHops.add(new LiteralOp(eps));
                if (RewriteGPUSpecificOps.fitsOnGPU(inHops, true)) {
                    LOG.debug((Object)"Applied batchNormTest rewrite.");
                    DnnOp newHop = new DnnOp(hi.getName(), hi.getDataType(), hi.getValueType(), Types.OpOpDnn.BATCH_NORM2D_TEST, inHops);
                    return HopRewriteUtils.rewireAllParentChildReferences(hi, newHop);
                }
            } else {
                LOG.debug((Object)"Skipping batchNormTest rewrite as there is potential for batch normalization train rewrite after recompilation.");
            }
        }
        return hi;
    }
}

