/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.hops.rewrite;

import java.util.ArrayList;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.hops.BinaryOp;
import org.tugraz.sysds.hops.DataOp;
import org.tugraz.sysds.hops.Hop;
import org.tugraz.sysds.hops.LiteralOp;
import org.tugraz.sysds.hops.UnaryOp;
import org.tugraz.sysds.hops.recompile.Recompiler;
import org.tugraz.sysds.hops.rewrite.HopRewriteRule;
import org.tugraz.sysds.hops.rewrite.HopRewriteUtils;
import org.tugraz.sysds.hops.rewrite.ProgramRewriteStatus;
import org.tugraz.sysds.lops.Lop;
import org.tugraz.sysds.lops.compile.Dag;
import org.tugraz.sysds.runtime.controlprogram.BasicProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.Program;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContextFactory;
import org.tugraz.sysds.runtime.instructions.Instruction;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObject;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObjectFactory;

public class RewriteConstantFolding
extends HopRewriteRule {
    private static final String TMP_VARNAME = "__cf_tmp";
    private BasicProgramBlock _tmpPB = null;
    private ExecutionContext _tmpEC = null;

    @Override
    public ArrayList<Hop> rewriteHopDAGs(ArrayList<Hop> roots, ProgramRewriteStatus state) {
        if (roots == null) {
            return null;
        }
        for (int i = 0; i < roots.size(); ++i) {
            Hop h = roots.get(i);
            roots.set(i, this.rule_ConstantFolding(h));
        }
        return roots;
    }

    @Override
    public Hop rewriteHopDAG(Hop root, ProgramRewriteStatus state) {
        if (root == null) {
            return null;
        }
        return this.rule_ConstantFolding(root);
    }

    private Hop rule_ConstantFolding(Hop hop) {
        return this.rConstantFoldingExpression(hop);
    }

    private Hop rConstantFoldingExpression(Hop root) {
        if (root.isVisited()) {
            return root;
        }
        for (int i = 0; i < root.getInput().size(); ++i) {
            Hop h = root.getInput().get(i);
            this.rConstantFoldingExpression(h);
        }
        LiteralOp literal = null;
        if (root.getDataType() == Types.DataType.SCALAR && (RewriteConstantFolding.isApplicableBinaryOp(root) || RewriteConstantFolding.isApplicableUnaryOp(root))) {
            try {
                literal = this.evalScalarOperation(root);
            }
            catch (Exception ex) {
                LOG.error((Object)"Failed to execute constant folding instructions. No abort.", (Throwable)ex);
            }
        } else if (RewriteConstantFolding.isApplicableFalseConjunctivePredicate(root)) {
            literal = new LiteralOp(false);
        } else if (RewriteConstantFolding.isApplicableTrueDisjunctivePredicate(root)) {
            literal = new LiteralOp(true);
        }
        if (literal != null) {
            if (!root.getParent().isEmpty()) {
                ArrayList<Hop> parents = new ArrayList<Hop>(root.getParent());
                for (Hop parent : parents) {
                    HopRewriteUtils.replaceChildReference(parent, root, literal);
                }
            } else {
                root = literal;
            }
        }
        root.setVisited();
        return root;
    }

    private LiteralOp evalScalarOperation(Hop bop) {
        DataOp tmpWrite = new DataOp(TMP_VARNAME, bop.getDataType(), bop.getValueType(), bop, Types.OpOpData.TRANSIENTWRITE, TMP_VARNAME);
        Dag<Lop> dag = new Dag<Lop>();
        Recompiler.rClearLops(tmpWrite);
        Lop lops = tmpWrite.constructLops();
        lops.addToDag(dag);
        ArrayList<Instruction> inst = dag.getJobs(null, ConfigurationManager.getDMLConfig());
        ExecutionContext ec = this.getExecutionContext();
        BasicProgramBlock pb = this.getProgramBlock();
        pb.setInstructions(inst);
        pb.execute(ec);
        ScalarObject so = (ScalarObject)ec.getVariable(TMP_VARNAME);
        LiteralOp literal = ScalarObjectFactory.createLiteralOp(so);
        tmpWrite.getInput().clear();
        bop.getParent().remove(tmpWrite);
        pb.setInstructions(null);
        ec.getVariables().removeAll();
        HopRewriteUtils.setOutputParametersForScalar(literal);
        return literal;
    }

    private BasicProgramBlock getProgramBlock() {
        if (this._tmpPB == null) {
            this._tmpPB = new BasicProgramBlock(new Program());
        }
        return this._tmpPB;
    }

    private ExecutionContext getExecutionContext() {
        if (this._tmpEC == null) {
            this._tmpEC = ExecutionContextFactory.createContext();
        }
        return this._tmpEC;
    }

    private static boolean isApplicableBinaryOp(Hop hop) {
        ArrayList<Hop> in = hop.getInput();
        return hop instanceof BinaryOp && in.get(0) instanceof LiteralOp && in.get(1) instanceof LiteralOp && ((BinaryOp)hop).getOp() != Hop.OpOp2.CBIND && ((BinaryOp)hop).getOp() != Hop.OpOp2.RBIND;
    }

    private static boolean isApplicableUnaryOp(Hop hop) {
        ArrayList<Hop> in = hop.getInput();
        return hop instanceof UnaryOp && in.get(0) instanceof LiteralOp && ((UnaryOp)hop).getOp() != Hop.OpOp1.EXISTS && ((UnaryOp)hop).getOp() != Hop.OpOp1.PRINT && ((UnaryOp)hop).getOp() != Hop.OpOp1.ASSERT && ((UnaryOp)hop).getOp() != Hop.OpOp1.STOP && hop.getDataType() == Types.DataType.SCALAR;
    }

    private static boolean isApplicableFalseConjunctivePredicate(Hop hop) {
        ArrayList<Hop> in = hop.getInput();
        return HopRewriteUtils.isBinary(hop, Hop.OpOp2.AND) && hop.getDataType().isScalar() && (in.get(0) instanceof LiteralOp && !((LiteralOp)in.get(0)).getBooleanValue() || in.get(1) instanceof LiteralOp && !((LiteralOp)in.get(1)).getBooleanValue());
    }

    private static boolean isApplicableTrueDisjunctivePredicate(Hop hop) {
        ArrayList<Hop> in = hop.getInput();
        return HopRewriteUtils.isBinary(hop, Hop.OpOp2.OR) && hop.getDataType().isScalar() && (in.get(0) instanceof LiteralOp && ((LiteralOp)in.get(0)).getBooleanValue() || in.get(1) instanceof LiteralOp && ((LiteralOp)in.get(1)).getBooleanValue());
    }
}

