/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.hops.ipa;

import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.hops.HopsException;
import org.tugraz.sysds.hops.ipa.FunctionCallGraph;
import org.tugraz.sysds.hops.ipa.FunctionCallSizeInfo;
import org.tugraz.sysds.hops.ipa.IPAPass;
import org.tugraz.sysds.parser.DMLProgram;
import org.tugraz.sysds.parser.ForStatementBlock;
import org.tugraz.sysds.parser.FunctionStatement;
import org.tugraz.sysds.parser.FunctionStatementBlock;
import org.tugraz.sysds.parser.IfStatement;
import org.tugraz.sysds.parser.IfStatementBlock;
import org.tugraz.sysds.parser.LanguageException;
import org.tugraz.sysds.parser.StatementBlock;
import org.tugraz.sysds.parser.WhileStatementBlock;

public class IPAPassFlagFunctionsRecompileOnce
extends IPAPass {
    @Override
    public boolean isApplicable(FunctionCallGraph fgraph) {
        return true;
    }

    @Override
    public void rewriteProgram(DMLProgram prog, FunctionCallGraph fgraph, FunctionCallSizeInfo fcallSizes) {
        if (!ConfigurationManager.isDynamicRecompilation()) {
            return;
        }
        try {
            for (String namespaceKey : prog.getNamespaces().keySet()) {
                for (String fname : prog.getFunctionStatementBlocks(namespaceKey).keySet()) {
                    FunctionStatementBlock fsblock = prog.getFunctionStatementBlock(namespaceKey, fname);
                    if (fgraph.isRecursiveFunction(namespaceKey, fname) || !this.rFlagFunctionForRecompileOnce(fsblock, false)) continue;
                    fsblock.setRecompileOnce(true);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("IPA: FUNC flagged for recompile-once: " + DMLProgram.constructFunctionKey(namespaceKey, fname)));
                }
            }
        }
        catch (LanguageException ex) {
            throw new HopsException(ex);
        }
    }

    public boolean rFlagFunctionForRecompileOnce(StatementBlock sb, boolean inLoop) {
        boolean ret = false;
        if (sb instanceof FunctionStatementBlock) {
            FunctionStatementBlock fsb = (FunctionStatementBlock)sb;
            FunctionStatement fstmt = (FunctionStatement)fsb.getStatement(0);
            for (StatementBlock c : fstmt.getBody()) {
                ret |= this.rFlagFunctionForRecompileOnce(c, inLoop);
            }
        } else if (sb instanceof WhileStatementBlock) {
            ret = true;
        } else if (sb instanceof IfStatementBlock) {
            IfStatementBlock isb = (IfStatementBlock)sb;
            IfStatement istmt = (IfStatement)isb.getStatement(0);
            ret |= inLoop && isb.requiresPredicateRecompilation();
            for (StatementBlock c : istmt.getIfBody()) {
                ret |= this.rFlagFunctionForRecompileOnce(c, inLoop);
            }
            for (StatementBlock c : istmt.getElseBody()) {
                ret |= this.rFlagFunctionForRecompileOnce(c, inLoop);
            }
        } else {
            ret = sb instanceof ForStatementBlock ? true : (ret |= inLoop && sb.requiresRecompilation());
        }
        return ret;
    }
}

