/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.hops.estim;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tugraz.sysds.hops.HopsException;
import org.tugraz.sysds.hops.estim.MMNode;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;
import org.tugraz.sysds.runtime.meta.MatrixCharacteristics;

public abstract class SparsityEstimator {
    protected static final Log LOG = LogFactory.getLog((String)SparsityEstimator.class.getName());
    public static boolean MULTI_THREADED_BUILD = false;
    public static boolean MULTI_THREADED_ESTIM = false;
    public static final int MIN_PAR_THRESHOLD = 10240;
    private static OpCode[] EXACT_META_DATA_OPS = new OpCode[]{OpCode.EQZERO, OpCode.NEQZERO, OpCode.CBIND, OpCode.RBIND, OpCode.TRANS, OpCode.DIAG, OpCode.RESHAPE};

    public abstract DataCharacteristics estim(MMNode var1);

    public abstract double estim(MatrixBlock var1, MatrixBlock var2);

    public abstract double estim(MatrixBlock var1, MatrixBlock var2, OpCode var3);

    public abstract double estim(MatrixBlock var1, OpCode var2);

    protected boolean isExactMetadataOp(OpCode op) {
        return ArrayUtils.contains((Object[])EXACT_META_DATA_OPS, (Object)((Object)op));
    }

    protected DataCharacteristics estimExactMetaData(DataCharacteristics dc1, DataCharacteristics dc2, OpCode op) {
        switch (op) {
            case EQZERO: {
                return new MatrixCharacteristics(dc1.getRows(), dc1.getCols(), dc1.getRows() * dc1.getCols() - dc1.getNonZeros());
            }
            case DIAG: {
                return dc1.getCols() == 1L ? new MatrixCharacteristics(dc1.getRows(), dc1.getRows(), dc1.getNonZeros()) : new MatrixCharacteristics(dc1.getRows(), 1L, Math.min(dc1.getRows(), dc1.getNonZeros()));
            }
            case CBIND: {
                return new MatrixCharacteristics(dc1.getRows(), dc1.getCols() + dc2.getCols(), dc1.getNonZeros() + dc2.getNonZeros());
            }
            case RBIND: {
                return new MatrixCharacteristics(dc1.getRows() + dc2.getRows(), dc1.getCols(), dc1.getNonZeros() + dc2.getNonZeros());
            }
            case TRANS: {
                return new MatrixCharacteristics(dc1.getCols(), dc1.getRows(), dc1.getNonZeros());
            }
            case NEQZERO: 
            case RESHAPE: {
                return dc1;
            }
        }
        throw new HopsException("Opcode is not an exact meta data operation: " + op.name());
    }

    public static enum OpCode {
        MM,
        MULT,
        PLUS,
        EQZERO,
        NEQZERO,
        CBIND,
        RBIND,
        TRANS,
        DIAG,
        RESHAPE;

    }
}

