/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.hops.estim;

import org.tugraz.sysds.hops.estim.SparsityEstimator;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;
import org.tugraz.sysds.runtime.meta.MatrixCharacteristics;

public class MMNode {
    private final MMNode _m1;
    private final MMNode _m2;
    private final MatrixBlock _data;
    private final DataCharacteristics _mc;
    private Object _synops = null;
    private final SparsityEstimator.OpCode _op;
    private final long[] _misc;

    public MMNode(MatrixBlock in) {
        this._m1 = null;
        this._m2 = null;
        this._data = in;
        this._mc = in.getDataCharacteristics();
        this._op = null;
        this._misc = null;
    }

    public MMNode(MMNode left, MMNode right, SparsityEstimator.OpCode op, long[] misc) {
        this._m1 = left;
        this._m2 = right;
        this._data = null;
        this._mc = new MatrixCharacteristics(-1L, -1L, -1, -1L);
        this._op = op;
        this._misc = misc;
    }

    public MMNode(MMNode left, MMNode right, SparsityEstimator.OpCode op) {
        this(left, right, op, null);
    }

    public MMNode(MMNode left, SparsityEstimator.OpCode op) {
        this(left, null, op);
    }

    public MMNode(MMNode left, SparsityEstimator.OpCode op, long[] misc) {
        this(left, null, op, misc);
    }

    public void reset() {
        if (this._m1 != null) {
            this._m1.reset();
        }
        if (this._m2 != null) {
            this._m2.reset();
        }
        this._synops = null;
    }

    public int getRows() {
        return (int)this._mc.getRows();
    }

    public int getCols() {
        return (int)this._mc.getCols();
    }

    public long[] getMisc() {
        return this._misc;
    }

    public long getMisc(int pos) {
        if (this._misc == null) {
            throw new DMLRuntimeException("Extra meta data not available.");
        }
        return this._misc[pos];
    }

    public DataCharacteristics getDataCharacteristics() {
        return this._mc;
    }

    public DataCharacteristics setDataCharacteristics(DataCharacteristics mc) {
        return this._mc.set(mc);
    }

    public MMNode getLeft() {
        return this._m1;
    }

    public MMNode getRight() {
        return this._m2;
    }

    public boolean isLeaf() {
        return this._data != null;
    }

    public MatrixBlock getData() {
        return this._data;
    }

    public void setSynopsis(Object obj) {
        this._synops = obj;
    }

    public Object getSynopsis() {
        return this._synops;
    }

    public SparsityEstimator.OpCode getOp() {
        return this._op;
    }
}

