/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.hops.estim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.math3.random.Well1024a;
import org.tugraz.sysds.hops.OptimizerUtils;
import org.tugraz.sysds.hops.estim.EstimatorBasicAvg;
import org.tugraz.sysds.hops.estim.MMNode;
import org.tugraz.sysds.hops.estim.SparsityEstimator;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.data.SparseBlock;
import org.tugraz.sysds.runtime.matrix.data.LibMatrixDatagen;
import org.tugraz.sysds.runtime.matrix.data.MatrixBlock;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;

public class EstimatorSampleRa
extends SparsityEstimator {
    private static final int RUNS = -1;
    private static final double SAMPLE_FRACTION = 0.1;
    private static final double EPSILON = 0.05;
    private static final double DELTA = 0.1;
    private static final int K = -1;
    private final int _runs;
    private final double _sampleFrac;
    private final double _eps;
    private final double _delta;
    private final int _k;
    private final Well1024a _bigrand;
    private double[] h1;
    private double[] h2;
    private double[] h3;
    private double[] h4;

    public EstimatorSampleRa() {
        this(-1, 0.1, 0.05, 0.1, -1);
    }

    public EstimatorSampleRa(double sampleFrac) {
        this(-1, sampleFrac, 0.05, 0.1, -1);
    }

    public EstimatorSampleRa(int runs, double sampleFrac, double eps, double delta, int k) {
        if (sampleFrac <= 0.0 || sampleFrac > 1.0) {
            throw new DMLRuntimeException("Invalid sample fraction: " + sampleFrac);
        }
        this._sampleFrac = sampleFrac;
        this._eps = eps;
        this._delta = delta;
        this._runs = runs < 0 ? (int)(Math.log(1.0 / this._delta) / Math.log(2.0)) : runs;
        this._k = k < 0 ? (int)Math.ceil(1.0 / (this._eps * this._eps)) : k;
        this._bigrand = LibMatrixDatagen.setupSeedsForRand(this._k);
    }

    @Override
    public DataCharacteristics estim(MMNode root) {
        LOG.warn((Object)"Recursive estimates not supported by EstimatorSampleRa, falling back to EstimatorBasicAvg.");
        return new EstimatorBasicAvg().estim(root);
    }

    @Override
    public double estim(MatrixBlock m1, MatrixBlock m2, SparsityEstimator.OpCode op) {
        if (op == SparsityEstimator.OpCode.MM) {
            return this.estim(m1, m2);
        }
        throw new NotImplementedException();
    }

    @Override
    public double estim(MatrixBlock m, SparsityEstimator.OpCode op) {
        throw new NotImplementedException();
    }

    @Override
    public double estim(MatrixBlock m1, MatrixBlock m2) {
        double[] results = new double[this._runs];
        for (int i = 0; i < this._runs; ++i) {
            this.initHashArrays(m1.getNumRows(), m1.getNumColumns(), m2.getNumColumns());
            results[i] = this.estimateSize(m1, m2);
        }
        Arrays.sort(results);
        long nnz = (long)results[this._runs / 2];
        return OptimizerUtils.getSparsity(m1.getNumRows(), m2.getNumColumns(), nnz);
    }

    private void initHashArrays(int m, int n, int l) {
        int t;
        if (this.h1 == null) {
            this.h1 = new double[m];
            this.h2 = new double[l];
            this.h3 = new double[l];
            this.h4 = new double[m];
        }
        Random rand = new Random(this._bigrand.nextLong());
        for (t = 0; t < this.h1.length; ++t) {
            this.h1[t] = rand.nextDouble();
        }
        for (t = 0; t < this.h2.length; ++t) {
            this.h2[t] = rand.nextDouble();
        }
        for (t = 0; t < this.h3.length; ++t) {
            this.h3[t] = rand.nextDouble();
        }
        for (t = 0; t < this.h4.length; ++t) {
            this.h4[t] = rand.nextDouble();
        }
    }

    private double estimateSize(MatrixBlock mb1, MatrixBlock mb2) {
        AdjacencyLists A = new AdjacencyLists(mb1, false);
        AdjacencyLists C = new AdjacencyLists(mb2, true);
        ArrayList<Double> sketch = new ArrayList<Double>();
        double p = 1.0;
        int bufferSize = 0;
        for (int i = 0; i < mb1.getNumColumns(); ++i) {
            ArrayList<Integer> Ai = A.getList(i);
            ArrayList<Integer> Ci = C.getList(i);
            if (Ai.isEmpty() || Ci.isEmpty()) continue;
            Integer[] x = (Integer[])Ai.stream().sorted(Comparator.comparing(a -> this.h1[a])).toArray(Integer[]::new);
            Integer[] y = (Integer[])Ci.stream().sorted(Comparator.comparing(a -> this.h2[a])).toArray(Integer[]::new);
            int s = 0;
            int sHat = 0;
            for (int t = 0; t < y.length; ++t) {
                int xIdx;
                int n = xIdx = sHat > 0 ? sHat - 1 : x.length - 1;
                while (this.h(x[sHat], y[t]) > this.h(x[xIdx], y[t])) {
                    sHat = (sHat + 1) % x.length;
                }
                s = sHat;
                if (this.h3[y[t]] > this._sampleFrac) continue;
                int num = 0;
                while (this.h(x[s], y[t]) < p && num < x.length) {
                    if (this.h4[x[s]] > this._sampleFrac) {
                        s = (s + 1) % x.length;
                        ++num;
                        continue;
                    }
                    sketch.add(this.h(x[s], y[t]));
                    if (++bufferSize > this._k) {
                        this.sortAndTruncate(sketch);
                        if (sketch.size() == this._k) {
                            p = sketch.get(sketch.size() - 1);
                        }
                        bufferSize = 0;
                    }
                    s = (s + 1) % x.length;
                    ++num;
                }
            }
        }
        this.sortAndTruncate(sketch);
        if (sketch.size() == this._k) {
            double v = sketch.get(sketch.size() - 1);
            return (double)this._k / (v * this._sampleFrac * this._sampleFrac);
        }
        return (double)sketch.size() / (this._sampleFrac * this._sampleFrac);
    }

    public void sortAndTruncate(ArrayList<Double> sketch) {
        Collections.sort(sketch);
        for (int t = 1; t < sketch.size(); ++t) {
            if (!(sketch.get(t) / sketch.get(t - 1) < 1.0000000001)) continue;
            sketch.remove(t);
            --t;
        }
        sketch.subList(Math.min(sketch.size(), this._k), sketch.size()).clear();
    }

    public double h(int x, int y) {
        double a = this.h1[x] - this.h2[y];
        return a < 0.0 ? a + 1.0 : a;
    }

    private static class AdjacencyLists {
        private ArrayList<Integer>[] indexes;

        public AdjacencyLists(MatrixBlock mb, boolean row) {
            int i;
            int len = row ? mb.getNumRows() : mb.getNumColumns();
            this.indexes = new ArrayList[len];
            for (i = 0; i < len; ++i) {
                this.indexes[i] = new ArrayList();
            }
            if (mb.isEmptyBlock(false)) {
                return;
            }
            if (mb.isInSparseFormat()) {
                SparseBlock sblock = mb.getSparseBlock();
                for (int i2 = 0; i2 < sblock.numRows(); ++i2) {
                    if (sblock.isEmpty(i2)) continue;
                    int apos = sblock.pos(i2);
                    int alen = sblock.size(i2);
                    int[] aix = sblock.indexes(i2);
                    for (int k = apos; k < apos + alen; ++k) {
                        this.indexes[row ? i2 : aix[k]].add(row ? aix[k] : i2);
                    }
                }
            } else {
                for (i = 0; i < mb.getNumRows(); ++i) {
                    for (int j = 0; j < mb.getNumColumns(); ++j) {
                        if (mb.quickGetValue(i, j) == 0.0) continue;
                        this.indexes[row ? i : j].add(row ? j : i);
                    }
                }
            }
        }

        public ArrayList<Integer> getList(int i) {
            return this.indexes[i];
        }
    }
}

