/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.hops.cost;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tugraz.sysds.hops.cost.CostEstimator;
import org.tugraz.sysds.hops.cost.CostEstimatorStaticRuntime;
import org.tugraz.sysds.hops.cost.VarStats;
import org.tugraz.sysds.runtime.DMLRuntimeException;
import org.tugraz.sysds.runtime.controlprogram.LocalVariableMap;
import org.tugraz.sysds.runtime.controlprogram.Program;
import org.tugraz.sysds.runtime.controlprogram.ProgramBlock;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.parfor.stat.Timing;

public class CostEstimationWrapper {
    private static final boolean LDEBUG = false;
    private static final Log LOG = LogFactory.getLog((String)CostEstimationWrapper.class.getName());
    private static final CostType DEFAULT_COSTTYPE = CostType.STATIC;
    private static CostEstimator _costEstim = null;

    public static double getTimeEstimate(Program rtprog, ExecutionContext ec) {
        Timing time = new Timing(true);
        HashMap<String, VarStats> stats = new HashMap<String, VarStats>();
        LocalVariableMap vars = ec != null ? ec.getVariables() : new LocalVariableMap();
        double costs = _costEstim.getTimeEstimate(rtprog, vars, stats);
        LOG.debug((Object)("Finished estimation in " + time.stop() + "ms."));
        return costs;
    }

    public static double getTimeEstimate(ProgramBlock pb, ExecutionContext ec, boolean recursive) {
        Timing time = new Timing(true);
        HashMap<String, VarStats> stats = new HashMap<String, VarStats>();
        LocalVariableMap vars = ec != null ? ec.getVariables() : new LocalVariableMap();
        double costs = _costEstim.getTimeEstimate(pb, vars, stats, recursive);
        LOG.debug((Object)("Finished estimation in " + time.stop() + "ms."));
        return costs;
    }

    private static CostEstimator createCostEstimator(CostType type) {
        switch (type) {
            case STATIC: {
                return new CostEstimatorStaticRuntime();
            }
        }
        throw new DMLRuntimeException("Unknown cost type: " + (Object)((Object)type));
    }

    static {
        try {
            _costEstim = CostEstimationWrapper.createCostEstimator(DEFAULT_COSTTYPE);
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed cost estimator initialization.", (Throwable)ex);
        }
    }

    public static enum CostType {
        NUM_MRJOBS,
        STATIC;

    }
}

