/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.hops.codegen.opt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tugraz.sysds.api.DMLScript;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.hops.AggBinaryOp;
import org.tugraz.sysds.hops.AggUnaryOp;
import org.tugraz.sysds.hops.BinaryOp;
import org.tugraz.sysds.hops.Hop;
import org.tugraz.sysds.hops.IndexingOp;
import org.tugraz.sysds.hops.LiteralOp;
import org.tugraz.sysds.hops.ParameterizedBuiltinOp;
import org.tugraz.sysds.hops.ReorgOp;
import org.tugraz.sysds.hops.TernaryOp;
import org.tugraz.sysds.hops.UnaryOp;
import org.tugraz.sysds.hops.codegen.opt.PlanAnalyzer;
import org.tugraz.sysds.hops.codegen.opt.PlanPartition;
import org.tugraz.sysds.hops.codegen.opt.PlanSelection;
import org.tugraz.sysds.hops.codegen.template.CPlanMemoTable;
import org.tugraz.sysds.hops.codegen.template.TemplateBase;
import org.tugraz.sysds.hops.codegen.template.TemplateOuterProduct;
import org.tugraz.sysds.hops.codegen.template.TemplateRow;
import org.tugraz.sysds.hops.codegen.template.TemplateUtils;
import org.tugraz.sysds.hops.rewrite.HopRewriteUtils;
import org.tugraz.sysds.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.tugraz.sysds.runtime.controlprogram.parfor.util.IDSequence;
import org.tugraz.sysds.runtime.util.UtilFunctions;
import org.tugraz.sysds.utils.Statistics;

public class PlanSelectionFuseCostBased
extends PlanSelection {
    private static final Log LOG = LogFactory.getLog((String)PlanSelectionFuseCostBased.class.getName());
    private static final double WRITE_BANDWIDTH = 2.147483648E9;
    private static final double READ_BANDWIDTH = 3.4359738368E10;
    private static final double COMPUTE_BANDWIDTH = 2.147483648E9 * (double)InfrastructureAnalyzer.getLocalParallelism();
    private static final IDSequence COST_ID = new IDSequence();
    private static final TemplateRow ROW_TPL = new TemplateRow();

    @Override
    public void selectPlans(CPlanMemoTable memo, ArrayList<Hop> roots) {
        Collection<PlanPartition> parts = PlanAnalyzer.analyzePlanPartitions(memo, roots, false);
        int sumMatPoints = 0;
        for (PlanPartition planPartition : parts) {
            PlanSelectionFuseCostBased.createAndAddMultiAggPlans(memo, planPartition.getPartition(), planPartition.getRoots());
            this.selectPlans(memo, planPartition.getPartition(), planPartition.getRoots(), planPartition.getMatPoints());
            sumMatPoints += planPartition.getMatPoints().size();
        }
        this.createAndAddMultiAggPlans(memo, roots);
        for (Map.Entry entry : this.getBestPlans().entrySet()) {
            memo.setDistinct((Long)entry.getKey(), (List)entry.getValue());
        }
        if (DMLScript.STATISTICS) {
            Statistics.incrementCodegenEnumAll(UtilFunctions.pow(2, sumMatPoints));
        }
    }

    private static void createAndAddMultiAggPlans(CPlanMemoTable memo, HashSet<Long> partition, HashSet<Long> R) {
        HashSet<Long> refHops = new HashSet<Long>();
        for (Map.Entry<Long, List<CPlanMemoTable.MemoTableEntry>> e : memo.getPlans().entrySet()) {
            if (e.getValue().isEmpty()) continue;
            Hop hop = memo.getHopRefs().get(e.getKey());
            for (Hop c : hop.getInput()) {
                refHops.add(c.getHopID());
            }
        }
        ArrayList<Long> fullAggs = new ArrayList<Long>();
        for (Long hopID : R) {
            Hop root = memo.getHopRefs().get(hopID);
            if (refHops.contains(hopID) || !PlanSelectionFuseCostBased.isMultiAggregateRoot(root)) continue;
            fullAggs.add(hopID);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Found within-partition ua(RC) aggregations: " + Arrays.toString((Object[])fullAggs.toArray(new Long[0]))));
        }
        for (int i = 0; i < fullAggs.size(); i += 3) {
            int ito = Math.min(i + 3, fullAggs.size());
            if (ito - i < 2) continue;
            CPlanMemoTable.MemoTableEntry me = new CPlanMemoTable.MemoTableEntry(TemplateBase.TemplateType.MAGG, (Long)fullAggs.get(i), (Long)fullAggs.get(i + 1), ito - i == 3 ? (Long)fullAggs.get(i + 2) : -1L, ito - i);
            if (PlanSelectionFuseCostBased.isValidMultiAggregate(memo, me)) {
                for (int j = i; j < ito; ++j) {
                    memo.add(memo.getHopRefs().get(fullAggs.get(j)), me);
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)("Added multiagg plan: " + fullAggs.get(j) + " " + me));
                }
                continue;
            }
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)("Removed invalid multiagg plan: " + me));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createAndAddMultiAggPlans(CPlanMemoTable memo, ArrayList<Hop> roots) {
        boolean bl;
        HashSet<Long> fullAggs = new HashSet<Long>();
        Hop.resetVisitStatus(roots);
        for (Hop hop : roots) {
            PlanSelectionFuseCostBased.rCollectFullAggregates(hop, fullAggs);
        }
        Hop.resetVisitStatus(roots);
        fullAggs.removeIf(p -> memo.contains((long)p, TemplateBase.TemplateType.MAGG));
        if (fullAggs.size() <= 1) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Found across-partition ua(RC) aggregations: " + Arrays.toString((Object[])fullAggs.toArray(new Long[0]))));
        }
        List<Object> aggInfos = new ArrayList();
        for (Long l : fullAggs) {
            Hop hop = memo.getHopRefs().get(l);
            AggregateInfo tmp = new AggregateInfo(hop);
            for (int i = 0; i < hop.getInput().size(); ++i) {
                Hop c = HopRewriteUtils.isMatrixMultiply(hop) && i == 0 ? hop.getInput().get(0).getInput().get(0) : hop.getInput().get(i);
                PlanSelectionFuseCostBased.rExtractAggregateInfo(memo, c, tmp, TemplateBase.TemplateType.CELL);
            }
            if (tmp._fusedInputs.isEmpty()) {
                if (HopRewriteUtils.isMatrixMultiply(hop)) {
                    tmp.addFusedInput(hop.getInput().get(0).getInput().get(0).getHopID());
                    tmp.addFusedInput(hop.getInput().get(1).getHopID());
                } else {
                    tmp.addFusedInput(hop.getInput().get(0).getHopID());
                }
            }
            aggInfos.add(tmp);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Extracted across-partition ua(RC) aggregation info: ");
            for (AggregateInfo aggregateInfo : aggInfos) {
                LOG.trace((Object)aggregateInfo);
            }
        }
        aggInfos = aggInfos.stream().sorted(Comparator.comparing(a -> a._inputAggs.size())).collect(Collectors.toList());
        boolean bl2 = false;
        while (!bl) {
            void var6_16;
            Object var6_15 = null;
            for (int i = 0; i < aggInfos.size(); ++i) {
                AggregateInfo current = (AggregateInfo)aggInfos.get(i);
                for (int j = i + 1; j < aggInfos.size(); ++j) {
                    AggregateInfo that = (AggregateInfo)aggInfos.get(j);
                    if (!current.isMergable(that)) continue;
                    AggregateInfo aggregateInfo = current.merge(that);
                    aggInfos.remove(j);
                    --j;
                }
            }
            bl = var6_16 == null;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Merged across-partition ua(RC) aggregation info: ");
            for (AggregateInfo aggregateInfo : aggInfos) {
                LOG.trace((Object)aggregateInfo);
            }
        }
        for (AggregateInfo aggregateInfo : aggInfos) {
            if (aggregateInfo._aggregates.size() <= 1) continue;
            Long[] aggs = aggregateInfo._aggregates.keySet().toArray(new Long[0]);
            CPlanMemoTable.MemoTableEntry me = new CPlanMemoTable.MemoTableEntry(TemplateBase.TemplateType.MAGG, aggs[0], aggs[1], aggs.length > 2 ? aggs[2] : -1L, aggs.length);
            for (int i = 0; i < aggs.length; ++i) {
                memo.add(memo.getHopRefs().get(aggs[i]), me);
                this.addBestPlan(aggs[i], me);
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Added multiagg* plan: " + aggs[i] + " " + me));
            }
        }
    }

    private static boolean isMultiAggregateRoot(Hop root) {
        return HopRewriteUtils.isAggUnaryOp(root, Types.AggOp.SUM, Types.AggOp.SUM_SQ, Types.AggOp.MIN, Types.AggOp.MAX) && ((AggUnaryOp)root).getDirection() == Types.Direction.RowCol || root instanceof AggBinaryOp && root.getDim1() == 1L && root.getDim2() == 1L && HopRewriteUtils.isTransposeOperation(root.getInput().get(0));
    }

    private static boolean isValidMultiAggregate(CPlanMemoTable memo, CPlanMemoTable.MemoTableEntry me) {
        int i;
        boolean ret = true;
        Hop refSize = memo.getHopRefs().get(me.input1).getInput().get(0);
        for (i = 1; ret && i < 3; ++i) {
            if (!me.isPlanRef(i)) continue;
            ret &= HopRewriteUtils.isEqualSize(refSize, memo.getHopRefs().get(me.input(i)).getInput().get(0));
        }
        for (i = 0; ret && i < 3; ++i) {
            if (!me.isPlanRef(i)) continue;
            HashSet<Long> probe = new HashSet<Long>();
            for (int j = 0; j < 3; ++j) {
                if (i == j) continue;
                probe.add(me.input(j));
            }
            ret &= PlanSelectionFuseCostBased.rCheckMultiAggregate(memo.getHopRefs().get(me.input(i)), probe);
        }
        return ret;
    }

    private static boolean rCheckMultiAggregate(Hop current, HashSet<Long> probe) {
        boolean ret = true;
        for (Hop c : current.getInput()) {
            ret &= PlanSelectionFuseCostBased.rCheckMultiAggregate(c, probe);
        }
        return ret &= !probe.contains(current.getHopID());
    }

    private static void rCollectFullAggregates(Hop current, HashSet<Long> aggs) {
        if (current.isVisited()) {
            return;
        }
        if (PlanSelectionFuseCostBased.isMultiAggregateRoot(current)) {
            aggs.add(current.getHopID());
        }
        for (Hop c : current.getInput()) {
            PlanSelectionFuseCostBased.rCollectFullAggregates(c, aggs);
        }
        current.setVisited();
    }

    private static void rExtractAggregateInfo(CPlanMemoTable memo, Hop current, AggregateInfo aggInfo, TemplateBase.TemplateType type) {
        if (PlanSelectionFuseCostBased.isMultiAggregateRoot(current)) {
            aggInfo.addInputAggregate(current.getHopID());
        }
        CPlanMemoTable.MemoTableEntry me = type != null ? memo.getBest(current.getHopID()) : null;
        for (int i = 0; i < current.getInput().size(); ++i) {
            Hop c = current.getInput().get(i);
            if (me != null && me.isPlanRef(i)) {
                PlanSelectionFuseCostBased.rExtractAggregateInfo(memo, c, aggInfo, type);
                continue;
            }
            if (type != null && c.getDataType().isMatrix()) {
                aggInfo.addFusedInput(c.getHopID());
            }
            PlanSelectionFuseCostBased.rExtractAggregateInfo(memo, c, aggInfo, null);
        }
    }

    private void selectPlans(CPlanMemoTable memo, HashSet<Long> partition, HashSet<Long> R, ArrayList<Long> M) {
        for (Long l : R) {
            CPlanMemoTable.MemoTableEntry me = memo.getBest(l, TemplateBase.TemplateType.ROW);
            if (me.type != TemplateBase.TemplateType.ROW || !memo.contains(l, TemplateBase.TemplateType.CELL) || !PlanSelectionFuseCostBased.isRowTemplateWithoutAgg(memo, memo.getHopRefs().get(l), new HashSet<Long>())) continue;
            List<CPlanMemoTable.MemoTableEntry> blacklist = memo.get(l, TemplateBase.TemplateType.ROW);
            memo.remove(memo.getHopRefs().get(l), new HashSet<CPlanMemoTable.MemoTableEntry>(blacklist));
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)("Removed row memo table entries w/o aggregation: " + Arrays.toString(blacklist.toArray(new CPlanMemoTable.MemoTableEntry[0]))));
        }
        for (Long l : partition) {
            CPlanMemoTable.MemoTableEntry me2;
            List<CPlanMemoTable.MemoTableEntry> entries;
            CPlanMemoTable.MemoTableEntry me1;
            CPlanMemoTable.MemoTableEntry rmEntry;
            if (memo.countEntries(l, TemplateBase.TemplateType.OUTER) != 2 || (rmEntry = TemplateOuterProduct.dropAlternativePlan(memo, me1 = (entries = memo.get(l, TemplateBase.TemplateType.OUTER)).get(0), me2 = entries.get(1))) == null) continue;
            memo.remove(memo.getHopRefs().get(l), Collections.singleton(rmEntry));
            memo.getPlansBlacklisted().remove(rmEntry.input(rmEntry.getPlanRefIndex()));
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace((Object)("Removed dominated outer product memo table entry: " + rmEntry));
        }
        if (M == null || M.isEmpty()) {
            for (Long l : R) {
                this.rSelectPlansFuseAll(memo, memo.getHopRefs().get(l), null, partition);
            }
        } else {
            Object plan;
            HashMap<Long, Double> computeCosts = new HashMap<Long, Double>();
            for (Long hopID : R) {
                PlanSelectionFuseCostBased.rGetComputeCosts(memo.getHopRefs().get(hopID), partition, computeCosts);
            }
            int n = (int)Math.pow(2.0, M.size());
            Object bestPlan = null;
            double bestC = Double.MAX_VALUE;
            for (int i = 0; i < n; ++i) {
                plan = PlanSelectionFuseCostBased.createAssignment(M.size(), i);
                double C = PlanSelectionFuseCostBased.getPlanCost(memo, partition, R, M, (boolean[])plan, computeCosts);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Enum: " + Arrays.toString((boolean[])plan) + " -> " + C));
                }
                if (bestPlan != null && !(C < bestC)) continue;
                bestC = C;
                bestPlan = plan;
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)"Enum: Found new best plan.");
            }
            if (DMLScript.STATISTICS) {
                Statistics.incrementCodegenEnumAllP(n);
                Statistics.incrementCodegenEnumEval(n);
            }
            HashSet<Long> visited = new HashSet<Long>();
            plan = R.iterator();
            while (plan.hasNext()) {
                Long hopID = (Long)plan.next();
                PlanSelectionFuseCostBased.rPruneSuboptimalPlans(memo, memo.getHopRefs().get(hopID), visited, partition, M, (boolean[])bestPlan);
            }
            HashSet<Long> visited2 = new HashSet<Long>();
            for (Long hopID : R) {
                PlanSelectionFuseCostBased.rPruneInvalidPlans(memo, memo.getHopRefs().get(hopID), visited2, partition, M, (boolean[])bestPlan);
            }
            for (Long hopID : R) {
                this.rSelectPlansFuseAll(memo, memo.getHopRefs().get(hopID), null, partition);
            }
        }
    }

    private static boolean isRowTemplateWithoutAgg(CPlanMemoTable memo, Hop current, HashSet<Long> visited) {
        CPlanMemoTable.MemoTableEntry me = memo.getBest(current.getHopID(), TemplateBase.TemplateType.ROW);
        boolean ret = true;
        for (int i = 0; i < 3; ++i) {
            if (!me.isPlanRef(i)) continue;
            ret &= PlanSelectionFuseCostBased.rIsRowTemplateWithoutAgg(memo, current.getInput().get(i), visited);
        }
        return ret;
    }

    private static boolean rIsRowTemplateWithoutAgg(CPlanMemoTable memo, Hop current, HashSet<Long> visited) {
        if (visited.contains(current.getHopID())) {
            return true;
        }
        boolean ret = true;
        CPlanMemoTable.MemoTableEntry me = memo.getBest(current.getHopID(), TemplateBase.TemplateType.ROW);
        for (int i = 0; i < 3; ++i) {
            if (!me.isPlanRef(i)) continue;
            ret &= PlanSelectionFuseCostBased.rIsRowTemplateWithoutAgg(memo, current.getInput().get(i), visited);
        }
        boolean bl = !(current instanceof AggUnaryOp) && !(current instanceof AggBinaryOp);
        visited.add(current.getHopID());
        return ret &= bl;
    }

    private static void rPruneSuboptimalPlans(CPlanMemoTable memo, Hop current, HashSet<Long> visited, HashSet<Long> partition, ArrayList<Long> M, boolean[] plan) {
        if (visited.contains(current.getHopID())) {
            return;
        }
        long hopID = current.getHopID();
        if (partition.contains(hopID) && memo.contains(hopID)) {
            Iterator<CPlanMemoTable.MemoTableEntry> iter = memo.get(hopID).iterator();
            while (iter.hasNext()) {
                CPlanMemoTable.MemoTableEntry me = iter.next();
                if (PlanSelectionFuseCostBased.hasNoRefToMaterialization(me, M, plan) || me.type == TemplateBase.TemplateType.OUTER) continue;
                iter.remove();
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Removed memo table entry: " + me));
            }
        }
        for (Hop c : current.getInput()) {
            PlanSelectionFuseCostBased.rPruneSuboptimalPlans(memo, c, visited, partition, M, plan);
        }
        visited.add(current.getHopID());
    }

    private static void rPruneInvalidPlans(CPlanMemoTable memo, Hop current, HashSet<Long> visited, HashSet<Long> partition, ArrayList<Long> M, boolean[] plan) {
        if (visited.contains(current.getHopID())) {
            return;
        }
        for (Hop c : current.getInput()) {
            PlanSelectionFuseCostBased.rPruneInvalidPlans(memo, c, visited, partition, M, plan);
        }
        long hopID = current.getHopID();
        if (partition.contains(hopID) && memo.contains(hopID, TemplateBase.TemplateType.ROW)) {
            for (CPlanMemoTable.MemoTableEntry me : memo.get(hopID)) {
                if (me.type != TemplateBase.TemplateType.ROW) continue;
                if (!me.hasPlanRef() && !TemplateUtils.hasMatrixInput(current)) {
                    me.type = TemplateBase.TemplateType.CELL;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Converted leaf memo table entry from row to cell: " + me));
                    }
                }
                if (!me.hasPlanRef() || ROW_TPL.open(current)) continue;
                boolean hasRowInput = false;
                for (int i = 0; i < 3; ++i) {
                    if (!me.isPlanRef(i)) continue;
                    hasRowInput |= memo.contains(me.input(i), TemplateBase.TemplateType.ROW);
                }
                if (hasRowInput) continue;
                me.type = TemplateBase.TemplateType.CELL;
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Converted inner memo table entry from row to cell: " + me));
            }
        }
        visited.add(current.getHopID());
    }

    private static boolean[] createAssignment(int len, int pos) {
        boolean[] ret = new boolean[len];
        int tmp = pos;
        for (int i = 0; i < len; ++i) {
            ret[i] = tmp < (int)Math.pow(2.0, len - i - 1);
            tmp = (int)((double)tmp % Math.pow(2.0, len - i - 1));
        }
        return ret;
    }

    private static double getPlanCost(CPlanMemoTable memo, HashSet<Long> partition, HashSet<Long> R, ArrayList<Long> M, boolean[] plan, HashMap<Long, Double> computeCosts) {
        HashSet<Pair<Long, Long>> visited = new HashSet<Pair<Long, Long>>();
        double costs = 0.0;
        for (Long hopID : R) {
            costs += PlanSelectionFuseCostBased.rGetPlanCosts(memo, memo.getHopRefs().get(hopID), visited, partition, M, plan, computeCosts, null, null);
        }
        return costs;
    }

    private static double rGetPlanCosts(CPlanMemoTable memo, Hop current, HashSet<Pair<Long, Long>> visited, HashSet<Long> partition, ArrayList<Long> M, boolean[] plan, HashMap<Long, Double> computeCosts, CostVector costsCurrent, TemplateBase.TemplateType currentType) {
        CostVector costVect;
        Pair tag = Pair.of((Object)current.getHopID(), (Object)(costsCurrent == null ? 0L : costsCurrent.ID));
        if (visited.contains(tag)) {
            return 0.0;
        }
        visited.add((Pair<Long, Long>)tag);
        CPlanMemoTable.MemoTableEntry best = null;
        boolean opened = false;
        if (memo.contains(current.getHopID())) {
            if (currentType == null) {
                best = memo.get(current.getHopID()).stream().filter(p -> p.isValid()).filter(p -> PlanSelectionFuseCostBased.hasNoRefToMaterialization(p, M, plan)).min(new PlanSelection.BasicPlanComparator()).orElse(null);
                opened = true;
            } else {
                best = memo.get(current.getHopID()).stream().filter(p -> p.type == currentType || p.type == TemplateBase.TemplateType.CELL).filter(p -> PlanSelectionFuseCostBased.hasNoRefToMaterialization(p, M, plan)).min(Comparator.comparing(p -> 7 - (p.type == currentType ? 4 : 0) - p.countPlanRefs())).orElse(null);
            }
        }
        CostVector costVector = costVect = !opened ? costsCurrent : new CostVector(Math.max(current.getDim1(), 1L) * Math.max(current.getDim2(), 1L));
        if (partition.contains(current.getHopID())) {
            costVect.computeCosts += computeCosts.get(current.getHopID()).doubleValue();
        }
        double costs = 0.0;
        for (int i = 0; i < current.getInput().size(); ++i) {
            Hop c = current.getInput().get(i);
            if (best != null && best.isPlanRef(i)) {
                costs += PlanSelectionFuseCostBased.rGetPlanCosts(memo, c, visited, partition, M, plan, computeCosts, costVect, best.type);
                continue;
            }
            if (best != null && PlanSelectionFuseCostBased.isImplicitlyFused(current, i, best.type)) {
                costVect.addInputSize(c.getInput().get(0).getHopID(), Math.max(c.getDim1(), 1L) * Math.max(c.getDim2(), 1L));
                continue;
            }
            costs += PlanSelectionFuseCostBased.rGetPlanCosts(memo, c, visited, partition, M, plan, computeCosts, null, null);
            if (costVect == null || !c.getDataType().isMatrix()) continue;
            costVect.addInputSize(c.getHopID(), Math.max(c.getDim1(), 1L) * Math.max(c.getDim2(), 1L));
        }
        if (partition.contains(current.getHopID())) {
            if (opened) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Cost vector for fused operator (hop " + current.getHopID() + "): " + costVect));
                }
                costs += costVect.outSize * 8.0 / 2.147483648E9;
                costs += Math.max(costVect.computeCosts * costVect.getMaxInputSize() / COMPUTE_BANDWIDTH, costVect.getSumInputSizes() * 8.0 / 3.4359738368E10);
            } else if (PlanSelectionFuseCostBased.hasNonPartitionConsumer(current, partition)) {
                costs += PlanSelectionFuseCostBased.rGetPlanCosts(memo, current, visited, partition, M, plan, computeCosts, null, null);
            }
        }
        if (costs < 0.0 || Double.isNaN(costs) || Double.isInfinite(costs)) {
            throw new RuntimeException("Wrong cost estimate: " + costs);
        }
        return costs;
    }

    private static void rGetComputeCosts(Hop current, HashSet<Long> partition, HashMap<Long, Double> computeCosts) {
        if (computeCosts.containsKey(current.getHopID())) {
            return;
        }
        for (Hop c : current.getInput()) {
            PlanSelectionFuseCostBased.rGetComputeCosts(c, partition, computeCosts);
        }
        double costs = 1.0;
        if (current instanceof UnaryOp) {
            switch (((UnaryOp)current).getOp()) {
                case ABS: 
                case ROUND: 
                case CEIL: 
                case FLOOR: 
                case SIGN: {
                    costs = 1.0;
                    break;
                }
                case SPROP: 
                case SQRT: {
                    costs = 2.0;
                    break;
                }
                case EXP: {
                    costs = 18.0;
                    break;
                }
                case SIGMOID: {
                    costs = 21.0;
                    break;
                }
                case LOG: 
                case LOG_NZ: {
                    costs = 32.0;
                    break;
                }
                case NCOL: 
                case NROW: 
                case PRINT: 
                case ASSERT: 
                case CAST_AS_BOOLEAN: 
                case CAST_AS_DOUBLE: 
                case CAST_AS_INT: 
                case CAST_AS_MATRIX: 
                case CAST_AS_SCALAR: {
                    costs = 1.0;
                    break;
                }
                case SIN: {
                    costs = 18.0;
                    break;
                }
                case COS: {
                    costs = 22.0;
                    break;
                }
                case TAN: {
                    costs = 42.0;
                    break;
                }
                case ASIN: {
                    costs = 93.0;
                    break;
                }
                case ACOS: {
                    costs = 103.0;
                    break;
                }
                case ATAN: {
                    costs = 40.0;
                    break;
                }
                case SINH: {
                    costs = 93.0;
                    break;
                }
                case COSH: {
                    costs = 103.0;
                    break;
                }
                case TANH: {
                    costs = 40.0;
                    break;
                }
                case CUMSUM: 
                case CUMMIN: 
                case CUMMAX: 
                case CUMPROD: {
                    costs = 1.0;
                    break;
                }
                case CUMSUMPROD: {
                    costs = 2.0;
                    break;
                }
                default: {
                    LOG.warn((Object)("Cost model not implemented yet for: " + (Object)((Object)((UnaryOp)current).getOp())));
                    break;
                }
            }
        } else if (current instanceof BinaryOp) {
            block19 : switch (((BinaryOp)current).getOp()) {
                case MULT: 
                case PLUS: 
                case MINUS: 
                case MIN: 
                case MAX: 
                case AND: 
                case OR: 
                case EQUAL: 
                case NOTEQUAL: 
                case LESS: 
                case LESSEQUAL: 
                case GREATER: 
                case GREATEREQUAL: 
                case CBIND: 
                case RBIND: {
                    costs = 1.0;
                    break;
                }
                case INTDIV: {
                    costs = 6.0;
                    break;
                }
                case MODULUS: {
                    costs = 8.0;
                    break;
                }
                case DIV: {
                    costs = 22.0;
                    break;
                }
                case LOG: 
                case LOG_NZ: {
                    costs = 32.0;
                    break;
                }
                case POW: {
                    costs = HopRewriteUtils.isLiteralOfValue(current.getInput().get(1), 2.0) ? 1 : 16;
                    break;
                }
                case MINUS_NZ: 
                case MINUS1_MULT: {
                    costs = 2.0;
                    break;
                }
                case MOMENT: {
                    int type = (int)(current.getInput().get(1) instanceof LiteralOp ? HopRewriteUtils.getIntValueSafe((LiteralOp)current.getInput().get(1)) : 2L);
                    switch (type) {
                        case 0: {
                            costs = 1.0;
                            break block19;
                        }
                        case 1: {
                            costs = 8.0;
                            break block19;
                        }
                        case 2: {
                            costs = 16.0;
                            break block19;
                        }
                        case 3: {
                            costs = 31.0;
                            break block19;
                        }
                        case 4: {
                            costs = 51.0;
                            break block19;
                        }
                        case 5: {
                            costs = 16.0;
                        }
                    }
                    break;
                }
                case COV: {
                    costs = 23.0;
                    break;
                }
                default: {
                    LOG.warn((Object)("Cost model not implemented yet for: " + (Object)((Object)((BinaryOp)current).getOp())));
                    break;
                }
            }
        } else if (current instanceof TernaryOp) {
            block38 : switch (((TernaryOp)current).getOp()) {
                case PLUS_MULT: 
                case MINUS_MULT: {
                    costs = 2.0;
                    break;
                }
                case CTABLE: {
                    costs = 3.0;
                    break;
                }
                case MOMENT: {
                    int type = (int)(current.getInput().get(1) instanceof LiteralOp ? HopRewriteUtils.getIntValueSafe((LiteralOp)current.getInput().get(1)) : 2L);
                    switch (type) {
                        case 0: {
                            costs = 2.0;
                            break block38;
                        }
                        case 1: {
                            costs = 9.0;
                            break block38;
                        }
                        case 2: {
                            costs = 17.0;
                            break block38;
                        }
                        case 3: {
                            costs = 32.0;
                            break block38;
                        }
                        case 4: {
                            costs = 52.0;
                            break block38;
                        }
                        case 5: {
                            costs = 17.0;
                        }
                    }
                    break;
                }
                case COV: {
                    costs = 23.0;
                    break;
                }
                default: {
                    LOG.warn((Object)("Cost model not implemented yet for: " + (Object)((Object)((TernaryOp)current).getOp())));
                    break;
                }
            }
        } else if (current instanceof ParameterizedBuiltinOp) {
            costs = 1.0;
        } else if (current instanceof IndexingOp) {
            costs = 1.0;
        } else if (current instanceof ReorgOp) {
            costs = 1.0;
        } else if (current instanceof AggBinaryOp) {
            costs = 2.0;
        } else if (current instanceof AggUnaryOp) {
            switch (((AggUnaryOp)current).getOp()) {
                case SUM: {
                    costs = 4.0;
                    break;
                }
                case SUM_SQ: {
                    costs = 5.0;
                    break;
                }
                case MIN: 
                case MAX: {
                    costs = 1.0;
                    break;
                }
                default: {
                    LOG.warn((Object)("Cost model not implemented yet for: " + (Object)((Object)((AggUnaryOp)current).getOp())));
                }
            }
        }
        computeCosts.put(current.getHopID(), costs);
    }

    private static boolean hasNoRefToMaterialization(CPlanMemoTable.MemoTableEntry me, ArrayList<Long> M, boolean[] plan) {
        boolean ret = true;
        for (int i = 0; ret && i < 3; ret &= !M.contains(me.input(i)) || !plan[M.indexOf(me.input(i))], ++i) {
        }
        return ret;
    }

    private static boolean hasNonPartitionConsumer(Hop hop, HashSet<Long> partition) {
        boolean ret = false;
        for (Hop p : hop.getParent()) {
            ret |= !partition.contains(p.getHopID());
        }
        return ret;
    }

    private static boolean isImplicitlyFused(Hop hop, int index, TemplateBase.TemplateType type) {
        return type == TemplateBase.TemplateType.ROW && HopRewriteUtils.isMatrixMultiply(hop) && index == 0 && HopRewriteUtils.isTransposeOperation(hop.getInput().get(index));
    }

    private static class AggregateInfo {
        public final HashMap<Long, Hop> _aggregates;
        public final HashSet<Long> _inputAggs = new HashSet();
        public final HashSet<Long> _fusedInputs = new HashSet();

        public AggregateInfo(Hop aggregate) {
            this._aggregates = new HashMap();
            this._aggregates.put(aggregate.getHopID(), aggregate);
        }

        public void addInputAggregate(long hopID) {
            this._inputAggs.add(hopID);
        }

        public void addFusedInput(long hopID) {
            this._fusedInputs.add(hopID);
        }

        public boolean isMergable(AggregateInfo that) {
            boolean ret = this._aggregates.size() < 3 && this._aggregates.size() + that._aggregates.size() <= 3;
            for (Long hopID : that._aggregates.keySet()) {
                ret &= !this._inputAggs.contains(hopID);
            }
            for (Long hopID : this._aggregates.keySet()) {
                ret &= !that._inputAggs.contains(hopID);
            }
            boolean bl = !CollectionUtils.intersection(this._fusedInputs, that._fusedInputs).isEmpty();
            Hop in1 = this._aggregates.values().iterator().next();
            Hop in2 = that._aggregates.values().iterator().next();
            return (ret &= bl) && HopRewriteUtils.isEqualSize(in1.getInput().get(HopRewriteUtils.isMatrixMultiply(in1) ? 1 : 0), in2.getInput().get(HopRewriteUtils.isMatrixMultiply(in2) ? 1 : 0));
        }

        public AggregateInfo merge(AggregateInfo that) {
            this._aggregates.putAll(that._aggregates);
            this._inputAggs.addAll(that._inputAggs);
            this._fusedInputs.addAll(that._fusedInputs);
            return this;
        }

        public String toString() {
            return "[" + Arrays.toString((Object[])this._aggregates.keySet().toArray(new Long[0])) + ": {" + Arrays.toString((Object[])this._inputAggs.toArray(new Long[0])) + "},{" + Arrays.toString((Object[])this._fusedInputs.toArray(new Long[0])) + "}]";
        }
    }

    private static class CostVector {
        public final long ID;
        public final double outSize;
        public double computeCosts = 0.0;
        public final HashMap<Long, Double> inSizes = new HashMap();

        public CostVector(double outputSize) {
            this.ID = COST_ID.getNextID();
            this.outSize = outputSize;
        }

        public void addInputSize(long hopID, double inputSize) {
            this.inSizes.put(hopID, inputSize);
        }

        public double getSumInputSizes() {
            return this.inSizes.values().stream().mapToDouble(d -> d).sum();
        }

        public double getMaxInputSize() {
            return this.inSizes.values().stream().mapToDouble(d -> d).max().orElse(0.0);
        }

        public String toString() {
            return "[" + this.outSize + ", " + this.computeCosts + ", {" + Arrays.toString((Object[])this.inSizes.keySet().toArray(new Long[0])) + ", " + Arrays.toString((Object[])this.inSizes.values().toArray(new Double[0])) + "}]";
        }
    }
}

