/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.hops.codegen.opt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tugraz.sysds.hops.Hop;
import org.tugraz.sysds.hops.codegen.opt.InterestingPoint;
import org.tugraz.sysds.hops.codegen.opt.PlanPartition;
import org.tugraz.sysds.hops.codegen.template.CPlanMemoTable;
import org.tugraz.sysds.hops.codegen.template.TemplateBase;
import org.tugraz.sysds.hops.rewrite.HopRewriteUtils;

public class PlanAnalyzer {
    private static final Log LOG = LogFactory.getLog((String)PlanAnalyzer.class.getName());

    public static Collection<PlanPartition> analyzePlanPartitions(CPlanMemoTable memo, ArrayList<Hop> roots, boolean ext) {
        Collection<HashSet<Long>> parts = PlanAnalyzer.getConnectedSubGraphs(memo, roots);
        ArrayList<PlanPartition> ret = new ArrayList<PlanPartition>();
        for (HashSet<Long> partition : parts) {
            HashSet<Long> R = PlanAnalyzer.getPartitionRootNodes(memo, partition);
            HashSet<Long> I = PlanAnalyzer.getPartitionInputNodes(R, partition, memo);
            ArrayList<Long> M = PlanAnalyzer.getMaterializationPoints(R, partition, memo);
            HashSet<Long> Pnpc = PlanAnalyzer.getNodesWithNonPartitionConsumers(R, partition, memo);
            InterestingPoint[] Mext = !ext ? null : PlanAnalyzer.getMaterializationPointsExt(R, partition, M, memo);
            boolean hasOuter = partition.stream().anyMatch(k -> memo.contains((long)k, TemplateBase.TemplateType.OUTER));
            ret.add(new PlanPartition(partition, R, I, Pnpc, M, Mext, hasOuter));
        }
        return ret;
    }

    private static Collection<HashSet<Long>> getConnectedSubGraphs(CPlanMemoTable memo, ArrayList<Hop> roots) {
        HashMap<Long, HashSet<Long>> refBy = new HashMap<Long, HashSet<Long>>();
        for (Map.Entry<Long, List<CPlanMemoTable.MemoTableEntry>> e : memo.getPlans().entrySet()) {
            for (CPlanMemoTable.MemoTableEntry memoTableEntry : e.getValue()) {
                for (int i = 0; i < 3; ++i) {
                    if (!memoTableEntry.isPlanRef(i)) continue;
                    if (!refBy.containsKey(memoTableEntry.input(i))) {
                        refBy.put(memoTableEntry.input(i), new HashSet());
                    }
                    refBy.get(memoTableEntry.input(i)).add(e.getKey());
                }
            }
        }
        ArrayList<HashSet<Long>> parts = new ArrayList<HashSet<Long>>();
        HashSet<Long> visited = new HashSet<Long>();
        for (Map.Entry entry : memo.getPlans().entrySet()) {
            HashSet<Long> part;
            if (refBy.containsKey(entry.getKey()) || (part = PlanAnalyzer.rGetConnectedSubGraphs((Long)entry.getKey(), memo, refBy, visited, new HashSet<Long>())).isEmpty()) continue;
            parts.add(part);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Connected sub graphs: " + parts.size()));
        }
        return parts;
    }

    private static HashSet<Long> getPartitionRootNodes(CPlanMemoTable memo, HashSet<Long> partition) {
        HashSet<Long> ix = new HashSet<Long>();
        for (Long hopID : partition) {
            if (!memo.contains(hopID)) continue;
            for (CPlanMemoTable.MemoTableEntry me : memo.get(hopID)) {
                ix.add(me.input1);
                ix.add(me.input2);
                ix.add(me.input3);
            }
        }
        HashSet<Long> roots = new HashSet<Long>();
        for (Long hopID : partition) {
            if (ix.contains(hopID)) continue;
            roots.add(hopID);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Partition root points: " + Arrays.toString((Object[])roots.toArray(new Long[0]))));
        }
        return roots;
    }

    private static ArrayList<Long> getMaterializationPoints(HashSet<Long> roots, HashSet<Long> partition, CPlanMemoTable memo) {
        ArrayList<Long> ret = new ArrayList<Long>();
        HashSet<Long> visited = new HashSet<Long>();
        for (Long hopID2 : roots) {
            PlanAnalyzer.rCollectMaterializationPoints(memo.getHopRefs().get(hopID2), visited, partition, roots, ret);
        }
        ret.removeIf(hopID -> roots.contains(hopID) || HopRewriteUtils.isTsmmInput(memo.getHopRefs().get(hopID)));
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Partition materialization points: " + Arrays.toString((Object[])ret.toArray(new Long[0]))));
        }
        return ret;
    }

    private static void rCollectMaterializationPoints(Hop current, HashSet<Long> visited, HashSet<Long> partition, HashSet<Long> R, ArrayList<Long> M) {
        if (visited.contains(current.getHopID())) {
            return;
        }
        for (Hop c : current.getInput()) {
            PlanAnalyzer.rCollectMaterializationPoints(c, visited, partition, R, M);
        }
        if (PlanAnalyzer.isMaterializationPointCandidate(current, partition, R)) {
            M.add(current.getHopID());
        }
        visited.add(current.getHopID());
    }

    private static boolean isMaterializationPointCandidate(Hop hop, HashSet<Long> partition, HashSet<Long> R) {
        return hop.getParent().size() >= 2 && hop.getDataType().isMatrix() && partition.contains(hop.getHopID()) && !R.contains(hop.getHopID());
    }

    private static HashSet<Long> getPartitionInputNodes(HashSet<Long> roots, HashSet<Long> partition, CPlanMemoTable memo) {
        HashSet<Long> ret = new HashSet<Long>();
        HashSet<Long> visited = new HashSet<Long>();
        for (Long hopID : roots) {
            Hop current = memo.getHopRefs().get(hopID);
            PlanAnalyzer.rCollectPartitionInputNodes(current, visited, partition, ret);
        }
        return ret;
    }

    private static void rCollectPartitionInputNodes(Hop current, HashSet<Long> visited, HashSet<Long> partition, HashSet<Long> I) {
        if (visited.contains(current.getHopID())) {
            return;
        }
        for (Hop c : current.getInput()) {
            if (partition.contains(c.getHopID())) {
                PlanAnalyzer.rCollectPartitionInputNodes(c, visited, partition, I);
                continue;
            }
            I.add(c.getHopID());
        }
        visited.add(current.getHopID());
    }

    private static HashSet<Long> getNodesWithNonPartitionConsumers(HashSet<Long> roots, HashSet<Long> partition, CPlanMemoTable memo) {
        HashSet<Long> ret = new HashSet<Long>();
        for (Long hopID : partition) {
            Hop hop = memo.getHopRefs().get(hopID);
            if (!PlanAnalyzer.hasNonPartitionConsumer(hop, partition) || roots.contains(hopID)) continue;
            ret.add(hopID);
        }
        return ret;
    }

    private static boolean hasNonPartitionConsumer(Hop hop, HashSet<Long> partition) {
        boolean ret = false;
        for (Hop p : hop.getParent()) {
            ret |= !partition.contains(p.getHopID());
        }
        return ret;
    }

    private static InterestingPoint[] getMaterializationPointsExt(HashSet<Long> roots, HashSet<Long> partition, ArrayList<Long> M, CPlanMemoTable memo) {
        ArrayList<InterestingPoint> tmp = new ArrayList<InterestingPoint>();
        tmp.addAll(PlanAnalyzer.getMaterializationPointConsumers(M, partition, memo));
        tmp.addAll(PlanAnalyzer.getTemplateChangePoints(partition, memo));
        Object[] ret = (InterestingPoint[])tmp.stream().distinct().toArray(InterestingPoint[]::new);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Partition materialization points (extended): " + Arrays.toString(ret)));
        }
        return ret;
    }

    private static ArrayList<InterestingPoint> getMaterializationPointConsumers(ArrayList<Long> M, HashSet<Long> partition, CPlanMemoTable memo) {
        ArrayList<InterestingPoint> ret = new ArrayList<InterestingPoint>();
        for (Long hopID : M) {
            for (Hop parent : memo.getHopRefs().get(hopID).getParent()) {
                if (!partition.contains(parent.getHopID())) continue;
                ret.add(new InterestingPoint(InterestingPoint.DecisionType.MULTI_CONSUMER, parent.getHopID(), hopID));
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Partition materialization point consumers: " + Arrays.toString(ret.toArray(new InterestingPoint[0]))));
        }
        return ret;
    }

    private static ArrayList<InterestingPoint> getTemplateChangePoints(HashSet<Long> partition, CPlanMemoTable memo) {
        ArrayList<InterestingPoint> ret = new ArrayList<InterestingPoint>();
        for (Long hopID : partition) {
            long[] refs = memo.getAllRefs(hopID);
            for (int i = 0; i < 3; ++i) {
                List<TemplateBase.TemplateType> tmp;
                if (refs[i] < 0L || !memo.containsNotIn(refs[i], tmp = memo.getDistinctTemplateTypes(hopID, i, true), true)) continue;
                ret.add(new InterestingPoint(InterestingPoint.DecisionType.TEMPLATE_CHANGE, hopID, refs[i]));
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Partition template change points: " + Arrays.toString(ret.toArray(new InterestingPoint[0]))));
        }
        return ret;
    }

    private static HashSet<Long> rGetConnectedSubGraphs(long hopID, CPlanMemoTable memo, HashMap<Long, HashSet<Long>> refBy, HashSet<Long> visited, HashSet<Long> partition) {
        if (visited.contains(hopID)) {
            return partition;
        }
        if (memo.contains(hopID)) {
            partition.add(hopID);
            visited.add(hopID);
        }
        if (refBy.containsKey(hopID)) {
            for (Long ref : refBy.get(hopID)) {
                PlanAnalyzer.rGetConnectedSubGraphs(ref, memo, refBy, visited, partition);
            }
        }
        if (memo.contains(hopID)) {
            long[] refs = memo.getAllRefs(hopID);
            for (int i = 0; i < 3; ++i) {
                if (refs[i] == -1L) continue;
                PlanAnalyzer.rGetConnectedSubGraphs(refs[i], memo, refBy, visited, partition);
            }
        }
        return partition;
    }
}

