/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.hops.codegen.cplan;

import java.util.ArrayList;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.hops.codegen.cplan.CNodeData;
import org.tugraz.sysds.hops.codegen.template.TemplateUtils;
import org.tugraz.sysds.runtime.controlprogram.parfor.util.IDSequence;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public abstract class CNode {
    private static final IDSequence _seqVar = new IDSequence();
    private static final IDSequence _seqID = new IDSequence();
    protected final long _ID = _seqID.getNextID();
    protected ArrayList<CNode> _inputs = new ArrayList();
    protected CNode _output = null;
    protected boolean _visited = false;
    protected boolean _generated = false;
    protected String _genVar = null;
    protected long _rows = -1L;
    protected long _cols = -1L;
    protected Types.DataType _dataType;
    protected boolean _literal = false;
    protected int _hash = 0;

    public long getID() {
        return this._ID;
    }

    public ArrayList<CNode> getInput() {
        return this._inputs;
    }

    public boolean isGenerated() {
        return this._generated;
    }

    public void resetGenerated() {
        if (this.isGenerated()) {
            for (CNode cn : this._inputs) {
                cn.resetGenerated();
            }
        }
        this._generated = false;
    }

    public String createVarname() {
        this._genVar = "TMP" + _seqVar.getNextID();
        return this._genVar;
    }

    public String getVarname() {
        return this._genVar;
    }

    public String getVectorLength() {
        if (this.getVarname().startsWith("a")) {
            return "len";
        }
        if (this.getVarname().startsWith("b")) {
            return this.getVarname() + ".clen";
        }
        if (this._dataType == Types.DataType.MATRIX) {
            return this.getVarname() + ".length";
        }
        return "";
    }

    public String getClassname() {
        return this.getVarname();
    }

    public void resetHash() {
        this._hash = 0;
    }

    public void setNumRows(long rows) {
        this._rows = rows;
    }

    public long getNumRows() {
        return this._rows;
    }

    public void setNumCols(long cols) {
        this._cols = cols;
    }

    public long getNumCols() {
        return this._cols;
    }

    public Types.DataType getDataType() {
        return this._dataType;
    }

    public void setDataType(Types.DataType dt) {
        this._dataType = dt;
        this._hash = 0;
    }

    public boolean isLiteral() {
        return this._literal;
    }

    public void setLiteral(boolean literal) {
        this._literal = literal;
        this._hash = 0;
    }

    public CNode getOutput() {
        return this._output;
    }

    public void setOutput(CNode output) {
        this._output = output;
        this._hash = 0;
    }

    public boolean isVisited() {
        return this._visited;
    }

    public void setVisited() {
        this.setVisited(true);
    }

    public void setVisited(boolean flag) {
        this._visited = flag;
    }

    public void resetVisitStatus() {
        if (!this.isVisited()) {
            return;
        }
        for (CNode h : this.getInput()) {
            h.resetVisitStatus();
        }
        this.setVisited(false);
    }

    public abstract String codegen(boolean var1);

    public abstract void setOutputDims();

    public int hashCode() {
        if (this._hash == 0) {
            int h = 1;
            for (CNode c : this._inputs) {
                if (c.getDataType() != Types.DataType.MATRIX) continue;
                h = UtilFunctions.intHashCode(h, c.hashCode());
            }
            for (CNode c : this._inputs) {
                if (c.getDataType() == Types.DataType.MATRIX) continue;
                h = UtilFunctions.intHashCode(h, c.hashCode());
            }
            h = UtilFunctions.intHashCode(h, this._output != null ? this._output.hashCode() : 0);
            h = UtilFunctions.intHashCode(h, this._dataType != null ? this._dataType.hashCode() : 0);
            this._hash = h = UtilFunctions.intHashCode(h, Boolean.hashCode(this._literal));
        }
        return this._hash;
    }

    public boolean equals(Object that) {
        if (!(that instanceof CNode)) {
            return false;
        }
        CNode cthat = (CNode)that;
        boolean ret = this._inputs.size() == cthat._inputs.size();
        for (int i = 0; i < this._inputs.size() && ret; ret &= this._inputs.get(i).equals(cthat._inputs.get(i)), ++i) {
        }
        return ret && (this._output == cthat._output || this._output.equals(cthat._output)) && this._dataType == cthat._dataType && this._literal == cthat._literal;
    }

    protected String replaceUnaryPlaceholders(String tmp, String varj, boolean vectIn) {
        tmp = tmp.replace("%IN1v%", varj + "vals");
        tmp = tmp.replace("%IN1i%", varj + "ix");
        tmp = tmp.replace("%IN1%", vectIn && TemplateUtils.isMatrix(this._inputs.get(0)) ? varj + ".values(rix)" : (vectIn && TemplateUtils.isRowVector(this._inputs.get(0)) ? varj + ".values(0)" : varj));
        String spos = this._inputs.get(0) instanceof CNodeData && this._inputs.get(0).getDataType().isMatrix() ? (!varj.startsWith("b") ? varj + "i" : (TemplateUtils.isMatrix(this._inputs.get(0)) ? varj + ".pos(rix)" : "0")) : "0";
        tmp = tmp.replace("%POS1%", spos);
        tmp = tmp.replace("%POS2%", spos);
        if (this._inputs.get(0).getDataType().isMatrix()) {
            tmp = tmp.replace("%LEN%", this._inputs.get(0).getVectorLength());
        }
        return tmp;
    }
}

