/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.hops;

import java.util.ArrayList;
import java.util.HashMap;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.hops.DataGenOp;
import org.tugraz.sysds.hops.DataOp;
import org.tugraz.sysds.hops.Hop;
import org.tugraz.sysds.hops.recompile.RecompileStatus;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;
import org.tugraz.sysds.runtime.meta.MatrixCharacteristics;

public class MemoTable {
    private HashMap<Long, DataCharacteristics> _memo = new HashMap();

    public void init(ArrayList<Hop> hops, RecompileStatus status) {
        if (hops == null || hops.isEmpty() || status == null || status.getTWriteStats().isEmpty()) {
            return;
        }
        Hop.resetVisitStatus(hops);
        for (Hop hop : hops) {
            this.rinit(hop, status);
        }
    }

    public void init(Hop hop, RecompileStatus status) {
        if (hop == null || status == null || status.getTWriteStats().isEmpty()) {
            return;
        }
        hop.resetVisitStatus();
        this.rinit(hop, status);
    }

    public void extract(ArrayList<Hop> hops, RecompileStatus status) {
        if (status == null) {
            return;
        }
        for (Hop hop : hops) {
            if (!(hop instanceof DataOp) || ((DataOp)hop).getOp() != Types.OpOpData.TRANSIENTWRITE) continue;
            String varname = hop.getName();
            Hop input = hop.getInput().get(0);
            DataCharacteristics dc = this.getAllInputStats(input);
            if (dc != null) {
                status.getTWriteStats().put(varname, dc);
                continue;
            }
            status.getTWriteStats().remove(varname);
        }
    }

    public void memoizeStatistics(long hopID, long dim1, long dim2, long nnz) {
        this._memo.put(hopID, new MatrixCharacteristics(dim1, dim2, -1, nnz));
    }

    public void memoizeStatistics(long hopID, DataCharacteristics dc) {
        this._memo.put(hopID, dc);
    }

    public DataCharacteristics[] getAllInputStats(ArrayList<Hop> inputs) {
        if (inputs == null) {
            return null;
        }
        DataCharacteristics[] ret = new MatrixCharacteristics[inputs.size()];
        for (int i = 0; i < inputs.size(); ++i) {
            Hop input = inputs.get(i);
            long dim1 = input.getDim1();
            long dim2 = input.getDim2();
            long nnz = input.getNnz();
            if (input.dimsKnown()) {
                ret[i] = new MatrixCharacteristics(dim1, dim2, -1, nnz);
                continue;
            }
            DataCharacteristics tmp = this._memo.get(input.getHopID());
            if (tmp != null) {
                dim1 = dim1 <= 0L ? tmp.getRows() : dim1;
                dim2 = dim2 <= 0L ? tmp.getCols() : dim2;
                nnz = nnz <= 0L ? tmp.getNonZeros() : nnz;
            }
            ret[i] = new MatrixCharacteristics(dim1, dim2, -1, nnz);
        }
        return ret;
    }

    public DataCharacteristics getAllInputStats(Hop input) {
        if (input == null) {
            return null;
        }
        MatrixCharacteristics ret = null;
        long dim1 = input.getDim1();
        long dim2 = input.getDim2();
        long nnz = input.getNnz();
        if (input.dimsKnown(true)) {
            ret = new MatrixCharacteristics(dim1, dim2, -1, nnz);
        } else {
            DataCharacteristics tmp = this._memo.get(input.getHopID());
            if (tmp != null) {
                dim1 = dim1 <= 0L ? tmp.getRows() : dim1;
                dim2 = dim2 <= 0L ? tmp.getCols() : dim2;
                nnz = nnz < 0L ? tmp.getNonZeros() : nnz;
            }
            ret = new MatrixCharacteristics(dim1, dim2, -1, nnz);
        }
        return ret;
    }

    public boolean hasInputStatistics(Hop h) {
        boolean ret = false;
        for (Hop in : h.getInput()) {
            if (!in.dimsKnownAny() && !this._memo.containsKey(in.getHopID())) continue;
            ret = true;
            break;
        }
        if (h instanceof DataOp && ((DataOp)h).getOp() == Types.OpOpData.TRANSIENTREAD || h instanceof DataGenOp) {
            ret = true;
        }
        return ret;
    }

    private void rinit(Hop hop, RecompileStatus status) {
        if (hop.isVisited()) {
            return;
        }
        if (hop instanceof DataOp && hop.getDataType() == Types.DataType.MATRIX && ((DataOp)hop).getOp() == Types.OpOpData.TRANSIENTREAD) {
            String varname = hop.getName();
            DataCharacteristics dc = status.getTWriteStats().get(varname);
            if (dc != null) {
                this._memo.put(hop.getHopID(), dc);
            }
        }
        if (hop.getInput() != null && !hop.getInput().isEmpty()) {
            for (Hop c : hop.getInput()) {
                this.rinit(c, status);
            }
        }
        hop.setVisited();
    }
}

