/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.hops;

import java.util.HashMap;
import java.util.Map;
import org.tugraz.sysds.api.DMLScript;
import org.tugraz.sysds.common.Types;
import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.hops.Hop;
import org.tugraz.sysds.hops.HopsException;
import org.tugraz.sysds.hops.LiteralOp;
import org.tugraz.sysds.hops.MemoTable;
import org.tugraz.sysds.hops.MultiThreadedHop;
import org.tugraz.sysds.hops.OptimizerUtils;
import org.tugraz.sysds.hops.rewrite.HopRewriteUtils;
import org.tugraz.sysds.lops.DataGen;
import org.tugraz.sysds.lops.Lop;
import org.tugraz.sysds.lops.LopProperties;
import org.tugraz.sysds.parser.DataIdentifier;
import org.tugraz.sysds.runtime.meta.DataCharacteristics;
import org.tugraz.sysds.runtime.meta.MatrixCharacteristics;
import org.tugraz.sysds.runtime.util.UtilFunctions;

public class DataGenOp
extends MultiThreadedHop {
    public static final long UNSPECIFIED_SEED = -1L;
    private Types.OpOpDG _op;
    private HashMap<String, Integer> _paramIndexMap = new HashMap();
    private DataIdentifier _id;
    private double _sparsity = -1.0;
    private String _baseDir;
    private double _incr = Double.MAX_VALUE;

    private DataGenOp() {
    }

    public DataGenOp(Types.OpOpDG mthd, DataIdentifier id, HashMap<String, Hop> inputParameters) {
        super(id.getName(), id.getDataType().isUnknown() ? Types.DataType.MATRIX : id.getDataType(), id.getValueType().isUnknown() ? Types.ValueType.FP64 : id.getValueType());
        this._id = id;
        this._op = mthd;
        if (inputParameters.containsKey("dims")) {
            this.setDataType(Types.DataType.TENSOR);
        }
        int index = 0;
        for (Map.Entry<String, Hop> e : inputParameters.entrySet()) {
            String s = e.getKey();
            Hop input = e.getValue();
            this.getInput().add(input);
            input.getParent().add(this);
            this._paramIndexMap.put(s, index);
            ++index;
        }
        Hop sparsityOp = inputParameters.get("sparsity");
        if (mthd == Types.OpOpDG.RAND && sparsityOp instanceof LiteralOp) {
            this._sparsity = HopRewriteUtils.getDoubleValue((LiteralOp)sparsityOp);
        }
        String scratch = ConfigurationManager.getScratchSpace();
        this._baseDir = scratch + "/" + "_p" + DMLScript.getUUID() + "/" + "/" + "_t0" + "/";
        this.refreshSizeInformation();
    }

    public DataGenOp(Types.OpOpDG mthd, DataIdentifier id) {
        super(id.getName(), Types.DataType.SCALAR, Types.ValueType.INT64);
        this._id = id;
        this._op = mthd;
        String scratch = ConfigurationManager.getScratchSpace();
        this._baseDir = scratch + "/" + "_p" + DMLScript.getUUID() + "/" + "/" + "_t0" + "/";
        this.refreshSizeInformation();
    }

    @Override
    public void checkArity() {
        int pz;
        int sz = this._input.size();
        HopsException.check(sz == (pz = this._paramIndexMap.size()), this, "has %d inputs but %d parameters", sz, pz);
    }

    @Override
    public String getOpString() {
        return "dg(" + this._op.toString().toLowerCase() + ")";
    }

    public Types.OpOpDG getOp() {
        return this._op;
    }

    @Override
    public boolean isGPUEnabled() {
        return false;
    }

    @Override
    public boolean isMultiThreadedOpType() {
        return this._op == Types.OpOpDG.RAND;
    }

    @Override
    public Lop constructLops() {
        if (this.getLops() != null) {
            return this.getLops();
        }
        LopProperties.ExecType et = this.optFindExecType();
        HashMap<String, Lop> inputLops = new HashMap<String, Lop>();
        for (Map.Entry<String, Integer> cur : this._paramIndexMap.entrySet()) {
            if (cur.getKey().equals("rows") && this.rowsKnown()) {
                inputLops.put(cur.getKey(), new LiteralOp(this.getDim1()).constructLops());
                continue;
            }
            if (cur.getKey().equals("cols") && this.colsKnown()) {
                inputLops.put(cur.getKey(), new LiteralOp(this.getDim2()).constructLops());
                continue;
            }
            inputLops.put(cur.getKey(), this.getInput().get(cur.getValue()).constructLops());
        }
        DataGen rnd = new DataGen(this._op, this._id, inputLops, this._baseDir, this.getDataType(), this.getValueType(), et);
        int k = OptimizerUtils.getConstrainedNumThreads(this._maxNumThreads);
        rnd.setNumThreads(k);
        rnd.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this.getBlocksize() > 0 ? (long)this.getBlocksize() : (long)ConfigurationManager.getBlocksize(), this._op == Types.OpOpDG.RAND && et == LopProperties.ExecType.SPARK && this.getNnz() != 0L ? -1L : this.getNnz(), this.getUpdateType());
        this.setLineNumbers(rnd);
        this.setLops(rnd);
        this.constructAndSetLopsDataFlowProperties();
        return this.getLops();
    }

    @Override
    public boolean allowsAllExecTypes() {
        return true;
    }

    @Override
    protected double computeOutputMemEstimate(long dim1, long dim2, long nnz) {
        double ret = this._op == Types.OpOpDG.RAND && this._sparsity != -1.0 ? (this.hasConstantValue(0.0) ? (double)OptimizerUtils.estimateSizeEmptyBlock(dim1, dim2) : (double)OptimizerUtils.estimateSizeExactSparsity(dim1, dim2, this._sparsity)) : (double)OptimizerUtils.estimateSizeExactSparsity(dim1, dim2, 1.0);
        return ret;
    }

    @Override
    protected double computeIntermediateMemEstimate(long dim1, long dim2, long nnz) {
        if (this._op == Types.OpOpDG.RAND && this.dimsKnown()) {
            long numBlocks = (long)(Math.ceil((double)dim1 / (double)ConfigurationManager.getBlocksize()) * Math.ceil((double)dim2 / (double)ConfigurationManager.getBlocksize()));
            return 32.0 + (double)numBlocks * 8.0;
        }
        return 0.0;
    }

    @Override
    protected DataCharacteristics inferOutputCharacteristics(MemoTable memo) {
        if ((this._op == Types.OpOpDG.RAND || this._op == Types.OpOpDG.SINIT) && OptimizerUtils.ALLOW_WORSTCASE_SIZE_EXPRESSION_EVALUATION) {
            long nnz;
            if (this._paramIndexMap.containsKey("dims")) {
                return null;
            }
            long dim1 = this.computeDimParameterInformation(this.getInput().get(this._paramIndexMap.get("rows")), memo);
            long dim2 = this.computeDimParameterInformation(this.getInput().get(this._paramIndexMap.get("cols")), memo);
            long l = nnz = this._sparsity >= 0.0 ? (long)(this._sparsity * (double)dim1 * (double)dim2) : -1L;
            if (dim1 >= 0L && dim2 >= 0L) {
                return new MatrixCharacteristics(dim1, dim2, -1, nnz);
            }
        } else if (this._op == Types.OpOpDG.SEQ) {
            long fromVal;
            long toVal;
            Hop from = this.getInput().get(this._paramIndexMap.get("from"));
            Hop to = this.getInput().get(this._paramIndexMap.get("to"));
            Hop incr = this.getInput().get(this._paramIndexMap.get("incr"));
            if (from instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)from) == 1.0 && incr instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)incr) == 1.0 && (toVal = this.computeDimParameterInformation(to, memo)) > 0L) {
                return new MatrixCharacteristics(toVal, 1L, -1, -1L);
            }
            if (to instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)to) == 1.0 && incr instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)incr) == -1.0 && (fromVal = this.computeDimParameterInformation(from, memo)) > 0L) {
                return new MatrixCharacteristics(fromVal, 1L, -1, -1L);
            }
        }
        return null;
    }

    @Override
    protected LopProperties.ExecType optFindExecType() {
        this.checkAndSetForcedPlatform();
        if (this._etypeForced != null) {
            this._etype = this._etypeForced;
        } else {
            this._etype = OptimizerUtils.isMemoryBasedOptLevel() ? this.findExecTypeByMemEstimate() : (this.areDimsBelowThreshold() || this.isVector() ? LopProperties.ExecType.CP : LopProperties.ExecType.SPARK);
            this.checkAndSetInvalidCPDimsAndSize();
        }
        this.setRequiresRecompileIfNecessary();
        if (this._op == Types.OpOpDG.SINIT || this._op == Types.OpOpDG.TIME) {
            this._etype = LopProperties.ExecType.CP;
        }
        return this._etype;
    }

    @Override
    public void refreshSizeInformation() {
        if (this._op == Types.OpOpDG.RAND || this._op == Types.OpOpDG.SINIT) {
            if (this._dataType != Types.DataType.TENSOR) {
                Hop input1 = this.getInput().get(this._paramIndexMap.get("rows"));
                Hop input2 = this.getInput().get(this._paramIndexMap.get("cols"));
                this.refreshRowsParameterInformation(input1);
                this.refreshColsParameterInformation(input2);
            }
        } else if (this._op == Types.OpOpDG.SEQ) {
            boolean incrKnown;
            Hop input1 = this.getInput().get(this._paramIndexMap.get("from"));
            Hop input2 = this.getInput().get(this._paramIndexMap.get("to"));
            Hop input3 = this.getInput().get(this._paramIndexMap.get("incr"));
            double from = this.computeBoundsInformation(input1);
            boolean fromKnown = from != Double.MAX_VALUE;
            double to = this.computeBoundsInformation(input2);
            boolean toKnown = to != Double.MAX_VALUE;
            double incr = this.computeBoundsInformation(input3);
            boolean bl = incrKnown = incr != Double.MAX_VALUE;
            if (fromKnown && toKnown && incr == 1.0) {
                double d = incr = from >= to ? -1.0 : 1.0;
            }
            if (fromKnown && toKnown && incrKnown) {
                this.setDim1(UtilFunctions.getSeqLength(from, to, incr, false));
                this.setDim2(1L);
                this._incr = incr;
            }
        } else if (this._op == Types.OpOpDG.TIME) {
            this.setDim1(0L);
            this.setDim2(0L);
            this._dataType = Types.DataType.SCALAR;
            this._valueType = Types.ValueType.INT64;
        }
        if (this._op == Types.OpOpDG.RAND && this.hasConstantValue(0.0)) {
            this.setNnz(0L);
        } else if (this.dimsKnown() && this._sparsity >= 0.0) {
            this.setNnz((long)(this._sparsity * (double)this.getLength()));
        } else {
            this.setNnz(-1L);
        }
    }

    public HashMap<String, Integer> getParamIndexMap() {
        return this._paramIndexMap;
    }

    public Hop getParam(String key) {
        return this.getInput().get(this.getParamIndex(key));
    }

    public int getParamIndex(String key) {
        return this._paramIndexMap.get(key);
    }

    public Hop getInput(String key) {
        return this.getInput().get(this.getParamIndex(key));
    }

    public void setInput(String key, Hop hop, boolean linkParent) {
        this.getInput().set(this.getParamIndex(key), hop);
        if (linkParent) {
            hop.getParent().add(this);
        }
    }

    public boolean hasConstantValue() {
        if (this._op != Types.OpOpDG.RAND) {
            return false;
        }
        Hop min = this.getInput().get(this._paramIndexMap.get("min"));
        Hop max = this.getInput().get(this._paramIndexMap.get("max"));
        Hop sparsity = this.getInput().get(this._paramIndexMap.get("sparsity"));
        if (min instanceof LiteralOp && max instanceof LiteralOp && sparsity instanceof LiteralOp) {
            try {
                double minVal = HopRewriteUtils.getDoubleValue((LiteralOp)min);
                double maxVal = HopRewriteUtils.getDoubleValue((LiteralOp)max);
                double sp = HopRewriteUtils.getDoubleValue((LiteralOp)sparsity);
                return sp == 1.0 && minVal == maxVal;
            }
            catch (Exception ex) {
                return false;
            }
        }
        if (min == max && sparsity instanceof LiteralOp) {
            return HopRewriteUtils.getDoubleValueSafe((LiteralOp)sparsity) == 1.0;
        }
        return false;
    }

    public boolean hasConstantValue(double val) {
        if (this._op != Types.OpOpDG.RAND) {
            return false;
        }
        boolean ret = false;
        Hop min = this.getInput().get(this._paramIndexMap.get("min"));
        Hop max = this.getInput().get(this._paramIndexMap.get("max"));
        if (min instanceof LiteralOp && max instanceof LiteralOp) {
            double minVal = HopRewriteUtils.getDoubleValueSafe((LiteralOp)min);
            double maxVal = HopRewriteUtils.getDoubleValueSafe((LiteralOp)max);
            boolean bl = ret = minVal == val && maxVal == val;
        }
        if (ret && val != 0.0) {
            Hop sparsity = this.getInput().get(this._paramIndexMap.get("sparsity"));
            ret = sparsity == null || sparsity instanceof LiteralOp && HopRewriteUtils.getDoubleValueSafe((LiteralOp)sparsity) == 1.0;
        }
        return ret;
    }

    public Hop getConstantValue() {
        return this.getInput().get(this._paramIndexMap.get("min"));
    }

    public void setIncrementValue(double incr) {
        this._incr = incr;
    }

    public double getIncrementValue() {
        return this._incr;
    }

    public static long generateRandomSeed() {
        return System.nanoTime();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DataGenOp ret = new DataGenOp();
        ret.clone(this, false);
        ret._op = this._op;
        ret._id = this._id;
        ret._sparsity = this._sparsity;
        ret._baseDir = this._baseDir;
        ret._paramIndexMap = (HashMap)this._paramIndexMap.clone();
        ret._maxNumThreads = this._maxNumThreads;
        return ret;
    }

    @Override
    public boolean compare(Hop that) {
        boolean ret;
        if (!(that instanceof DataGenOp)) {
            return false;
        }
        if (this._op == Types.OpOpDG.TIME) {
            return false;
        }
        DataGenOp that2 = (DataGenOp)that;
        boolean bl = ret = this._op == that2._op && this._sparsity == that2._sparsity && this._baseDir.equals(that2._baseDir) && this._paramIndexMap != null && that2._paramIndexMap != null && this._maxNumThreads == that2._maxNumThreads;
        if (ret) {
            for (Map.Entry<String, Integer> e : this._paramIndexMap.entrySet()) {
                String key1 = e.getKey();
                int pos1 = e.getValue();
                int pos2 = that2._paramIndexMap.getOrDefault(key1, -1);
                ret &= pos2 >= 0 && that2.getInput().get(pos2) != null && this.getInput().get(pos1) == that2.getInput().get(pos2);
            }
            if (this._op == Types.OpOpDG.RAND || this._op == Types.OpOpDG.SINIT) {
                Hop seed = this.getInput().get(this._paramIndexMap.get("seed"));
                Hop min = this.getInput().get(this._paramIndexMap.get("min"));
                Hop max = this.getInput().get(this._paramIndexMap.get("max"));
                if (seed.getName().equals(String.valueOf(-1L)) && min != max) {
                    ret = false;
                }
            }
        }
        return ret;
    }
}

