/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.common;

import org.tugraz.sysds.runtime.DMLRuntimeException;

public class Types {

    public static enum FileFormat {
        TEXT,
        BINARY,
        MM,
        CSV,
        LIBSVM;

    }

    public static enum OpOpData {
        PERSISTENTREAD,
        PERSISTENTWRITE,
        TRANSIENTREAD,
        TRANSIENTWRITE,
        FUNCTIONOUTPUT,
        SQLREAD,
        FEDERATED;


        public boolean isTransient() {
            return this == TRANSIENTREAD || this == TRANSIENTWRITE;
        }

        public boolean isPersistent() {
            return this == PERSISTENTREAD || this == PERSISTENTWRITE;
        }

        public boolean isWrite() {
            return this == TRANSIENTWRITE || this == PERSISTENTWRITE;
        }

        public boolean isRead() {
            return this == TRANSIENTREAD || this == PERSISTENTREAD;
        }

        public String toString() {
            switch (this) {
                case PERSISTENTREAD: {
                    return "PRead";
                }
                case PERSISTENTWRITE: {
                    return "PWrite";
                }
                case TRANSIENTREAD: {
                    return "TRead";
                }
                case TRANSIENTWRITE: {
                    return "TWrite";
                }
                case FUNCTIONOUTPUT: {
                    return "FunOut";
                }
                case SQLREAD: {
                    return "Sql";
                }
                case FEDERATED: {
                    return "Fed";
                }
            }
            return "Invalid";
        }
    }

    public static enum OpOpDG {
        RAND,
        SEQ,
        SINIT,
        SAMPLE,
        TIME;

    }

    public static enum OpOpDnn {
        MAX_POOL,
        MAX_POOL_BACKWARD,
        AVG_POOL,
        AVG_POOL_BACKWARD,
        CONV2D,
        CONV2D_BACKWARD_FILTER,
        CONV2D_BACKWARD_DATA,
        BIASADD,
        BIASMULT,
        BATCH_NORM2D_TEST,
        CHANNEL_SUMS,
        UPDATE_NESTEROV_X,
        CONV2D_BIAS_ADD,
        RELU_MAX_POOL,
        RELU_MAX_POOL_BACKWARD,
        RELU_BACKWARD;

    }

    public static enum ParamBuiltinOp {
        INVALID,
        CDF,
        INVCDF,
        GROUPEDAGG,
        RMEMPTY,
        REPLACE,
        REXPAND,
        LOWER_TRI,
        UPPER_TRI,
        TRANSFORMAPPLY,
        TRANSFORMDECODE,
        TRANSFORMCOLMAP,
        TRANSFORMMETA,
        TOSTRING,
        LIST,
        PARAMSERV;

    }

    public static enum ReOrgOp {
        DIAG,
        RESHAPE,
        REV,
        SORT,
        TRANS;


        public String toString() {
            switch (this) {
                case TRANS: {
                    return "t";
                }
                case RESHAPE: {
                    return "rshape";
                }
            }
            return this.name().toLowerCase();
        }
    }

    public static enum OpOpN {
        PRINTF,
        CBIND,
        RBIND,
        MIN,
        MAX,
        PLUS,
        EVAL,
        LIST;


        public boolean isCellOp() {
            return this == MIN || this == MAX || this == PLUS;
        }
    }

    public static enum OpOp4 {
        WSLOSS,
        WSIGMOID,
        WDIVMM,
        WCEMM,
        WUMM;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum OpOp3 {
        QUANTILE,
        INTERQUANTILE,
        CTABLE,
        MOMENT,
        COV,
        PLUS_MULT,
        MINUS_MULT,
        IFELSE;


        public String toString() {
            switch (this) {
                case MOMENT: {
                    return "cm";
                }
                case PLUS_MULT: {
                    return "+*";
                }
                case MINUS_MULT: {
                    return "-*";
                }
            }
            return this.name().toLowerCase();
        }

        public static OpOp3 valueOfCode(String code) {
            switch (code) {
                case "cm": {
                    return MOMENT;
                }
                case "+*": {
                    return PLUS_MULT;
                }
                case "-*": {
                    return MINUS_MULT;
                }
            }
            return OpOp3.valueOf(code);
        }
    }

    public static enum AggOp {
        SUM,
        SUM_SQ,
        PROD,
        SUM_PROD,
        MIN,
        MAX,
        TRACE,
        MEAN,
        VAR,
        MAXINDEX,
        MININDEX;


        public String toString() {
            switch (this) {
                case SUM: {
                    return "+";
                }
                case SUM_SQ: {
                    return "sq+";
                }
                case PROD: {
                    return "*";
                }
            }
            return this.name().toLowerCase();
        }
    }

    public static enum CorrectionLocationType {
        NONE,
        LASTROW,
        LASTCOLUMN,
        LASTTWOROWS,
        LASTTWOCOLUMNS,
        LASTFOURROWS,
        LASTFOURCOLUMNS,
        INVALID;


        public int getNumRemovedRowsColumns() {
            return this == LASTROW || this == LASTCOLUMN ? 1 : (this == LASTTWOROWS || this == LASTTWOCOLUMNS ? 2 : (this == LASTFOURROWS || this == LASTFOURCOLUMNS ? 4 : 0));
        }

        public boolean isRows() {
            return this == LASTROW || this == LASTTWOROWS || this == LASTFOURROWS;
        }
    }

    public static enum Direction {
        RowCol,
        Row,
        Col;


        public String toString() {
            switch (this) {
                case RowCol: {
                    return "RC";
                }
                case Row: {
                    return "R";
                }
                case Col: {
                    return "C";
                }
            }
            throw new RuntimeException("Invalid direction type: " + (Object)((Object)this));
        }
    }

    public static enum ReturnType {
        NO_RETURN,
        SINGLE_RETURN,
        MULTI_RETURN;

    }

    public static enum BlockType {
        EMPTY_BLOCK,
        ULTRA_SPARSE_BLOCK,
        SPARSE_BLOCK,
        DENSE_BLOCK;

    }

    public static enum ValueType {
        FP32,
        FP64,
        INT32,
        INT64,
        BOOLEAN,
        STRING,
        UNKNOWN;


        public boolean isNumeric() {
            return this == INT32 || this == INT64 || this == FP32 || this == FP64;
        }

        public boolean isUnknown() {
            return this == UNKNOWN;
        }

        public boolean isPseudoNumeric() {
            return this.isNumeric() || this == BOOLEAN;
        }

        public String toExternalString() {
            switch (this) {
                case FP32: 
                case FP64: {
                    return "DOUBLE";
                }
                case INT32: 
                case INT64: {
                    return "INT";
                }
                case BOOLEAN: {
                    return "BOOLEAN";
                }
            }
            return this.toString();
        }

        public static ValueType fromExternalString(String value) {
            String lvalue;
            switch (lvalue = value != null ? value.toUpperCase() : null) {
                case "FP32": {
                    return FP32;
                }
                case "FP64": 
                case "DOUBLE": {
                    return FP64;
                }
                case "INT32": {
                    return INT32;
                }
                case "INT64": 
                case "INT": {
                    return INT64;
                }
                case "BOOLEAN": {
                    return BOOLEAN;
                }
                case "STRING": {
                    return STRING;
                }
            }
            throw new DMLRuntimeException("Unknown value type: " + value);
        }
    }

    public static enum DataType {
        TENSOR,
        MATRIX,
        SCALAR,
        FRAME,
        LIST,
        UNKNOWN;


        public boolean isMatrix() {
            return this == MATRIX;
        }

        public boolean isTensor() {
            return this == TENSOR;
        }

        public boolean isFrame() {
            return this == FRAME;
        }

        public boolean isScalar() {
            return this == SCALAR;
        }

        public boolean isList() {
            return this == LIST;
        }

        public boolean isUnknown() {
            return this == UNKNOWN;
        }
    }

    public static enum ExecType {
        CP,
        CP_FILE,
        SPARK,
        GPU,
        INVALID;

    }

    public static enum ExecMode {
        SINGLE_NODE,
        HYBRID,
        SPARK;

    }
}

