/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.api.mlcontext;

import org.tugraz.sysds.conf.ConfigurationManager;
import org.tugraz.sysds.runtime.meta.MatrixCharacteristics;

public abstract class Metadata {
    protected Long numRows = null;
    protected Long numColumns = null;
    protected Integer blockSize = null;
    protected Long numNonZeros = null;

    public MatrixCharacteristics asMatrixCharacteristics() {
        if (this.numRows == null && this.numColumns == null && this.blockSize == null && this.numNonZeros == null) {
            return null;
        }
        long nr = this.numRows == null ? -1L : this.numRows;
        long nc = this.numColumns == null ? -1L : this.numColumns;
        int blen = this.blockSize == null ? ConfigurationManager.getBlocksize() : this.blockSize;
        long nnz = this.numNonZeros == null ? -1L : this.numNonZeros;
        return new MatrixCharacteristics(nr, nc, blen, nnz);
    }

    protected String fieldDisplay(Object field) {
        if (field == null) {
            return "None";
        }
        return field.toString();
    }

    public Long getNumColumns() {
        return this.numColumns;
    }

    public Long getNumNonZeros() {
        return this.numNonZeros;
    }

    public Long getNumRows() {
        return this.numRows;
    }

    public Integer getBlocksize() {
        return this.blockSize;
    }

    public void setMatrixCharacteristics(MatrixCharacteristics matrixCharacteristics) {
        this.numRows = matrixCharacteristics.getRows();
        this.numColumns = matrixCharacteristics.getCols();
        this.numNonZeros = matrixCharacteristics.getNonZeros();
        this.blockSize = matrixCharacteristics.getBlocksize();
    }

    public void setNumColumns(Long numColumns) {
        this.numColumns = numColumns;
    }

    public void setNumNonZeros(Long numNonZeros) {
        this.numNonZeros = numNonZeros;
    }

    public void setNumRows(Long numRows) {
        this.numRows = numRows;
    }

    public void setBlocksize(Integer blen) {
        this.blockSize = blen;
    }

    public String toString() {
        return "rows: " + this.fieldDisplay(this.numRows) + ", columns: " + this.fieldDisplay(this.numColumns) + ", non-zeros: " + this.fieldDisplay(this.numNonZeros) + ", blocksize: " + this.fieldDisplay(this.blockSize);
    }
}

