/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.api.mlcontext;

import java.util.Set;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.tugraz.sysds.api.mlcontext.Frame;
import org.tugraz.sysds.api.mlcontext.MLContextConversionUtil;
import org.tugraz.sysds.api.mlcontext.MLContextException;
import org.tugraz.sysds.api.mlcontext.MLContextUtil;
import org.tugraz.sysds.api.mlcontext.Matrix;
import org.tugraz.sysds.api.mlcontext.Script;
import org.tugraz.sysds.api.mlcontext.ScriptExecutor;
import org.tugraz.sysds.runtime.controlprogram.LocalVariableMap;
import org.tugraz.sysds.runtime.controlprogram.caching.FrameObject;
import org.tugraz.sysds.runtime.controlprogram.caching.MatrixObject;
import org.tugraz.sysds.runtime.controlprogram.context.ExecutionContext;
import org.tugraz.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.tugraz.sysds.runtime.instructions.cp.BooleanObject;
import org.tugraz.sysds.runtime.instructions.cp.Data;
import org.tugraz.sysds.runtime.instructions.cp.DoubleObject;
import org.tugraz.sysds.runtime.instructions.cp.IntObject;
import org.tugraz.sysds.runtime.instructions.cp.ScalarObject;
import org.tugraz.sysds.runtime.instructions.cp.StringObject;
import scala.Tuple1;
import scala.Tuple10;
import scala.Tuple11;
import scala.Tuple12;
import scala.Tuple13;
import scala.Tuple14;
import scala.Tuple15;
import scala.Tuple16;
import scala.Tuple17;
import scala.Tuple18;
import scala.Tuple19;
import scala.Tuple2;
import scala.Tuple20;
import scala.Tuple21;
import scala.Tuple22;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.Tuple6;
import scala.Tuple7;
import scala.Tuple8;
import scala.Tuple9;

public class MLResults {
    protected LocalVariableMap symbolTable = null;
    protected Script script = null;
    protected SparkExecutionContext sparkExecutionContext = null;

    public MLResults() {
    }

    public MLResults(LocalVariableMap symbolTable) {
        this.symbolTable = symbolTable;
    }

    public MLResults(Script script) {
        this.script = script;
        this.symbolTable = script.getSymbolTable();
        ScriptExecutor scriptExecutor = script.getScriptExecutor();
        ExecutionContext executionContext = scriptExecutor.getExecutionContext();
        if (executionContext instanceof SparkExecutionContext) {
            this.sparkExecutionContext = (SparkExecutionContext)executionContext;
        }
    }

    public Data getData(String outputName) {
        Set<String> keys = this.symbolTable.keySet();
        if (!keys.contains(outputName)) {
            throw new MLContextException("Variable '" + outputName + "' not found");
        }
        return this.symbolTable.get(outputName);
    }

    public MatrixObject getMatrixObject(String outputName) {
        Data data = this.getData(outputName);
        if (!(data instanceof MatrixObject)) {
            throw new MLContextException("Variable '" + outputName + "' not a matrix");
        }
        return (MatrixObject)data;
    }

    public FrameObject getFrameObject(String outputName) {
        Data data = this.getData(outputName);
        if (!(data instanceof FrameObject)) {
            throw new MLContextException("Variable '" + outputName + "' not a frame");
        }
        return (FrameObject)data;
    }

    public double[][] getMatrixAs2DDoubleArray(String outputName) {
        MatrixObject mo = this.getMatrixObject(outputName);
        return MLContextConversionUtil.matrixObjectTo2DDoubleArray(mo);
    }

    public JavaRDD<String> getJavaRDDStringIJV(String outputName) {
        if (this.isMatrixObject(outputName)) {
            MatrixObject mo = this.getMatrixObject(outputName);
            return MLContextConversionUtil.matrixObjectToJavaRDDStringIJV(mo);
        }
        if (this.isFrameObject(outputName)) {
            FrameObject fo = this.getFrameObject(outputName);
            return MLContextConversionUtil.frameObjectToJavaRDDStringIJV(fo);
        }
        return null;
    }

    public JavaRDD<String> getJavaRDDStringCSV(String outputName) {
        if (this.isMatrixObject(outputName)) {
            MatrixObject mo = this.getMatrixObject(outputName);
            return MLContextConversionUtil.matrixObjectToJavaRDDStringCSV(mo);
        }
        if (this.isFrameObject(outputName)) {
            FrameObject fo = this.getFrameObject(outputName);
            return MLContextConversionUtil.frameObjectToJavaRDDStringCSV(fo, ",");
        }
        return null;
    }

    public RDD<String> getRDDStringCSV(String outputName) {
        if (this.isMatrixObject(outputName)) {
            MatrixObject mo = this.getMatrixObject(outputName);
            return MLContextConversionUtil.matrixObjectToRDDStringCSV(mo);
        }
        if (this.isFrameObject(outputName)) {
            FrameObject fo = this.getFrameObject(outputName);
            return MLContextConversionUtil.frameObjectToRDDStringCSV(fo, ",");
        }
        return null;
    }

    public RDD<String> getRDDStringIJV(String outputName) {
        if (this.isMatrixObject(outputName)) {
            MatrixObject mo = this.getMatrixObject(outputName);
            return MLContextConversionUtil.matrixObjectToRDDStringIJV(mo);
        }
        if (this.isFrameObject(outputName)) {
            FrameObject fo = this.getFrameObject(outputName);
            return MLContextConversionUtil.frameObjectToRDDStringIJV(fo);
        }
        return null;
    }

    public Dataset<Row> getDataFrame(String outputName) {
        if (this.isMatrixObject(outputName)) {
            MatrixObject mo = this.getMatrixObject(outputName);
            return MLContextConversionUtil.matrixObjectToDataFrame(mo, this.sparkExecutionContext, false);
        }
        if (this.isFrameObject(outputName)) {
            FrameObject mo = this.getFrameObject(outputName);
            return MLContextConversionUtil.frameObjectToDataFrame(mo, this.sparkExecutionContext);
        }
        return null;
    }

    private boolean isMatrixObject(String outputName) {
        Data data = this.getData(outputName);
        return data instanceof MatrixObject;
    }

    private boolean isFrameObject(String outputName) {
        Data data = this.getData(outputName);
        return data instanceof FrameObject;
    }

    public Dataset<Row> getDataFrame(String outputName, boolean isVectorDF) {
        if (this.isFrameObject(outputName)) {
            throw new MLContextException("This method currently supports only matrices");
        }
        MatrixObject mo = this.getMatrixObject(outputName);
        return MLContextConversionUtil.matrixObjectToDataFrame(mo, this.sparkExecutionContext, isVectorDF);
    }

    public Dataset<Row> getDataFrameDoubleWithIDColumn(String outputName) {
        if (this.isFrameObject(outputName)) {
            throw new MLContextException("This method currently supports only matrices");
        }
        MatrixObject mo = this.getMatrixObject(outputName);
        return MLContextConversionUtil.matrixObjectToDataFrame(mo, this.sparkExecutionContext, false);
    }

    public Dataset<Row> getDataFrameVectorWithIDColumn(String outputName) {
        if (this.isFrameObject(outputName)) {
            throw new MLContextException("This method currently supports only matrices");
        }
        MatrixObject mo = this.getMatrixObject(outputName);
        return MLContextConversionUtil.matrixObjectToDataFrame(mo, this.sparkExecutionContext, true);
    }

    public Dataset<Row> getDataFrameDoubleNoIDColumn(String outputName) {
        if (this.isFrameObject(outputName)) {
            throw new MLContextException("This method currently supports only matrices");
        }
        MatrixObject mo = this.getMatrixObject(outputName);
        Dataset<Row> df = MLContextConversionUtil.matrixObjectToDataFrame(mo, this.sparkExecutionContext, false);
        return df.drop("__INDEX");
    }

    public Dataset<Row> getDataFrameVectorNoIDColumn(String outputName) {
        if (this.isFrameObject(outputName)) {
            throw new MLContextException("This method currently supports only matrices");
        }
        MatrixObject mo = this.getMatrixObject(outputName);
        Dataset<Row> df = MLContextConversionUtil.matrixObjectToDataFrame(mo, this.sparkExecutionContext, true);
        return df.drop("__INDEX");
    }

    public Matrix getMatrix(String outputName) {
        MatrixObject mo = this.getMatrixObject(outputName);
        return new Matrix(mo, this.sparkExecutionContext);
    }

    public Frame getFrame(String outputName) {
        FrameObject fo = this.getFrameObject(outputName);
        return new Frame(fo, this.sparkExecutionContext);
    }

    public String[][] getFrameAs2DStringArray(String outputName) {
        FrameObject frameObject = this.getFrameObject(outputName);
        return MLContextConversionUtil.frameObjectTo2DStringArray(frameObject);
    }

    public double getDouble(String outputName) {
        ScalarObject so = this.getScalarObject(outputName);
        return so.getDoubleValue();
    }

    public Object get(String outputName) {
        Data data = this.getData(outputName);
        if (data instanceof ScalarObject) {
            ScalarObject so = (ScalarObject)data;
            return so.getValue();
        }
        if (data instanceof MatrixObject) {
            return this.getMatrix(outputName);
        }
        if (data instanceof FrameObject) {
            return this.getFrame(outputName);
        }
        return data;
    }

    public ScalarObject getScalarObject(String outputName) {
        Data data = this.getData(outputName);
        if (!(data instanceof ScalarObject)) {
            throw new MLContextException("Variable '" + outputName + "' not a scalar");
        }
        return (ScalarObject)data;
    }

    public boolean getBoolean(String outputName) {
        ScalarObject so = this.getScalarObject(outputName);
        return so.getBooleanValue();
    }

    public long getLong(String outputName) {
        ScalarObject so = this.getScalarObject(outputName);
        return so.getLongValue();
    }

    public String getString(String outputName) {
        ScalarObject so = this.getScalarObject(outputName);
        return so.getStringValue();
    }

    public Script getScript() {
        return this.script;
    }

    public <T> Tuple1<T> getTuple(String outputName1) {
        return new Tuple1(this.outputValue(outputName1));
    }

    public <T1, T2> Tuple2<T1, T2> getTuple(String outputName1, String outputName2) {
        return new Tuple2(this.outputValue(outputName1), this.outputValue(outputName2));
    }

    public <T1, T2, T3> Tuple3<T1, T2, T3> getTuple(String outputName1, String outputName2, String outputName3) {
        return new Tuple3(this.outputValue(outputName1), this.outputValue(outputName2), this.outputValue(outputName3));
    }

    public <T1, T2, T3, T4> Tuple4<T1, T2, T3, T4> getTuple(String outputName1, String outputName2, String outputName3, String outputName4) {
        return new Tuple4(this.outputValue(outputName1), this.outputValue(outputName2), this.outputValue(outputName3), this.outputValue(outputName4));
    }

    public <T1, T2, T3, T4, T5> Tuple5<T1, T2, T3, T4, T5> getTuple(String outputName1, String outputName2, String outputName3, String outputName4, String outputName5) {
        return new Tuple5(this.outputValue(outputName1), this.outputValue(outputName2), this.outputValue(outputName3), this.outputValue(outputName4), this.outputValue(outputName5));
    }

    public <T1, T2, T3, T4, T5, T6> Tuple6<T1, T2, T3, T4, T5, T6> getTuple(String outputName1, String outputName2, String outputName3, String outputName4, String outputName5, String outputName6) {
        return new Tuple6(this.outputValue(outputName1), this.outputValue(outputName2), this.outputValue(outputName3), this.outputValue(outputName4), this.outputValue(outputName5), this.outputValue(outputName6));
    }

    public <T1, T2, T3, T4, T5, T6, T7> Tuple7<T1, T2, T3, T4, T5, T6, T7> getTuple(String outputName1, String outputName2, String outputName3, String outputName4, String outputName5, String outputName6, String outputName7) {
        return new Tuple7(this.outputValue(outputName1), this.outputValue(outputName2), this.outputValue(outputName3), this.outputValue(outputName4), this.outputValue(outputName5), this.outputValue(outputName6), this.outputValue(outputName7));
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8> Tuple8<T1, T2, T3, T4, T5, T6, T7, T8> getTuple(String outputName1, String outputName2, String outputName3, String outputName4, String outputName5, String outputName6, String outputName7, String outputName8) {
        return new Tuple8(this.outputValue(outputName1), this.outputValue(outputName2), this.outputValue(outputName3), this.outputValue(outputName4), this.outputValue(outputName5), this.outputValue(outputName6), this.outputValue(outputName7), this.outputValue(outputName8));
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9> Tuple9<T1, T2, T3, T4, T5, T6, T7, T8, T9> getTuple(String outputName1, String outputName2, String outputName3, String outputName4, String outputName5, String outputName6, String outputName7, String outputName8, String outputName9) {
        return new Tuple9(this.outputValue(outputName1), this.outputValue(outputName2), this.outputValue(outputName3), this.outputValue(outputName4), this.outputValue(outputName5), this.outputValue(outputName6), this.outputValue(outputName7), this.outputValue(outputName8), this.outputValue(outputName9));
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> Tuple10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> getTuple(String outputName1, String outputName2, String outputName3, String outputName4, String outputName5, String outputName6, String outputName7, String outputName8, String outputName9, String outputName10) {
        return new Tuple10(this.outputValue(outputName1), this.outputValue(outputName2), this.outputValue(outputName3), this.outputValue(outputName4), this.outputValue(outputName5), this.outputValue(outputName6), this.outputValue(outputName7), this.outputValue(outputName8), this.outputValue(outputName9), this.outputValue(outputName10));
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Tuple11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> getTuple(String outputName1, String outputName2, String outputName3, String outputName4, String outputName5, String outputName6, String outputName7, String outputName8, String outputName9, String outputName10, String outputName11) {
        return new Tuple11(this.outputValue(outputName1), this.outputValue(outputName2), this.outputValue(outputName3), this.outputValue(outputName4), this.outputValue(outputName5), this.outputValue(outputName6), this.outputValue(outputName7), this.outputValue(outputName8), this.outputValue(outputName9), this.outputValue(outputName10), this.outputValue(outputName11));
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> Tuple12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> getTuple(String outputName1, String outputName2, String outputName3, String outputName4, String outputName5, String outputName6, String outputName7, String outputName8, String outputName9, String outputName10, String outputName11, String outputName12) {
        return new Tuple12(this.outputValue(outputName1), this.outputValue(outputName2), this.outputValue(outputName3), this.outputValue(outputName4), this.outputValue(outputName5), this.outputValue(outputName6), this.outputValue(outputName7), this.outputValue(outputName8), this.outputValue(outputName9), this.outputValue(outputName10), this.outputValue(outputName11), this.outputValue(outputName12));
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> Tuple13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> getTuple(String outputName1, String outputName2, String outputName3, String outputName4, String outputName5, String outputName6, String outputName7, String outputName8, String outputName9, String outputName10, String outputName11, String outputName12, String outputName13) {
        return new Tuple13(this.outputValue(outputName1), this.outputValue(outputName2), this.outputValue(outputName3), this.outputValue(outputName4), this.outputValue(outputName5), this.outputValue(outputName6), this.outputValue(outputName7), this.outputValue(outputName8), this.outputValue(outputName9), this.outputValue(outputName10), this.outputValue(outputName11), this.outputValue(outputName12), this.outputValue(outputName13));
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> Tuple14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> getTuple(String outputName1, String outputName2, String outputName3, String outputName4, String outputName5, String outputName6, String outputName7, String outputName8, String outputName9, String outputName10, String outputName11, String outputName12, String outputName13, String outputName14) {
        return new Tuple14(this.outputValue(outputName1), this.outputValue(outputName2), this.outputValue(outputName3), this.outputValue(outputName4), this.outputValue(outputName5), this.outputValue(outputName6), this.outputValue(outputName7), this.outputValue(outputName8), this.outputValue(outputName9), this.outputValue(outputName10), this.outputValue(outputName11), this.outputValue(outputName12), this.outputValue(outputName13), this.outputValue(outputName14));
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> Tuple15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> getTuple(String outputName1, String outputName2, String outputName3, String outputName4, String outputName5, String outputName6, String outputName7, String outputName8, String outputName9, String outputName10, String outputName11, String outputName12, String outputName13, String outputName14, String outputName15) {
        return new Tuple15(this.outputValue(outputName1), this.outputValue(outputName2), this.outputValue(outputName3), this.outputValue(outputName4), this.outputValue(outputName5), this.outputValue(outputName6), this.outputValue(outputName7), this.outputValue(outputName8), this.outputValue(outputName9), this.outputValue(outputName10), this.outputValue(outputName11), this.outputValue(outputName12), this.outputValue(outputName13), this.outputValue(outputName14), this.outputValue(outputName15));
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> Tuple16<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> getTuple(String outputName1, String outputName2, String outputName3, String outputName4, String outputName5, String outputName6, String outputName7, String outputName8, String outputName9, String outputName10, String outputName11, String outputName12, String outputName13, String outputName14, String outputName15, String outputName16) {
        return new Tuple16(this.outputValue(outputName1), this.outputValue(outputName2), this.outputValue(outputName3), this.outputValue(outputName4), this.outputValue(outputName5), this.outputValue(outputName6), this.outputValue(outputName7), this.outputValue(outputName8), this.outputValue(outputName9), this.outputValue(outputName10), this.outputValue(outputName11), this.outputValue(outputName12), this.outputValue(outputName13), this.outputValue(outputName14), this.outputValue(outputName15), this.outputValue(outputName16));
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> Tuple17<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17> getTuple(String outputName1, String outputName2, String outputName3, String outputName4, String outputName5, String outputName6, String outputName7, String outputName8, String outputName9, String outputName10, String outputName11, String outputName12, String outputName13, String outputName14, String outputName15, String outputName16, String outputName17) {
        return new Tuple17(this.outputValue(outputName1), this.outputValue(outputName2), this.outputValue(outputName3), this.outputValue(outputName4), this.outputValue(outputName5), this.outputValue(outputName6), this.outputValue(outputName7), this.outputValue(outputName8), this.outputValue(outputName9), this.outputValue(outputName10), this.outputValue(outputName11), this.outputValue(outputName12), this.outputValue(outputName13), this.outputValue(outputName14), this.outputValue(outputName15), this.outputValue(outputName16), this.outputValue(outputName17));
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> Tuple18<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18> getTuple(String outputName1, String outputName2, String outputName3, String outputName4, String outputName5, String outputName6, String outputName7, String outputName8, String outputName9, String outputName10, String outputName11, String outputName12, String outputName13, String outputName14, String outputName15, String outputName16, String outputName17, String outputName18) {
        return new Tuple18(this.outputValue(outputName1), this.outputValue(outputName2), this.outputValue(outputName3), this.outputValue(outputName4), this.outputValue(outputName5), this.outputValue(outputName6), this.outputValue(outputName7), this.outputValue(outputName8), this.outputValue(outputName9), this.outputValue(outputName10), this.outputValue(outputName11), this.outputValue(outputName12), this.outputValue(outputName13), this.outputValue(outputName14), this.outputValue(outputName15), this.outputValue(outputName16), this.outputValue(outputName17), this.outputValue(outputName18));
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> Tuple19<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19> getTuple(String outputName1, String outputName2, String outputName3, String outputName4, String outputName5, String outputName6, String outputName7, String outputName8, String outputName9, String outputName10, String outputName11, String outputName12, String outputName13, String outputName14, String outputName15, String outputName16, String outputName17, String outputName18, String outputName19) {
        return new Tuple19(this.outputValue(outputName1), this.outputValue(outputName2), this.outputValue(outputName3), this.outputValue(outputName4), this.outputValue(outputName5), this.outputValue(outputName6), this.outputValue(outputName7), this.outputValue(outputName8), this.outputValue(outputName9), this.outputValue(outputName10), this.outputValue(outputName11), this.outputValue(outputName12), this.outputValue(outputName13), this.outputValue(outputName14), this.outputValue(outputName15), this.outputValue(outputName16), this.outputValue(outputName17), this.outputValue(outputName18), this.outputValue(outputName19));
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20> Tuple20<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20> getTuple(String outputName1, String outputName2, String outputName3, String outputName4, String outputName5, String outputName6, String outputName7, String outputName8, String outputName9, String outputName10, String outputName11, String outputName12, String outputName13, String outputName14, String outputName15, String outputName16, String outputName17, String outputName18, String outputName19, String outputName20) {
        return new Tuple20(this.outputValue(outputName1), this.outputValue(outputName2), this.outputValue(outputName3), this.outputValue(outputName4), this.outputValue(outputName5), this.outputValue(outputName6), this.outputValue(outputName7), this.outputValue(outputName8), this.outputValue(outputName9), this.outputValue(outputName10), this.outputValue(outputName11), this.outputValue(outputName12), this.outputValue(outputName13), this.outputValue(outputName14), this.outputValue(outputName15), this.outputValue(outputName16), this.outputValue(outputName17), this.outputValue(outputName18), this.outputValue(outputName19), this.outputValue(outputName20));
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21> Tuple21<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21> getTuple(String outputName1, String outputName2, String outputName3, String outputName4, String outputName5, String outputName6, String outputName7, String outputName8, String outputName9, String outputName10, String outputName11, String outputName12, String outputName13, String outputName14, String outputName15, String outputName16, String outputName17, String outputName18, String outputName19, String outputName20, String outputName21) {
        return new Tuple21(this.outputValue(outputName1), this.outputValue(outputName2), this.outputValue(outputName3), this.outputValue(outputName4), this.outputValue(outputName5), this.outputValue(outputName6), this.outputValue(outputName7), this.outputValue(outputName8), this.outputValue(outputName9), this.outputValue(outputName10), this.outputValue(outputName11), this.outputValue(outputName12), this.outputValue(outputName13), this.outputValue(outputName14), this.outputValue(outputName15), this.outputValue(outputName16), this.outputValue(outputName17), this.outputValue(outputName18), this.outputValue(outputName19), this.outputValue(outputName20), this.outputValue(outputName21));
    }

    public <T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22> Tuple22<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22> getTuple(String outputName1, String outputName2, String outputName3, String outputName4, String outputName5, String outputName6, String outputName7, String outputName8, String outputName9, String outputName10, String outputName11, String outputName12, String outputName13, String outputName14, String outputName15, String outputName16, String outputName17, String outputName18, String outputName19, String outputName20, String outputName21, String outputName22) {
        return new Tuple22(this.outputValue(outputName1), this.outputValue(outputName2), this.outputValue(outputName3), this.outputValue(outputName4), this.outputValue(outputName5), this.outputValue(outputName6), this.outputValue(outputName7), this.outputValue(outputName8), this.outputValue(outputName9), this.outputValue(outputName10), this.outputValue(outputName11), this.outputValue(outputName12), this.outputValue(outputName13), this.outputValue(outputName14), this.outputValue(outputName15), this.outputValue(outputName16), this.outputValue(outputName17), this.outputValue(outputName18), this.outputValue(outputName19), this.outputValue(outputName20), this.outputValue(outputName21), this.outputValue(outputName22));
    }

    private <T> T outputValue(String outputName) {
        Data data = this.getData(outputName);
        if (data instanceof BooleanObject) {
            return (T)Boolean.valueOf(((BooleanObject)data).getBooleanValue());
        }
        if (data instanceof DoubleObject) {
            return (T)new Double(((DoubleObject)data).getDoubleValue());
        }
        if (data instanceof IntObject) {
            return (T)new Long(((IntObject)data).getLongValue());
        }
        if (data instanceof StringObject) {
            return (T)((StringObject)data).getStringValue();
        }
        if (data instanceof MatrixObject) {
            return (T)this.getMatrix(outputName);
        }
        if (data instanceof FrameObject) {
            return (T)this.getFrame(outputName);
        }
        return (T)data;
    }

    public LocalVariableMap getSymbolTable() {
        return this.symbolTable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MLContextUtil.displayOutputs(this.script.getOutputVariables(), this.symbolTable));
        return sb.toString();
    }
}

