/*
 * Decompiled with CFR 0.152.
 */
package org.tugraz.sysds.api.mlcontext;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.tugraz.sysds.common.Types;

public class FrameSchema {
    private List<Types.ValueType> schema = null;

    public FrameSchema() {
    }

    public FrameSchema(List<Types.ValueType> schema) {
        this.schema = schema;
    }

    public FrameSchema(String schema) {
        this.schema = FrameSchema.schemaStringToListOfValueTypes(schema);
    }

    public List<Types.ValueType> getSchema() {
        return this.schema;
    }

    public void setSchema(List<Types.ValueType> schema) {
        this.schema = schema;
    }

    public void setSchemaAsString(String schema) {
        this.schema = FrameSchema.schemaStringToListOfValueTypes(schema);
    }

    private static List<Types.ValueType> schemaStringToListOfValueTypes(String schemaString) {
        if (StringUtils.isBlank((CharSequence)schemaString)) {
            return null;
        }
        return Arrays.stream(schemaString.split(",")).map(s -> Types.ValueType.valueOf(s.toUpperCase())).collect(Collectors.toList());
    }

    public String getSchemaAsString() {
        if (this.schema == null || this.schema.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.schema.size(); ++i) {
            Types.ValueType vt = this.schema.get(i);
            sb.append((Object)vt);
            if (i + 1 >= this.schema.size()) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

